<?php

require_once("$STPHPLIB_DIR/stphpobject.php");

class STPHPApplication extends STPHPObject
{
        function STPHPApplication($name)
        {
                STPHPObject::STPHPObject($name);
        }

        function dtor()
        {
                unset($this->title);
                unset($this->author);
                unset($this->copyright);
                unset($this->version);
                unset($this->language);
                unset($this->wndMain);
                STPHPObject::dtor();
        }

        function init($compress=FALSE)
        {
                if(!empty($this->wndMain))
                {
                        $this->wndMain->init();
                }

                $retValue  = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">';
                $retValue .= '<HTML>';
                $retValue .= '<HEAD>';
                $retValue .= '<META http-equiv="Content-Type" content="text/html; charset=iso-8859-1">';
                if(!empty($this->author))
                {
                        $retValue .= '<META NAME=author CONTENT="' . $this->author . '">';
                }

                if(!empty($this->version))
                {
                        $retValue .= '<META NAME=version CONTENT="' . $this->version . '">';
                }

                if(!empty($this->copyright))
                {
                        $retValue .= '<META NAME=copyright CONTENT="' . $this->getCopyright() . '">';
                }
                
                $retValue .= '<META NAME=generator CONTENT="STPHPLib - http://stphplib.sourceforge.net">';

                if(!empty($this->wndMain))
                {
                        while (list ($key, $val) = each($this->wndMain->metaRows))
                        {
                                $retValue .= $val;
                        }
                }

                $retValue .= '<TITLE>' . $this->title . '</TITLE>';

                $codeFiles = array();
                $cssFiles = array();

                if(!empty($this->wndMain))
                {
                        $codeFiles=array_unique($this->wndMain->getCodeFiles());
                        while (list ($key, $val) = each ($codeFiles))
                        {
                                $retValue .= '<SCRIPT TYPE="text/javascript" SRC="' . $val . '"></SCRIPT>';
                        }

                        $cssFiles=array_unique($this->wndMain->getCssFiles());
                        while (list ($key, $val) = each ($cssFiles))
                        {
                                $retValue .= '<LINK REL=StyleSheet TYPE="text/css" HREF="' . $val . '">';
                        }

                }

                $retValue .= '</HEAD>';
                if(!empty($this->wndMain))
                {
                        $content = $this->wndMain->Write();
                        if($compress)
                        {
                                $content=str_replace("\n", '', $content);
                                $content=str_replace("\t", '', $content);
                        }
                        $retValue .= $content;
                }
                $retValue .= '</HTML>';

                echo $retValue;
        }


        function setTitle($value)
        {
                $this->title=$value;
        }

        function getTitle()
        {
                return $this->title;
        }

        function setVersion($value)
        {
                $this->version=$value;
        }

        function getVersion()
        {
                return $this->version;
        }

        function setAuthor($value)
        {
                $this->author=$value;
        }

        function getAuthor()
        {
                return $this->author;
        }

        function setCopyright($value)
        {
                $this->copyright=$value;
        }

        function getCopyright()
        {
                return "Copyright by " . $this->copyright;
        }

        function setWndMain(&$window)
        {
                $this->wndMain =& $window;
        }

        function setLanguage($language)
        {
                $this->language=strtoupper($language);
        }

        function getLanguage()
        {
                return $this->language;
        }

        var $title;
        var $author;
        var $copyright;
        var $version;
        var $language;
        var $wndMain;
}

?>
