<?php
function store($data_file, $array)
{
	$old_array = array();
	if(!file_exists($data_file)) //if permanent file doesn't exist (first time store_results is called) create it
	{
		touch($data_file);
	}
	else
	{
		$temp_file = fopen($data_file, "r");
		if (flock($temp_file, LOCK_SH)) //acquires lock
		{
			$old_array = explode("|", fread($temp_file, filesize($data_file))); //split string into array
			flock($temp_file, LOCK_UN); //releases lock
		}
		fclose($temp_file);
	}
	//calculates and writes new informations
	for($j = 0; $j < sizeof($array); $j++) $array[$j] += $old_array[$j];
	$updated_file;
	for($j = 0; $j < sizeof($array); $j++) $updated_file = $updated_file . $array[$j] ."|";
	$updated_file = substr($updated_file, 0, strlen($updated_file)-1); //cut last "|"
	$perm_file = fopen($data_file, "w");
	if (flock($perm_file, LOCK_EX)) //acquires lock
	{
		fwrite($perm_file, $updated_file);
		flock($perm_file, LOCK_UN); //releases lock
	}
	fclose($perm_file);
}

function store_results($data_file) //function to save temporary data to file.
{
	global $files_dir;
	global $os_file_name;
	global $browser_file_name;
	global $country_file_name;
	
	$os_data_file = dirname(__FILE__) . "/" . $files_dir . $os_file_name;
	$browser_data_file = dirname(__FILE__) . "/" . $files_dir . $browser_file_name;
	$country_data_file = dirname(__FILE__) . "/" . $files_dir . $country_file_name;

	$entries = file($data_file);
	$os_type = os_detect ($entries);
	$browser_type = browser_detect($entries);
	$country_type = country_detect($entries);
	
	store($os_data_file, $os_type);
	store($browser_data_file, $browser_type);
	store($country_data_file, $country_type);
	
	unlink($data_file);
}
?>