<?php
//save updated count files
function store_counts($filename, $contents)
{
	$perm_file = fopen($filename, "w");
	if (flock($perm_file, LOCK_EX)) //acquires lock
	{
		fwrite($perm_file, $contents);
		flock($perm_file, LOCK_UN); //releases lock
	}
	fclose($perm_file);
}
//difference operator between two vectors
function subtract($count_array, $month_count_array)
{
	$keys = array_keys($count_array);
	for($j = 0; $j < sizeof($keys); $j++) $count_array[$keys[$j]] -= $month_count_array[$keys[$j]];
	return $count_array;
}
//retrieves informations from permanent files
function retrieve_perm_info($perm_file)
{
	$array = array();
	if(file_exists($perm_file))
	{
		$tot_file = fopen($perm_file, "r");
		if (flock($tot_file, LOCK_SH)) //acquires lock
		{
			$array = explode("|", fread($tot_file, filesize($perm_file))); //split string into array
			flock($tot_file, LOCK_UN); //releases lock
		}
		fclose($tot_file);
	}
	return $array;
}

//sum informations of permanent files to those of temporary file
function temp_plus_perm($temp_array, $perm_file)
{
	$old_array = retrieve_perm_info($perm_file);
	for($i = 0; $i < sizeof($old_array); $i++) $temp_array[$i] += $old_array[$i];
	return $temp_array;
}

//writes month statistics to file (formato x|x|x|x|x|x)
function store_month_results($array, $data_file)
{
	$updated_file;
	foreach($array as $item) $updated_file = $updated_file . $item ."|";
	$updated_file = substr($updated_file, 0, strlen($updated_file)-1); //cut last "|"
	$perm_file = fopen($data_file, "w");
	if (flock($perm_file, LOCK_EX))
	{
		fwrite($perm_file, $updated_file);
		flock($perm_file, LOCK_UN);
	}
	fclose($perm_file);
}

//all php files are stored on a vector, with filename as array key
function count_into_vector($old_dir)
{
	$count_array = array();
	if ($handle = opendir($old_dir)) 
	{
		while (false !== ($file = readdir($handle))) 
		{
			if(is_file($old_dir . "/" . $file) && strstr($file, ".php") && !strstr($file, ".php~"))
			{
				$temp = fopen($old_dir . "/" . $file, "r");
				if (flock($temp, LOCK_SH))
				{
					$count_array[$file] = fread($temp, filesize($old_dir . "/" . $file));
					flock($temp, LOCK_UN);
				}
				fclose($temp);
			}
		}
	}
	return $count_array;
}

function store_month($month, $data_file)
{
	global $files_dir;
	global $os_file_name;
	global $browser_file_name;
	global $country_file_name;
	global $CONTROL_DELETED_FILES;
	global $ROOT;
	
	$old_dir = dirname(__FILE__) . "/" . $files_dir;
	
	//retrieves permanent informations from file
	$os_type = array();
	$browser_type = array();
	$country_type = array();
	if (file_exists($data_file))
	{
		$entries = file($data_file);
		$os_type = os_detect ($entries);
		$browser_type = browser_detect($entries);
		$country_type = country_detect($entries);
		if (file_exists($old_dir.$os_file_name)) //avoid reading from empty files
		{
			$os_type = temp_plus_perm($os_type, $old_dir.$os_file_name);
			$browser_type = temp_plus_perm($browser_type, $old_dir.$browser_file_name);
			$country_type = temp_plus_perm($country_type, $old_dir.$country_file_name);
		}
	}
	else if (file_exists($old_dir.$os_file_name))
	{
		$os_type = retrieve_perm_info($old_dir.$os_file_name);
		$browser_type = retrieve_perm_info($old_dir.$browser_file_name);
		$country_type = retrieve_perm_info($old_dir.$country_file_name);
	}
	$count_array = count_into_vector($old_dir);
	
	//for each month directory gets informations and subtracts them from total
	if ($handle = opendir($old_dir)) 
	{
		while (false !== ($file = readdir($handle))) 
		{
			$file = $old_dir . $file . "/";
			if (is_dir($file) && $file != "." && $file != ".." && strstr($file, "_2"))
			{
				//updates count files
				$month_count_array = count_into_vector($file);
				$count_array = subtract($count_array, $month_count_array);
				//updates OS file
				$monthly_os_array = retrieve_perm_info($file . $os_file_name);
				for($i = 0; $i < sizeof($os_type); $i++) $os_type[$i] -= $monthly_os_array[$i];
				//updates browser file
				$monthly_browser_array = retrieve_perm_info($file . $browser_file_name);
				for($i = 0; $i < sizeof($browser_type); $i++) $browser_type[$i] -= $monthly_browser_array[$i];
				//updates country file
				$monthly_country_array = retrieve_perm_info($file . $country_file_name);
				for($i = 0; $i < sizeof($country_type); $i++) $country_type[$i] -= $monthly_country_array[$i];
			}
		}
	}
	mkdir($month);
	store_month_results($os_type, $month . "/" . $os_file_name);
	store_month_results($browser_type, $month . "/" . $browser_file_name);
	store_month_results($country_type, $month . "/" . $country_file_name);
	//store page counts. if ccounter manages to recognize base dir, it deletes counts of deleted files.
	$pages_counted = array_keys($count_array);
	for($j = 0; $j < sizeof($pages_counted); $j++) 
	{
		if ($CONTROL_DELETED_FILES == "Y" && $ROOT != "")
		{
			if (file_exists($ROOT . "/" . str_replace("%", "/", $pages_counted[$j])))
				store_counts($month . "/" . $pages_counted[$j], $count_array[$pages_counted[$j]]);
			else unlink ($old_dir . "/" . $pages_counted[$j]);
		}
		else store_counts($month . "/" . $pages_counted[$j], $count_array[$pages_counted[$j]]);
	}
}
?>