<?php
//to add a new item, update $XXXXX_type_name vector and add a "elseif(stristr($entries[$i]..." line in the proper section

$os_type_name = array("Linux", "Unix", "Windows 2000/XP", "Windows 98/Me", "Windows (generic)", "Mac OS X", "FreeBSD", "Others/Unknown", "OS/2");

$browser_type_name = array("Internet Explorer 6", "Internet Explorer 5", "Firefox", "Mozilla (generic)", "Netscape", "Safari", "Camino", "Opera", "Web Search bots", "Others/Unknown", "Konqueror");

$country_type_name = array("US Commercial", "Network", "Non-Profit Organizations", "US(gov, mil, edu)", "United Kingdom", "Italy", "France", "Germany", "Australia", "Canada", "Netherlands", "Brazil", "Japan", "Switzerland", "Norway", "Poland", "Denmark", "Czech Republic", "Hungary", "Russian Federation", "China", "India", "Spain", "Taiwan", "Finland", "Others/Unknown");

function os_detect ($entries)
{
	global $os_type_name;
	$os_type = array();
	for ($i = 0; $i<count($os_type_name); $i++) array_push ($os_type, 0);
	for($i = 0; $i < sizeof($entries); $i++)
	{
		if(stristr($entries[$i], "linux")) $os_type[0]++;
		elseif(stristr($entries[$i], "unix")) $os_type[1]++;
		elseif(stristr($entries[$i], "windows nt 5.")) $os_type[2]++;
		elseif(stristr($entries[$i], "win98") || stristr($entries[$i], "windows me")) $os_type[3]++;
		elseif(stristr($entries[$i], "windows")) $os_type[4]++;
		elseif(stristr($entries[$i], "os x")) $os_type[5]++;
		elseif(stristr($entries[$i], "freebsd")) $os_type[6]++;
		elseif(stristr($entries[$i], "os/2")) $os_type[8]++;
		else $os_type[7]++;
	}
	return $os_type; 
}
function browser_detect($entries)
{
	global $browser_type_name;
	$browser_type = array();
	for ($i = 0; $i<count($browser_type_name); $i++) array_push ($browser_type, 0);
	for($i = 0; $i < sizeof($entries); $i++)
	{
		if(stristr($entries[$i], "MSIE 6.0")) $browser_type[0]++;
		elseif(stristr($entries[$i], "MSIE 5.")) $browser_type[1]++;
		elseif(stristr($entries[$i], "firefox")) $browser_type[2]++;
		elseif(stristr($entries[$i], "netscape")) $browser_type[4]++;
		elseif(stristr($entries[$i], "safari")) $browser_type[5]++;
		elseif(stristr($entries[$i], "camino")) $browser_type[6]++;
		elseif(stristr($entries[$i], "opera")) $browser_type[7]++;
		elseif(stristr($entries[$i], "konqueror")) $browser_type[10]++;
		elseif(stristr($entries[$i], "bot")) $browser_type[8]++;
		elseif(stristr($entries[$i], "mozilla")) $browser_type[3]++;
		else $browser_type[9]++;
	}
	return $browser_type;
}
function country_detect($entries)
{
	global $country_type_name;
	$country_type = array();
	for ($i = 0; $i<count($country_type_name); $i++) array_push ($country_type, 0);
	for($i = 0; $i < sizeof($entries); $i++)
	{
		if(stristr($entries[$i], "com*")) $country_type[0]++;
		elseif(stristr($entries[$i], "net*")) $country_type[1]++;
		elseif(stristr($entries[$i], "org*")) $country_type[2]++;
		elseif(stristr($entries[$i], "mil*") || stristr($entries[$i], "edu*") || stristr($entries[$i], "gov*")) $country_type[3]++;
		elseif(stristr($entries[$i], "uk*")) $country_type[4]++;
		elseif(stristr($entries[$i], "it*")) $country_type[5]++;
		elseif(stristr($entries[$i], "fr*")) $country_type[6]++;
		elseif(stristr($entries[$i], "de*")) $country_type[7]++;
		elseif(stristr($entries[$i], "au*")) $country_type[8]++;
		elseif(stristr($entries[$i], "ca*")) $country_type[9]++;
		elseif(stristr($entries[$i], "nl*")) $country_type[10]++;
		elseif(stristr($entries[$i], "br*")) $country_type[11]++;
		elseif(stristr($entries[$i], "jp*")) $country_type[12]++;
		elseif(stristr($entries[$i], "ch*")) $country_type[13]++;
		elseif(stristr($entries[$i], "no*")) $country_type[14]++;
		elseif(stristr($entries[$i], "pl*")) $country_type[15]++;
		elseif(stristr($entries[$i], "dk*")) $country_type[16]++;
		elseif(stristr($entries[$i], "cz*")) $country_type[17]++;
		elseif(stristr($entries[$i], "hu*")) $country_type[18]++;
		elseif(stristr($entries[$i], "ru*")) $country_type[19]++;
		elseif(stristr($entries[$i], "cn*")) $country_type[20]++;
		elseif(stristr($entries[$i], "in*")) $country_type[21]++;
		elseif(stristr($entries[$i], "es*")) $country_type[22]++;
		elseif(stristr($entries[$i], "tw*")) $country_type[23]++;
		elseif(stristr($entries[$i], "fi*")) $country_type[24]++;
		//elseif(stristr($entries[$i], "<TLD>")) $country_type[26]++;
		else $country_type[25]++;
	}
	return $country_type;
}
?>