<?php
/*********************************************************************/
/*                           CcCounter 2.0b                          */
/*  Written by Emanuele Guadagnoli - cicoandcico[at]cicoandcico.com  */
/*      Reference page: http://www.cicoandcico.com/products.php      */
/*                            License: GPL                           */
/*                To change preferences, edit config.php             */
/*********************************************************************/
require dirname(__FILE__) . "/config.php";
$data_dir = dirname(__FILE__) . "/" . $files_dir;
$user_file_name = $data_dir . $temp_file_name;
$locking = TRUE; //use with flock
$page_name = substr($_SERVER["SCRIPT_NAME"], 1);
$file_name = str_replace("/", "%", $page_name); //replaces slashes with % symbol
if (!is_dir($data_dir)) mkdir($data_dir); //controls if data directory exists
$file_name = $data_dir . "/" . $file_name;
$page_counts = 1;

function write_to_file($file_name, $string)
{
	$file = fopen($file_name, "w");
	if (flock($file, LOCK_EX)) //acquires lock
	{
		fwrite($file, $string);
		flock($file, LOCK_UN); //releases lock
	}
	fclose($file);	
}

//controls if IP is valid
if (in_array($_SERVER["REMOTE_ADDR"], $BLOCKED_IPS))
{
	if(file_exists($file_name))
	{
		$file = fopen($file_name, "r");
		if (flock($file, LOCK_SH)) //acquires lock
		{
			$page_counts = fread($file, filesize($file_name));
			flock($file, LOCK_UN); //releases lock
		}
		fclose($file);
	}
}
else {
//store page counts
if(file_exists($file_name))
{
	$file = fopen($file_name, "r");
	if (flock($file, LOCK_SH)) //acquires lock
	{
		$page_counts = fread($file, filesize($file_name))+1;
		flock($file, LOCK_UN); //releases lock
	}
	fclose($file);
	write_to_file($file_name, $page_counts);
}
else write_to_file($file_name, "1");

//store global informations (OS, browser...) to temporary file
$user_info = $_SERVER['HTTP_USER_AGENT'] . " " . gethostbyaddr($_SERVER['REMOTE_ADDR']) . "*\n";
$user_file = fopen($user_file_name, "a");
if (flock($user_file, LOCK_EX))
{
	fwrite($user_file, $user_info);
	flock($user_file, LOCK_UN);
}
fclose($user_file);

//store informations to a permanent file when temp file size exceeds MAX_SIZE
if(file_exists($user_file_name) && filesize($user_file_name) > $MAX_SIZE)
{
	$lock_file = fopen($data_dir . "/lock_t", "w");
	if (flock($lock_file, LOCK_EX, $locking))
	{
		//critical section
		if(file_exists($user_file_name) && filesize($user_file_name) > $MAX_SIZE) //prevents from protected code to be executed twice
		{
			if(!function_exists(os_detect)) require dirname(__FILE__) . "/detect_func.php";
			require dirname(__FILE__) . "/store_func.php";
			store_results($user_file_name);
		}
		flock($lock_file, LOCK_UN);
	}
	fclose($lock_file);
}

$date = getdate();
//store date (only the first time the script is executed)
if (!file_exists($data_dir . "date")) write_to_file($data_dir . "date", $date['mday'] . "\n" . $date['mon'] . "\n" . $date['year']);

//store monthly informations
$date['mon'] -= 1; //counts previous month
if($date['mon'] == 0) {$date['mon'] = 12; $date['year'] -= 1;}; //if date is 1-2002 -> date = 12-2001
$month = $data_dir . "/" . $date['mon'] . "_" . $date['year']; //dir format: 1_2004

$old_date  = file($data_dir . "date"); //import date: if month == current month, don't execute the script
if (!is_dir($month) && $old_date[1] != $date['mon']+1)
{
	$lock_file = fopen($data_dir . "/lock_m", "w");
	if (flock($lock_file, LOCK_EX, $locking))
	{
		if (!file_exists($month)) //prevents from protected code to be executed twice
		{
			if(!function_exists(os_detect)) require dirname(__FILE__) . "/detect_func.php";
			require dirname(__FILE__) . "/month_func.php";
			store_month($month, $user_file_name);
		}
		flock($lock_file, LOCK_UN);
	}
	fclose($lock_file);
}
}
print str_replace ("<NUMBER>", $page_counts, $OUTPUT);
?>