<?php
function  MakeImage($cookie, $count = 0)  {
	global $cookieTxt;
	// Creation of image with GD
	if ($cookie == 1) {
		$text = "$cookieTxt";
		$length = strlen($text);
		$size = 14+($length-1)*9;
		$im = imagecreate($size,20);
	} elseif ($cookie == 2) {
		if ($count == 0) { 
			$length = 1;
		} else {
			$length =  1+intval(log($count)/log(10));
		}
		$size = 14+($length-1)*9;
		$im = imagecreate($size,20);
		$text = "$count";
  } elseif ($cookie == 3) {
    $text = "Count";
    $im = imagecreate(50,20);
  } else  {
    $text = "";
    $im = imagecreate(1,1);
  }
  $black  =  ImageColorAllocate($im,  0,  0,  0); 
  $white  =  ImageColorAllocate($im,  255,  255,  255); 
  imagefill($im,0,0,$black);  
  ImageString($im,5,3,2,$text,$white);
	if (function_exists("imagegif")) {
		header("Content-type: image/gif");
		imagegif($im);
	} elseif (function_exists("imagepng")) {
		header("Content-type: image/png");
		imagepng($im);
	} elseif (function_exists("imagejpeg")) {
		header("Content-type: image/jpeg");
		imagejpeg($im, "", 0.8);
	}  elseif (function_exists("imagewbmp")) {
		header("Content-type: image/vnd.wap.wbmp");
		imagewbmp($im);
	} else {
		die("No image support in this PHP server");
	}
	ImageDestroy($im);
}

function backstr($haystack, $needle) {
        return substr($haystack, 0, strlen($haystack) - strlen(strstr($haystack,$needle)));
 }

/***** Include configuration files *********/
$path = "./";
include ("$path/Php/config_sql.php");
include ("$path/Php/config.php");
include ("$path/Php/sites.php");
include ("$path/Php/funct.country.inc.php"); 
include ("$path/Php/log_function.php");

if (!isset($cookieTxt)) {
	$cookieTxt = "Admin";
}

/***** Catching Data **********************/
if (!isset($p) or $p == "") $p = $_GET['p'];
if (!isset($sid) or $sid == "") $sid = $_GET['sid'];
if (!isset($r) or $r == "") $r = $_GET['r'];
if (!isset($phpTrafficA) or $phpTrafficA=="") {
	if (isset($_COOKIE['phpTrafficA'])) $phpTrafficA = $_COOKIE['phpTrafficA'];
}

/**** Processing Data *********************/
$to = base64_decode(rawurldecode($p));
if ($sites[$sid]['trim']) {
	$to = backstr($to,'?');
}
$table = $sites[$sid]['table'];
$site = $sites[$sid]['site'];
$referer = base64_decode(rawurldecode($r));
$ip = $_SERVER['REMOTE_ADDR'];
$agent = $_SERVER['HTTP_USER_AGENT'];
$servertime = time();

/**** Make the image **********************/
if (!array_key_exists ($sid, $sites)) {
     MakeImage(3);
} else if ($phpTrafficA != "Admin") {
	$pageview = logit($table, $site, $to, $ip, $agent, $servertime, $referer, $sites[$sid]['crawler']);
	if ($sites[$sid]['counter'] == 1) {
		MakeImage(2, $pageview);
	} else {
		MakeImage(0, $pageview);
	}
} else {
	if ($cookieTxt != "") {
		MakeImage(1);
	} else {
		MakeImage(0);
	}
}

?>