<?php
/***************************************************************************
 phpTrafficA @soft.ZoneO.net
 Copyright (C) 2004-2007 ZoneO-soft, Butchu (email: "butchu" with the domain "zoneo.net")

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 More Info About The Licence At http://www.gnu.org/copyleft/gpl.html
****************************************************************************/
include ("./config_sql.php");
include ("./config.php");
?>
<html>
<title>Welcome to phpTrafficA</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
<META NAME="AUTHOR" CONTENT="phpTrafficA">
<link rel="stylesheet" href="main.css" type="text/css">
</head>
<div id="main">
<h1>Upgrading phpTrafficA</h1>
<?php
// ****************************************************************************
// 1- Read and write permission to sites.php
// ****************************************************************************
echo "<P>Checking write and read permissions to file sites.php\n<br>- Reading file: ";
$ok = true;
if (is_readable('sites.php')) { 
	echo "<font color='#35BA4D'>Ok</font>";
} else {
	echo "<font color='#FF0000'>Failed</font>";
	$ok = false;
}
echo "\n<br>- Writing file: ";
if (is_writable('sites.php')) { 
	echo "<font color='#35BA4D'>Ok</font>";
} else {
	echo "<font color='#FF0000'>Failed</font>";
	$ok = false;
}
// ****************************************************************************
// 2- Creation and deletion of temporary files
// ****************************************************************************
echo "\n<br>Testing creation of a temporary file in tmp directory: ";
$path =  __FILE__;
$path = preg_replace( "'\\\upgrade\.php'", "", $path);
$path = preg_replace( "'/upgrade\.php'", "", $path);
$file = "$path/../$tmpdirectory/test.txt";
if (touch($file)) {
	echo "<font color='#35BA4D'>Ok</font>";
} else {
	echo "<font color='#FF0000'>Failed</font>";
	$ok = false;
}
echo "\n<br>Trying to delete the file that was just created: ";
if (unlink($file)) {
	echo "<font color='#35BA4D'>Ok</font>";
} else {
	echo "<font color='#FF0000'>Failed</font>";
	$ok = false;
}
echo "</P>\n<P>End of file system test. Status: ";
if ($ok) {
	echo "<font color='#35BA4D'>Pass</font>.";
} else {
	echo "<font color='#FF0000'>Failed</font>.";
}
// ****************************************************************************
// 3- End of filesystem tests. Summary
// ****************************************************************************
if (!$ok) {
	die ("\n<P>There was an error in the filesystem test. The installation will stop here. Refer to <a href=\"http://soft.ZoneO.net/phpTrafficA\">phpTrafficA homepage</a> for more information");
}
// ****************************************************************************
// 4- Upgrading configuration (list of OS/ list of web browsers)
// ****************************************************************************
echo "\n<P>Updating table in database...";
include ("./confDB.sql.php");
$sqllist = split("\n", $sqlupgrade);
$c = mysql_connect("$server","$user","$password") or die("Can not connect to database in upgrade.php[86]: ".mysql_error());
$db = mysql_select_db("$base",$c) or die("Can not select base in upgrade.php[87]: ".mysql_error());
foreach($sqllist as $doit) {
  if (!mysql_query($doit,$c))
    die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
}
echo "<P>Done with creation of tables.";
// ****************************************************************************
// 5- Upgrading sites.php
// ****************************************************************************
echo "<P>Upgrading sites.php:</P>";
// ****************************************************************************
// 5.1- upgrade sites.php v1.0 (more options, such as trim URL and public/private
// ****************************************************************************
include('sites.php');
if (!isset($vsite)) { $vsite = 1.0; }
if ($vsite < 1.1) {
	$newString = "<?php  \n// Sites beging audited\n\$vsite = 1.1;\n\$sites = array( ";
	$i = 0;
	while ($bar=each($sites)) {
		$thisid = $bar[0];
		$thistable = $bar[1][table];
		$thissite = $bar[1][site];
		echo "<br>Upgrading entry for $thissite";
		$thispublic = 1; // Default in phpTrafficA: public
		$thistrim = 0; // Default in phpTrafficA: do trim
		if ($i==0) {
			$newString .= "\n\"$thisid\"=> array(\"table\" =>\"$thistable\", \"site\"=>\"$thissite\", \"public\"=>$thispublic, \"trim\"=>$thistrim)";
		}  else {
			$newString .= "\n,\"$thisid\"=> array(\"table\" =>\"$thistable\", \"site\"=>\"$thissite\", \"public\"=>$thispublic, \"trim\"=>$thistrim)";
		}
		$i+=1;
	}
	$newString .= ");\n?>";
	$temp = fopen ("sites.php", 'w');
	fwrite($temp, $newString);
	fclose($temp);
}
// ****************************************************************************
// 5.2- upgrade sites.php v1.1 (add extra table for each site in sql database 
//       for unique IP and path analysis + more fields in page table)
// ****************************************************************************
include('sites.php');
if ($vsite < 1.2) {
	$newString = "<?php  \n// Sites beging audited\n\$vsite = 1.2;\n\$sites = array( ";
	$i = 0;
	while ($bar=each($sites)) {
		$thisid = $bar[0];
		$thistable = $bar[1][table];
		$thissite = $bar[1][site];
		$thispublic = $bar[1]['public'];
		$thistrim = $bar[1][trim];
		echo "<br>Upgrading entry for $thissite";
		if ($i==0) {
			$newString .= "\n\"$thisid\"=> array(\"table\" =>\"$thistable\", \"site\"=>\"$thissite\", \"public\"=>$thispublic, \"trim\"=>$thistrim)";
		}  else {
			$newString .= "\n,\"$thisid\"=> array(\"table\" =>\"$thistable\", \"site\"=>\"$thissite\", \"public\"=>$thispublic, \"trim\"=>$thistrim)";
		}
		echo "<br>Creating tables ${thistable}_uniq and ${thistable}_path in database";
		$doit = "CREATE TABLE `${thistable}_uniq` ( `id` mediumint(9) unsigned NOT NULL auto_increment, `label` mediumint(9) unsigned default '0', `date` date NOT NULL default '0000-00-00', `count` mediumint(9) unsigned default '0', PRIMARY KEY (`id`) ) TYPE=MyISAM";
		if (!mysql_query($doit,$c))
			die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
		$doit = "CREATE TABLE `${thistable}_path` ( `id` mediumint(9) unsigned NOT NULL auto_increment,  `first` datetime NOT NULL default '0000-00-00 00:00:00', `last` datetime NOT NULL default '0000-00-00 00:00:00', `entry` mediumint(9) unsigned default '0', `exit` mediumint(9) unsigned default '0', `path` tinytext NOT NULL, `length` mediumint(9) unsigned NOT NULL default '0',`count` mediumint(9) unsigned NOT NULL default '0', PRIMARY KEY (`id`) ) TYPE=MyISAM";
		if (!mysql_query($doit,$c))
			die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
		$doit = "ALTER TABLE `${thistable}_pages` ADD `ref` MEDIUMINT DEFAULT '0', ADD `se` MEDIUMINT DEFAULT '0', ADD `internal` MEDIUMINT DEFAULT '0', ADD `other` MEDIUMINT DEFAULT '0'";
		if (!mysql_query($doit,$c))
			die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
		$i+=1;
	}
	$newString .= ");\n?>";
	$temp = fopen ("sites.php", 'w');
	fwrite($temp, $newString);
	fclose($temp);
}
// ****************************************************************************
// 5.3- Fix a bug introduced in 1.2beta1 that forgot columns in some SQL tables
// ****************************************************************************
include('sites.php');
while ($bar=each($sites)) {
	$thistable = $bar[1][table];
	$thissite = $bar[1][site];
	$doit = "SHOW columns FROM ${thistable}_pages";
	if (!mysql_query($doit,$c))
		die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
	$res = mysql_query($doit,$c);
	$count = 0;
	while ($elt = mysql_fetch_array ( $res )) {
		$count += 1;
	}
	if ($count == 3) {
		$doit = "ALTER TABLE `${thistable}_pages` ADD `ref` MEDIUMINT DEFAULT '0', ADD `se` MEDIUMINT DEFAULT '0', ADD `internal` MEDIUMINT DEFAULT '0', ADD `other` MEDIUMINT DEFAULT '0'";
		if (!mysql_query($doit,$c))
			die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
	}
}
// ****************************************************************************
// 5.4- Add a new column in pages table, new since 1.3
//     This column is used for old sites only that did not record accesses in 
//     the se, ref, internal, or other columns
// ****************************************************************************
reset($sites);
while ($bar=each($sites)) {
	$thistable = $bar[1][table];
	$thissite = $bar[1][site];
	$doit = "SHOW columns FROM ${thistable}_pages";
	if (!mysql_query($doit,$c))
		die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
	$res = mysql_query($doit,$c);
	$count = 0;
	while ($elt = mysql_fetch_array ( $res )) {
		$count += 1;
	}
	if ($count == 7) {
		echo "<br>Your version of the tables $thistable is <= 1.2. Table with pages needs to be upgraded.";
		$doit = "ALTER TABLE `${thistable}_pages` ADD `old` MEDIUMINT DEFAULT '0'";
		if (!mysql_query($doit,$c))
			die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
		// Now we want to fill up this old column...
		$req = "SELECT SUM(count) as count, label FROM ${thistable}_acces GROUP BY label";
		$res = mysql_query($req,$c);
		$pageCount = array();
		while ($row = mysql_fetch_object($res)) {
			$pageCount[$row->label] = $row->count;
		}
		$req = "SELECT id,ref,se,internal,other FROM ${thistable}_pages";
		$res = mysql_query($req,$c);
		$pageCount2 = array();
		while ($row = mysql_fetch_object($res)) {
			$pageCount2[$row->id] = $row->ref+$row->se+$row->internal+$row->other;
			$pageName[$row->id] = $row->name;
		}
		foreach($pageCount2 AS $id => $count2){
			$correction = $pageCount[$id]-$count2;
			$sql = "UPDATE `${thistable}_pages` SET old=$correction WHERE id=$id";
			$res = mysql_query($sql,$c);
		}
		echo " <font color='#35BA4D'>Done</font>.";
		// Calculating totals for each day
		echo "<br>Acces table for $thistable needs to be upgraded as well...";
		$req = "SELECT date ,SUM(count) as count FROM ${thistable}_acces GROUP BY date";
		$res = mysql_query($req,$c);
		while($row = mysql_fetch_object($res)) {
			$date = $row->date;
			$count = $row->count;
			$req2 ="INSERT INTO `${thistable}_acces` VALUES ('', 0, '$date','$count')";
			// $req2 = "UPDATE `${thistable}_acces` SET count=$count WHERE label=0 AND date='$date'";
			$res2 = mysql_query($req2,$c);
		}
		echo " <font color='#35BA4D'>Done</font>.";
	}
}
// ****************************************************************************
// 5.5- upgrade sites.php v1.2 (add extra configuration options: 
// counter and crawler stats that were introduced in 1.4)
// ****************************************************************************
include('sites.php');
reset($sites);
if ($vsite < 1.4) {
	echo "<br>Your version of sites.php is <= 1.2. It needs to be upgraded.";
	$newString = "<?php  \n// Sites beging audited\n\$vsite = 1.4;\n\$sites = array( ";
	$i = 0;
	while ($bar=each($sites)) {
		$thisid = $bar[0];
		$thistable = $bar[1][table];
		$thissite = $bar[1][site];
		$thispublic = $bar[1]['public'];
		$thistrim = $bar[1]['trim'];
		$thiscrawler = 1; // by default, we record crawlers
		$thiscounter = 0; // by default, phpTrafficA is not a counter
		echo "<br>Upgrading entry for $thissite";
		if ($i==0) {
			$newString .= "\n\"$thisid\"=> array(\"table\" =>\"$thistable\", \"site\"=>\"$thissite\", \"public\"=>$thispublic, \"trim\"=>$thistrim, \"crawler\"=>$thiscrawler, \"counter\"=>$thiscounter)";
		}  else {
			$newString .= "\n,\"$thisid\"=> array(\"table\" =>\"$thistable\", \"site\"=>\"$thissite\", \"public\"=>$thispublic, \"trim\"=>$thistrim, \"crawler\"=>$thiscrawler, \"counter\"=>$thiscounter)";
		}
		$i+=1;
	}
	$newString .= ");\n?>";
	$temp = fopen ("sites.php", 'w');
	fwrite($temp, $newString);
	fclose($temp);
}
include('sites.php');
reset($sites);
// ****************************************************************************
// 5.6- Add a new column in configuration table that were added with 
//      phpTrafficA 1.4 (ntop, ntoplong)
// ****************************************************************************
$doit = "SELECT count(*) as nlines FROM $config_table";
if (!mysql_query($doit,$c))
	die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
$res = mysql_query($doit,$c);
$elt = mysql_fetch_array ($res);
$count = $elt->nlines;
if ($count != 9) {
	echo "<br>Your version of the configuration table is <= 1.4. It needs to be upgraded.";
	$doit = "INSERT INTO $config_table VALUES ('ntop', '10')";
	if (!mysql_query($doit,$c))
		die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
	$doit = "INSERT INTO $config_table VALUES ('ntoplong', '15')";
	if (!mysql_query($doit,$c))
		die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
	echo " <font color='#35BA4D'>Done</font>.";
	$doit = "INSERT INTO $config_table VALUES ('seref', '0')";
	if (!mysql_query($doit,$c))
		die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
	echo " <font color='#35BA4D'>Done</font>.";
	$doit = "INSERT INTO $config_table VALUES ('visitcutoff', '15')";
	if (!mysql_query($doit,$c))
		die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
	echo " <font color='#35BA4D'>Done</font>.";
}
// ****************************************************************************
// 5.7- Change column type of column 'address' in referrer tables. It was tinytext but turned out to be too small for some URL. Change it to text type after 1.4beta3
// ****************************************************************************
while ($bar=each($sites)) {
	$thistable = $bar[1][table];
	$thissite = $bar[1][site];
	$doit = "SHOW columns FROM ${thistable}_referrer LIKE 'address'";
	if (!mysql_query($doit,$c))
		die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
	$res = mysql_query($doit,$c);
	$elt = mysql_fetch_array($res);
	if (strtolower($elt['Type']) == "tinytext") {
		$sql = "ALTER TABLE ${thistable}_referrer CHANGE `address` `address` TEXT NOT NULL";
		echo "<br>Your version of <code>${thistable}_referrer</code> has limitations with long URLs. Upgrading the <code>address</code> column type from <code>tinytext</code> to <code>text</code>.";
		$res = mysql_query($sql,$c);
		if (!$res) die("<br>Error with database: ".mysql_error()."<br>Was working on $sql.");
	}
}
reset($sites);
// ****************************************************************************
// 5.8- Change column type of column 'ref' in latest hosts tables. It was tinytext but turned out to be too small for some URL. Change it to text type after 1.4beta4
// ****************************************************************************
while ($bar=each($sites)) {
	$thistable = $bar[1][table];
	$thissite = $bar[1][site];
	$doit = "SHOW columns FROM ${thistable}_host LIKE 'ref'";
	if (!mysql_query($doit,$c))
		die("<br>Error with database: ".mysql_error()."<br>Was working on $doit.");
	$res = mysql_query($doit,$c);
	$elt = mysql_fetch_array($res);
	if (strtolower($elt['Type']) == "tinytext") {
		$sql = "ALTER TABLE ${thistable}_host CHANGE `ref` `ref` TEXT NOT NULL";
		echo "<br>Your version of <code>${thistable}_host</code> has limitations with long URLs. Upgrading the <code>ref</code> column type from <code>tinytext</code> to <code>text</code>.";
		$res = mysql_query($sql,$c);
		if (!$res) die("<br>Error with database: ".mysql_error()."<br>Was working on $sql.");
	}
}
reset($sites);
@mysql_close ($c);
// ****************************************************************************
// End of upgrade
// ****************************************************************************
echo "<P>Installation completed.
<P>Delete the following files
<ul>
<li>confDB.sql.php
<li>confDBUpgrade.sql.php
<li>install.php
<li>upgrade.php
</ul>
and enjoy!";
?>
</div>
</body>
</html>