<?php

/***************************************************************************
phpTrafficA @soft.ZoneO.net
Copyright (C) 2004-2007 ZoneO-soft, Butchu (email: "butchu" with the domain "zoneo.net")

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

More Info About The Licence At http://www.gnu.org/copyleft/gpl.html
****************************************************************************/

/*********************************************************************************/
/* Function: SEPlot
/* Role: plots the different search engines used to acess a given page
/* Parameters:
/*   - $c: connection to the database
/*   - $table
/*   - $sid
/*   - $showpage (id or 'all')
/* Returns:
/*   - the string with the plot
/* Create: 09/2005
/*********************************************************************************/
function SEPlot($c,$table, $sid, $showpage) {
global $strings;
global $tmpdirectory;
$timecall = time();
if ($showpage=='all') {
	$req = "SELECT engine,SUM(count) as count FROM ${table}_keyword GROUP BY engine ORDER BY count DESC";
} else {
	$req = "SELECT engine,SUM(count) as count FROM ${table}_keyword WHERE page=$showpage GROUP BY engine ORDER BY count DESC";
}
$res = mysql_query($req,$c);
$temp = fopen ("$tmpdirectory/tmp.$timecall.txt.php", 'w');
fwrite($temp, "<?php  \n\$date_data = array(");
$countother = 0;
$i=0;
$max = 0;
while($row = mysql_fetch_object($res)) {
	$i += 1;
	if ($i>9) {
		$countother += $row->count;
	} else {
		$engine = shorten($row->engine,6);
		$count = $row->count;
		if ($count > $max) {$max=$count;}
		if ($i > 1) {
			fwrite($temp, "\n,array(\"$engine\",$count)");
		} else {
			fwrite($temp, "\narray(\"$engine\",$count)");
		}
	}
}
if ($countother > $max) {$max=$countother;}
fwrite($temp, "\n,array(\"".$strings['Other']."\",$countother)");
fwrite($temp, "\n);\n\$maxY = $max;\n\$plottype=\"bars\";");
fwrite($temp, "\n\$ylabel = \"".translitarate($strings['Nsearch'])."\";");
fwrite($temp, "\n\$yscale=\"qdrt\";");
fwrite($temp, "\n?>");
fclose($temp);
if ($i>0) {
	$str = "<img src=\"./plotStatBar.php?file=tmp.$timecall.txt.php\" alt=\"".$strings['Nsearch']."\">";
} else {
	$str = "&nbsp;<br>".$strings['Nothingyet']."<br>&nbsp;";
}
return $str;
}

/*********************************************************************************/
/* Function: kwdHistoryPlot
/* Role: plots a history of the number of new keywords per day for a given page
/* Parameters:
/*   - $c: connection to the database
/*   - $table
/*   - $sid
/*   - $showpage (id or 'all')
/* Returns:
/*   - the string with the plot
/* Create: 09/2005
/*********************************************************************************/
function kwdHistoryPlot($c,$table, $sid, $showpage) {
global $strings;
global $tmpdirectory;
$timecall = time();
$start = 100000000000;
$end = 0;
$maxcount = 0;
if ($showpage=='all') {
	$req = "SELECT DATE_FORMAT(first, '%Y-%m-%d') AS Date, COUNT(*) AS num FROM ${table}_keyword  GROUP BY Date ORDER BY first ASC";
} else {
	$req = "SELECT DATE_FORMAT(first, '%Y-%m-%d') AS Date, COUNT(*) AS num FROM ${table}_keyword WHERE page=$showpage GROUP BY Date ORDER BY first ASC";
}
$res = mysql_query($req,$c);
while ($row = mysql_fetch_object($res)) {
	$day = $row->Date;
	$time = intval(100*floor(strtotime($day)/100));
	$count = $row->num;
	//echo "<br>day is $day, time is $time, count is $count";
	if ($time<$start) {$start=$time;}
	if ($time>$end) {$end=$time;}
	if ($count>$maxcount) {$maxcount = $count;}
	$count_array[$time] = $count;
}
$average = array();
if ((($start+2679000) != $end)&&$maxcount>0) {
	$day = $start;
	while ($day<=$end) {
		if (!array_key_exists($day, $count_array)) $count_array[$day] = 0;
		$day = strtotime("+1 day",$day);
	}
	$day = strtotime("+3 days", $start);
	$endloop =strtotime("-3 days", $end);
	while ($day<=$endloop) {
		$average[$day] = 1.0*($count_array[$day-3*86400] + $count_array[$day-2*86400]
			+ $count_array[$day-86400] + $count_array[$day]
			+ $count_array[$day+86400] + $count_array[$day+2*86400]
			+ $count_array[$day+3*86400]) / 7.0;
		$day = strtotime("+1 day",$day);
	}
	$temp = fopen ("$tmpdirectory/tmp2.$timecall.txt.php", 'w');
	fwrite($temp, "<?php  \n\$date_data = array(");
	$day = $start;
	$i = 0;
	while ($day<$end) {
		if ($i>0) {
			fwrite($temp,"\n,array(\"\",$day");
		} else {
			fwrite($temp,"\narray(\"\",$day");
		}
		if (array_key_exists($day, $average)) {
			fwrite($temp,",$count_array[$day],$average[$day])");
		} else {
			fwrite($temp,",$count_array[$day])");
		}
		$day = strtotime("+1 day",$day);
		$i += 1;
	}
	fwrite($temp, "\n);\n\$start=$start;\n\$end=$end;\n\$maxY=$maxcount;\n\$plottype=\"lines\";");
	fwrite($temp, "\n\$width = 600;");
	fwrite($temp, "\n\$height = 300;");
	fwrite($temp, "\n\$legende = array(\"".translitarate($strings['Dailycount'])."\",\"".translitarate($strings['Weeklyaverage'])."\");");
	fwrite($temp, "\n\$ylabel = \"".translitarate($strings['Newkeywordsperday'])."\";");
	fwrite($temp, "\n?>");
	fclose($temp);
	$str = "<img src=\"./plotStat.php?file=tmp2.$timecall.txt.php\" alt=\"".$strings['Newkeywordsperday']."\">";
} else {
	$str = "&nbsp;<br>".$strings['Nothingyet']."<BR>&nbsp;";
}
return $str;
}

/*********************************************************************************/
/* Function: tableSE
/* Role:
/* Parameters:
/*   - $c: connection to the database
/*   - $table
/*   - $sid
/*   - $pageid (id or 'all')
/*   - $sort
/*   - $start: table page number
/* Returns:
/*   - the string with the plot
/* Create: 09/2005
/*********************************************************************************/
function tableSE ($c,$table,$sid,$title,$pageid,$sort,$start) {
global $strings;
global $lang;
global $display;

$nperpage = $display['ntoplong'];
// Table restriction on page for keyword or referer search
if (($pageid=="all")&&($sort!="kwd")&&($sort!="page")) {
	$ncol = 4;
} else {
	$ncol = 3;
}
if (($pageid=="all")) {
	$where = "";
} else {
	$where = " WHERE page=$pageid ";
}
$toreturn = "";
$f = $nperpage * ($start - 1);
// Sorting options
if ($sort == "kwd") {
	$req = "SELECT MIN(first) as first,keyword,SUM(count) as count FROM ${table}_keyword $where GROUP BY keyword ORDER BY count DESC LIMIT $f,$nperpage";
	$titlecol = $strings['Firsttime'];
} 
if ($sort == "page") {
	$req = "SELECT MIN(first) as first,page,SUM(count) as count FROM ${table}_keyword $where GROUP BY page ORDER BY count DESC LIMIT $f,$nperpage";
	$titlecol = $strings['Firsttime'];
} 
if ($sort == "hits") {
	$req = "SELECT page,first,engine,keyword,count FROM ${table}_keyword $where ORDER BY count DESC LIMIT $f,$nperpage";
	$titlecol = $strings['Firsttime'];
}
if ($sort == "latest") {
	$req = "SELECT page,first,engine,keyword,count FROM ${table}_keyword $where ORDER BY first DESC LIMIT $f,$nperpage";
	$titlecol = $strings['Firsttime'];
} 
if ($sort == "latesthit") {
	$req = "SELECT engine,keyword,page,last as first,count FROM ${table}_keyword $where ORDER BY last DESC LIMIT $f,$nperpage";
	$titlecol = $strings['Latesthit'];
}
// table itself
$toreturn .= "<tr class=\"caption\">";
if (($pageid=="all")&&($sort!="kwd")) $toreturn .= "<td>".$strings['Page']."</td>";
$toreturn .= "<td>$titlecol</td>";
if ($sort!="page") $toreturn .=  "<td>".$strings['Keyword']."</td>";
$toreturn .= "<td>".$strings['Hits']."</td></tr>";
$res = mysql_query($req,$c);
$n = 0;
$today = strtotime(date("M j, Y"));
while ($row = mysql_fetch_object($res)) {
	$n += 1;
	$count = $row->count;
	$date = strtotime($row->first);
	if ($date>$today) {
		$first = timetoday($date,0);
	} else {
		$first = dayMmYear($date,0);
	}
	if ($sort == "kwd") {
		$keyword = htmlentities ($row->keyword, ENT_NOQUOTES, 'UTF-8');
		$txt = $keyword;
		$pagetxt = "";
	} else if ($sort=="page") {
		$thispageid = $row->page;
		$page = shortenPage(pagename($c, $table, $thispageid));
		$pagetxt = "<td class='av'><a href='./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;pageid=$thispageid&amp;start=1&amp;sort=kwd&amp;lang=$lang'>$page</a></td>";
	} else {
		$engine = $row->engine;
		$keyword = htmlentities ($row->keyword, ENT_NOQUOTES, 'UTF-8');
		$txt = "$engine: $keyword";
		if (($count == 1)&&($sort!="latest")) $txt .= " <font color=\"#FF0000\">-- ".$strings['new!']."</font>";
		$thispageid = $row->page;
		$page = shortenPage(pagename($c, $table, $thispageid));
		$pagetxt = "<td class='av'><a href='./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;pageid=$thispageid&amp;start=1&amp;sort=kwd&amp;lang=$lang'>$page</a></td>";
	}
	$toreturn .= "\n<tr>";
	if (($pageid=="all")||($sort=="page")) $toreturn .= "$pagetxt";
	$toreturn .= "<td class='av'>$first</td>";
	if ($sort!="page") $toreturn .= "<td class='av'>$txt</td>";
	$toreturn .= "<td class='av'>$count ".$strings['hits']."</td></tr>\n";
}
if ($n == 0) {
	$toreturn .= "<tr><td colspan=\"$ncol\"><div align=\"center\">".$strings['Nothingyet']."</div></td></tr>\n";
} else {
	if ($sort == "kwd") {
		$req = "SELECT COUNT(DISTINCT keyword) as count FROM ${table}_keyword $where";
	} else if ($sort == "page") {
		$req = "SELECT COUNT(DISTINCT page) as count FROM ${table}_keyword $where";
	} else { 
		$req = "SELECT COUNT(*) as count FROM ${table}_keyword $where";
	}
	$res = mysql_query($req,$c);
	$row = mysql_fetch_object($res);
	$nref = $row->count;
	$npages = intval($nref/$nperpage)+1;
	$toreturn .= "<tr><td colspan=\"$ncol\"><div align=\"center\"><strong>".$strings['Page'].":</strong> ";
	$toreturn .= navPage("./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;sort=$sort&amp;pageid=$pageid&amp;lang=$lang&amp;start=", $npages, $start);
	$toreturn .= "</div></td></tr>\n";
}
return $toreturn;
}

/*********************************************************************************/
/* Function: echoEngine
/* Role: echos search engines and keyword stats
/* Parameters:
/*   - $c: connection to the database
/*   - $table
/*   - $site
/*   - $sid
/*   - $showpage (id or 'all')
/*   - $sort: what kind of sorting for the table
/*   - $start: page number
/* Returns:
/*   - nothing, but echos what it finds
/* Created: 2004
/* 11/2006: removed database connection function (moved earlier in the code)
/*********************************************************************************/
function echoEngine($c,$table, $site, $sid, $showpage, $sort, $start) {
global $DEBUG;
global $strings;
global $lang;

/// Title
if ($showpage=='all') {
	$title = $strings['forthewholesite'];
	$where = "";
	$where2 = "";
	$where3 = "";
} else {
	$pagename = pagename($c,$table,$showpage);
	$title = $strings['for']." $pagename";
	$where = " WHERE page=$showpage ";
	$where2 = " WHERE label=$showpage ";
	$where3 = " WHERE id=$showpage ";
}

// Navigation
$nav = formnavpages($c, $table, $showpage, "index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;lang=$lang", $strings['Statisticsfor']);
echo $nav;

// Basic stats
echo "<table class=\"stat\">
<tr class=\"title\"><td colspan=\"2\">".$strings['Searchenginesstats']." $title</td></tr>\n";
$req = "SELECT COUNT(*) as count FROM ${table}_keyword $where;";
$res = mysql_query($req,$c);
$count=mysql_fetch_array($res);
$nrefs = $count['count'];
if ($nrefs=='') $nrefs=0;
echo "<tr><td>".$strings['Numberofkeywordscombinationsindatabase']."</td><td width=\"100px\">$nrefs</td></tr>\n";
// Total number of visits from search engines. In table_pages we have some idea for pages created after version 1.2, it is the exact number. For the others, we need a correction.
$req = "SELECT SUM(ref) as ref,SUM(se) as se,SUM(internal) as internal, SUM(other) as other, SUM(old) as old FROM ${table}_pages $where3;";
$res = mysql_query($req,$c);
$row =mysql_fetch_object($res);
$fromRef = $row->ref;
$fromSE = $row->se;
$fromInternal = $row->internal;
$fromOther = $row->other;
$fromOld = $row->old;
$total = $fromRef+$fromSE+$fromInternal+$fromOther+$fromOld;
// Here is the correction
$thistotal = $fromRef + $fromSE + $fromInternal + $fromOther;
if ($thistotal > 0) {
	$fromSECorrected = intval($fromSE * $total / $thistotal);
} else {
	$fromSECorrected = 0;
}
echo "<tr><td>".$strings['Numberofvisitsfromsearchengines']."</td><td>$fromSECorrected</td></tr>\n";
$req = "SELECT SUM(count) as count,keyword FROM ${table}_keyword $where GROUP BY keyword ORDER BY count DESC LIMIT 0,1";
$res = mysql_query($req,$c);
$count=mysql_fetch_array($res);
$refs = $count['count'];
$keyword = $count['keyword'];
if ($refs > 0) echo "<tr><td colspan=\"2\">".$strings['Bestkeywords'].": $keyword ($refs ".$strings['hits'].")</td></tr>\n";
if ($showpage == "all") {
	$req = "SELECT SUM(count) as count,page FROM ${table}_keyword $where GROUP BY page ORDER BY count DESC LIMIT 0,1";
	$res = mysql_query($req,$c);
	$count=mysql_fetch_array($res);
	$refs = $count['count'];
	$thispageid = $count['page'];
	$page = shortenPage(pagename($c, $table, $thispageid));
	if ($refs>0) echo "<tr><td colspan=\"2\">".$strings['Bestpageforsearchengines'].":  <a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;pageid=$thispageid&amp;start=1&amp;sort=kwd&amp;lang=$lang\" class=\"basic\">$page</a> ($refs ".$strings['hits'].")</td></tr>\n";

}
echo "<tr><td colspan=\"2\"><strong>".$strings['Plot'].":</strong> ";
if ($sort == "peng") {
	echo $strings['Searchengines']." -- ";
	$title = $strings['Searchengineplot']." $title";
} else {
	echo "<a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;pageid=$showpage&amp;sort=peng&amp;lang=$lang\" class=\"basic\">".$strings['Searchengines']."</a> -- ";
}
if ($sort == "kwdday") {
	echo $strings['NewkeywordsPday'];
	$title = $strings['Newkeywordsperday']." $title";
} else {
	echo "<a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;pageid=$showpage&amp;sort=kwdday&amp;lang=$lang\" class=\"basic\">".$strings['NewkeywordsPday']."</a>";
} 
echo "</td></tr>\n<tr><td colspan=\"2\"><strong>".$strings['Tablesortedby'].":</strong> ";
if ($sort == "kwd") {
	echo $strings['Keywordhits']." -- ";
	$title = $strings['Popularkeywords']." $title";
} else {
	echo "<a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;pageid=$showpage&amp;sort=kwd&amp;start=1&amp;lang=$lang\" class=\"basic\">".$strings['Keywordhits']."</a> -- ";
}
if ($sort == "page") {
	echo  $strings['Pagehits']." -- ";
	$title = $strings['Popularpagesforsearchengines'];
} else {
	if ($showpage == "all") {
		echo "<a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;pageid=$showpage&amp;sort=page&amp;start=1&amp;lang=$lang\" class=\"basic\">".$strings['Pagehits']."</a> -- ";
	}
}
if ($sort == "hits") {
	echo $strings['Hits']." -- ";
	$title = $strings['Popularkeywordssearchengines']." $title";
} else {
	echo "<a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;pageid=$showpage&amp;sort=hits&amp;start=1&amp;lang=$lang\" class=\"basic\">".$strings['Hits']."</a> -- ";
}
if ($sort == "latest") {
	echo $strings['Latests']." -- " ;
	$title = $strings['Newsearchenginehits']." $title";
} else {
	echo "<a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;pageid=$showpage&amp;sort=latest&amp;start=1&amp;lang=$lang\" class=\"basic\">".$strings['Latests']."</a> -- ";
}
if ($sort == "latesthit") {
	echo $strings['Latesthit'];
	$title = $strings['Latesthit']." $title";
} else {
	echo "<a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=key&amp;pageid=$showpage&amp;sort=latesthit&amp;start=1&amp;lang=$lang\" class=\"basic\">".$strings['Latesthit']."</a>";
}
echo "</td></tr>\n";
if ($showpage != "all") {
	echo "<tr><td colspan=\"2\"><strong>".$strings['Other'].":</strong> <a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=page&amp;pageid=$showpage&amp;lang=$lang\" class=\"basic\">".$strings['Accesscount']."</a> -- <a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=ref&amp;start=1&amp;sort=hits&amp;pageid=$showpage&amp;lang=$lang\" class=\"basic\">".$strings['Referrerstats']."</a> -- <a href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=pathdesign&amp;pageid=$pageid&amp;lang=$lang\" class=\"basic\">".$strings['Path']."</a></td></tr>\n";

}
echo "</table>\n";

if (($showpage=="all")&&($sort!="kwd")&&($sort!="page")) {
	$ncol = 4;
} elseif (($sort=="pend")||($sort=="kwdday")) {
	$ncol = 1;
} else {
	$ncol = 3;
}

echo "<table class=\"stat\">
<tr class=\"title\"><td colspan=\"$ncol\">$title</td></tr>\n";
if ($sort == "peng") {
	echo "<tr><td>&nbsp;<div align=\"center\">";
	echo SEPlot($c,$table, $sid, $showpage);
	echo "</div>&nbsp;</td></tr>\n";
} else if ($sort == "kwdday") {
	echo "<tr><td>&nbsp;<div align=\"center\">";
	echo kwdHistoryPlot($c,$table, $sid, $showpage);
	echo "</div>&nbsp;</td></tr>\n";
} else {
	echo tableSE ($c,$table,$sid, $title,$showpage,$sort,$start);
}
echo "</table>";
}

?>
