<?php
/***************************************************************************
 phpTrafficA @soft.ZoneO.net
 Copyright (C) 2004-2007 ZoneO-soft, Butchu (email: "butchu" with the domain "zoneo.net")

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 More Info About The Licence At http://www.gnu.org/copyleft/gpl.html
****************************************************************************/

/*********************************************************************************/
/* Function: pathAnalysis
/* Role: performs path analysis on the latest visitors
/* Parameters:
/*   - $c: connection to the database
/*   - $table: base name for sql tables
/*   - $site: root of the website
/*   - $sid: id of the website
/*   - $threshold: lower limit for hit numbers
/* Output:
/*   - nothing, but echos whatever it finds
/* Created: 06/2004
/* 11/2006: removed database connection function (moved earlier in the code)
/*********************************************************************************/

// We need those functions as well
include('Php/log_function.php');
include ("Php/config.php");
include ("Php/funct.country.inc.php");

function pathAnalysis($c, $table, $site, $sid, $threshold=3) {
global $config_table;
global $strings;
global $lang;

// We read the config, we will need some of it
$conf = read_config($config_table, $c);
$os_id =  $conf['os_id'];
$os_label = $conf['os_label'];
$browser_id = $conf['browser_id'];
$browser_label = $conf['browser_label'];
$engine_id = $conf['engine_id'];
$engine_url = $conf['engine_url'] ;
$engine_kwd = $conf['engine_kwd'];
$engine_charset = $conf['engine_charset'];
$save_host = $conf['save_host'];
// Find different IP's, sort them by date
$req = "SELECT host,agent, MIN(date) AS min FROM ${table}_host GROUP BY host ORDER BY date DESC";
$res = mysql_query($req,$c);
$iplist = array();
$start = array();
$agent = array();
// Loop on ip addresses, fetching IP, agent, and starting date
while($row = mysql_fetch_object($res)) {
	$iplist[] = $row->host;
	$start[$row->host] = $row->min;
	$agent[$row->host] = $row->agent;
}
echo "<table class=\"stat\">\n<tr class=\"title\"><td>".$strings['Pathanalysisforthelatest']." $save_host ".$strings['hits']."</td></tr>\n";
echo "<tr class=\"caption\"><td>".$strings['Threshold'].": ";
if ($threshold != 0) {
	echo "<a class=\"basic\" href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=path&amp;sort=0&amp;lang=$lang\">".$strings['none']."</a> -- ";
} else {
	echo $strings['none']." -- ";
} if ($threshold != 1) {
	echo "<a class=\"basic\" href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=path&amp;sort=1&amp;lang=$lang\">2 ".$strings['hits']."</a> -- ";
} else {
	echo "2 ".$strings['hits']." -- ";
} 
if ($threshold != 2) {
	echo "<a class=\"basic\" href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=path&amp;sort=2&amp;lang=$lang\">3 ".$strings['hits']."</a> -- ";
} else {
	echo "3 ".$strings['hits']." -- ";
} 
if ($threshold != 4) {
	echo "<a class=\"basic\" href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=path&amp;sort=4&amp;lang=$lang\">5 ".$strings['hits']."</a> -- ";
} else {
	echo "5 ".$strings['hits']." -- ";
} 
if ($threshold != 9) {
	echo "<a class=\"basic\" href=\"./index.php?mode=stats&amp;sid=$sid&amp;show=path&amp;sort=9&amp;lang=$lang\">10 ".$strings['hits']."</a>";
} else {
	echo "10 ".$strings['hits']."";
} 
echo "</td></tr>\n";
$ntot = 0;   // Total number of path displayed
$nhits = 0;  // Number of hist, for one visitor
foreach ($iplist as $ip) {
	$country = ip2Country($ip);
	if (whoislink($country) == FALSE) {
		$whoislink = "no whois link";
	} else {
		$whoislink = "<a href=\"".whoislink($country)."$ip\"  target=\"blank\" class=\"basic\">whois</a>";
	}
	$maplink = "<a href=\"http://soft.zoneo.net/phpTrafficA/mapIP.php?ip=$ip\" target=\"blank\" class=\"basic\">".$strings['map']."</a>";
	list($wb,$os)=split(";",ExtractAgent($agent[$ip],$browser_id,$browser_label,$os_id,$os_label));
	if (($wb != 'Crawler') && ($wb != 'Googlebot')) {  // Crawler are not included in here
		$req = "SELECT date,page,ref,agent FROM ${table}_host WHERE host='$ip' ORDER BY date";
		$res = mysql_query($req,$c);
		$n = 0;
		while($row = mysql_fetch_object($res)) {
			$time = $row->date;
			$referer = $row->ref;
			$thisagent = $row->agent;
			$page = $row->page;
			// If it is the first time we work with this IP, or if we have a change of
			// agent (probably another visitor, we lookup the main info (wb, os, origin)
			// Removed agent filtering (too heavy on server...)
			if ($n==0) {
				if ($nhits>$threshold) { 
					echo "$echo\n";
					$ntot += $nhits;
					echo "<div class=\"clearer\">&nbsp;</div></td></tr>\n";
				}
				$nhits = 0;
				$start = $row->date;
				list($wb,$os)=split(";",ExtractAgent($thisagent,$browser_id,$browser_label,$os_id,$os_label));
				$oldagent = $thisagent;
				$echo = "<tr><td><table class=\"postit\"><tr><td colspan=\"2\">$ip</td><td colspan=\"2\">$start</td></tr><tr><td colspan=\"4\">$whoislink, $maplink</td></tr><tr><td>".countryNameFlag($country)."</td><td colspan=\"2\"></td></tr><tr><td>".osImgName($os)."</td><td>".browserImgName($wb)."</td></tr>";
				if ($referer == "") {
					$echo .= "<tr><td colspan=\"4\">".$strings['Directaccess']."</td></tr>";
				} else {
					if ((preg_match("/". preg_quote($site, '/') . "/i", "$referer")))  {
					$refString = urlLink($referer,1);
					$echo .= "<tr><td colspan=\"4\">$refString</td></tr>";
					} else {
						$keywords = "";
						$keywordsArray = ExtractKeywords($referer,$engine_id,$engine_url,$engine_kwd,$engine_charset,$debugit);
						if ($keywordsArray != "") {
							// search engine
							$how = 2;
							$engine = $keywordsArray[1];
							$keywords = cleanText($keywordsArray[0]);
							$echo .= "<tr><td colspan=\"4\">$engine: <a href=\"$referer\" class=\"basic\" target=\"_new\" rel=\"nofollow\">$keywords</a></td></tr>";
						} else {
							$refString = urlLink($referer,1);
							$echo .= "<tr><td colspan=\"4\">$refString</td></tr>";
						}
					}
				}
				$echo .= "</table>";
			}
			// simple path analysis
			$n += 1;
			$nhits += 1;
			$when = getTimeEn(strtotime($time)-strtotime($start));
			$echo .= "<div class=\"postit\">$when<br>$page</div>";
		}
		if ($nhits>$threshold) { 
			echo "$echo\n";
			echo "<div class=\"clearer\">&nbsp;</div></td></tr>\n";
			$ntot += $nhits;
			$nhits = 0;
		}
	}
}
if ($ntot == 0) {
	echo "<tr><td><div align=\"center\">".$strings['Nothingyet']."</div></td></tr>\n";
}
echo "</table>\n";
}