<?php

/***************************************************************************
phpTrafficA @soft.ZoneO.net
Copyright (C) 2004-2007 ZoneO-soft, Butchu (email: "butchu" with the domain "zoneo.net")

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

More Info About The Licence At http://www.gnu.org/copyleft/gpl.html
****************************************************************************/

/*********************************************************************************/
/* Function: getmicrotime
/* Role: time with milliseconds
/* Parameters:
/* Output:
/*   - returns the time
/* Source: php website
/*********************************************************************************/
if (!function_exists('getmicrotime')) {
	function getmicrotime()  {
		global $DEBUG;
		list($usec, $sec) = explode(" ", microtime());
		return ((float)$usec + (float)$sec); 
	}
}

/*********************************************************************************/
/* Function: echodebug
/* Role: Saves a debug string in error file
/* Parameters:
/*   - the error string
/* Output:
/*   - Nothing
/* Created: 02/2005
/*********************************************************************************/
function echodebug($string) {
global $path;
global $tmpdirectory;
$errors = fopen("$path/$tmpdirectory/errors.dat",'a');
fwrite($errors,"$string\n");
fclose($errors);
}

/*********************************************************************************/
/* Function: clean text
/* Role: clean up text from ' and " to it does not fucks up php strings
/* Parameters:
/*   - $text: the text to be cleaned up
/* Output:
/*   - returns the clean text
/* Created 05/2004
/*********************************************************************************/
function cleanText($text) {
global $DEBUG;
$text = str_replace("\'", "&#39", $text);
$text = str_replace("'", "&#39", $text);
$text = str_replace("\"", "&#34", $text);
$text = str_replace("\\\"", "&#34", $text);
$text = str_replace("\\", "&#92", $text);
$text = str_replace("\\\\", "&#92", $text);
return $text;
}

/*********************************************************************************/
/* Function: addBP_LDC
/* Role: add entry in a label-month-count database (monthly count)
/*         if label-month exists: count=count+1
/*         if not, new line, count=1
/* Parameters:
/*   - $table: table with page id's
/*   - $connection: link with database
/*   - $monthstring: month of entry in yyyy-mm-01 format
/*   - $label: label to be looking for
/* Output:
/*   - return 1 if successful
/*   - return -1 if failed
/* Created 05/2004
/* Completely Changed 06/2005 to reduce number of sql queries
/*********************************************************************************/
function addDB_LDC($table,$connection,$monthstring,$label) {
// We try to add 1 to the count value. If it fails we have some more work to do.
$sql3 = "UPDATE `$table` SET count=count+1 WHERE STRCMP(label,'$label')=0 AND date='$monthstring'";
$res3 = mysql_query($sql3,$connection);
if (mysql_affected_rows() < 1) {
	// We failed in incrementing the counter: we need to add a new line
	$req4 ="INSERT INTO `$table` VALUES ('', '$label', '$monthstring','1')";
	$res4 = mysql_query($req4,$connection);
}
return 1;
}

/*********************************************************************************/
/* Function: add_access
/* Role: add access entry in a the access database
/*         if label-date exists: count=count+1
/*         if not, new line, count=1
/*       Also adds how we got there
/* Parameters:
/*   - $table: table with page id's
/*   - $c: link with database
/*   - $datestring: month of entry in yyyy-mm-01 format
/*   - $pageid: label to be looking for
/*   - $how: how did we get to the page
/*          0: unknow, 1: internal link, 2: search engine, 3: referer
/* Output:
/*   - return total number of access to this page
/* Created 11/2005 from an older version
/*********************************************************************************/
function add_access($table, $c, $datestring, $pageid, $how=0) {
global $DEBUG;
// Saving how we got to the page
switch($how) {
	case 2:
		$sql = "UPDATE `${table}_pages` SET se=se+1 WHERE id=$pageid;";
		break;
	case 3:
		$sql = "UPDATE `${table}_pages` SET ref=ref+1 WHERE id=$pageid;";
		break;
	case 1:
		$sql = "UPDATE `${table}_pages` SET internal=internal+1 WHERE id=$pageid;";
		break;
	default:
		$sql = "UPDATE `${table}_pages` SET other=other+1 WHERE id=$pageid;";
		break;
}
$res = mysql_query($sql,$c);
// Updating count
$sql = "UPDATE `${table}_acces` SET count=count+1 WHERE label=$pageid AND date='$datestring'";
$res = mysql_query($sql,$c);
if (mysql_affected_rows() < 1) {
// We failed in incrementing the counter: we need to add a new line
	$sql ="INSERT INTO `${table}_acces` VALUES ('', $pageid, '$datestring','1')";
	$res = mysql_query($sql,$c);
}
// Updating count for the whole site
$sql = "UPDATE `${table}_acces` SET count=count+1 WHERE label=0 AND date='$datestring'";
$res = mysql_query($sql,$c);
if (mysql_affected_rows() < 1) {
// We failed in incrementing the counter: we need to add a new line
	$sql ="INSERT INTO `${table}_acces` VALUES ('', 0, '$datestring','1')";
	$res = mysql_query($sql,$c);
}
// Get the total number of access
$sql = "SELECT SUM(count) as count FROM ${table}_acces WHERE label=$pageid;";
$res = mysql_query($sql,$c);
$count=mysql_fetch_array($res);
return $count['count'];
}


/*********************************************************************************/
/* Function: pageid
/* Role: lookup page id in the database, and create one if does not exist
/* Parameters: 
/*   - $table: table with page id's 
/*   - $connection: link with database
/*   - $page
/*   - $date: access date (used only with creating new ID)
/* Output: 
/*   - return id if successful
/*   - return -1 if failed
/* Created 05/2004
/*********************************************************************************/
function pageid($table, $connection, $page, $date) {
$sql3 = "SELECT id FROM `$table` WHERE STRCMP(name,'$page')=0";
$res3 = mysql_query($sql3,$connection);
if ( (mysql_num_rows($res3) == 0) or (mysql_num_rows($res3) == FALSE) ) {
	$req4 ="INSERT INTO `$table` VALUES ('', '$page', '$date', '0', '0', '0', '0', '0')";
	$res4 = mysql_query($req4,$connection);
	$pageid = mysql_insert_id();
} else {
	$row2 = mysql_fetch_object($res3);
	$pageid = $row2->id;
}
return $pageid;
}

/*********************************************************************************/
/* Function: updateCount
/* Role: update counter in a simple database (value, count) with no line instertion
/* Parameters: 
/*   - $table: table with logs
/*   - $connection: link with database
/*   - $value: the value to be updated (will do count=count+1 for value = $value)
/* Output: 
/*   - return 1 if successful
/*   - return -1 if failed
/* Created 05/2004
/*********************************************************************************/
function updateCount($table, $connection, $value) {
$sql3 = "UPDATE `$table` SET count=count+1 WHERE value=$value";
$res3 = mysql_query($sql3,$connection);
return 1;
}

/*********************************************************************************/
/* Function: addReferrer
/* Role: add a log of a referrer into the database
/* Parameters: 
/*   - $table: table with referrer logs
/*   - $connection: link with database
/*   - $referer: referrer
/*   - $date: date of the entry in yyyy-mm-dd format
/* Output: 
/*   - return 1 if successful
/*   - return -1 if failed
/* Created 05/2004
/* Completely changed 06/2005 to reduce number of SQL access
/*********************************************************************************/
function addReferrer($table, $connection, $referer, $date,$pageid) {
$sql3 = "UPDATE `$table` SET count=count+1,last='$date' WHERE STRCMP(address,'$referer')=0 AND page=$pageid";
$res3 = mysql_query($sql3,$connection);
if (mysql_affected_rows() < 1) {
	$req4 ="INSERT INTO `$table` VALUES ('', '$referer', '$pageid', '$date', '$date','1')";
	$res4 = mysql_query($req4,$connection);
}
return 1;
}

/*********************************************************************************/
/* Function: addSEngine
/* Role: add a log of search engine and keywords into the database
/* Parameters: 
/*   - $table: table with search engine logs
/*   - $connection: link with database
/*   - $engine: search engine name
/*   - $keywords
/*   - $date: date of the entry in yyyy-mm-dd format
/* Output: 
/*   - return 1 if successful
/*   - return -1 if failed
/* Created 05/2004
/* Completely changed 06/2005 to reduce number of SQL access
/*********************************************************************************/
function addSEngine($table, $connection, $engine, $keywords, $date, $pageid) {
$sql3 = "UPDATE `$table` SET count=count+1,last='$date' WHERE STRCMP(engine,'$engine')=0 AND STRCMP(keyword,'$keywords')=0 AND page=$pageid";
$res3 = mysql_query($sql3,$connection);
if (mysql_affected_rows() < 1) {
	$req4 ="INSERT INTO `$table` VALUES ('', '$engine', '$keywords', '$pageid','$date', '$date','1')";
	$res4 = mysql_query($req4,$connection);
}
return 1;
}

/*********************************************************************************/
/* Function: ExtractAgent
/* Role: extract browser and OS from OS string recorded in the log
/* Parameters:
/*   - $agt: agent and browser string
/*   - $browser_id: array with browser ID's
/*   - $browser_label: array with browser names
/*   - $os_id: array with OS ID's
/*   - $os_label: array with OS names
/* Output: a string like WebBrowser;OS
/*    You can extract OS and WebBrowser using:
/*    list($wb,$os)=split(";",ExtractAgent($HTTP_USER_AGENT));
/*     echo $wb."<br>";
/*     echo $os."<br>";
/* Created 04/2004
/* Inspiration from existing function in ezboo webstats, http://www.ezboo.com
/*********************************************************************************/
function ExtractAgent($agt,$browser_id,$browser_label,$os_id,$os_label) {
global $DEBUG;
// Init default values
$new_agt_browser="???";   // Do not change these ??? . It is used in other scripts
$new_agt_os="???";        // Do not change these ??? . It is used in other scripts
// Check for browser
for ($cpt = 0; $cpt < count($browser_id) ; $cpt++) {
	if (strpos($agt,$browser_id[$cpt]) !== FALSE) {
		$new_agt_browser=$browser_label[$cpt];
		break;
	}
}
if (($new_agt_browser=="Googlebot") || ($new_agt_browser=="Crawler") || ($new_agt_browser=="Google Adwords")) {
	$new_agt_os = $new_agt_browser;
} else {
	// Check for OS
	for ($cpt = 0; $cpt < count($os_id) ; $cpt++) {
		if (strpos($agt,$os_id[$cpt]) !== FALSE) {
			$new_agt_os=$os_label[$cpt];
			break;
		}
	}
}
//DEBUG if ($DEBUG==1) {
//if (($new_agt_browser=="???")||($new_agt_os=="???")) {
//   echodebug("Unkown agent or browser: $agt gives $new_agt_browser, $new_agt_os");
//}
//DEBUG }
return($new_agt_browser.";".$new_agt_os);   # Systax is=  WebBrowser;OS
}

/*********************************************************************************/
/* Function: ExtractKeywords
/* Role: extract keywords and search engines (SE) from a referrer string
/* Parameters:
/*   - $refurl: referrer string
/*   - $engine_id: array with SE ID's
/*   - $engine_url: array with strings to detect the SE
/*   - $engine_kwd: array with an array of strings to detect the SE keywords
/*   - $engine_charset: array with an array of strings with the Charset used by this search engine
/* Output: a list (keyword1 keyword2... SE)
/* Created 05/2004
/* Inspiration from code at scriptygoddess
/*          http://www.scriptygoddess.com/archives/003277.php
/*          but heavily modified
/* Modified: 11/2006, for better handling of charsets
/* Modified: 07/2007, fixing charsets for Russian search engines
/*********************************************************************************/
function  ExtractKeywords($refurl,$engine_id,$engine_url,$engine_kwd,$engine_charset,$debugit=false) {
global $DEBUG;
$found = 0;
// Separate hosts and the rest
if (ereg('^(.*)\?(.*)',$refurl,$regs)) {
	$refhost=$regs[1];
	$refquery=$regs[2];
}
$nSengine = count($engine_url);
for ($i=0; $i<$nSengine;$i++) {
	// Is url matching the search engine?
	if (strpos($refhost,$engine_url[$i]) !== FALSE) {
		// Look for keywords
		$nKeySearch = count($engin_kwd[$i]);
		foreach($engine_kwd[$i] as $key) {
			if (preg_match('/\b'.$key.'=(.*)(?:&|$)/Ui',$refquery,$regs)) {
				// ok, we have a match, store the SE name
				$engid = $engine_id[$i];
				// look for keywords
				$searched=urldecode($regs[1]);
				// Try to convert keywords to UTF-8
				// Russian Search Engine
				if (isset($engine_charset[$i]) and ($engine_charset[$i] == "Windows-1251")) {
					// Yandex keywords (double coding)
					$searched = iconv ($engine_charset[$i], "UTF-8", $searched);
					if (preg_match('/yandex/i', $engid)) {
						$keyYandex = "qs";
						if (preg_match('/\b'.$keyYandex.'=(.*)(?:&|$)/Ui',$refquery,$regsYandex)) {
							$refquery=urldecode($regsYandex[1]);
							$key = "text";
							if (preg_match('/\b'.$key.'=(.*)(?:&|$)/Ui',$refquery,$regs)) {
								$searched = iconv("KOI8-U", "UTF-8", urldecode($regs[1]));
							}
						}
					// end Yandex keywords (double coding)
					// Rambler keywords (KOI8-U)
					} else if (preg_match('/rambler/i', $engid)) {
						$keyRambler1 = "btnG";
						$keyRambler2 = "oe";
						$keyRambler3 = "utf8";
						$keyRambler4 = "old_q";
						if (preg_match('/\b'.$keyRambler1.'=(.*)(?:&|$)/Ui',$refquery,$regsRambler)) {
							if (preg_match('/%EE%C1%CA%D4%C9%21/i', $regsRambler[1])) {
								if (preg_match('/\b'.$key.'=(.*)(?:&|$)/Ui',$refquery,$regs)) {
									$searched = iconv("KOI8-U", "UTF-8", urldecode($regs[1]));
									if (preg_match('/\b'.$keyRambler4.'=(.*)(?:&|$)/Ui',$refquery,$regs_old)){
										$s_old = iconv("KOI8-U", "UTF-8", urldecode($regs_old[1]));
										$searched = $s_old." -> ".$searched;
									}
								}
		  					} else if (preg_match('/\b'.$keyRambler4.'=(.*)(?:&|$)/Ui',$refquery,$regs_old)) {
								$s_old = iconv($engine_charset[$i], "UTF-8", urldecode($regs_old[1]));
								$searched = $s_old." -> ".$searched;
							}
						} else if (preg_match('/\b'.$keyRambler2.'=(.*)(?:&|$)/Ui',$refquery,$regsRambler)) {
							if (preg_match('/koi8r/i', $regsRambler[1])) {
								if (preg_match('/\b'.$key.'=(.*)(?:&|$)/Ui',$refquery,$regs)) {
									$searched = iconv ("KOI8-U", "UTF-8", urldecode($regs[1]));
									if (preg_match('/\b'.$keyRambler4.'=(.*)(?:&|$)/Ui',$refquery,$regs_old)){
										$s_old = iconv("KOI8-U", "UTF-8", urldecode($regs_old[1]));
										$searched = $s_old." -> ".$searched;
									}
								}
  							}
						} else if (preg_match('/\b'.$keyRambler3.'=(.*)(?:&|$)/Ui',$refquery,$regsRambler)){
							if (preg_match('/1/i', $regsRambler[1])) {
								if (preg_match('/\b'.$key.'=(.*)(?:&|$)/Ui',$refquery,$regs)) {
									$searched = urldecode($regs[1]);
									if (preg_match('/\b'.$keyRambler4.'=(.*)(?:&|$)/Ui',$refquery,$regs_old)){
										$s_old = iconv("KOI8-U", "UTF-8", urldecode($regs_old[1]));
										$searched = $s_old." -> ".$searched;
									}
								}
						}
						}
					// end Rambler keywords (KOI8-U)
					// Mail keywords 
					} else if (preg_match('/mail/i', $engid)) {
						$keyMail = "old_q";
						if (preg_match('/\b'.$key.'=(.*)(?:&|$)/Ui',$refquery,$regsMail)) {
							$searched_old_Mail = iconv($engine_charset[$i], "UTF-8", urldecode($regsMail[1]));
							$searched = $searched_old_Mail." -> ".$searched;
						}
					}
					// End Mail keywords
				// end Russian Search Engine
				} else if (isset($engine_charset[$i])) {
					$searched = iconv ($engine_charset[$i], "UTF-8", $searched);
				} else if (preg_match('/google/i', $engid)) {
					$key = "ie";
					if (preg_match('/\b'.$key.'=(.*)(?:&|$)/Ui',$refquery,$regs)) {
						$encoding=urldecode($regs[1]);
						$searched = iconv ($encoding, "UTF-8", $searched);
					}
				} else if (preg_match('/yahoo/i', $engid)) {
					$key = "ei";
					if (preg_match('/\b'.$key.'=(.*)(?:&|$)/Ui',$refquery,$regs)) {
						$encoding=urldecode($regs[1]);
						$searched = iconv ($encoding, "UTF-8", $searched);
					}
				}
				$found = 1;
				$engkwd[0] = trim(preg_replace('/\s\s+/', ' ', $searched))." "; // Space for backwards compatibility 
				$engkwd[1] = $engid;
				return $engkwd;
				// Exit the whole loop on SE, we found it...
			}
		}
	}
}
return;
}

/*********************************************************************************/
/* Function: read_config
/* Role: Read configuration table
/* Parameters: 
/*   - $config_table: table name
/*   - $connection: connection to the database
/* Output:
/*   - a table with 
/*        $conf[save_host] = number of hosts to save in hosts history table
/*        $conf[os_id] = list with operating systems ID's
/*        $conf[os_label] = list with operating systems labels
/*        $conf[browser_id] = list with browser ID's
/*        $conf[browser_label] = list with browser labels
/*        $conf[engine_id] = list with search engines ID's
/*        $conf[engine_url] = list with search engines url's
/*        $conf[engine_kwd] = list with search engines keyword parameters
/*        $conf[blacklist] = blacklist for referers
/*        $conf[visitcutoff] = cut-off time for individual visits
/* Created 05/2004
/*********************************************************************************/
function read_config($config_table, $connection) {
global $DEBUG;
// get configuration (browser, OS list, search engines definitions)
$sql = "SELECT * FROM $config_table";
$result = mysql_query ($sql,$connection);
$config = array("x" =>"x");
while($row = mysql_fetch_array($result)) {
	$config = $config + array($row["variable"] => $row["value"] );
}
mysql_free_result ($result);
// Read the os_list and assign 2 arrays (label and id)
$buffer = split ("\n",$config['os_list']);
if (trim(end($buffer)) == "") {array_pop($buffer);}
$i=0;
foreach($buffer as $buffer1) {
	list ($os_id[$i], $os_label[$i]) = split ('[|]', trim($buffer1));
	$i+=1;
}
// Read the browser_list and assign 2 arrays (label and id)
$buffer = split ("\n",$config['browser_list']);
if (trim(end($buffer)) == "") {array_pop($buffer);}
$i=0;
foreach($buffer as $buffer1) {
	list ($browser_id[$i], $browser_label[$i]) = split ('[|]', trim($buffer1));
	$i+=1;
}
// Read search engines and keywords table
$buffer = split ("\n",$config['search_engines']);
if (trim(end($buffer)) == "") {array_pop($buffer);}
$i=0;
foreach($buffer as $buffer1) {
	list ($engine_id[$i], $engine_url[$i], $keywords, $engine_charset[$i]) = split ('[|]', trim($buffer1));
	$engine_kwd[$i] = split ('[:]', $keywords);
	//echo $engine_id[$i].", ".$engine_url[$i].", ".$keywords.", ".$engine_charset[$i]."<br>";
	$i+=1;
}
// Read number of hosts to be saved
$save_host = $config['save_host'];
// Read the referrer black list
$blacklist = split ("\n",$config['blacklist']);
if (trim(end($blacklist)) == "") {array_pop($blacklist);}
// Search engines in referrer table
$seAreRef =  $config['seref'];
// Visit cut-off
$visitCutoff =  $config['visitcutoff'];
// Prepare data to return
$conf['save_host'] = $save_host;
$conf['os_id'] = $os_id;
$conf['os_label'] = $os_label;
$conf['browser_id'] = $browser_id;
$conf['browser_label'] = $browser_label;
$conf['engine_id'] = $engine_id;
$conf['engine_url'] = $engine_url;
$conf['engine_kwd'] = $engine_kwd;
$conf['engine_charset'] = $engine_charset;
$conf['blacklist'] = $blacklist;
$conf['seAreRef'] = $seAreRef;
$conf['visitcutoff'] = $visitCutoff;
return $conf;
}

/*********************************************************************************/
/* Function: insert_ipbased_entry
/* Role: Inserts data in database for one visitor: visitor count for each page, path, and visitor retention
/* Parameters:
/*   - $c: connection to the database
/*   - $table: base name for tables
/*   - $first: time when visit started (unix timestamp)
/*   - $last: time when visit ended (unix timestamp)
/*   - $clicks: number of hits
/*   - $path: path, page id's separated with "|"
/* Output: none
/* Created 11/2005
/*********************************************************************************/
function insert_ipbased_entry($c, $table, $first, $last, $clicks, $path) {
// Convert duration of stay to minutes
$duration = intval(($last-$first)/60);
// If the duration is negative, something went wrong and we ignore it
if ($duration>=0) {
	$date = date("Y-m-01",$first);
	$sql3 = "UPDATE `${table}_retention` SET count=count+1 WHERE date='$date' AND mode=0 AND length=$duration";
	$res3 = mysql_query($sql3,$c);
	if (mysql_affected_rows() < 1) {
		$req4 ="INSERT INTO `${table}_retention` VALUES ('', '$date', '0', '$duration', '1')";
		$res4 = mysql_query($req4,$c);
	} 
}
// Number of clicks
$sql3 = "UPDATE `${table}_retention` SET count=count+1 WHERE date='$date' AND mode=1 AND length=$clicks";
$res3 = mysql_query($sql3,$c);
if (mysql_affected_rows() < 1) {
	$req4 ="INSERT INTO `${table}_retention` VALUES ('', '$date', '1', '$clicks', '1')";
	$res4 = mysql_query($req4,$c);
}
// Unique IP hits...
$datestring = date("Y-m-d",$first);
addDB_LDC("${table}_uniq",$c,$datestring,0); // whole site
$pages = explode("|", $path);
$pageuniq = array_unique($pages);
foreach ($pageuniq as $page) {
	if ($page != 0) addDB_LDC("${table}_uniq",$c,$datestring,$page);
}
// Path
$path = "|$path|";
$entry = $pages[0];
$exit = $pages[count($pages)-1];
$date = date("Y-m-d H:i:s",$first);
$sql3 = "UPDATE `${table}_path` SET count=count+1,last='$date' WHERE STRCMP(path,'$path')=0";
$res3 = mysql_query($sql3,$c);
if (mysql_affected_rows() < 1) {
	$req4 ="INSERT INTO `${table}_path` VALUES ('', '$date', '$date', '$entry', '$exit', '$path', '$clicks','1')";
	$res4 = mysql_query($req4,$c);
}
return 1;
}

/*********************************************************************************/
/* Function: ipbased
/* Role: deals with stats based on unique IP's
/* Parameters:
/*   - $c: connection to the database
/*   - $pageid: page being viewed
/*   - $ip: IP address
/*   - $agent: agent string 
/*   - $time: unix timestamp 
/*   - $conf: configuration table
/*   - $table: root for table names
/*   - $site
/*   - $visitCutoff: time of inactivity after which  visit is considered to be finished, in minutes
/* Output: none
/* Created 11/2005
/* Changed 12/2006: added the $visitCutoff parameter
/*********************************************************************************/
function ipbased($c,$pageid,$ip,$agent,$time,$conf,$table,$site,$visitCutoff) {
global $path;
global $tmpdirectory;
$max_keep_ipbased = $visitCutoff*60; // 1800 = 30 minutes, 3600 = 1 hour
$pageid = trim($pageid, " \n\r");
$tmpfile = "$path/$tmpdirectory/ipbased.$table.dat";
if (!file_exists($tmpfile)) {
	touch($tmpfile);
}
$stats = file("$tmpfile");
$found = FALSE;
$newpath = TRUE;
$newString = "";
foreach($stats as $log) {
	$log_arr = explode("|>|", $log);
	$host = $log_arr[0];
	$first = $log_arr[1];
	$last = $log_arr[2];
	$clicks = $log_arr[3];
	$thispath = $log_arr[4];
	if ($first>100) {
		if ($host==$ip) {
			if ($last+$max_keep_ipbased > $time) {
				$newpath = FALSE;
				$clicks += 1;
				$thispath .= "|$pageid";
				$newString .= "$ip|>|$first|>|$time|>|$clicks|>|$thispath|>|\n";
			} else {
				insert_ipbased_entry($c, $table, $first, $last, $clicks, $thispath);
				$newString .= "$ip|>|$time|>|$time|>|1|>|$pageid|>|\n";
			}
			$found = TRUE;
		} else {
			if ($last+$max_keep_ipbased > $time) {
				$newString .= "$host|>|$first|>|$last|>|$clicks|>|$thispath|>|\n";
			} else {
				insert_ipbased_entry($c, $table, $first, $last, $clicks, $thispath);
			}
		}
	}
}
if (!$found) { $newString .= "$ip|>|$time|>|$time|>|1|>|$pageid|>|\n";}
$newstats =fopen("$tmpfile", "w");
@flock ($newstats,2);
fwrite($newstats,$newString);
@flock ($newstats,3);
fclose($newstats);
// Test IP2C
// $country = ip2Country($ip);
if ($newpath) {
	// Add country, OS, and browser
	$monthstring = date("Y-m",$time)."-01";
	list($wb,$os)=split(";",ExtractAgent($agent,$conf[browser_id],$conf[browser_label],$conf[os_id],$conf[os_label]));
	$test = addDB_LDC("${table}_os",$c,$monthstring,$os);
	$test = addDB_LDC("${table}_browser",$c,$monthstring,$wb);
	if (!(preg_match("/Crawler/i", $wb))) {
		if (!(preg_match("/Google/i", $wb))) {
			$country = ip2Country($ip);
			$test = addDB_LDC("${table}_country",$c,$monthstring,$country);
		}
	}
	// echodebug("$time: $ip, $country, $agent gives $os and $wb");
}
return 1;
}

/*********************************************************************************/
/* Function: figureOutRefOrSE
/* Role: deals with extraction of referrers and search engine keywords
/* Parameters:
/*   - $c: connection to the database
/*   - $referer: referrer string
/*   - $site: URL of the site
/*   - $table
/*   - $engine_id: array with SE id's
/*   - $engine_url: array with SE URL's
/*   - $engine_kwd: array with the way to extract keywords
/*   - $engine_charset: array with the charsets used by a SE
/*   - $blacklist: referrer blaclist 
/*   - $date
/*   - $pageid
/*   - $seAreRef: 1 if SE are inserted in referrer table
/* Output: 0 if not know, 1 if link inside site, 2 if SE, 3 if referer
/* Created 11/2006
/*********************************************************************************/
function figureOutRefOrSE ($c, $referer, $site, $table, $engine_id,$engine_url,$engine_kwd,$engine_charset, $blacklist, $date, $pageid,$seAreRef) {
$how = 0;
if ($referer != "") {
	// FIXME: strtolower is not the best
	$pos2 = strpos(strtolower($referer), strtolower($site));
	if ($pos2 !== false) {
		// if link from within the site do nothing, otherwise, check
		$how = 1;
	} else {
		$keywords = "";
		$keywordsArray = ExtractKeywords($referer,$engine_id,$engine_url,$engine_kwd,$engine_charset,0);
		if ($keywordsArray != "") {
			// search engine
			$how = 2;
			$test = addSEngine("${table}_keyword", $c, $keywordsArray[1], $keywordsArray[0], $date,$pageid);
			if ($test == -1) { break;}
			if ($seAreRef) {
				$test = addReferrer("${table}_referrer", $c, $referer, $date,$pageid);
				if ($test == -1) { break;}
			}
		} else {
			// not a search engine, it's a link, we check the black list
			$test = 1;
			foreach ($blacklist as $black) {
				// Is url matching the one in the black list
				$pos = strpos($referer,$black);
				if ($pos !== false) {
					$test = 0;
					break;
				}
			}
			if ($test == 1) {
				$how = 3;
				$test = addReferrer("${table}_referrer", $c, $referer, $date,$pageid);
				if ($test == -1) { break;}
			}
		}
	}
}
return $how;
}

/*********************************************************************************/
/* Function: logit
/* Role: logs a access into proper databases
/* Parameters:
/*   - $table: base name for tables
/*   - $site: site being audited
/*   - $page: page accessed
/*   - $ip: ip number of host
/*   - $agent: agent string
/*   - $time: unix timestamp
/*   - $referer: referer string
/*   - $visitCutoff: time of inactivity after which  visit is considered to be finished, in minutes
/*   - $recordCrawler: true or false, depending on if you want to record visits from Crawlers
/* Output: none
/* Created 05/2004
/* Changed heavily 11/2005 to switch to unique IP based stats...
/* Changed heavily 11/2006 to accomodate a function to not record to record visits from crawlers
/* Changed 11/2006 to pull out the referrer and search engine extraction functions
/* Changed 12/2006: added the $visitCutoff parameter (it used to default at 1hour)
/* Changed 01/2007: removed the $visitCutoff parameter (moved into SQL config)
/*********************************************************************************/
function logit($table, $site, $page, $ip, $agent, $time, $referer, $recordCrawler=true) {
global $DEBUG, $server, $user, $password, $base, $config_table;
// $timestart = getmicrotime();
// basic stuff
$hour = date("H", $time);
$day = date("w", $time);
$datestring = date("Y-m-d",$time);
$date = date("Y-m-d H:i:s",$time);
// Connect to database
$c = mysql_connect("$server","$user","$password") or die("<br>Can not connect to database in log_function.php[593]: ".mysql_error());
$db = mysql_select_db("$base",$c) or die("<br>Can not select base in log_function.php[594] ".mysql_error());
// mysql_query("SET NAMES 'utf8'", $c);
// Read configurations
$conf = read_config($config_table, $c);
$save_host = $conf['save_host'];
$engine_id = $conf['engine_id'];
$engine_url = $conf['engine_url'] ;
$engine_kwd = $conf['engine_kwd'];
$engine_charset = $conf['engine_charset'];
$blacklist= $conf['blacklist'];
$seAreRef = $conf['seAreRef'];
$visitCutoff = $conf['visitcutoff'];
// Extracting the OS and webbrowser
list($wb,$os)=split(";",ExtractAgent($agent,$conf[browser_id],$conf[browser_label],$conf[os_id],$conf[os_label]));
$crawlerArray = array ("Crawler", "Googlebot", "Google Adwords");
if ( $recordCrawler || (!$recordCrawler && (array_search ($wb,$crawlerArray) === FALSE)) ) {
	// If we record crawlers, or if it is not a crawler, go ahead
	// Fixing pagename
	$page = preg_replace("/\/+/", "/", $page); // replace all // with / in the page url
	$page = ereg_replace ("index.html$", "", $page);
	$page = ereg_replace ("index.shtml$", "", $page);
	$page = ereg_replace ("index.asp$", "", $page);
	$page = ereg_replace ("index.xml$", "", $page);
	$page = ereg_replace ("index.php$", "", $page);
	$page = ereg_replace ("index.php3$", "", $page);
	$page = ereg_replace ("index.php4$", "", $page);
	$page = ereg_replace ("index.php5$", "", $page);
	// SPECIAL ZONEO: / Becomes index.php This should be fixed... FIX ME!
	$isindex = substr($page, -1);
	if ($isindex == "/") {
		$page = $page."index.php";
	}
	// Find out if this page has been audited yet, and get the index
	$pageid = pageid("${table}_pages", $c, $page, $datestring);
	if ($pageid == -1) { break;}
	// Hour and day of the week
	$test = updateCount("${table}_hour", $c, $hour);
	$test = updateCount("${table}_day", $c, $day);
	// IP Based stats are in a different function
	//   includes OS, browser, and country stats
	ipbased($c,$pageid,$ip,$agent,$time,$conf,$table,$site,$visitCutoff);
	// Referrer, search engines, keywords
	$how = figureOutRefOrSE ($c, $referer, $site, $table, $engine_id,$engine_url,$engine_kwd,$engine_charset, $blacklist, $date, $pageid,$seAreRef);
	// Add page view + way we got here
	$pageview = add_access($table,$c,$datestring,$pageid,$how);
}
// Insert access in latest hosts table, even if it is a crawler
$cleanref = cleanText($referer);
$sql3 ="INSERT INTO `${table}_host` VALUES ('$date', '$ip', '', '$page','$cleanref','$agent')";
$res3 = mysql_query($sql3,$c);
// Cleanup the host table, we do not want that many... Just keep the last ones.
// We will keep twice more hosts than keep_hosts so we do not have to clear up the table all the time. This is for the sake of speeeeed!
$req3 = "SELECT COUNT(*) as count FROM ${table}_host";
$res3 = mysql_query($req3,$c);
$tmp=mysql_fetch_array($res3);
if (($tmp['count']-2*$save_host)>0) {
	$hostdelete = $tmp['count']-$save_host;
	$req3 = "ALTER TABLE `${table}_host` ORDER BY `date`";
	$res3 = mysql_query($req3,$c);
	$req3 = "DELETE FROM `${table}_host` LIMIT $hostdelete";
	$res3 = mysql_query($req3,$c);
	$req3 = "OPTIMIZE TABLE `${table}_host` ";
	$res3 = mysql_query($req3,$c);
}
// Close database
@mysql_close ($c);
return $pageview;
}
?>