<?php
/* 
 * phpMyVisites : website statistics and audience measurements
 * Copyright (C) 2002 - 2006
 * http://www.phpmyvisites.net/ 
 * phpMyVisites is free software (license GNU/GPL)
 * Authors : phpMyVisites team
*/

// $Id: phpmyvisites.php,v 1.55 2005/10/27 00:29:29 matthieu_ Exp $

define('SAVE_STAT', 1);
define('DEBUG', false);
define('PROFILING', false);
define('INCLUDE_PATH', '.');

if(!SAVE_STAT)
{
	$img = "./images/logos/pixel.gif";
	
	header("Content-type: image/gif");
	readfile($img);
	exit;
}


if(PROFILING)
{
	xdebug_start_profiling();
}
// TODO dans le test du referer appartient au site, testez également en plus 
// des sitesUrls le host de l'url de la page current sur le host de l'url ref

// TODO  en cas de prob de charge optimiser à mort tout ce qui est fait ici : 
// securisation de variables, inclusion de fichiers, requêtes, etc

@ignore_user_abort(true);


require_once INCLUDE_PATH."/core/include/global.php";
require_once INCLUDE_PATH."/core/include/Logs.functions.php";
require_once INCLUDE_PATH."/core/include/common.functions.php";
require_once INCLUDE_PATH."/core/include/Cookie.class.php";
require_once INCLUDE_PATH."/core/include/Site.class.php";
require_once INCLUDE_PATH."/core/include/PmvConfig.class.php";


$c =& PmvConfig::getInstance();

$db =& Db::getInstance();
$db->connect();

// when no get specified, display a marketing page :)
if(sizeof($_GET) === 0)
{
	require_once INCLUDE_PATH."/core/include/Lang.class.php";
	$l = new Lang();
	displayPageWhenEmptyGet();
	exit;
}

if(DEBUG)
{	
	require_once INCLUDE_PATH."/core/include/functions.php";
}

if(DEBUG)
	ob_start();
	
// - imprimer doc mysql "optimisation"
// - enregistrer les URLs des sites SANS SLASH A LA FIN


/*
 * Get page & visitor information
 */
$visitTime    = 30; // one visit time = 30 minutes

$idSite       = getRequestVar('id', null, 'numeric');

$pmvCookie    = new Cookie( COOKIE_NAME . $idSite);

$GLOBALS['cookie'] = $pmvCookie;

if($pmvCookie->isDefined())
{
	printDebug("<b>Cookie at the beginning (size : ".$GLOBALS['cookie']->getSize()." bytes)</b> :<br>");
	printDebug($GLOBALS['cookie']->get()); 
	$returningVisitor = 1;
}
else
{
	$returningVisitor = 0;
	printDebug("<b>Cookie not found !</b>");
}

$flash        = getRequestVar('flash', 0, 'numeric');
$director     = getRequestVar('director', 0, 'numeric');
$quicktime    = getRequestVar('quicktime', 0, 'numeric');
$realPlayer   = getRequestVar('realplayer', 0, 'numeric');
$windowsMedia = getRequestVar('windowsmedia', 0, 'numeric');
$pdf          = getRequestVar('pdf', 0, 'numeric');
$java         = getRequestVar('java', 0, 'numeric');

$refererUrl   = getRequestVar('ref', '');


$site = new Site($idSite);

/*
 * site urls
 */
if(!$siteUrls = $GLOBALS['cookie']->getVar('site_urls'))
{
	$siteUrls     = $site->getUrls();
	
	// save array of site urls in the cookie
	$GLOBALS['cookie']->setVar('site_urls', $siteUrls);
}

/*
 * site info
 */
if(!$siteInfo = $GLOBALS['cookie']->getVar('site_info'))
{
	$siteInfo = $site->getInfo();
	
	// save array of site urls in the cookie
	$GLOBALS['cookie']->setVar('site_info', $siteInfo);
}


$logo              = $site->getLogo();
$siteParams        = $site->getParams();
$paramsExclude     = $siteParams['params_names'];
$paramsIncludeOnly = $siteParams['params_names'];

/*
 * page variables
 */
$a_vars = getRequestVar('a_vars', array(), 'array');

/*
 * visitor config, as saved in the database
 */
$userAgent    = secureVar($_SERVER['HTTP_USER_AGENT']);
$os           = getOs($userAgent);
$a_browser    = getBrowserInfo($userAgent);
$resolution   = getRequestVar('res');
$colorDepth   = getRequestVar('col', 32, 'numeric');

$browserLang  = secureVar($_SERVER['HTTP_ACCEPT_LANGUAGE']);

$localTime    = getRequestVar('h',date("H"),'numeric').':'.
						getRequestVar('m',date("i"),'numeric').':'.getRequestVar('s',date("s"),'numeric');

$pageUrl      = getRequestVar('url');


// assign pageCategory default value of the parse_url::path?query
$pageUrlParamsProcessed = processParams($pageUrl, $siteParams);

$urlParse     = parse_url($pageUrlParamsProcessed);

if(isset($urlParse['path']))
{
	$pageNameDefault = substr($urlParse['path'], 1);
}

if(isset($urlParse['query']))
{
	$pageNameDefault .= '?'.$urlParse['query'];
}

if(  (!isset($pageNameDefault) || strcmp($pageNameDefault, '')===0)
		&& isset($urlParse['host']))
{
	$pageNameDefault = DEFAULT_PAGE_NAME;
}
else if(!isset($pageNameDefault))
{
	$pageNameDefault = null;
}
printDebug("PageNameDefault : " . $pageNameDefault);

// stripslashed because otherwise pageName if value is pageNameDefault is slashed twice 
$pageCompleteName = utf8_encode(getRequestVar('pagename' , 
											stripslashes(html_entity_decode($pageNameDefault))
									)
								);

// works only on 'path' of this url because the query may contain delimiter !
$urlParse = parse_url($pageCompleteName);
$pageCompleteNamePath = $urlParse['path'];

$lastDelimiter = strrpos($pageCompleteNamePath, CATEGORY_DELIMITER);

if($lastDelimiter !== false)
{
	// in the $pageCompleteName "g1>g2>page" select only "g1>g2"
	$pageCategory = substr($pageCompleteNamePath, 0, $lastDelimiter);
	
	if($pageCategory == '/'
	|| $pageCategory == ' '
	|| $pageCategory == '+'
	|| $pageCategory == '-'
	|| $pageCategory == '"'
	|| $pageCategory == '\''
	)
	{
		$pageCategory = '';
	}
	
	// in the $pageCompleteName "g1>g2>page" select only "page"
	$pageName = substr($pageCompleteName, $lastDelimiter + 1);
}
else
{
	$pageCategory = '';
	$pageName = $pageCompleteName;
}

// concerning names of pages in subgroups like /g1/g2/g3/ without page names
if(strcmp($pageName, '')===0)
{
	$pageName = DEFAULT_PAGE_NAME;
}



printDebug('<br>URL : '.$pageUrl);
printDebug('<br>pageName : '.$pageName);
printDebug('<br>pageCategory : '.$pageCategory);
printDebug('<br>a_vars : '); printDebug($a_vars);
printDebug('<br>referer : '); printDebug($refererUrl);
printDebug('<br>flash : '.$flash);
printDebug('<br>director : '.$director);
printDebug('<br>quicktime : '.$quicktime);
printDebug('<br>real player : '.$realPlayer);
printDebug('<br>windows media : '.$windowsMedia);
printDebug('<br>PDF : '.$pdf);
printDebug('<br>java : '.$java);
printDebug('<br>referer Url : '.$refererUrl);
printDebug('<br>id site : '.$idSite);
printDebug('<br>site Urls : '); printDebug($siteUrls);
printDebug('<br>site Info : '); printDebug($siteInfo);
printDebug('<br>user Agent : '.$userAgent);
printDebug('<br>os : '.$os);
printDebug('<br>browser : '.$a_browser['longName']);
printDebug('<br>resolution : '.$resolution);
printDebug('<br>color : '.$colorDepth);

// pageCategory contains only groups names, and is NOT finished by >

// remove phpsessid from URLs
/**
 * other information
 */
$todayDate = date("Y-m-d");

/**
 * try to recognize the visitor, with or without cookie
 * who said we are very strong ?
 */

// last_visit = last visit timestamp
// idcookie = id cookie

printDebug("<br><strong>Try to recognize the visitor...</strong><br>");


// does phpmyvisites cookie exist ?
if($GLOBALS['cookie']->isDefined())
{
	// yes, known visitor
	$idVisit = $GLOBALS['cookie']->getVar('idvisit');
	$idCookie = $GLOBALS['cookie']->getVar('idcookie');
	$lastVisit = $GLOBALS['cookie']->getVar('last_visit_time');
	$serverTime = $GLOBALS['cookie']->getVar('server_time');
	$serverDate = $GLOBALS['cookie']->getVar('server_date');
	
	if(DEBUG)
		printDebug("<br>We know the visitor (thanks to his cookie). <br>He has idvisit = $idVisit and went last time on ".getTimeForDisplay($lastVisit)."<br>"); 
}
else
{
	printDebug("=>We can't find the cookie...<br>");
	
	// compute IP
	$ip           = getIp();
	$ip2long      = ip2long($ip);
	exitIfIpExcluded($ip2long, $logo, $site);
	
	
	$tryPutCookie = true;
	
	// no
	// does the referer belong to the website ?	
	if($site->isUrlIn($refererUrl))
	{
		printDebug("=> Referer Is in the site ! try to catch the visitor...<br>");
		
		// referer is in the current site
		$refererUrlIsInSite = true;
		
		// does the config (os+browser+resolution+color_depth) and the IP match any visitor ?
		$r = query("SELECT idvisit, idcookie, TIME_TO_SEC(last_visit_time), TIME_TO_SEC(server_time)" .
				" FROM ".T_VISIT.
				" WHERE ip = '$ip2long'" .
				" AND os = '$os'" .
				" AND browser_name = '".$a_browser['shortName']."'
				  AND browser_version = '".$a_browser['version']."'" .
				" AND resolution = '$resolution'" .
				" AND color_depth = '$colorDepth'" .
				" AND server_date = '$todayDate'".
				" AND idsite = '$idSite'" .
				" ORDER BY last_visit_time DESC" .
				" LIMIT 1");
		if(mysql_num_rows($r)>0)
		{
			// yes
			$r = mysql_fetch_row($r);
			$idVisit = $r[0];
			$idCookie = $r[1];
			$lastVisit = $r[2];
			$serverTime = $r[3];
			$serverDate = date("Y-m-d");
			printDebug("=> We found the ip+config of visitor so he is known<br>");
		}
		else
		{
			// no
			// does the IP match any visitor ?		
			$r = query("SELECT idvisit, idcookie, TIME_TO_SEC(last_visit_time), TIME_TO_SEC(server_time)" .
				" FROM ".T_VISIT.
				" WHERE ip = '$ip2long'" .
				" AND server_date = '$todayDate'".
				" AND idsite = '$idSite'" .
				" ORDER BY last_visit_time DESC" .
				" LIMIT 1");
				
			if(mysql_num_rows($r)>0)
			{
				// yes
				$r = mysql_fetch_row($r);
				$idVisit = $r[0];
				$idCookie = $r[1];
				$lastVisit = $r[2];
				$serverTime = $r[3];
				$serverDate = date("Y-m-d");
				printDebug("=> We found the ip of visitor so he is known<br>");
			}
			else
			{
				// no
				// select the last visitor who visited this page last
				$r = query("SELECT v.idvisit, v.idcookie, TIME_TO_SEC(v.last_visit_time), TIME_TO_SEC(server_time)" .
					" FROM ".T_VISIT." as v, ".T_LINK_VP." as l, ".T_PAGE." as p, ".T_PAGE_URL." as pu" .
					" WHERE pu.url = '$refererUrl'" .
					" AND pu.idpage = p.idpage" .
					" AND p.idpage = l.idpage" .
					" AND l.idvisit = v.idvisit" .
					" AND v.server_date = '$todayDate'".
					" AND v.idsite = '$idSite'" .
					" ORDER BY l.idlink_vp DESC, v.last_visit_time DESC " .
					" LIMIT 1");

				if(mysql_num_rows($r)>0)
				{
					// yes
					$r = mysql_fetch_row($r);
					$idVisit = $r[0];
					$idCookie = $r[1];
					$lastVisit = $r[2];
					$serverTime = $r[3];
					$serverDate = date("Y-m-d");
					printDebug("=> We found the last visitor who visited the same page so he is known<br>");
				}
				else
				{
					// no
					// select the last visitor for this site
					$r = query("SELECT idvisit, idcookie, TIME_TO_SEC(last_visit_time), TIME_TO_SEC(server_time)" .
						" FROM ".T_VISIT.
						" WHERE idsite = '$idSite'" .
						" AND server_date = '$todayDate'".
						" ORDER BY last_visit_time DESC " .
						" LIMIT 1");
					if(mysql_num_rows($r)>0)
					{
						// yes
						$r = mysql_fetch_row($r);
						$idVisit = $r[0];
						$idCookie = $r[1];
						$lastVisit = $r[2];
						$serverTime = $r[3];
						$serverDate = date("Y-m-d");
						printDebug("=> We found the ip of visitor so he is known<br>");
						
					}
					else
					{
						printDebug("=> Very rare case : the visitor has a referer belonging to the site, " .
								"but is unknown for phpmyvisites<br>");
						$newVisitor = true;
					}
				}
			}
		}
	}
	else
	{
		// try to match a today's visitor with him. criterias are configuration (os+browser+resol+depth) and IP
		// !!! it may cause problem in intranet if people all have the same IP !!!
		$r = query("SELECT idvisit, idcookie, TIME_TO_SEC(last_visit_time), TIME_TO_SEC(server_time)" .
				" FROM ".T_VISIT.
				" WHERE ip = '$ip2long'" .
				" AND os = '$os'" .
				" AND browser_name = '".$a_browser['shortName']."'
				  AND browser_version = '".$a_browser['version']."'" .
				" AND resolution = '$resolution'" .
				" AND color_depth = '$colorDepth'" .
				" AND ip = '$ip2long'" .
				" AND pdf = '$pdf'" .
				" AND flash = '$flash'" .
				" AND java = '$java'" .
				" AND director = '$director'" .
				" AND quicktime = '$quicktime'" .
				" AND realplayer = '$realPlayer'" .
				" AND windowsmedia = '$windowsMedia'" .
				" AND server_date = '$todayDate'".
				" AND idsite = '$idSite'" .
				" ORDER BY idvisit DESC" .
				" LIMIT 1");
				
		if(mysql_num_rows($r)>0)
		{
			// yes
			$r = mysql_fetch_row($r);
			$idVisit = $r[0];
			$idCookie = $r[1];
			$lastVisit = $r[2];
			$serverTime = $r[3];
			$serverDate = date("Y-m-d");
			printDebug("=> We found the ip+config of visitor we suppose he is known (may cause problems in intranet)<br>");
		}
		else
		{
			// no, new visitor
			$newVisitor = true;
			printDebug("=> It's definitely a new visitor<br>");
		}
	}
}
/**
 * Current visitor is a new visitor or an old one
 * but without cookie, so we put a cookie
 */
if(isset($newVisitor) || isset($tryPutCookie))
{
	// record it and set the cookie
	$idCookie = $GLOBALS['cookie']->put(isset($idCookie)?$idCookie:'');
	
	// case : visitor known but cookie not set during his first page views...
	if(isset($idVisit))
	{
		$GLOBALS['cookie']->setVar('idvisit', $idVisit);
	}
	else
	{
		$lastVisit = todayTime();
	}
}

/**
 * Visitor is known, we now look if it's a new visit or not
 */
// is the visit older than 30 minutes ?
if(!isset($newVisitor))
{
	if(DEBUG)
		printDebug("(idvisit = $idVisit, ".getTimeForDisplay($serverTime)." | now : " .                         
				todayTime()." :: first page last time : $serverTime)");
	if ($serverDate == date("Y-m-d")
			&& ($serverTime > (todayTime() - $visitTime * 60))
		)
	{
		// yes, new visit
		$GLOBALS['cookie']->setVar('last_visit_time', todayTime());
		$knownVisit = true;
		
		printDebug("<br><b>=>Visit is known on  date : $serverDate</b><br>");
	}
	else
	{
		$expr = todayTime() - $visitTime * 60 ;
		printDebug("=>Last visit  is too old <b>==> New visit</b><br>");
	}
}
else
{
	printDebug("<br><b>=>New Visitor also means new visit</b><br>");
}


/*
 * find $idPageRef if possible
 */

// update referer information if referer belongs to the site and if visitor is known (we need idVisit !)
if(isset($idVisit) 
	&& !empty($refererUrl) 
	&& (isset($refererUrlIsInSite) || $site->isUrlIn($refererUrl))
	)
{
	$timeDiffRef = todayTime() - $lastVisit;
	
	// try to find the last "idpage" value
	// look in the cookie first if defined $a_idPage[$url]
	if($GLOBALS['cookie']->isDefined())
	{
		$a_idPage = $GLOBALS['cookie']->getVar('a_idPage');
		if(isset($a_idPage[$refererUrl]))
		{
			$idPageRef = $a_idPage[$refererUrl];
			printDebug("=>idPageRef found in cookie : $refererUrl => $idPageRef <br>");
		}
	}
	
	// else in database
	if(!isset($idPageRef))
	{
		// try to find it manually in the database (can be very heavy query)
		$r = query("SELECT l.idpage" .
				" FROM  ".T_LINK_VP." as l, ".T_PAGE." as p, ".T_PAGE_URL." as pu " .
				" WHERE l.idvisit = '$idVisit'" .
				" AND pu.url = '$refererUrl'" .
				" AND pu.idpage = p.idpage" .
				" AND p.idpage = l.idpage " .
				" ORDER BY pu.idpage_url DESC" .
				" LIMIT 1");
		if(mysql_num_rows($r)>0)
		{
			$r = mysql_fetch_assoc($r);
			$idPageRef = $r['idpage'];
			printDebug("=>idPageRef found in BDD : $refererUrl => $idPageRef <br>");
		}
	}
	
	if(!isset($idPageRef))
	{
		// url not found in database... don't save
		printDebug("=> Url ref not found in database and in cookie... forget it !<br>");
	}
}

if(!isset($idPageRef))
{
	$idPageRef = 0;
	$timeDiffRef = DEFAULT_TIME_PAGE;
}

/**
 * Current visit is a known visit
 */
// save current page, etc.
if(isset($knownVisit) && $knownVisit)
{
	// we know 
	// * $lastVisit
	// * $idVisit
	// * $idCookie
	
	// update last_visit_time
	printDebug("==> This is a visit known... we update the data <br>");
	
	// do it first because we need idpage for visit info insert
	$idPage = recordDbPage($pageName, $pageUrl, $pageCategory);
	
	// save current page & url & variables information
	$idLink_vp = recordDbInfoPage($idVisit, $idPage, $idPageRef, $timeDiffRef, $a_vars);
	
	$total_time = DEFAULT_TIME_PAGE + todayTime() - $serverTime;
	// update last_visit_time & total_pages & c_total_time
	$r = query("UPDATE ".T_VISIT.
			" SET last_visit_time = CURRENT_TIME()," .
				" total_pages = total_pages + 1," .
				" total_time = '$total_time'," .
				" exit_idpage = '$idPage'" .
			" WHERE idvisit = '$idVisit'" .
			" LIMIT 1");
			
	// if a page ref really exists
	if(isset($idPageRef) && $idPageRef != 0)
	{
		// save path
//		recordDbPath($idVisit, $idPageRef, $idPage); 
	}	
	// save idlink_pv in the cookie
}
/*
 * Current visit a new visit
 */
// now we know the visitor and its idcookie
// save new visit
else 
{
	printDebug("==> This is a new visit, we create datas in the database when necessary<br>");
	
	if(!isset($ip))
	{		
		$ip           = getIp();
		$ip2long      = ip2long($ip);
		exitIfIpExcluded($ip2long, $logo, $site);
	}
	$hostExt    = getHostnameExt(getHost($ip));
	printDebug('<br>ip : '.$ip);
	printDebug('<br>hostname : '.$hostExt);
	
	$serverDate = date("Y-m-d");
	$serverTime = date("H:i:s");
	
	$country = getCountry($hostExt, $browserLang);
	$continent = getContinent($country);
	
	if(strlen($refererUrl)===0)
	{
		$refererUrl = 'NULL';
	}
	else
	{
		$refererUrl = "'".$refererUrl."'";
	}
	
	// do it first because we need idpage for visit info insert
	$idPage = recordDbPage($pageName, $pageUrl, $pageCategory);
	
	// save visitor information
	$r = query("INSERT INTO ".T_VISIT." (idsite, idcookie, returning, last_visit_time, server_date, server_time, referer," .
					" os, browser_name, browser_version, resolution, color_depth, pdf, flash, java, director," .
					" quicktime, realplayer, windowsmedia, local_time," .
					" ip, hostname_ext, browser_lang, country, continent, total_pages, total_time, " .
					" entry_idpage, exit_idpage)" .
					" VALUES ('$idSite', '$idCookie', '$returningVisitor', CURRENT_TIME(), '$serverDate', '$serverTime', $refererUrl," .
					" '$os', '".$a_browser['shortName']."', '".$a_browser['version']."', '$resolution', 
					  '$colorDepth', '$pdf', '$flash', '$java', '$director'," .
					" '$quicktime', '$realPlayer', '$windowsMedia', '$localTime'," .
					" '$ip2long', '$hostExt', '$browserLang', '$country', '$continent', 1, '
					".DEFAULT_TIME_PAGE ."', " .
					" '$idPage', '$idPage')");
	$idVisit = mysql_insert_id();
	
	// save page view and URL and variables
	recordDbInfoPage($idVisit, $idPage, $idPageRef, $timeDiffRef, $a_vars);
	
	// save idvisit
	$GLOBALS['cookie']->setVar('idvisit', $idVisit);
	$GLOBALS['cookie']->setVar('last_visit_time', todayTime());
	$GLOBALS['cookie']->setVar('server_time', todayTime());
	$GLOBALS['cookie']->setVar('server_date', $serverDate);
	
}

// cookie post-process
// save in cookie
if($GLOBALS['cookie']->isDefined())
{
	$a_idPage = array();
	
	// save idpage of the current page in the a_idPage array in the cookie
	$a_idPage = $GLOBALS['cookie']->getVar('a_idPage');

	// if array size of "url => id" is superior to max_url_in_cookie, unset the array because the cookie can't be so big
	if(sizeof($a_idPage) > MAX_URL_IN_COOKIE) 
	{
		reset($a_idPage);
		unset($a_idPage[key($a_idPage)]);
	}
	
	// add current idpage
	$a_idPage[$pageUrl] = $idPage;
	
	$GLOBALS['cookie']->setVar('a_idPage', $a_idPage);	
}
	

$GLOBALS['cookie']->save();
printDebug("<br><b>Next cookie should be :</b>");
printDebug($GLOBALS['cookie']->getContent());

$db->close();

if(!PROFILING)
	loadImage($logo, $idSite);

// flush content for display
if(DEBUG)
	ob_end_flush();

if(PROFILING)
	xdebug_dump_function_profile(4);
/*
// TODO faire champ date et champ time au lieu de adteteim car DATE available since 4.1.1
SELECT avg( time ) , avg( query ) , max( time ) , max( query ) , min( query ) , count( * )
FROM query_log
LIMIT 0 , 40;

SELECT avg( time ) , avg( query ) , max( time ) , max( query ) , min( query ) , count( * )
FROM query_log
WHERE date=current_date() AND time < 2

 *
 * COMPARER DATES	
 *
SELECT date, avg( time ) , avg( query ) , max( time ) , max( query ) , min( query ) , count( * )
FROM query_log
WHERE (
date = '2005-09-02'
OR date = '2005-09-31'
OR date = '2005-09-03'
OR date = '2005-09-04'
OR date = '2005-09-04'
OR date = '2005-09-05'
)
AND time <2
GROUP BY date
ORDER BY date ASC
	

*
* REquetes lourdes
*
SELECT time
FROM query_log
WHERE time >2
LIMIT 0 , 40


SELECT browser_lang AS b, count( * ) AS s, idvisit
FROM visit
WHERE country = 'xx'
GROUP BY b
ORDER BY s DESC
LIMIT 0 , 30

visites & visiteur par date
select count(*), count( distinct idcookie), server_date from visit GROUP BY server_date

visites de plus de 20min
select  count(*), (TIME_TO_SEC(last_visit_time)-TIME_TO_SEC(server_time)) as toto 
from visit 
where server_date = '2005-07-26' and TIME_TO_SEC(last_visit_time)-TIME_TO_SEC(server_time) > 1200 
GROUP BY TIME_TO_SEC(last_visit_time)-TIME_TO_SEC(server_time) 


comparer phpmv v1 & v2

SELECT substring_index( host, '.', -1 ) AS h, count( * ) AS c
FROM phpmv
WHERE date = '2005-08-01'
GROUP BY h
HAVING char_length(
h
) =2
ORDER BY c DESC 
limit 0, 2000

SELECT substring_index( hostname, '.', -1 ) AS h, count( * ) AS c
FROM visit
WHERE server_date = '2005-08-01'
GROUP BY h
HAVING char_length(
h
) =2
ORDER BY c DESC 
limit 0, 2000
*/
?>