<?php
// +--------------------------------------------------------------------------+
// |   phpMyVisites   |   statistiques et mesure d'audience de sites Internet |
// +--------------------------------------------------------------------------+
// | Copyright (c) 2002-2004 Matthieu Aubry. Tous droits réservés             |
// +--------------------------------------------------------------------------+
// | Ce code est distribué sous license GNU GPL, disponible   '/docs/licence' |
// | Pour toute information supplémentaire :                                  |
// | http://www.phpmyvisites.net    |    matthieu@phpmyvisites.net            |
// +--------------------------------------------------------------------------+

//
// Technical information
//
$lang['auteur_nom'] = "Matthieu Aubry"; // nom du traducteur
$lang['auteur_email'] = "contacts sur http://www.phpmyvisites.net/index.php?part=contacts"; // email du traducteur
$lang['charset'] = "utf-8"; // charset du fichier de langue (utf-8 par défaut)
$lang['text_dir'] = "ltr"; // ('ltr' for left to right, 'rtl' for right to left)
$lang['lang_iso'] = "fr"; // iso language code
$lang['lang_libelle_en'] = "French"; // le nom de la langue en anglais
$lang['lang_libelle_fr'] = "Français"; // le nom de la langue en français
$lang['unites_bytes'] = array('Octets', 'Ko', 'Mo', 'Go', 'To', 'Po', 'Eo');
$lang['separateur_milliers'] = ' '; // trois cent mille s'écrit en français 300 000
$lang['separateur_decimaux'] = ','; // entre la partie entière d'un nombre et la partie décimale

//
// HTML Markups
//
$lang['head_titre'] = "phpMyVisites | application libre et gratuite de gestion de statistiques et de mesure d'audience de sites internet"; // Titre des pages de stats dans le header html
$lang['head_keywords'] = "phpmyvisites, php, script, application, logiciel, statistiques, mesure d'audience, audience, stats, gratuit, open source, gpl, visites, visiteurs, mysql, pages vues, pages, vues, temps de visites, graphiques, navigateurs, os, systèmes d'exploitation, résolutions, jour, semaine, mois, records, pays, host, fournisseurs d'accès, moteurs de recherche, mots clés, suivi, referrers, graphs, pages d'entrées, pages de sorties, camemberts"; // Mots clé dans le header html
$lang['head_description'] = "phpMyVisites | Application de statistiques et de mesure d'audience de sites Internet | Logiciel gratuit et open source distribué sous licence GPL, développé en php/MySQL"; // Description dans le header html
$lang['logo_description'] = "phpMyVisites : logiciel gratuit de mesure d'audience et de statistiques de sites Internet (licence libre GPL, logiciel en php/MySQL)"; // description pour le code JS : ne pas faire long

//
// Main menu & submenu
//
$lang['menu_visites'] = "Visites";
$lang['menu_pagesvues'] = "Pages vues";
$lang['menu_suivi'] = "Suivi";
$lang['menu_provenance'] = "Provenance";
$lang['menu_configurations'] = "Configurations";
$lang['menu_affluents'] = "Affluents";
$lang['menu_listesites'] = "Liste des sites";
$lang['menu_bilansites'] = "Résumé";
$lang['menu_jour'] = "Jour";
$lang['menu_semaine'] = "Semaine";
$lang['menu_mois'] = "Mois";
$lang['menu_annee'] = "Année";
$lang['menu_periode'] = "Période étudiée : %s"; // Période étudiée : Lundi 11 Novembre
$lang['liens_siteofficiel'] = "Site officiel";
$lang['liens_admin'] = "Installation &amp; configuration";
$lang['liens_contacts'] = "Contacts";

//
// Divers
//
$lang['generique_nombre'] = "Nombre";
$lang['generique_tauxsortie'] = "Taux de sortie";
$lang['generique_ok'] = "ok";
$lang['generique_erreur'] = "Erreur";
$lang['generique_erreurrubrique'] = "Erreur : la rubrique sélectionnée est inconnue.";
$lang['generique_erreurvar'] = "Erreur : une variable n'est pas correctement définie.";
$lang['generique_choixlangue'] = "Choix de la langue";
$lang['generique_total'] = "TOTAL";
$lang['generique_microtime'] = "Durée : %s secondes"; // temps en secondes
$lang['generique_timefooter'] = "La génération de la page a durée %s secondes"; // temps en secondes
$lang['generique_voirlesprecedents'] = "Voir les %s précédents";
$lang['generique_voirlessuivants'] = "Voir les %s suivants";
$lang['generique_divers'] = "Divers"; // (pour les graphs)
$lang['generique_inconnu'] = "Inconnu"; // (pour les graphs)
$lang['generique_vous'] = "... Vous ?";
$lang['generique_traducteur'] = "Traducteur";
$lang['generique_langue'] = "Langue"; 
$lang['generique_autrelangure'] = "Autre ?"; // Autre langue, appel à contribution
$lang['aucunvisiteur_titre'] = "Pas de visite sur cette période."; 
$lang['aucunvisiteur_titre1'] = "Aucun visiteur le %s."; // Aucun visiteur le Mercredi 24 Janvier 2004
$lang['aucunvisiteur_titre2'] = "Aucun visiteur pour la %s."; // Aucun visiteur pour la Semaine du 24 Janvier au 2 Février 2004
$lang['aucunvisiteur_titre3'] = "Aucun visiteur pour le %s."; // Aucun visiteur pour le Mois de Décembre 2003
$lang['aucunvisiteur_periodeinvalide'] = "Impossible de consulter les statistiques sur cette période car aucun jour n'est encore achevé.<br />Or les statistiques sur des périodes sont seulement effectuées sur des jours terminés.";
$lang['generique_betaversion'] = "Version bêta %s de phpMyVisites en cours de développement et en phase de test."; // Version bêta 1.2 de phpMyVisites
$lang['generique_aucune_visite_bdd'] = "<b>Attention ! </b> Vous n'avez aucune visite enregistrée dans la base de données. Please be sure you've installed your javascript code on your pages, with the correct phpMyVisites URL <u>IN</u> the Javascript code. Try documentation for help."; 
$lang['generique_aucune_site_bdd'] = "Aucun site enregistré dans la base de données ! Logguez vous en tant que super administrateur pour ajouter un nouveau site à phpMyVisites."; 
$lang['generique_retourhaut'] = "Haut";
$lang['generique_tempsvisite'] = "%1\$smin %2\$ss"; 
$lang['generique_tempsheure'] = "%sh"; // 4 h means 4 hours
$lang['generique_siteno'] = "Site %s"; // Site "phpmyvisites"
$lang['generique_newsletterno'] = "Newsletter %s"; // Newsletter "version 2 announcement" 
$lang['generique_partnerno'] = "Partenaire %s"; // Newsletter "version 2 announcement"
$lang['generique_general'] = "Général"; 
$lang['generique_previous'] = "Précédent"; 
$lang['generique_next'] = "Suivant";
$lang['generique_lowpop'] = "Exclure les petites populations des statistiques";
$lang['generique_allpop'] = "Inclure toute la population dans les statistiques"; 
$lang['generique_to'] = "à"; // 4 'to' 8 
$lang['generique_total'] = "sur"; // 4 to 8 'on' 10 
$lang['generique_information'] = "Informations"; 
$lang['generique_done'] = "Validé!"; 

//
// Authentification
//
$lang['login_private1'] = "La consultation des statistiques de %s phpMyVisites %s est protégée."; // lien vers le site
$lang['login_private2'] = "La zone d'administration de %s phpMyVisites %s est protégée."; // lien vers le site
$lang['login_password'] = "password :"; // en minuscule
$lang['login_login'] = "login :"; // en minuscule
$lang['login_error'] = "Erreur lors de la connexion. Mauvais login/mot de passe.";
$lang['login_protected'] = "Vous souhaitez rentrer dans une zone protégée de  %s phpMyVisites %s.";

//
// Contacts & "Others ?"
//
$lang['contacts_titre'] = "Contacts";
$lang['contacts_langue'] = "Traductions";
$lang['contacts_merci'] = "Remerciements";
$lang['contacts_auteur'] = "L'auteur de l'application, de la documentation et créateur du projet phpMyVisites est <strong>Matthieu Aubry</strong>.";
$lang['contacts_questions'] = "Pour toute <strong>question technique, rapport de bug, ou suggestion</strong>, veuillez s'il vous plaît <strong>utiliser les forums prévus à cet effet</strong> sur le site officiel %s. Pour les autres demandes, veuillez contactez l'auteur en utilisant le formulaire sur le site officiel."; // adresse du site
$lang['contacts_trad1'] = "Vous souhaiteriez utiliser phpMyVisites dans une autre langue ? N'hésitez pas à contribuer vous-même aux traductions de l'application, <strong>phpMyVisites a besoin de vous !</strong>";
$lang['contacts_trad2'] = "Traduire phpMyVisites est un travail qui demande un peu de temps (quelques heures) et qui nécessite une parfaite maîtrise de la langue dans laquelle la traduction est effectuée ; mais <strong>le travail réalisé sera utile à de très nombreux autres utilisateurs</strong>, lesquels pourront pleinement utiliser phpMyVisites. Si vous êtes intéressé pour traduire phpMyVisites, vous trouverez toutes les informations nécessaires dans %s la documentation officielle de phpMyVisites %s."; // lien vers la doc
$lang['contacts_doc'] = "N'hésitez pas à consulter %s la documentation officielle de phpMyVisites %s qui vous donnera de très nombreuses informations sur l'installation, la configuration, les fonctionnalités de phpMyVisites, etc. Elle est disponible directement dans votre version de phpMyVisites."; // lien vers la doc
$lang['contacts_merci1'] = "Merci à <strong>Marc Boussard</strong>, co-développeur de phpMyVisites, pour son implication dans le projet et la qualité de son travail.";
$lang['contacts_merci3'] = "N'hésitez pas à consulter la page remerciements sur le site officiel de phpMyVisites pour avoir une liste plus complète des amis de phpMyVisites.";
$lang['contacts_merci2'] = "Un grand merci également à tous ceux qui ont partagé leur culture en contribuant à la traduction de phpMyVisites :";

//
// Rss
//
$lang['rss_titre'] = "Site %1\$s le %2\$s"; // Site MyHomePage on Sunday 29 
$lang['rss_go'] = "Aller aux statistiques détaillés";

//
// Visits Part
//
$lang['visites_titre'] = "Informations visites";
$lang['visites_statistiques'] = "Statistiques";
$lang['visites_periodesel'] = "Pour la période sélectionnée";
$lang['visites_visites'] = "Visites";
$lang['visites_uniques'] = "Visiteurs uniques";
$lang['visites_pagesvues'] = "Pages vues";
$lang['visites_pagesvisiteurs'] = "Pages vues par visiteur";
$lang['visites_pagesvisites'] = "Pages par visite";  
$lang['visites_pagesvisitessign'] = "Pages par visite significative";
$lang['visites_tempsmoyen'] = "Temps moyen de visite";
$lang['visites_tempsmoyenpv'] = "Temps moyen par page vue";
$lang['visites_tauxvisite'] = "Taux de visites à une page";
$lang['visites_recapperiode'] = "Récapitulatifs sur la période";
$lang['visites_nbvisites'] = "Visites";
$lang['visites_nonarchive'] = "Non archivé"; // dans tableau, faire court
$lang['visites_aucunevivisite'] = "Aucune visite"; // dans tableau, faire court
$lang['visites_recap'] = "Récapitulatif";
$lang['visites_unepage'] = "1 page"; // (graph)
$lang['visites_pages'] = "%s pages"; // 1-2 pages (graph)
$lang['visites_min'] = "%s min"; // 10-15 min (graph)
$lang['visites_sec'] = "%s s"; // 0-30 s (secondes, graph)
$lang['visites_grapghrecap'] = "Graphique récapitulatif des statistiques";
$lang['visites_graphtempsvisites'] = "Graphique des durées des visites par visiteur";
$lang['visites_graphtempsvisitesimg'] = "Durée des visites par visiteur";
$lang['visites_graphheureserveur'] = "Graphique des visites par heure du serveur";
$lang['visites_graphheureserveurimg'] = "Visites heures serveur";
$lang['visites_graphheurevisiteur'] = "Graphique des visites par heure du visiteur";
$lang['visites_graphheurelocalimg'] = "Visites heures locales";
$lang['visites_graphlieux'] = "Graphique des lieux de connexion";
$lang['visites_graphlieuximg'] = "Lieux de connexion";
$lang['visites_domicile'] = "Domicile";
$lang['visites_travail'] = "Travail";

//
// Frequency Part
//
$lang['frequence_titre'] = "Fréquence des visites";
$lang['frequence_nouveauxconnus'] = "Nouveaux visiteurs et visiteurs connus";
$lang['frequence_titremenu'] = "Fréquence"; 
$lang['frequence_visitesconnues'] = "Visiteurs connus"; 
$lang['frequence_nouvellesvisites'] = "Nouvelles visites"; 
$lang['frequence_returningrate'] = "Taux de retour"; 
$lang['frequence_vispervis'] = "Nombre de visites par visiteur"; 
$lang['frequence_vis'] = "visite"; 

//
// Seen Pages
//
$lang['pagesvues_titre'] = "Informations pages vues";
$lang['pagesvues_joursel'] = "Jour sélectionné";
$lang['pagesvues_jmoins7'] = "Jour J-7";
$lang['pagesvues_jmoins14'] = "Jour J-14";
$lang['pagesvues_moyenne'] = "(moyenne)";
$lang['pagesvues_pagesvues'] = "Pages vues";
$lang['pagesvues_pagesvudiff'] = "Pages vues différentes";
$lang['pagesvues_recordpages'] = "Record de pages vues pour 1 visiteur";
$lang['pagesvues_tabdetails'] = "Tableau des détails des pages vues (de %s à %s)"; // (de 1 à 21)
$lang['pagesvues_graphsnbpages'] = "Graphique des visites par nombre de pages vues";
$lang['pagesvues_graphnbvisitespageimg'] = "Visites par nombre de pages vues";
$lang['pagesvues_graphheureserveur'] = "Graphique des pages vues par heure du serveur";
$lang['pagesvues_graphheureserveurimg'] = "Pages vues heures serveur";
$lang['pagesvues_graphheurevisiteur'] = "Graphique des pages vues par heure du visiteur";
$lang['pagesvues_graphpageslocalimg'] = "Pages vues heures locales";
$lang['pagesvues_tempsparpage'] = "Temps par page"; 

//
// Follows-Up
//
$lang['suivi_titre'] = "Suivi du visiteur";
$lang['suivi_pageentree'] = "Pages d'entrées";
$lang['suivi_pagesortie'] = "Pages de sortie";
$lang['suivi_cheminvisiteur'] = "Suivi du chemin du visiteur";
$lang['suivi_nombre'] = "Nombre";
$lang['suivi_tauxsortie'] = "Taux de sortie";
$lang['suivi_dea'] = " (de %s à %s)"; // suivi du chemin du visiteur (de 1 à 1)
$lang['suivi_pageselectionnee'] = "Page sélectionnée : %s"; // Page sélectionnée : /index.php
$lang['suivi_lapage'] = "La page %s ne propose pas de suivi, son taux de sortie étant de 100%%. <br />La page d'entrée principale %s est utilisée pour les calculs."; // La page /index.php ne propose pas de suivi...
$lang['suivi_aucunsuivi'] = "Aucun suivi n'a été enregistré. Peut-être n'avez vous qu'une seule page vue sur le site aujourd'hui ?";
$lang['suivi_pageentreehits'] = "Hits d'entrée"; 
$lang['suivi_pagesortiehits'] = "Hits de sortie"; 
$lang['suivi_singlepage'] = "Pages des visites à une page"; 

//
// Origin
//
$lang['provenance_titre'] = "Provenance";
$lang['provenance_recappays'] = "Récapitulatif des pays";
$lang['provenance_pays'] = "Pays";
$lang['provenance_paysimg'] = "Graphique des pays des visiteurs";
$lang['provenance_fai'] = "Fournisseurs d'accès";
$lang['provenance_nbpays'] = "Nombre de nationalités différentes : %s"; 
$lang['provenance_provider'] = "Providers"; // le même que $lang['provenance_fai'], sauf si $lang['provenance_fai'] est trop long
$lang['provenance_nombre'] = "Nombre";
$lang['provenance_continent'] = "Continent";
$lang['provenance_mappemonde'] = "Mappemonde";
$lang['provenance_backmap'] = "Retour à la mappemonde";
$lang['provenance_error_font'] = "La police %s n'a pas été trouvée. Essayez de la télécharger sur le site de phpMyVisites.";
$lang['provenance_interetspays'] = "Intérêts par pays"; 

//
// Setup
//
$lang['configurations_titre'] = "Configurations visiteurs";
$lang['configurations_os'] = "Systèmes d'exploitation";
$lang['configurations_osimg'] = "Graphique des systèmes d'exploitation par visiteur";
$lang['configurations_navigateurs'] = "Navigateurs";
$lang['configurations_navigateursimg'] = "Graphique des navigateurs par visiteur";
$lang['configurations_resolutions'] = "Résolutions";
$lang['configurations_resolutionsimg'] = "Graphique des résolutions par visiteur";
$lang['configurations_couleurs'] = "Couleurs";
$lang['configurations_couleursimg'] = "Graphique des couleurs par visiteur";
$lang['configurations_rapport'] = "Ecran large/normal";
$lang['configurations_large'] = "Ecran large";
$lang['configurations_normal'] = "Ecran normal";
$lang['configurations_double'] = "Bi-écran"; 
$lang['configurations_type'] = "Type"; // utilisé dans le tableau des écrans larges/normaux
$lang['configurations_plugins'] = "Plugins";
$lang['configurations_navigateursbytype'] = "Navigateurs (par famille)";
$lang['configurations_navigateursbytypeimg'] = "Graphiques des familles de navigateurs";
$lang['configurations_os_interest'] = "Intérêts par système d'exploitation"; 
$lang['configurations_navigateurs_interest'] = "Intérêts par navigateur"; 
$lang['configurations_resolutions_interest'] = "Intérêts par résolution"; 
$lang['configurations_couleurs_interest'] = "Intérêts par profondeur de couleurs"; 
$lang['configurations_configurations'] = "Intérêts par configuration"; 

//
// Referers
//
$lang['affluents_titre'] = "Affluents";
$lang['affluents_recapimg'] = "Graphique récapitulatif des affluents";
$lang['affluents_directimg'] = "Direct";
$lang['affluents_sitesimg'] = "Sites";
$lang['affluents_moteursimg'] = "Moteurs";
$lang['affluents_newslettersimg'] = "Mailing"; 
$lang['affluents_partenairesimg'] = "Partenaires"; 
$lang['affluents_referrersimg'] = "Affluents";
$lang['affluents_moteurs'] = "Moteurs de recherche";
$lang['affluents_nbparmoteur'] = "Nombre de visiteurs ayant accédé au site par des moteurs de recherche : %s";
$lang['affluents_aucunmoteur'] = "Aucun visiteur n'a accédé au site par des moteurs de recherche.";
$lang['affluents_motscles'] = "Mots clés";
$lang['affluents_nbmotscles'] = "Nombre de mots clés différents : %s";
$lang['affluents_aucunmotscles'] = "Aucun mot clé n'a été détecté.";
$lang['affluents_sitesinternet'] = "Sites internet";
$lang['affluents_nbautressites'] = "Nombre de visiteurs ayant accédé au site par des liens sur d'autres sites internet : %s";
$lang['affluents_nbautressitesdiff'] = "Nombre de sites différents : %s";
$lang['affluents_aucunautresite'] = "Aucun visiteur n'a accédé au site par d'autres sites internet.";
$lang['affluents_entreedirecte'] = "Entrées directes";
$lang['affluents_nbentreedirecte'] = "Nombre de visiteurs ayant accédé directement au site : %s";
$lang['affluents_nbpartenaires'] = "Nombre de visiteurs ayant accédé au site par des liens sur des sites partenaires : %s"; 
$lang['affluents_aucunpartenaire'] = "Aucun visiteur n'a accédé au site depuis un lien sur un site partenaire."; 
$lang['affluents_nbnewsletters'] = "Nombre de visiteurs ayant accédé au site par des liens dans des newsletters : %s"; 
$lang['affluents_aucunnewsletter'] = "Aucun visiteur n'a accédé au site depuis un lien dans une newsletter."; 
$lang['affluents_motinconnu'] = "Mot clé inconnu"; // affiché pour un moteur pour lequel on ne peut avoir le mot clé
$lang['affluents_sites_page'] = "Pages"; // dans le tableau sous résultats de sites referrers
$lang['affluents_details'] = "Détails"; // dans le tableau sous résultats de sites referrers
$lang['affluents_interetsmoteurs'] = "Intérêts par moteurs de recherche"; 
$lang['affluents_motscles'] = "Mots clés"; 
$lang['affluents_interetsmotscles'] = "Intérêts par mots clés"; 
$lang['affluents_interetssitesinternet'] = "Intérêts par sites Internet"; 
$lang['affluents_partenairesimg'] = "Partenaires"; 
$lang['affluents_partenaires'] = "Partenaires"; 
$lang['affluents_interetspartenaires'] = "Intérêts par sites partenaires"; 
$lang['affluents_newslettersimg'] = "Newsletters"; 
$lang['affluents_newsletters'] = "Newsletters"; 
$lang['affluents_interetsnewsletters'] = "Intérêts par newsletter"; 

//
// Summary
//
$lang['purge_titre'] = "Résumé des visites et affluents";
$lang['purge_intro'] = "Cette période a été purgée dans l'administration : seules les statistiques essentielles ont été sauvegardées.";
$lang['admin_purge'] = "Purge et optimisation de la base de données";
$lang['admin_sitepurge'] = "Veuillez choisir le site sur lequel vous souhaitez faire des opérations :";
$lang['admin_purgeintro'] = "Cette rubrique vous permet de gérer les tables de phpMyVisites. Vous pouvez consulter la taille occupée par les tables, les optimiser (à conseiller sur les tables de taille importante), ou supprimer des enregistrements anciens. Cela vous permettra de limiter les tailles de vos tables dans la base de données.";
$lang['admin_optimisation'] = "Optimisation de [ %s ]..."; // nom des tables
$lang['admin_postopt'] = "La taille totale a diminuée de %chiffres% %unites%"; // Ex : 28 Ko
$lang['admin_purgeres'] = "Purge des périodes suivantes : %s";
$lang['admin_purge_fini'] = "Fin de l'opération de purge des tables...";
$lang['admin_bdd_nom'] = "Nom";
$lang['admin_bdd_enregistrements'] = "Enregistrements";
$lang['admin_bdd_taille'] = "Taille table";
$lang['admin_bdd_opt'] = "Optimiser";
$lang['admin_bdd_purge'] = "Purge des tables";
$lang['admin_bdd_optall'] = "Tout optimiser";
$lang['admin_purge_j'] = "Purge des éléments vieux de %s jours";
$lang['admin_purge_s'] = "Purge des éléments vieux de %s semaines";
$lang['admin_purge_m'] = "Purge des éléments vieux de %s mois";
$lang['admin_purge_logs'] = "Purge des logs (Archiver tous les jours terminés)";
$lang['admin_purge_autres'] = "Purge commune à la table '%s'";
$lang['admin_purge_none'] = "Aucune action possible";
$lang['admin_purge_cal'] = "Calculer et purger (cela peut prendre quelques minutes)";
$lang['admin_alias_title'] = "Alias et URLs du site"; 
$lang['admin_partner_title'] = "Sites partenaires"; 
$lang['admin_newsletter_title'] = "Newsletters du site"; 
$lang['admin_ip_exclude_title'] = "Plage d'Ip à exclure des statistiques"; 
$lang['admin_name'] = "Nom:"; 
$lang['admin_error_ip'] = "L'Ip doit être dans un format correct: %s"; 
$lang['admin_site_name'] = "Nom du site"; 
$lang['admin_site_url'] = "URL principale du site"; 
$lang['admin_db_log'] = "Essayez de vous identifier en tant que Super Utilisateur de phpMyVisites pour changer les paramètres de configuration de l'accès à la base de données."; 
$lang['admin_error_critical'] = "Erreur, doit être réparé pour que phpMyVisites fonctionne correctement."; 
$lang['admin_warning'] = "Attention, phpMyVisites pourrait fonctionner correctement mais certaines fonctionnalités seront indisponibles."; 

//
// Setup
//
$lang['admin_titre'] = "Installation &amp; configuration"; // Installation & configuration
$lang['admin_intro'] = "Bienvenue dans la partie configuration de phpMyVisites. Vous pouvez modifier et paramétrer toutes les informations relatives à votre installation. Si vous avez des problèmes avec l'utilisation de certaines fonctionnalités, n'hésitez pas à consulter %s la documentation officielle de phpMyVisites %s."; // lien vers la documentation
$lang['admin_configetperso'] = "Configuration générale";
$lang['admin_ajoutsite'] = "Ajouter un site internet aux statistiques";
$lang['admin_modifsite'] = "Modifier les informations d'un site configuré";
$lang['admin_afficherjavascript'] = "Afficher le code javascript à insérer sur les pages";
$lang['admin_cookieadmin'] = "Ne pas vous prendre en compte dans les statistiques";
$lang['admin_gestionlangues'] = "Gestion des langues";
$lang['admin_saisienouveausite'] = "Vous allez ajouter le site n°%s Veuillez saisir les informations relatives au nouveau site."; // le site n°2
$lang['admin_sitesenregistres'] = "Liste des sites enregistrés :";
$lang['admin_modifetvalid'] = "Vous allez modifier le site n°%s Saisissez les informations et validez"; // le site n°2
$lang['admin_sitejavascript'] = "Cliquez sur le site dont vous souhaitez afficher le code javascript :";
$lang['admin_retour'] = "Retour";
$lang['admin_sitecookie'] = "Cliquez sur le site dont vous souhaitez ne pas être pris en compte pour les stats :";
$lang['admin_cookienavigateur'] = "Vous avez la possibilité de ne pas tenir compte de vos visites sur le site et de ne pas être totalisé par phpMyVisites. La méthode utilisée repose sur les cookies, cette option ne sera donc valable que pour le navigateur que vous utilisez au moment de la configuration. Vous pouvez bien sûr changer cette configuration ici à tout moment.";
$lang['admin_prendreencompteadmin'] = "Prendre en compte l'admin pour les statistiques (supprimer le cookie)";
$lang['admin_nepasprendreencompteadmin'] = "Ne pas prendre en compte l'admin pour les statistiques (mettre un cookie)";
$lang['admin_etatcookieoui'] = "Actuellement vous êtes pris en compte dans les statistiques pour ce site (ceci est la configuration par défaut, vous êtes considéré comme un visiteur normal).";
$lang['admin_etatcookienon'] = "Actuellement vous n'êtes pas pris en compte pour les statistiques pour ce site (Lorsque vous visitez le site ci-dessus, vous n'êtes pas comptabilisé par phpMyVisites).";
$lang['admin_explicationslangues'] = "Vous avez la possibilité de définir une langue par défaut ; elle sera alors automatiquement chargée lors de vos visites, quel que soit le navigateur utilisé. Vous pouvez également supprimer des fichiers de langues existantes.";
$lang['admin_langesconfigurees'] = "Voici les langues actuellement configurées :";
$lang['admin_langue'] = "Langue";
$lang['admin_fichier'] = "Fichier";
$lang['admin_languesdispos'] = "Voici les fichiers langues actuellement disponibles :";
$lang['admin_verifdispoconfigure'] = "Si ce tableau n'est pas équivalent à celui en dessous faites \"Recharger les fichiers de langues\"";
$lang['admin_action'] = "Action";
$lang['admin_defaut'] = "Défaut";
$lang['admin_pardefaut'] = "Par défaut";
$lang['admin_supprimer'] = "Supprimer";
$lang['admin_erreur'] = "Erreur";
$lang['admin_creationfichier'] = "Création du fichier %s"; // Création du fichier config.php...
$lang['admin_suppfichier'] = "Suppression du fichier %s"; // Suppression du fichier config.php...
$lang['admin_erreursupplangue'] = "Erreur lors de la suppression du fichier %s"; // Erreur lors de la suppression du fichier config.php
$lang['admin_deleteconfirm'] = "Veuillez confirmer que vous souhaitez effacer %s ?"; 
$lang['admin_sitedeletemessage'] = "<u>Faites très attention</u> : toutes les données associéees à ce site seront supprimées <br>et il n'y aura aucune moyen de récupérer cette perte de données !"; 
$lang['admin_confirmyes'] = "Oui, je souhaite le supprimer"; 
$lang['admin_confirmno'] = "Non, je ne souhaite pas le supprimer"; 
$lang['admin_nonewsletter'] = "Aucune newsletter trouvée pour ce site !"; 
$lang['admin_nopartner'] = "Aucun site partenaire trouvé pour ce site !"; 
$lang['admin_get_question'] = "Enregistrer les variables GET (dans l'URL) ?"; 
$lang['admin_get_a1'] = "Enregistrer toutes les variables"; 
$lang['admin_get_a2'] = "Ne pas enregistrer les variables"; 
$lang['admin_get_a3'] = "Enregistrer seulement les variables spécifiées"; 
$lang['admin_get_a4'] = "Enregistrer toutes les variables sauf celles spécifiées"; 
$lang['admin_get_list'] = "Noms des variables (séparées par des <b>;</b>) <br/>Exemple : %s"; 
$lang['admin_required'] = "%s est requis."; 
$lang['admin_title_required'] = "Requis"; 
$lang['admin_write_dir'] = "Répertoire avec droits d'écriture"; 
$lang['admin_chmod_howto'] = "Ces répertoires doivent autoriser l'écriture par le serveur web. Pour cela, vous devez faire un chmod 755 sur ces répertoires avec votre logiciel FTP (clic droit sur le répertoire > chmod (ou permissions))"; 
$lang['admin_optional'] = "Optionnel"; 
$lang['admin_memory_limit'] = "Limite de mémoire"; 
$lang['admin_allowed'] = "autorisé"; 
$lang['admin_webserver'] = "Serveur web"; 
$lang['admin_server_os'] = "Serveur OS"; 
$lang['admin_server_time'] = "Server time"; 
$lang['admin_legend'] = "Légende :"; 
$lang['admin_error_url'] = "L'URL doit être dans un format correct : %s (sans slash à la fin)"; 
$lang['admin_url_n'] = "Url %s:"; 
$lang['admin_url_aliases'] = "Alias d'URLs"; 
$lang['admin_logo_question'] = "Afficher le logo ?"; 
$lang['admin_type_again'] = "(recommencez)"; 
$lang['admin_admin_mail'] = "Email Super Administrateur"; 
$lang['admin_admin'] = "Super Utilisateur";
$lang['admin_phpmv_path'] = "Chemin complet d'accès à votre répertoire phpmyvisites"; 
$lang['admin_valid_email'] = "L'Email doit être un email valide."; 
$lang['admin_valid_pass'] = "Le mot de passe doit être plus complexe (6 caractères minimum, et doit contenir des chiffres)"; 
$lang['admin_match_pass'] = "Les mots de passe ne correspondent pas."; 

//
// Archives
//
$lang['archivage_ok'] = "ok"; // avec succès
$lang['archivage_error'] = "Erreur : ";
$lang['archivage_temporaire'] = "Archivage temporaire (jour non terminé) du %s : "; // du Mardi 29 Mars 2004
$lang['archivage_nontemporaire'] = "Archivage du %s : "; // Archivage
$lang['archivage_periodearchivee'] = "Période archivée";
$lang['archivage_dejaarchive'] = "Période temporaire déjà archivée";
$lang['archivage_semaine'] = "Archivage de la semaine %s (du %s au %s) :";    // Archivage de la semaine 14 (du 2004-03-29 au 2004-04-04)
$lang['archivage_mois'] = "Archivage de %s (du %s au %s) :";     // Archivage de Mars 2004 (du 2004-03-01 au 2004-03-31)
$lang['archivage_archivagetemporaire'] = " Cet archivage est temporaire.";

//
// Installation Step
//
$lang['install_txt1'] = "Bienvenue dans la phase d'installation de phpMyVisites. L'installation est automatique et se fait en 3 phases simples et rapides. Prévoyez un total d'une dizaine de minutes pour obtenir vos premières statistiques.";
$lang['install_txt2'] = "A la fin de l'installation, une requête sera faite vers le site officiel, <strong>dans le seul but de comptabiliser le nombre d'utilisateurs de phpMyVisites</strong> (bien sûr, aucune information confidentielle ne sera transmise). Merci de votre compréhension.";
$lang['install_txt3'] = "<strong>Si vous procédez à une mise à jour</strong>, dans le champ \"Préfixe\", entrez le préfixe (sans le '_' final) qui est attribué aux tables de phpMyVisites déjà présentes dans votre base de données. Pour plus d'informations, consultez la documentation.";
$lang['install_phase1a3'] = "Phase 1 de 3 : saisie des informations";
$lang['install_phase2a3'] = "Phase 2 de 3 : configuration &amp; personnalisation";
$lang['install_phase3a3'] = "Phase 3 de 3 : prise en compte des statistiques";
$lang['install_saisieinfos'] = "Veuillez saisir les informations relatives à la base de données Mysql.";
$lang['install_nomsite'] = "Nom du site";
$lang['install_adressesite'] = "Adresse du site (finie par un '/')";
$lang['install_loginmysql'] = "Login MySQL";
$lang['install_mdpmysql'] = "Mot de passe MySQL";
$lang['install_serveurmysql'] = "Serveur MySQL";
$lang['install_basemysql'] = "Base MySQL";
$lang['install_prefixetable'] = "Préfixe des tables";
$lang['install_utilisateursavances'] = "Utilisateurs avancés (facultatif)";
$lang['install_variablesget'] = "Prendre en compte tout ou partie des paramètres GET (variables de l'URL). <br />'Non' Signifie que seule la page sera comptabilisée, sans les éventuelles variables du type '?date=09102003&amp;partie=2'";
$lang['install_oui'] = "Oui";
$lang['install_non'] = "Non";
$lang['install_explicationsget'] = "Si Oui, spécifiez éventuellement les paramètres GET à ne pas prendre en compte (séparer les noms de variables par des ;\"). <br />&nbsp;&nbsp;&nbsp;Si vous voulez prendre en compte toutes les variables de l'url, laissez ce champ vide";
$lang['install_continuer'] = "Continuer";
$lang['install_annuler'] = "Annuler";
$lang['install_ok'] = "ok";
$lang['install_probleme'] = "Problème : ";
$lang['install_erreur'] = "Erreur";
$lang['install_essaiconnexion'] = "Essai de connexion... ";
$lang['install_connexionimpossible'] = "Impossible de se connecter à la base de données.";
$lang['install_connexionreussie'] = "Connexion réussie !";
$lang['install_selectionbasemysql'] = "Essai de sélection de la base de données... ";
$lang['install_selectionimpossible'] = "Impossible de sélectionner la base de données.";
$lang['install_baseselectionnee'] = "Base sélectionnée !";
$lang['install_creationtables'] = "Création des tables...";
$lang['install_erreurmiseajournormale'] = "Cette erreur est normale si vous procédez à une mise à jour de phpMyVisites : les tables existent déjà et vous n'avez pas besoin de les récréer. Vous pouvez donc continuer la reconfiguration. <br>Si vous n'êtes pas en train de faire une mise à jour, vérifiez que vous avez les droits pour créer des tables dans la base de données (vérifiez auprès de l'administrateur réseau).";
$lang['install_urlinvalide'] = "L'adresse entrée est invalide. Veillez à bien respecter le format \"http://www.adresse.com/\".";
$lang['install_problemedroitrepertoire'] = "Cannot write in the repertory %s : please verify that you have the rights necessary to create files on the server (try to CHMOD 755 the repertory with your FTP software (right click on the directory -> Permissions (or CHMOD))."; // Cannot access the file config.php... 
$lang['install_remplirchamps'] = "Veuillez bien remplir tous les champs.";
$lang['install_loginadmin'] = "Login d'accès à l'administration :";
$lang['install_mdpadmin'] = "Mot de passe d'accès à l'administration :";
$lang['install_chemincomplet'] = "Chemin complet d'accès à phpMyVisites (de la forme 'http://www.monsite.com/rep1/rep3/phpmyvisites/'). Le chemin doit finir par un '<strong>/</strong>'.";
$lang['install_rendrestatspubliques'] = "Je souhaite rendre publique mes statistiques et ne pas en restreindre l'accès (sauf la partie administration qui restera protégée par le login/mot de passe ci-dessus).";
$lang['install_nepasrendrestatspubliques'] = "Je préfère protéger l'accès à l'ensemble de phpMyVisites (statistiques et partie administration) par le login/mot de passe ci-dessus.";
$lang['install_afficherlogo'] = "Afficher le logo %s sur les pages indexées ? <strong>Autoriser l'affichage du logo sur votre site permettra à phpMyVisites de mieux se faire connaître de tous et ainsi d'évoluer plus rapidement : c'est une manière de remercier l'équipe de développement</strong> qui a passé de très nombreuses heures à développer cette application libre et gratuite."; // %s remplacé par l'image du logo
$lang['install_affichergraphique'] = "Afficher les graphiques lors de la consultation des statistiques ?";
$lang['install_valider'] = "Valider"; // à l'install et au login
$lang['install_accederpersonnaliser'] = "Vous pouvez maintenant configurer l'accès aux statistiques et personnaliser phpMyVisites.";
$lang['install_configok'] = "Vous avez configuré avec succès phpMyVisites. Bravo !";
$lang['install_explicationjavascript'] = "Pour enregistrer toutes les données dans la base Mysql configurée, il est nécessaire d'insérer le code javascript suivant sur toutes les pages du site dont vous souhaitez obtenir les statistiques. %s Les pages du site ne doivent pas nécessairement être en php, <strong>phpMyVisites fonctionnera très bien sur des pages HTML, ASP, PERL ou autres.</strong>%s Voici le code (effectuez simplement un copier coller sur vos pages, <strong>mais ne transformez pas le code auquel cas l'enregistrement des données serait erroné !</strong>) : "; // les %s remplacés par des sauts de lignes
$lang['install_explicationchemin'] = "Si le chemin du répertoire de phpMyVisites n'est pas '%s' changez le par le bon chemin (de la forme par exemple './web/monsite1/phpmyvisites/' ou encore 'http://www.monsite.com/soussite1/phpmyvisites/')"; // n'est pas 'http://www.site.com/phpmyvisites/'
$lang['install_terminerinstall'] = "Terminer l'installation";
$lang['install_popup_logo'] = "Sélectionnez le logo désiré";
$lang['install_logodispo'] = "Voir les différents logos disponibles.";
$lang['install_welcome'] = "Bienvenue !"; 
$lang['install_system_requirements'] = "Configuration requise"; 
$lang['install_database_setup'] = "Configuration Base de données"; 
$lang['install_create_tables'] = "Création des tables"; 
$lang['install_general_setup'] = "Configuration générale"; 
$lang['install_create_config_file'] = "Création du fichier de configuration"; 
$lang['install_first_website_setup'] = "Ajout du site Internet"; 
$lang['install_display_javascript_code'] = "Affichage du code Javascript"; 
$lang['install_finish'] = "Fini !"; 
$lang['install_database_setup_txt'] = "Veuillez entrer les informations relatives à votre base de données."; 
$lang['install_general_config_text'] = "phpMyVisite n'aura qu'un seul et unique super administrateur. Il aura l'accès complet pour voir/éditer les sites et autres configurations. Veuillez choisir un login et un mot de passe pour ce compte. Vous pourrez ajouter des nouveaux utilisateurs plus tard."; 
$lang['install_config_file'] = " Les informations sur le super administrateur ont été enregistrées avec succès."; 
$lang['install_js_code_text'] = "<p>Pour prendre en compte les visites dans phpMyVisites, vous devez ajouter ce court code javascript sur toutes les pages de votre site Internet. </p><p> Vos pages ne doivent pas nécessairement être en PHP, <strong>phpMyVisites fonctionne très bien avec tous les formats (HTML, ASP, Perl ou autres).</strong> </p><p> Voici le code que vous devez insérer: (copiez collez le sur toutes les pages de votre site) </p>"; 
$lang['install_intro'] = "Bienvenue dans la phase d'installation de phpMyVisites.";  
$lang['install_intro2'] = "L'installation est séparée en %s phases simples et prendra environ 10 minutes."; 
$lang['install_next_step'] = "Aller à la phase suivante"; 
$lang['install_status'] = "Avancement de l'installation"; 
$lang['install_done'] = "Installation à %s%% complète"; // Install 25% complete 
$lang['install_site_success'] = "Site crée avec succès !"; 
$lang['install_site_info'] = "Veuillez entrer toutes les informations relatives au site Internet."; 
$lang['install_go_phpmv'] = "Allez sur phpMyVisites"; 
$lang['install_congratulation'] = "Félicitations ! Votre installation de phpMyVisites est terminée."; 
$lang['install_end_text'] = "Assurez vous d'avoir bien installé le code Javascript sur toutes vos pages Internet et vous n'avez plus qu'à attendre vos premiers visiteurs !"; 
$lang['install_db_ok'] = "Connexion à la base de données ok!"; 
$lang['install_table_exist'] = "Les tables de phpMyVisites existent déjà dans la base de données."; 
$lang['install_table_choice'] = "Vous avez le choix entre réutiliser les tables existantes de votre base de données, ou partir avec une installation propre en supprimant toutes les tables existantes."; 
$lang['install_table_erase'] = "Supprimer toutes les tables (Soyez prudents !)"; 
$lang['install_table_reuse'] = "Utiliser les tables existantes"; 
$lang['install_table_success'] = "Tables crées avec succès !"; 

//
// Update Step
//
$lang['update_titre'] = "Mise à jour de la base de donnée";
$lang['update_warning1'] = "Nous avons détecté que la version de la base de donnée phpMyVisites est inférieure à la version du logiciel phpMyVisites. phpMyVisites <strong>ne fonctionnera donc pas correctement.</strong>";
$lang['update_warning2'] = "Vous devez mettre vos bases de données à jour en cliquant sur le bouton ci-dessous.";
$lang['update_bouton'] = "Lancer la mise à jour";
$lang['update_jschange'] = "Attention ! <br /> Le code Javascript de phpMyVisites a changé. Vous DEVEZ mettre à jour vos pages et copier/coller le nouveau code Javascript de phpMyVisites sur TOUS vos sites configurés. <br /> Le changement de code Javascript est très rare, nous sommes désolés des désagréments encourus.";

//
// Dates
//

/*
%daylong% // Monday
%dayshort% // Mon
%daynumeric% // 27
%monthlong% // Febuary
%monthshort% // Feb
%monthnumeric% // 02
%yearlong% // 2004
%yearshort% // 04
*/

// Monday February 10 2004
$lang['tdate1'] = "%daylong% %daynumeric% %monthlong% %yearlong%"; 

// Monday 10
$lang['tdate2'] = "%daylong% %daynumeric%"; 

// Week February 10 To February 17 2004
$lang['tdate3']  = "Semaine du %daynumeric% %monthlong% au %daynumeric2% %monthlong2%  %yearlong%"; 

// February 2004 Month
$lang['tdate4']  = "Mois de %monthlong% %yearlong%"; 

// December 2003
$lang['tdate5']  = "%monthlong% %yearlong%"; 

// 10 Febuary week
$lang['tdate6']  = "Semaine du %daynumeric% %monthlong%"; 

// 10-02-2003 // February 2 2003
$lang['tdate7']  = "%daynumeric%-%monthnumeric%-%yearlong%"; 

// Mon 10 (Only for Graphs purpose)
$lang['tdate8']  = "%dayshort% %daynumeric%"; 

// Week 10 Feb (Only for Graphs purpose)
$lang['tdate9']  = " Sem %daynumeric% %monthshort%"; 

// Deb 2004 (Only for Graphs purpose)
$lang['tdate10'] = "%monthshort% %yearlong%"; 

// Year 2004
$lang['tdate11'] = "Year %yearlong%"; 

// 2004
$lang['tdate12'] = "%yearlong%"; 

// Months
$lang['moistab']['01'] = "Janvier";
$lang['moistab']['02'] = "Février";
$lang['moistab']['03'] = "Mars";
$lang['moistab']['04'] = "Avril";
$lang['moistab']['05'] = "Mai";
$lang['moistab']['06'] = "Juin";
$lang['moistab']['07'] = "Juillet";
$lang['moistab']['08'] = "Août";
$lang['moistab']['09'] = "Septembre";
$lang['moistab']['10'] = "Octobre";
$lang['moistab']['11'] = "Novembre";
$lang['moistab']['12'] = "Décembre";

// Months (Graph purpose, 4 chars max)
$lang['moistab_graph']['01'] = "Janv";
$lang['moistab_graph']['02'] = "Fevr";
$lang['moistab_graph']['03'] = "Mars";
$lang['moistab_graph']['04'] = "Avril";
$lang['moistab_graph']['05'] = "Mai";
$lang['moistab_graph']['06'] = "Juin";
$lang['moistab_graph']['07'] = "Juil";
$lang['moistab_graph']['08'] = "Aout";
$lang['moistab_graph']['09'] = "Sept";
$lang['moistab_graph']['10'] = "Oct";
$lang['moistab_graph']['11'] = "Nov";
$lang['moistab_graph']['12'] = "Dec";

// Day of the week
$lang['jsemaine']['Mon'] = "Lundi";
$lang['jsemaine']['Tue'] = "Mardi";
$lang['jsemaine']['Wed'] = "Mercredi";
$lang['jsemaine']['Thu'] = "Jeudi";
$lang['jsemaine']['Fri'] = "Vendredi";
$lang['jsemaine']['Sat'] = "Samedi";
$lang['jsemaine']['Sun'] = "Dimanche";

// Day of the week (Graph purpose, 4 chars max)
$lang['jsemaine_graph']['Mon'] = "Lun";
$lang['jsemaine_graph']['Tue'] = "Mar";
$lang['jsemaine_graph']['Wed'] = "Mer";
$lang['jsemaine_graph']['Thu'] = "Jeu";
$lang['jsemaine_graph']['Fri'] = "Ven";
$lang['jsemaine_graph']['Sat'] = "Sam";
$lang['jsemaine_graph']['Sun'] = "Dim";

// First letter of each day, weekdays ordered
$lang['calendrier_jours'][0] = "L";
$lang['calendrier_jours'][1] = "M";
$lang['calendrier_jours'][2] = "M";
$lang['calendrier_jours'][3] = "J";
$lang['calendrier_jours'][4] = "V";
$lang['calendrier_jours'][5] = "S";
$lang['calendrier_jours'][6] = "D";

// DO NOT ALTER!
$lang['weekdays']['Mon'] = '1';
$lang['weekdays']['Tue'] = '2';
$lang['weekdays']['Wed'] = '3';
$lang['weekdays']['Thu'] = '4';
$lang['weekdays']['Fri'] = '5';
$lang['weekdays']['Sat'] = '6';
$lang['weekdays']['Sun'] = '7';

// Continents
$lang['eur'] = "Europe";
$lang['afr'] = "Afrique";
$lang['asi'] = "Asie";
$lang['ams'] = "Amérique centrale/sud";
$lang['amn'] = "Amérique du nord";
$lang['oce'] = "Océanie";

// Oceans
$lang['oc_pac'] = "OCÉAN PACIFIQUE";
$lang['oc_atl'] = "OCÉAN ATLANTIQUE";
$lang['oc_ind'] = "OCÉAN INDIEN";

// Countries
$lang['domaines'] = array( 
    "xx" => "Inconnu",
    "ac" => "Ascension (île)",
    "ad" => "Andorre",
    "ae" => "Emirats Arabes Unis",
    "af" => "Afghanistan",
    "ag" => "Antigua et Barbuda",
    "ai" => "Anguilla",
    "al" => "Albanie",
    "am" => "Arménie",
    "an" => "Antilles Neerlandaises",
    "ao" => "Angola",
    "aq" => "Antarctique",
    "ar" => "Argentine",
    "as" => "American Samoa",
    "at" => "Autriche",
    "au" => "Australie",
    "aw" => "Aruba",
    "az" => "Azerbaidjan",
    "ba" => "Bosnie Herzégovine",
    "bb" => "Barbade",
    "bd" => "Bangladesh",
    "be" => "Belgique",
    "bf" => "Burkina Faso",
    "bg" => "Bulgarie",
    "bh" => "Bahrein",
    "bi" => "Burundi",
    "bj" => "Bénin",
    "bm" => "Bermudes",
    "bn" => "Brunei",
    "bo" => "Bolivie",
    "br" => "Brésil",
    "bs" => "Bahamas",
    "bt" => "Bhoutan",
    "bv" => "Bouvet (île)",
    "bw" => "Botswana",
    "by" => "Biélorussie",
    "bz" => "Bélize",
    "ca" => "Canada",
    "cc" => "Cocos (Keeling) îles",
    "cd" => "Rép. dém. du Congo",
    "cf" => "Rép Centrafricaine",
    "cg" => "Congo",
    "ch" => "Suisse",
    "ci" => "Côte d'Ivoire",
    "ck" => "Cook (îles)",
    "cl" => "Chili",
    "cm" => "Cameroun",
    "cn" => "Chine",
    "co" => "Colombie",
    "cr" => "Costa Rica",
	"cs" => "Serbie Montenegro", 
    "cu" => "Cuba",
    "cv" => "Cap Vert",
    "cx" => "Christmas (île)",
    "cy" => "Chypre",
    "cz" => "Tchéquie",
    "de" => "Allemagne",
    "dj" => "Djibouti",
    "dk" => "Danemark",
    "dm" => "Dominique",
    "do" => "Rép Dominicaine",
    "dz" => "Algérie",
    "ec" => "Equateur",
    "ee" => "Estonie",
    "eg" => "Egypte",
    "eh" => "Sahara Occidental",
    "er" => "Erythrée",
    "es" => "Espagne",
    "et" => "Ethiopie",
    "fi" => "Finlande",
    "fj" => "Fidji",
    "fk" => "Falkland (Malouines) îles",
    "fm" => "Micronésie",
    "fo" => "Faroe (îles)",
    "fr" => "France",
    "ga" => "Gabon",
    "gd" => "Grenade",
    "ge" => "Géorgie",
    "gf" => "Guyane Française",
    "gg" => "Guernsey",
    "gh" => "Ghana",
    "gi" => "Gibraltar",
    "gl" => "Groenland",
    "gm" => "Gambie",
    "gn" => "Guinée",
    "gp" => "Guadeloupe",
    "gq" => "Guinée Equatoriale",
    "gr" => "Grèce",
    "gs" => "Géorgie du sud",
    "gt" => "Guatemala",
    "gu" => "Guam",
    "gw" => "Guinée-Bissau",
    "gy" => "Guyana",
    "hk" => "Hong Kong",
    "hm" => "Heard et McDonald (îles)",
    "hn" => "Honduras",
    "hr" => "Croatie",
    "ht" => "Haiti",
    "hu" => "Hongrie",
    "id" => "Indonésie",
    "ie" => "Irlande",
    "il" => "Israël",
    "im" => "Ile de Man",
    "in" => "Inde",
    "io" => "Ter. Brit. Océan Indien",
    "iq" => "Iraq",
    "ir" => "Iran",
    "is" => "Islande",
    "it" => "Italie",
    "je" => "Jersey",
    "jm" => "Jamaïque",
    "jo" => "Jordanie",
    "jp" => "Japon",
    "ke" => "Kenya",
    "kg" => "Kirghizistan",
    "kh" => "Cambodge",
    "ki" => "Kiribati",
    "km" => "Comores",
    "kn" => "Saint Kitts et Nevis",
    "kp" => "Corée du nord",
    "kr" => "Corée du sud",
    "kw" => "Koweït",
    "ky" => "Caïmanes (îles)",
    "kz" => "Kazakhstan",
    "la" => "Laos",
    "lb" => "Liban",
    "lc" => "Sainte Lucie",
    "li" => "Liechtenstein",
    "lk" => "Sri Lanka",
    "lr" => "Liberia",
    "ls" => "Lesotho",
    "lt" => "Lituanie",
    "lu" => "Luxembourg",
    "lv" => "Lettonie",
    "ly" => "Libye",
    "ma" => "Maroc",
    "mc" => "Monaco",
    "md" => "Moldavie",
    "mg" => "Madagascar",
    "mh" => "Marshall (îles)",
    "mk" => "Macédoine",
    "ml" => "Mali",
    "mm" => "Myanmar",
    "mn" => "Mongolie",
    "mo" => "Macao",
    "mp" => "Mariannes du nord (îles)",
    "mq" => "Martinique",
    "mr" => "Mauritanie",
    "ms" => "Montserrat",
    "mt" => "Malte",
    "mu" => "Maurice (île)",
    "mv" => "Maldives",
    "mw" => "Malawi",
    "mx" => "Mexique",
    "my" => "Malaisie",
    "mz" => "Mozambique",
    "na" => "Namibie",
    "nc" => "Nouvelle Calédonie",
    "ne" => "Niger",
    "nf" => "Norfolk (île)",
    "ng" => "Nigéria",
    "ni" => "Nicaragua",
    "nl" => "Pays Bas",
    "no" => "Norvège",
    "np" => "Népal",
    "nr" => "Nauru",
    "nu" => "Niue",
    "nz" => "Nouvelle Zélande",
    "om" => "Oman",
    "pa" => "Panama",
    "pe" => "Pérou",
    "pf" => "Polynésie Française",
    "pg" => "Papouasie Nvelle Guinée",
    "ph" => "Philippines",
    "pk" => "Pakistan",
    "pl" => "Pologne",
    "pm" => "St. Pierre et Miquelon",
    "pn" => "Pitcairn (île)",
    "pr" => "Porto Rico",
    "pt" => "Portugal",
    "pw" => "Palau",
    "py" => "Paraguay",
    "qa" => "Qatar",
    "re" => "Réunion (île de la)",
    "ro" => "Roumanie",
    "ru" => "Russie",
    "rs" => "Russie",
    "rw" => "Rwanda",
    "sa" => "Arabie Saoudite",
    "sb" => "Salomon (îles)",
    "sc" => "Seychelles",
    "sd" => "Soudan",
    "se" => "Suède",
    "sg" => "Singapour",
    "sh" => "St. Hélène",
    "si" => "Slovénie",
    "sj" => "Svalbard/Jan Mayen (îles)",
    "sk" => "Slovaquie",
    "sl" => "Sierra Leone",
    "sm" => "Saint-Marin",
    "sn" => "Sénégal",
    "so" => "Somalie",
    "sr" => "Suriname",
    "st" => "Sao Tome et Principe",
    "su" => "Ex U.R.S.S.",
    "sv" => "Salvador",
    "sy" => "Syrie",
    "sz" => "Swaziland",
    "tc" => "Turks et Caïques (îles)",
    "td" => "Tchad",
    "tf" => "Territoires Fr du sud",
    "tg" => "Togo",
    "th" => "Thailande",
    "tj" => "Tadjikistan",
    "tk" => "Tokelau",
    "tm" => "Turkménistan",
    "tn" => "Tunisie",
    "to" => "Tonga",
    "tp" => "Timor Oriental",
    "tr" => "Turquie",
    "tt" => "Trinité et Tobago",
    "tv" => "Tuvalu",
    "tw" => "Taiwan",
    "tz" => "Tanzanie",
    "ua" => "Ukraine",
    "ug" => "Ouganda",
    "uk" => "Royaume Uni",
    "gb" => "Grande Bretagne",
    "um" => "US Minor Outlying (îles)",
    "us" => "États-Unis",
    "uy" => "Uruguay",
    "uz" => "Ouzbékistan",
    "va" => "Vatican",
    "vc" => "St Vincent et les Grenadines",
    "ve" => "Venezuela",
    "vg" => "Vierges Brit. (îles)",
    "vi" => "Vierges USA (îles)",
    "vn" => "Viêt Nam",
    "vu" => "Vanuatu",
    "wf" => "Wallis et Futuna (îles)",
    "ws" => "Western Samoa",
    "ye" => "Yemen",
    "yt" => "Mayotte",
    "yu" => "Yugoslavie",
    "za" => "Afrique du Sud",
    "zm" => "Zambie",
    "zr" => "Rép. Dém. du Congo (ex Zaïre)",
    "zw" => "Zimbabwe",
    "com" => "-",
    "net" => "-",
    "org" => "-",
    "edu" => "-",
    "int" => "-",
    "arpa" => "-",
    "gov" => "-",
    "mil" => "-",
    "reverse" => "-",
    "biz" => "-",
    "info" => "-",
    "name" => "-",
    "pro" => "-",
    "coop" => "-",
    "aero" => "-",
    "museum" => "-",
    "tv" => "-",
    "ws" => "-"
);
?>