<?php
// +--------------------------------------------------------------------------+
// |   phpMyVisites   |   statistiques et mesure d'audience de sites Internet |
// +--------------------------------------------------------------------------+
// | Copyright (c) 2002-2004 Matthieu Aubry. Tous droits réservés             |
// +--------------------------------------------------------------------------+
// | Ce code est distribué sous license GNU GPL, disponible   '/docs/licence' |
// | Pour toute information supplémentaire :                                  |
// | http://www.phpmyvisites.net    |    matthieu@phpmyvisites.net            |
// +--------------------------------------------------------------------------+

//
// Technical information
//
$lang['auteur_nom'] = "David Carrington"; // Translator's name
$lang['auteur_email'] = "david.carrington@gmail.com"; // Translator's email
$lang['charset'] = "utf-8"; // language file charset (utf-8 by default)
$lang['text_dir'] = "ltr"; // ('ltr' for left to right, 'rtl' for right to left)
$lang['lang_iso'] = "en"; // iso language code
$lang['lang_libelle_en'] = "English"; // english language name
$lang['lang_libelle_fr'] = "Anglais"; // french language name
$lang['unites_bytes'] = array('Bytes', 'Kb', 'Mb', 'Gb', 'Tb', 'Pb', 'Eb', 'Zb', 'Yb');
$lang['separateur_milliers'] = ''; // three thousand spells 3,000 in english
$lang['separateur_decimaux'] = '.'; // Separator for the float part of a number

//
// HTML Markups
//
$lang['head_titre'] = "phpMyVisites | open source website statistics and web traffic analyzer application"; // Pages header's title
$lang['head_keywords'] = "phpmyvisites, php, script, application, software, statistics, referals, stats, free, open source, gpl, visits, visitors, mysql, viewed pages, pages, views, number of visits, graphs, Browsers, os, operating system, resolutions, day, week, month, records, country, host, service providors, search enginge, key words, referrers, graphs, entry pages, exit pages, pie charts"; // Header keywords
$lang['head_description'] = "phpMyVisites | An open source website statistics application developed in PHP/MySQL and distributed under the Gnu GPL."; // Header description
$lang['logo_description'] = "phpMyVisites : an open source website statistics application in PHP/MySQL, distributed under the GPL."; // This is the JS code description. Has to be short.

//
// Main menu & submenu
//
$lang['menu_visites'] = "Visits";
$lang['menu_pagesvues'] = "Pages Viewed";
$lang['menu_suivi'] = "Follow-up";
$lang['menu_provenance'] = "Source";
$lang['menu_configurations'] = "Settings";
$lang['menu_affluents'] = "Referals";
$lang['menu_listesites'] = "List Sites";
$lang['menu_bilansites'] = "Summary";
$lang['menu_jour'] = "Day";
$lang['menu_semaine'] = "Week";
$lang['menu_mois'] = "Month";
$lang['menu_annee'] = "Year";
$lang['menu_periode'] = "Studied period: %s"; // Text formatted (e.g.: Studied period: Sunday, July the 14th)
$lang['liens_siteofficiel'] = "Official website";
$lang['liens_admin'] = "Administration";
$lang['liens_contacts'] = "Contacts";

//
// Divers
//
$lang['generique_nombre'] = "Number";
$lang['generique_tauxsortie'] = "Exit Rate";
$lang['generique_ok'] = "OK";
$lang['generique_erreur'] = "Error";
$lang['generique_erreurrubrique'] = "Error: the selected heading is unknown.";
$lang['generique_erreurvar'] = "Error: a variable is not correctly defined.";
$lang['generique_choixlangue'] = "Language";
$lang['generique_total'] = "Total";
$lang['generique_microtime'] = "Duration : %s seconds"; // Time in seconds
$lang['generique_timefooter'] = "Page generated in %s seconds"; // Time in seconds
$lang['generique_voirlesprecedents'] = "Previous %s";
$lang['generique_voirlessuivants'] = "Next %s";
$lang['generique_divers'] = "Others"; // (for the graphs)
$lang['generique_inconnu'] = "Unknown"; // (for the graphs)
$lang['generique_vous'] = "... You ?";
$lang['generique_traducteur'] = "Translator";
$lang['generique_langue'] = "Language";
$lang['generique_autrelangure'] = "Other?"; // Other language, translations wanted
$lang['aucunvisiteur_titre'] = "No visitor on this period."; 
$lang['aucunvisiteur_titre1'] = "No visitors on %s."; // No visitors on .....
$lang['aucunvisiteur_titre2'] = "No visitors for the week of %s."; // No visitors for the week of ...
$lang['aucunvisiteur_titre3'] = "No visitors for the month of %s."; // No visitors for the month of ...
$lang['aucunvisiteur_periodeinvalide'] = "It is not possible to view statistics from this period <br />because statistics can only be viewed for finished days.";
$lang['generique_betaversion'] = "phpMyVisites %s Beta currently beta tested"; // phpMyVisites Version beta 1.2
$lang['generique_aucune_visite_bdd'] = "<b>Warning ! </b> You have no visitor recorded in the database for the current site. Please be sure you've installed your javascript code on your pages, with the correct phpMyVisites URL <u>IN</u> the Javascript code. Try documentation for help.";
$lang['generique_aucune_site_bdd'] = "No site registered in the database ! Try to Try to login as phpMyVisites Super User to add a new site.";
$lang['generique_retourhaut'] = "Top";
$lang['generique_tempsvisite'] = "%1\$smin %2\$ss";
$lang['generique_tempsheure'] = "%sh"; // 4 h means 4 hours
$lang['generique_siteno'] = "Site %s"; // Site "phpmyvisites"
$lang['generique_newsletterno'] = "Newsletter %s"; // Newsletter "version 2 announcement"
$lang['generique_partnerno'] = "Partner %s"; // Newsletter "version 2 announcement"
$lang['generique_general'] = "General";
$lang['generique_previous'] = "Previous";
$lang['generique_next'] = "Next";
$lang['generique_lowpop'] = "Exclude low population from statistics";
$lang['generique_allpop'] = "Include all the population in statistics";
$lang['generique_to'] = "to"; // 4 'to' 8
$lang['generique_total'] = "on"; // 4 to 8 'on' 10
$lang['generique_information'] = "Information";
$lang['generique_done'] = "Done!";

//
// Authentification
//
$lang['login_private1'] = "The statistics for %s phpMyVisites %s are protected."; // a link to the site
$lang['login_private2'] = "The administration area for %s phpMyVisites %s is protected."; // a link to the site
$lang['login_password'] = "password: "; // lowercase
$lang['login_login'] = "login: "; // lowercase
$lang['login_error'] = "Cannot login. Bad login or password.";
$lang['login_protected'] = "You wish to enter a %s phpMyVisites %s protected area.";

//
// Contacts & "Others ?"
//
$lang['contacts_titre'] = "Contacts";
$lang['contacts_langue'] = "Translations";
$lang['contacts_merci'] = "Thanks";
$lang['contacts_auteur'] = "The author, documentor, and creator of the phpMyVisites project is <strong>Matthieu Aubry</strong>.";
$lang['contacts_questions'] = "For <strong>technical questions, reporting bugs, suggestions</strong> please use the official website forums %s. For other requests, please contact the author using the official website form."; // adresse du site
$lang['contacts_trad1'] = "Do you want to translate phpMyVisites to your language? Don't hesitate because <strong>phpMyVisites needs you!</strong>";
$lang['contacts_trad2'] = "Translatating phpMyVisites will take quite a while (a few hours) and requires a good knowledge of the languages involved; but remember that <strong>any work you do will benefit a large number of users</strong>.  If you are interested in translatating phpMyVisites you can find all the information you need in %s the official documentation of phpMyVisites %s."; // lien vers la doc
$lang['contacts_doc'] = "Don't hesitate to consult %s the official documentation of phpMyVisites %s which will give you plenty of information on installation, configuration, and the functionality of phpMyVisites. It is available in your version of phpMyVisites."; // lien vers la doc
$lang['contacts_merci1'] = "Thank you <strong>Marc Boussard</strong>, co-developer of phpMyVisites, for his high quality work on the project.";
$lang['contacts_merci3'] = "Don't hesitate to consult the acknowledgments page on the official website to get a complete list of phpMyVisites friends.";
$lang['contacts_merci2'] = "A big thank you to all those who shared their culture while contributing to the translation of phpMyVisites:";

//
// Rss
// 
$lang['rss_titre'] = "Site %1\$s on %2\$s"; // Site MyHomePage on Sunday 29 
$lang['rss_go'] = "Go to detailed statistics";

//
// Visits Part
//
$lang['visites_titre'] = "Visitor information"; 
$lang['visites_statistiques'] = "Statistics";
$lang['visites_periodesel'] = "For the selected period";
$lang['visites_visites'] = "Visits";
$lang['visites_uniques'] = "Unique visitors";
$lang['visites_pagesvues'] = "Pages viewed";
$lang['visites_pagesvisiteurs'] = "Pages per visitor"; 
$lang['visites_pagesvisites'] = "Pages per visit"; 
$lang['visites_pagesvisitessign'] = "Pages per significant visit"; 
$lang['visites_tempsmoyen'] = "Average visit duration";
$lang['visites_tempsmoyenpv'] = "Average time by page seen";
$lang['visites_tauxvisite'] = "1 page visit rate"; 
$lang['visites_recapperiode'] = "Period summaries";
$lang['visites_nbvisites'] = "Visits";
$lang['visites_nonarchive'] = "Not archived"; // in the table, must be short
$lang['visites_aucunevivisite'] = "No visit"; // in the table, must be short
$lang['visites_recap'] = "Summary";
$lang['visites_unepage'] = "1 page"; // (graph)
$lang['visites_pages'] = "%s pages"; // 1-2 pages (graph)
$lang['visites_min'] = "%smin"; // 10-15 min (graph)
$lang['visites_sec'] = "%ss"; // 0-30 s (seconds, graph)
$lang['visites_grapghrecap'] = "Graph to show statistics summary";
$lang['visites_graphtempsvisites'] = "Graph to show durations of the visits by visitor";
$lang['visites_graphtempsvisitesimg'] = "Duration of the visits by visitor";
$lang['visites_graphheureserveur'] = "Graph to show visits per hour for the server"; 
$lang['visites_graphheureserveurimg'] = "Visits by server time"; 
$lang['visites_graphheurevisiteur'] = "Graph to show visits per hour for the visitor";
$lang['visites_graphheurelocalimg'] = "Visits by local time"; 
$lang['visites_graphlieux'] = "Graph to show places of connection";
$lang['visites_graphlieuximg'] = "Places of connection";
$lang['visites_domicile'] = "Residence";
$lang['visites_travail'] = "Work";

// 
// Frequency Part
//
$lang['frequence_titre'] = "Returning visitors";
$lang['frequence_nouveauxconnus'] = "New vs Returning visits";
$lang['frequence_titremenu'] = "Frequency";
$lang['frequence_visitesconnues'] = "Returning visits";
$lang['frequence_nouvellesvisites'] = "New visits";
$lang['frequence_returningrate'] = "Returning rate";
$lang['frequence_vispervis'] = "Number of visits per visitor";
$lang['frequence_vis'] = "visit";

//
// Seen Pages
//
$lang['pagesvues_titre'] = "Pages views Information";
$lang['pagesvues_joursel'] = "Day selected";
$lang['pagesvues_jmoins7'] = "Day - 7";
$lang['pagesvues_jmoins14'] = "Day - 14";
$lang['pagesvues_moyenne'] = "(average)";
$lang['pagesvues_pagesvues'] = "Page views";
$lang['pagesvues_pagesvudiff'] = "Unique page views";
$lang['pagesvues_recordpages'] = "Highest number of pages for one visitor";
$lang['pagesvues_tabdetails'] = "Pages and groups viewed";
$lang['pagesvues_graphsnbpages'] = "Graph to show number of visits per page viewed";
$lang['pagesvues_graphnbvisitespageimg'] = "Visits by number of pages viewed";
$lang['pagesvues_graphheureserveur'] = "Graph to show visits by server time";
$lang['pagesvues_graphheureserveurimg'] = "Visits by server time";
$lang['pagesvues_graphheurevisiteur'] = "Graph to show visits by local time";
$lang['pagesvues_graphpageslocalimg'] = "Visits by local time";
$lang['pagesvues_tempsparpage'] = "Time by page";

//
// Follows-Up
//
$lang['suivi_titre'] = "Visitor movement";
$lang['suivi_pageentree'] = "Entry pages";
$lang['suivi_pagesortie'] = "Exit pages";
$lang['suivi_cheminvisiteur'] = "Visitor movement";
$lang['suivi_nombre'] = "Number";
$lang['suivi_tauxsortie'] = "Exit rate";
$lang['suivi_dea'] = " (from %s to %s)"; // (from 1 to 11)
$lang['suivi_pageselectionnee'] = "Page selected: %s"; // Selected page : /index.php
$lang['suivi_lapage'] = "No follow-up available for the page %s because its exit rate is 100%%. <br />The homepage %s will be shown."; // for the page /index.php 
$lang['suivi_aucunsuivi'] = "No follow-up has been made. Maybe you only have a single unique page viewed on the website today?";
$lang['suivi_pageentreehits'] = "Entry hits";
$lang['suivi_pagesortiehits'] = "Exit hits";
$lang['suivi_singlepage'] = "Single Pages visits";

//
// Origin
//
$lang['provenance_titre'] = "Visitors Origins";
$lang['provenance_recappays'] = "Countries Summary";
$lang['provenance_pays'] = "Countries";
$lang['provenance_paysimg'] = "Visitors Chart by Country";
$lang['provenance_fai'] = "Internet Service Providers";
$lang['provenance_nbpays'] = "Number of different nationalities : %s";
$lang['provenance_provider'] = "Providers"; // same as $lang['provenance_fai'], but not if $lang['provenance_fai'] is too long
$lang['provenance_nombre'] = "Number";
$lang['provenance_continent'] = "Continent";
$lang['provenance_mappemonde'] = "Map of the world";
$lang['provenance_backmap'] = "Return to the map of the world";
$lang['provenance_error_font'] = "The font file %s cannot be found. Please try to download it on phpMyVisites website.";
$lang['provenance_interetspays'] = "Countries Interests";

//
// Setup
//
$lang['configurations_titre'] = "Visitor Settings";
$lang['configurations_os'] = "Operating Systems";
$lang['configurations_osimg'] = "Graph to show visitors operating systems";
$lang['configurations_navigateurs'] = "Browsers";
$lang['configurations_navigateursimg'] = "Graph to show visitors browsers";
$lang['configurations_resolutions'] = "Screen Resolutions";
$lang['configurations_resolutionsimg'] = "Graph to show visitors screen resolutions";
$lang['configurations_couleurs'] = "Color Depth";
$lang['configurations_couleursimg'] = "Graph to show visitors color depth";
$lang['configurations_rapport'] = "Normal/widescreen";
$lang['configurations_large'] = "Widescreen";
$lang['configurations_normal'] = "Normal";
$lang['configurations_double'] = "Dual Screen";
$lang['configurations_type'] = "Type"; // Used for the normal/wide screen array
$lang['configurations_plugins'] = "Plugins";
$lang['configurations_navigateursbytype'] = "Browsers (by type)";
$lang['configurations_navigateursbytypeimg'] = "Graph to show browsers types";
$lang['configurations_os_interest'] = "Operating Systems Interest";
$lang['configurations_navigateurs_interest'] = "Browsers Interest";
$lang['configurations_resolutions_interest'] = "Screen Resolutions Interest";
$lang['configurations_couleurs_interest'] = "Color Depth Interest";
$lang['configurations_configurations'] = "Top settings";

//
// Referers
//
$lang['affluents_titre'] = "Referers";
$lang['affluents_recapimg'] = "Visitors Chart by Referers";
$lang['affluents_directimg'] = "Direct";
$lang['affluents_sitesimg'] = "Websites";
$lang['affluents_moteursimg'] = "Engines";
$lang['affluents_newslettersimg'] = "Mailing";
$lang['affluents_partenairesimg'] = "Partners";
$lang['affluents_referrersimg'] = "Referers";
$lang['affluents_moteurs'] = "Search Engines";
$lang['affluents_nbparmoteur'] = "Visits provided by search engines : %s";
$lang['affluents_aucunmoteur'] = "No visits were provided by search engines.";
$lang['affluents_motscles'] = "Keywords";
$lang['affluents_nbmotscles'] = "Distinct keywords : %s";
$lang['affluents_aucunmotscles'] = "No keyword found.";
$lang['affluents_sitesinternet'] = "Websites";
$lang['affluents_nbautressites'] = "Visits provided by other websites : %s";
$lang['affluents_nbautressitesdiff'] = "Number of different websites : %s";
$lang['affluents_aucunautresite'] = "No visits were provided by websites.";
$lang['affluents_entreedirecte'] = "Direct Request";
$lang['affluents_nbentreedirecte'] = "Direct request visits : %s";
$lang['affluents_nbpartenaires'] = "Visits provided by partners : %s";
$lang['affluents_aucunpartenaire'] = "No visits were provided by partners sites.";
$lang['affluents_nbnewsletters'] = "Visits provided by newsletters : %s";
$lang['affluents_aucunnewsletter'] = "No visits were provided by newsletters.";
$lang['affluents_motinconnu'] = "Unknown keyword"; // Displayed for an engine for which we can't get a keyword list
$lang['affluents_sites_page'] = "Pages"; // In the results of the referers array
$lang['affluents_details'] = "Details"; // In the results of the referers array
$lang['affluents_interetsmoteurs'] = "Search Engines Interests";
$lang['affluents_motscles'] = "Keywords";
$lang['affluents_interetsmotscles'] = "Keywords Interests";
$lang['affluents_interetssitesinternet'] = "Websites Interests";
$lang['affluents_partenairesimg'] = "Partners";
$lang['affluents_partenaires'] = "Partners";
$lang['affluents_interetspartenaires'] = "Partners Interests";
$lang['affluents_newslettersimg'] = "Newsletters";
$lang['affluents_newsletters'] = "Newsletters";
$lang['affluents_interetsnewsletters'] = "Newsletters Interests";

//
// Summary
//
$lang['purge_titre'] = "Summary of the visits and referals";
$lang['purge_intro'] = "This period was removed in the administration, only the essential statistics were kept.";
$lang['admin_purge'] = "Database maintenance";
$lang['admin_sitepurge'] = "Please choose the site you wish to work with:";
$lang['admin_purgeintro'] = "This section lets you manage the tables used by phpMyVisites. You can see the disk space used by the tables, optimize them, or remove old records. This will enable you to limit the size of the tables in your database.";
$lang['admin_optimisation'] = "Optimization of [ %s ]..."; // Tables names
$lang['admin_postopt'] = "The total size decreased by %chiffres% %unites%"; // 28 Kb
$lang['admin_purgeres'] = "Remove following periods: %s";
$lang['admin_purge_fini'] = "Finished deleting tables...";
$lang['admin_bdd_nom'] = "Name";
$lang['admin_bdd_enregistrements'] = "Records";
$lang['admin_bdd_taille'] = "Table Size";
$lang['admin_bdd_opt'] = "Optimize";
$lang['admin_bdd_purge'] = "Purge Criteria";
$lang['admin_bdd_optall'] = "Optimize All";
$lang['admin_purge_j'] = "Remove records older than %s days";
$lang['admin_purge_s'] = "Remove records older than %s weeks";
$lang['admin_purge_m'] = "Remove records older than %s months";
$lang['admin_purge_logs'] = "Remove all logs";
$lang['admin_purge_autres'] = "Purge common to the table '%s'";
$lang['admin_purge_none'] = "No possible action";
$lang['admin_purge_cal'] = "Calculate and purge (this can take a few minutes)";
$lang['admin_alias_title'] = "Website aliases and URLs";
$lang['admin_partner_title'] = "Website partners";
$lang['admin_newsletter_title'] = "Website newsletters";
$lang['admin_ip_exclude_title'] = "Ip address Ranges to exclude from the statistics";
$lang['admin_name'] = "Name:";
$lang['admin_error_ip'] = "Ip has to be in correct format: %s";
$lang['admin_site_name'] = "Site Name";
$lang['admin_site_url'] = "Site main URL";
$lang['admin_db_log'] = "Try to login as phpMyVisites Super User to change database settings.";
$lang['admin_error_critical'] = "Error, need to be repaired for phpMyVisites to work.";
$lang['admin_warning'] = "Warning, phpMyVisites will work correctly but maybe some extra features won't.";

//
// Setup
//
$lang['admin_titre'] = "Installation &amp; configuration"; // Installation & Configuration
$lang['admin_intro'] = "Welcome to the phpMyVisites configuration area. You can modify all information relating to your installation. If you have any problems then do not hesitate to consult %s the official documentation of phpMyVisites %s."; // link to the doc
$lang['admin_configetperso'] = "General settings";
$lang['admin_ajoutsite'] = "Add a site";
$lang['admin_modifsite'] = "Modify a site";
$lang['admin_afficherjavascript'] = "Show JavaScript statistics code";
$lang['admin_cookieadmin'] = "Don't count the administrator within statistics";
$lang['admin_gestionlangues'] = "Languages Administration";
$lang['admin_saisienouveausite'] = "You are going to add the website #%s Please type in all information about it."; // Website #2
$lang['admin_sitesenregistres'] = "Recorded websites:";
$lang['admin_modifetvalid'] = "You are going to modify the website #%s Please type in all information and submit"; // Website #2
$lang['admin_sitejavascript'] = "Please select the website you would like to show the Javascript code :";
$lang['admin_retour'] = "Back";
$lang['admin_sitecookie'] = "Please select the website you would like to not be counted within statistics:";
$lang['admin_cookienavigateur'] = "You may exclude Adminstrator from statistics. This method is cookies based and this option will only work with this current browser. You can change this option at any time.";
$lang['admin_prendreencompteadmin'] = "Count the administrator within statistics (delete the cookie)";
$lang['admin_nepasprendreencompteadmin'] = "Don't count in the administrator within statistics (create a cookie)";
$lang['admin_etatcookieoui'] = "The Administrator is counted within statistics for this website (This is the default configuration, you are considered as a normal visitor)";
$lang['admin_etatcookienon'] = "You are not counted within statistics for this website (Your visits will not be counted for this website)";
$lang['admin_explicationslangues'] = "You have the ability to define a default language; it will be changed automatically for your browser. You can also delete language files.";
$lang['admin_langesconfigurees'] = "Configured languages:";
$lang['admin_langue'] = "Language";
$lang['admin_fichier'] = "File";
$lang['admin_languesdispos'] = "Language files availables:";
$lang['admin_verifdispoconfigure'] = "If this table is not what you were expecting then reload the language files.";
$lang['admin_action'] = "Action";
$lang['admin_defaut'] = "Default";
$lang['admin_pardefaut'] = "Default";
$lang['admin_supprimer'] = "Delete";
$lang['admin_erreur'] = "Error";
$lang['admin_creationfichier'] = "Creation of file: %s"; // Cration of file: config.php...
$lang['admin_suppfichier'] = "Deleting file %s"; // Deleting file config.php...
$lang['admin_erreursupplangue'] = "Cannot delete the file %s"; // Cannot delete the file en-utf-8.php...
$lang['admin_deleteconfirm'] = "Please confirm that you want to delete %s?";
$lang['admin_sitedeletemessage'] = "Please <u>be very careful</u>: all datas associated to that Site will be deleted <br>and there won't be any way to recover the data loss.";
$lang['admin_confirmyes'] = "Yes, I want to delete it";
$lang['admin_confirmno'] = "No, I don't want to delete it";
$lang['admin_nonewsletter'] = "No newsletter found for this site!";
$lang['admin_nopartner'] = "No Partner found for this site!";
$lang['admin_get_question'] = "Record GET variable? (URL variables)";
$lang['admin_get_a1'] = "Record ALL url variables";
$lang['admin_get_a2'] = "Do NOT record any url variable";
$lang['admin_get_a3'] = "Record ONLY specified variables";
$lang['admin_get_a4'] = "Record all EXCEPT specified variables";
$lang['admin_get_list'] = "Variable names (<b>;</b> separated list) <br/>Example : %s";
$lang['admin_required'] = "%s is required.";
$lang['admin_title_required'] = "Required";
$lang['admin_write_dir'] = "Writable directories";
$lang['admin_chmod_howto'] = "These directories need to be writable by the server. This means you have to chmod 755 them, with your FTP software (right-click on the directory -> Permissions (or chmod))";
$lang['admin_optional'] = "Optional";
$lang['admin_memory_limit'] = "Memory limit";
$lang['admin_allowed'] = "allowed";
$lang['admin_webserver'] = "Web server";
$lang['admin_server_os'] = "Server OS";
$lang['admin_server_time'] = "Server time";
$lang['admin_legend'] = "Legend:";
$lang['admin_error_url'] = "URL has to be in a correct format : %s (without slash at the end)";
$lang['admin_url_n'] = "Url %s:";
$lang['admin_url_aliases'] = "URLs aliases";
$lang['admin_logo_question'] = "Display logo?";
$lang['admin_type_again'] = "(type again)";
$lang['admin_admin_mail'] = "Super Administrator email";
$lang['admin_admin'] = "Super Administrator";
$lang['admin_phpmv_path'] = "Complete path to the phpMyVisites application";
$lang['admin_valid_email'] = "Email has to be a valid email";
$lang['admin_valid_pass'] = "Password must be more complex (6 characters mini, must contains numbers)";
$lang['admin_match_pass'] = "Passwords do not match";

//
// Archives
//
$lang['archivage_ok'] = "ok"; // Successfully
$lang['archivage_error'] = "Error : ";
$lang['archivage_temporaire'] = "Temporary archive (day not finished) for %s : "; // for Monday 26...
$lang['archivage_nontemporaire'] = "Archive of %s : "; // Archive of Monday 26...
$lang['archivage_periodearchivee'] = "Archive period";
$lang['archivage_dejaarchive'] = "Period already temporarily archived";
$lang['archivage_semaine'] = "Archive week %s (from %s to %s) :"; // Archive of week #14 (from 2004-03-29 to 2004-04-04)
$lang['archivage_mois'] = "Archive %s (from %s to %s) :"; // Archive of March 2004 (from 2004-03-01 to 2004-03-31)
$lang['archivage_archivagetemporaire'] = " This is a temporary archive.";

//
// Installation Step
//
$lang['install_txt1'] = "Welcome to the phpMyVisites installation. This process is split up into 3 easy steps and will take around 10 minutes.";
$lang['install_txt2'] = "At the end of installation, a request will be made to the official site to help us keep track of the number of people using phpMyVisites. Thank you for your understanding.";
$lang['install_txt3'] = "<strong>If you are making an upgrade</strong>, type in the prefix (without the final '_') that is now used by your current installation. For more information, please consult the documentation.";
$lang['install_phase1a3'] = "Step 1 of 3: Information";
$lang['install_phase2a3'] = "Step 2 of 3: Configuration &amp; Customization";
$lang['install_phase3a3'] = "Step 3 of 3: Statistics configurations";
$lang['install_saisieinfos'] = "Please enter your MySQL database settings.";
$lang['install_nomsite'] = "Website name";
$lang['install_adressesite'] = "Website URL (with a final '/')";
$lang['install_loginmysql'] = "Database login";
$lang['install_mdpmysql'] = "Database password";
$lang['install_serveurmysql'] = "Database server";
$lang['install_basemysql'] = "Database name";
$lang['install_prefixetable'] = "Table prefix";
$lang['install_utilisateursavances'] = "Advanced users (optional)";
$lang['install_variablesget'] = "Record GET variable statistics (URL variables). <br />'No' means that only the page name will be registered, without the variables ('?date=09102003&amp;partie=2' for example)";
$lang['install_oui'] = "Yes";
$lang['install_non'] = "No";
$lang['install_explicationsget'] = "GET variable exceptions (they won't be saved)<br />(e.g. <strong>id;test;page</strong>)";
$lang['install_continuer'] = "Continue";
$lang['install_annuler'] = "Cancel";
$lang['install_ok'] = "OK";
$lang['install_probleme'] = "Problem: ";
$lang['install_erreur'] = "Error";
$lang['install_essaiconnexion'] = "Trying to connect to database server... ";
$lang['install_connexionimpossible'] = "Cannot connect to database server.";
$lang['install_connexionreussie'] = "Successful connection !";
$lang['install_selectionbasemysql'] = "Trying to select database... ";
$lang['install_selectionimpossible'] = "Cannot select database.";
$lang['install_baseselectionnee'] = "Database selected !";
$lang['install_creationtables'] = "Creating tables...";
$lang['install_erreurmiseajournormale'] = "This is a normal error if you are performing an update of phpMyVisites : database tables were already created and don't need to be recreated. You can safely continue this installation. <br>If you are not updating an old version, please verify that you have rights to create tables in the database (contact your network administrator if needed).";
$lang['install_urlinvalide'] = "The website URL is not valid. Please use this syntax: <strong>http://www.adresse.com/</strong>";
$lang['install_problemedroitrepertoire'] = "Cannot write in the repertory %s : please verify that you have the rights necessary to create files on the server (try to CHMOD 755 the repertory with your FTP software (right click on the directory -> Permissions (or CHMOD))."; // Cannot access the file config.php...
$lang['install_remplirchamps'] = "Please complete all fields.";
$lang['install_loginadmin'] = "Super Administrator login";
$lang['install_mdpadmin'] = "Super Administrator password";
$lang['install_chemincomplet'] = "Complete path to the phpMyVisites application (like http://www.mysite.com/rep1/rep3/phpmyvisites/). The path must end with a <strong>/</strong>.";
$lang['install_rendrestatspubliques'] = "I want to give public access to all of my statistics. (except for the administration part that will be protected with the login/password given above)";
$lang['install_nepasrendrestatspubliques'] = "I want to protect all of my statistics and administration part with the login/password given above.";
$lang['install_afficherlogo'] = "Show the logo on your pages? %s <br />By allowing the display of the logo on your site, you will help publicize phpMyVisites and help it evolve more rapidly.  It is also a way to thank the author who has spent many hours developing this Open Source, free application."; // %s replaced by the logo image
$lang['install_affichergraphique'] = "Show statistics graphs.";
$lang['install_valider'] = "Submit"; //  during installation and for login
$lang['install_accederpersonnaliser'] = "You can now configure access permissions to statistics and customize phpMyVisites.";
$lang['install_configok'] = "Congratulation ! phpMyVisites has been successfully configured.";
$lang['install_explicationjavascript'] = "To count every visitors, you must insert the javascript code on all of your pages.%s Your pages do not have to be made with PHP, <strong>phpMyVisites will work on all kinds of pages (whether it is HTML, ASP, Perl or any other languages)</strong>%s Here is the code you have to insert: (copy and paste on your pages, <strong>you must not modify the code or data will be corrupted!</strong>)"; // %s are here replaced by some line breaks
$lang['install_explicationchemin'] = "If the path to phpMyVisites is not '%s', please correct it now. (examples : './web/mywebsite/phpmyvisites/' or 'http://www.mywebsite.com/phpmyvisites/')"; // ...is not 'http://www.site.com/phpmyvisites/'...
$lang['install_terminerinstall'] = "Finish the installation";
$lang['install_popup_logo'] = "Please select a logo";
$lang['install_logodispo'] = "See the various logos available";
$lang['install_welcome'] = "Welcome!";
$lang['install_system_requirements'] = "System Requirements";
$lang['install_database_setup'] = "Database Setup";
$lang['install_create_tables'] = "Table creation";
$lang['install_general_setup'] = "General Setup";
$lang['install_create_config_file'] = "Create Config File";
$lang['install_first_website_setup'] = "Add First Website";
$lang['install_display_javascript_code'] = "Display Javascript code";
$lang['install_finish'] = "Finished!";
$lang['install_database_setup_txt'] = "Please enter your Database settings.";
$lang['install_general_config_text'] = "phpMyVisites will have only one administrator user who has full access to view/modify everything. Please choose a username and password for your super administrator account. You can add additional users later.";
$lang['install_config_file'] = " Admin user info entered successfully.";
$lang['install_js_code_text'] = "<p>To count every visitors, you must insert the javascript code on all of your pages. </p><p> Your pages do not have to be made with PHP, <strong>phpMyVisites will work on all kinds of pages (whether it is HTML, ASP, Perl or any other languages).</strong> </p><p> Here is the code you have to insert: (copy and paste on all your pages) </p>";
$lang['install_intro'] = "Welcome to the phpMyVisites installation."; 
$lang['install_intro2'] = "This process is split up into %s easy steps and will take around 10 minutes.";
$lang['install_next_step'] = "Go to next step";
$lang['install_status'] = "Installation Status";
$lang['install_done'] = "Install %s%% complete"; // Install 25% complete
$lang['install_site_success'] = "Website created with success!";
$lang['install_site_info'] = "Please type in all information about the first website.";
$lang['install_go_phpmv'] = "Go to phpMyVisites!";
$lang['install_congratulation'] = "Congratulations! Your phpMyVisites install is complete.";
$lang['install_end_text'] = "Make sure your javascript code is well set on your pages, and wait for your first visitors!";
$lang['install_db_ok'] = "Connection to database server ok!";
$lang['install_table_exist'] = "phpMyVisites tables already exist in the database.";
$lang['install_table_choice'] = "Either choose to reuse the existing database tables or select a clean install to erase all existing data in the database.";
$lang['install_table_erase'] = "Erase all tables (be careful!)";
$lang['install_table_reuse'] = "Reuse existing tables";
$lang['install_table_success'] = "Tables created with success!";

//
// Update Step
//
$lang['update_titre'] = "Updating Database";
$lang['update_warning1'] = "We have detected that the version of the phpMyvisites database is older than the phpMyVisites program. phpMyVisites <strong>will not run correctly.</strong>";
$lang['update_warning2'] = "You must update your database by clicking on the following button.";
$lang['update_bouton'] = "Start Updating"; 
$lang['update_jschange'] = "Warning! <br /> The phpMyVisites javascript code has been modified. You MUST update your pages and copy/paste the new phpMyVisites Javascript on ALL your configured sites. <br /> The changes made to javascript code are rare, we apologies for the trouble we are taking you through with this change.";

//
// Dates
//

/*
%daylong% // Monday
%dayshort% // Mon
%daynumeric% // 27
%monthlong% // Febuary
%monthshort% // Feb
%monthnumeric% // 02
%yearlong% // 2004
%yearshort% // 04
*/

// Monday February 10 2004
$lang['tdate1'] = "%daylong% %monthlong% %daynumeric% %yearlong%";

// Monday 10
$lang['tdate2'] = "%daylong% %daynumeric%";

// Week February 10 To February 17 2004
$lang['tdate3']  = "Week %monthlong% %daynumeric% To %monthlong2% %daynumeric2% %yearlong%";

// February 2004 Month
$lang['tdate4']  = "%monthlong% %yearlong% Month";

// December 2003
$lang['tdate5']  = "%monthlong% %yearlong%";

// 10 Febuary week
$lang['tdate6']  = "%daynumeric% %monthlong% week";

// 10-02-2003 // February 2 2003
$lang['tdate7']  = "%daynumeric%-%monthnumeric%-%yearlong%";

// Mon 10 (Only for Graphs purpose)
$lang['tdate8']  = "%dayshort% %daynumeric%";

// Week 10 Feb (Only for Graphs purpose)
$lang['tdate9']  = " Week %daynumeric% %monthshort%";

// Deb 04 (Only for Graphs purpose)
$lang['tdate10'] = "%monthshort% %yearshort%";

// Year 2004
$lang['tdate11'] = "Year %yearlong%";

// 2004
$lang['tdate12'] = "%yearlong%";

// Months
$lang['moistab']['01'] = "January";
$lang['moistab']['02'] = "February";
$lang['moistab']['03'] = "March";
$lang['moistab']['04'] = "April";
$lang['moistab']['05'] = "May";
$lang['moistab']['06'] = "June";
$lang['moistab']['07'] = "July";
$lang['moistab']['08'] = "August";
$lang['moistab']['09'] = "September";
$lang['moistab']['10'] = "October";
$lang['moistab']['11'] = "November";
$lang['moistab']['12'] = "December";

// Months (Graph purpose, 4 chars max)
$lang['moistab_graph']['01'] = "Jan";
$lang['moistab_graph']['02'] = "Feb";
$lang['moistab_graph']['03'] = "Mar";
$lang['moistab_graph']['04'] = "Apr";
$lang['moistab_graph']['05'] = "May";
$lang['moistab_graph']['06'] = "Jun";
$lang['moistab_graph']['07'] = "Jul";
$lang['moistab_graph']['08'] = "Aug";
$lang['moistab_graph']['09'] = "Sep";
$lang['moistab_graph']['10'] = "Oct";
$lang['moistab_graph']['11'] = "Nov";
$lang['moistab_graph']['12'] = "Dec";

// Day of the week
$lang['jsemaine']['Mon'] = "Monday";
$lang['jsemaine']['Tue'] = "Tuesday";
$lang['jsemaine']['Wed'] = "Wednesday";
$lang['jsemaine']['Thu'] = "Thursday";
$lang['jsemaine']['Fri'] = "Friday";
$lang['jsemaine']['Sat'] = "Saturday";
$lang['jsemaine']['Sun'] = "Sunday";

// Day of the week (Graph purpose, 4 chars max)
$lang['jsemaine_graph']['Mon'] = "Mon";
$lang['jsemaine_graph']['Tue'] = "Tue";
$lang['jsemaine_graph']['Wed'] = "Wed";
$lang['jsemaine_graph']['Thu'] = "Thu";
$lang['jsemaine_graph']['Fri'] = "Fri";
$lang['jsemaine_graph']['Sat'] = "Sat";
$lang['jsemaine_graph']['Sun'] = "Sun";

// First letter of each day, weekdays ordered
$lang['calendrier_jours'][0] = "M";
$lang['calendrier_jours'][1] = "T";
$lang['calendrier_jours'][2] = "W";
$lang['calendrier_jours'][3] = "T";
$lang['calendrier_jours'][4] = "F";
$lang['calendrier_jours'][5] = "S";
$lang['calendrier_jours'][6] = "S";

// DO NOT ALTER!
$lang['weekdays']['Mon'] = '1';
$lang['weekdays']['Tue'] = '2';
$lang['weekdays']['Wed'] = '3';
$lang['weekdays']['Thu'] = '4';
$lang['weekdays']['Fri'] = '5';
$lang['weekdays']['Sat'] = '6';
$lang['weekdays']['Sun'] = '7';

// Continents
$lang['eur'] = "Europe";
$lang['afr'] = "Africa";
$lang['asi'] = "Asia";
$lang['ams'] = "South and Central America";
$lang['amn'] = "North America";
$lang['oce'] = "Oceania";

// Oceans
$lang['oc_pac'] = "Pacific Ocean";
$lang['oc_atl'] = "Atlantic Ocean";
$lang['oc_ind'] = "Indian Ocean";

// Countries
$lang['domaines'] = array(
    "xx" => "Unknown",
    "ac" => "Ascension Islands",
    "ad" => "Andorra",
    "ae" => "United Arab Emirates",
    "af" => "Afghanistan",
    "ag" => "Antigua and Barbuda",
    "ai" => "Anguilla",
    "al" => "Albania",
    "am" => "Armenia",
    "an" => "Netherlands Antilles",
    "ao" => "Angola",
    "aq" => "Antarctica",
    "ar" => "Argentina",
    "as" => "American Samoa",
    "at" => "Austria",
    "au" => "Australia",
    "aw" => "Aruba",
    "az" => "Azerbaijan",
    "ba" => "Bosnia and Herzegovina",
    "bb" => "Barbados",
    "bd" => "Bangladesh",
    "be" => "Belgium",
    "bf" => "Burkina Faso",
    "bg" => "Bulgaria",
    "bh" => "Bahrain",
    "bi" => "Burundi",
    "bj" => "Benin",
    "bm" => "Bermuda",
    "bn" => "Bruneo",
    "bo" => "Bolivia",
    "br" => "Brazil",
    "bs" => "Bahamas",
    "bt" => "Bhutan",
    "bv" => "Bouvet Island",
    "bw" => "Botswana",
    "by" => "Belarus",
    "bz" => "Belize",
    "ca" => "Canada",
    "cc" => "Cocos (Keeling) Islands",
    "cd" => "Congo, The Democratic Republic of the",
    "cf" => "Central African Republic",
    "cg" => "Congo",
    "ch" => "Switzerland",
    "ci" => "Cote D'Ivoire",
    "ck" => "Cook Islands",
    "cl" => "Chile",
    "cm" => "Cameroon",
    "cn" => "China",
    "co" => "Colombia",
    "cr" => "Costa Rica",
	"cs" => "Serbia Montenegro",
    "cu" => "Cuba",
    "cv" => "Cape Verde",
    "cx" => "Christmas Island",
    "cy" => "Cyprus",
    "cz" => "Czech Republic",
    "de" => "Germany",
    "dj" => "Djibouti",
    "dk" => "Denmark",
    "dm" => "Dominica",
    "do" => "Dominican Republic",
    "dz" => "Algeria",
    "ec" => "Ecuador",
    "ee" => "Estonia",
    "eg" => "Egypt",
    "eh" => "Western Sahara",
    "er" => "Eritrea",
    "es" => "Spain",
    "et" => "Ethiopia",
    "fi" => "Finland",
    "fj" => "Fiji",
    "fk" => "Falkland Islands (Malvinas)",
    "fm" => "Micronesia, Federated States of",
    "fo" => "Faroe Islands",
    "fr" => "France",
    "ga" => "Gabon",
    "gd" => "Grenada",
    "ge" => "Georgia",
    "gf" => "French Guyana",
    "gg" => "Guernsey",
    "gh" => "Ghana",
    "gi" => "Gibraltar",
    "gl" => "Greenland",
    "gm" => "Gambia",
    "gn" => "Guinea",
    "gp" => "Guadeloupe",
    "gq" => "Equatorial Guinea",
    "gr" => "Greece",
    "gs" => "South Georgia and the South Sandwich Islands",
    "gt" => "Guatemala",
    "gu" => "Guam",
    "gw" => "Guinea-Bissau",
    "gy" => "Guyana",
    "hk" => "Hong Kong",
    "hm" => "Heard Island and McDonald Islands",
    "hn" => "Honduras",
    "hr" => "Croatia",
    "ht" => "Haiti",
    "hu" => "Hungary",
    "id" => "Indonesia",
    "ie" => "Ireland",
    "il" => "Israel",
    "im" => "Man Island",
    "in" => "India",
    "io" => "British Indian Ocean Territory",
    "iq" => "Iraq",
    "ir" => "Iran, Islamic Republic of",
    "is" => "Iceland",
    "it" => "Italy",
    "je" => "Jersey",
    "jm" => "Jamaica",
    "jo" => "Jordan",
    "jp" => "Japan",
    "ke" => "Kenya",
    "kg" => "Kyrgyzstan",
    "kh" => "Cambodia",
    "ki" => "Kiribati",
    "km" => "Comoros",
    "kn" => "Saint Kitts and Nevis",
    "kp" => "Korea, Democratic People's Republic of",
    "kr" => "Korea, Republic of",
    "kw" => "Kuwait",
    "ky" => "Cayman Islands",
    "kz" => "Kazakhstan",
    "la" => "Laos",
    "lb" => "Lebanon",
    "lc" => "Saint Lucia",
    "li" => "Liechtenstein",
    "lk" => "Sri Lanka",
    "lr" => "Liberia",
    "ls" => "Lesotho",
    "lt" => "Lithuania",
    "lu" => "Luxembourg",
    "lv" => "Latvia",
    "ly" => "Libya",
    "ma" => "Morocco",
    "mc" => "Monaco",
    "md" => "Moldova, Republic of",
    "mg" => "Madagascar",
    "mh" => "Marshall Islands",
    "mk" => "Macedonia",
    "ml" => "Mali",
    "mm" => "Myanmar",
    "mn" => "Mongolia",
    "mo" => "Macau",
    "mp" => "Northern Mariana Islands",
    "mq" => "Martinique",
    "mr" => "Mauritania",
    "ms" => "Montserrat",
    "mt" => "Malta",
    "mu" => "Mauritius",
    "mv" => "Maldives",
    "mw" => "Malawi",
    "mx" => "Mexico",
    "my" => "Malaysia",
    "mz" => "Mozambique",
    "na" => "Namibia",
    "nc" => "New Caledonia",
    "ne" => "Niger",
    "nf" => "Norfolk Island",
    "ng" => "Nigeria",
    "ni" => "Nicaragua",
    "nl" => "Netherlands",
    "no" => "Norway",
    "np" => "Nepal",
    "nr" => "Nauru",
    "nu" => "Niue",
    "nz" => "New Zealand",
    "om" => "Oman",
    "pa" => "Panama",
    "pe" => "Peru",
    "pf" => "French Polynesia",
    "pg" => "Papua New Guinea",
    "ph" => "Philippines",
    "pk" => "Pakistan",
    "pl" => "Poland",
    "pm" => "Saint Pierre and Miquelon",
    "pn" => "Pitcairn",
    "pr" => "Puerto Rico",
    "pt" => "Portugal",
    "pw" => "Palau",
    "py" => "Paraguay",
    "qa" => "Qatar",
    "re" => "Reunion Island",
    "ro" => "Romania",
    "ru" => "Russian Federation",
    "rs" => "Russia",
    "rw" => "Rwanda",
    "sa" => "Saudi Arabia",
    "sb" => "Solomon Islands",
    "sc" => "Seychelles",
    "sd" => "Sudan",
    "se" => "Sweden",
    "sg" => "Singapore",
    "sh" => "Saint Helena",
    "si" => "Slovenia",
    "sj" => "Svalbard",
    "sk" => "Slovakia",
    "sl" => "Sierra Leone",
    "sm" => "San Marino",
    "sn" => "Senegal",
    "so" => "Somalia",
    "sr" => "Suriname",
    "st" => "Sao Tome and Principe",
    "su" => "Old U.R.S.S.",
    "sv" => "El Salvador",
    "sy" => "Syrian Arab Republic",
    "sz" => "Switzerland",
    "tc" => "Turks and Caicos Islands",
    "td" => "Chad",
    "tf" => "French Southern Territories",
    "tg" => "Togo",
    "th" => "Thailand",
    "tj" => "Tajikistan",
    "tk" => "Tokelau",
    "tm" => "Turkmenistan",
    "tn" => "Tunisia",
    "to" => "Tonga",
    "tp" => "East Timor",
    "tr" => "Turkey",
    "tt" => "Trinidad and Tobago",
    "tv" => "Tuvalu",
    "tw" => "Taiwan, Province of China",
    "tz" => "Tanzania, United Republic of",
    "ua" => "Ukraine",
    "ug" => "Uganda",
    "uk" => "United Kingdom",
    "gb" => "Great Britain",
    "um" => "United States Minor Outlying Islands",
    "us" => "United States",
    "uy" => "Uruguay",
    "uz" => "Uzbekistan",
    "va" => "Vatican City",
    "vc" => "Saint Vincent and the Grenadines",
    "ve" => "Venezuela",
    "vg" => "Virgin Islands, British",
    "vi" => "Virgin Islands, U.S.",
    "vn" => "Vietnam",
    "vu" => "Vanuatu",
    "wf" => "Wallis and Futuna",
    "ws" => "Samoa",
    "ye" => "Yemen",
    "yt" => "Mayotte",
    "yu" => "Yugoslavia",
    "za" => "South Africa",
    "zm" => "Zambia",
    "zr" => "Zaire",
    "zw" => "Zimbabwe",
    "com" => "-",
    "net" => "-",
    "org" => "-",
    "edu" => "-",
    "int" => "-",
    "arpa" => "-",
    "gov" => "-",
    "mil" => "-",
    "reverse" => "-",
    "biz" => "-",
    "info" => "-",
    "name" => "-",
    "pro" => "-",
    "coop" => "-",
    "aero" => "-",
    "museum" => "-",
    "tv" => "-",
    "ws" => "-"
);
?>