<?php
/* 
 * phpMyVisites : website statistics and audience measurements
 * Copyright (C) 2002 - 2006
 * http://www.phpmyvisites.net/ 
 * phpMyVisites is free software (license GNU/GPL)
 * Authors : phpMyVisites team
*/

// $Id: ViewRss.class.php,v 1.12 2005/10/28 21:27:48 matthieu_ Exp $


require_once INCLUDE_PATH."/core/include/ViewModule.class.php";
require_once INCLUDE_PATH."/core/include/PmvConfig.class.php";
require_once INCLUDE_PATH."/libs/Cache/Lite.php";
require_once INCLUDE_PATH."/core/views/ViewVisitsRss.class.php";
require_once INCLUDE_PATH . "/libs/XML/Serializer.php";

class ViewRss extends ViewModule
{
	function ViewRss(  )
	{
		parent::ViewModule( '' );
	}
	
	function showAll()
	{	
		
		$allSiteArchive =  DataModel::getSites();
		//$uniqCacheId = md5(serialize($allSiteArchive).date("Y-m-d")) . '.rss';
		$uniqCacheId = time();

		// Set a few options
		$options = array(
		    'cacheDir' => DIR_CACHE_RSS,
		    'lifeTime' => CACHE_RSS_LIFETIME
		);
		
		
		// Create a Cache_Lite object
		$Cache_Lite = new Cache_Lite($options);
		
		// Test if thereis a valide cache for this id
		if (!$allData = $Cache_Lite->get($uniqCacheId)) 
		{
						
			$dataTmp = $this->data;
			
			$o_config =& PmvConfig::getInstance();
			

			foreach($allSiteArchive as $id => $infoSite)
			{
				$allArchives = $dataTmp->getLastArchives(NB_DAYS_FOR_RSS_ITEMS, 0, 0, $infoSite);
				
				$i = 0;
				foreach($allArchives as $date => $o_archive)
				{					
					$this->request->setDate( $o_archive->date->get() );
					$this->request->setModuleName( 'view_visits_rss' );
					
					$o_mod = new ViewVisitsRss( );
					$o_mod->init($this->request, $this->tpl);
										
					$rssContent = $o_mod->showAll( true );
					
					$dateRss = date("r", time() - 100 * $i++ - 10 * $id);
					$item['pubDate'] = $dateRss;
				    $item['guid'] = "http://www.phpmyvisites.net/".md5($dateRss);

					$url =  PHPMV_URL . "?site=".$infoSite->getId()."&mod=view_visits&date=".$o_archive->date->get();
				    $item['link'] = $url;
					
				    $item['title'] = vsprintf($GLOBALS['lang']['rss_titre'], array($infoSite->getName(), $date));
					$item['author'] = "matthieu@phpmyvisites.net (phpMyVisites)";
					$item['date_ts'] = time() - 10 * $id ;
					$item['description'] = $rssContent;
					$item['date_ts'] = $o_archive->date->getTimestamp();
		
					$allItems[] = $item;
					$urls[] = $url;
				}
			}
			$GLOBALS['sorting_index'] = 'date_ts';
			uasort($allItems, "sortingDataInfo");
			
			$channel['title'] = "phpMyVisites stats by RSS";
			$channel['link'] = "http://www.phpmyvisites.net";
			$channel['description'] = "Enjoy phpmyvisites power ! :)";
			$channel['pubDate'] = date("r");
			$channel['generator'] = "phpMyVisites";
			$channel['language'] = $GLOBALS['lang']['lang_iso'];
			$channel['lastBuildDate'] = date("r");
			
			foreach($allItems as $chan)
			{
				unset($chan['date_ts']);
				$channel[] = $chan;
			}
			$rss = array('channel' => $channel);
			
			
			// An array of serializer options
			$serializer_options = array (
			    'addDecl' => TRUE,
			    'encoding' => 'UTF-8',
			    'indent' => '  ',
			    'rootName' => 'rss',
			    'defaultTagName' => 'item',
			    'rootAttributes' => array ( 'version' => '2.0'),
			);
			
			$Serializer = &new XML_Serializer($serializer_options);
			// Serialize the data structure
			
			$Serializer->setOption("keyAttribute", "rdf:about");
			
			$status = $Serializer->serialize($rss);
			
			$allData =  $Serializer->getSerializedData();
		
			$Cache_Lite->save($allData);
		
		}			
		
		$this->displayRss($allData);
	}
	
	function displayRss(&$data)
	{
		// Display the XML document
		header('Content-type: text/xml');
		print($data);
		exit;
	}
}
?>
