<?php
/* 
 * phpMyVisites : website statistics and audience measurements
 * Copyright (C) 2002 - 2006
 * http://www.phpmyvisites.net/ 
 * phpMyVisites is free software (license GNU/GPL)
 * Authors : phpMyVisites team
*/

// $Id: SendMail.class.php,v 1.13 2005/10/08 02:57:53 matthieu_ Exp $


require_once INCLUDE_PATH."/core/include/ViewModule.class.php";
require_once INCLUDE_PATH."/core/include/PmvConfig.class.php";
require_once INCLUDE_PATH."/libs/Cache/Lite.php";
require_once INCLUDE_PATH."/core/views/ViewVisitsRss.class.php";		
require_once INCLUDE_PATH."/core/include/myMailer.class.php";

class SendMail extends Module
{
	var $defaultAction = "showAll";
	
	function SendMail()
	{
		parent::Module();
	}
	
	function showAll()
	{	
		$this->tpl->setMainTemplate("structure_mail.tpl");
		
		
		$this->request->setModuleName( 'view_visits_rss');
		$allSiteArchive =  DataModel::getSites();
		
		/**
		 * Cache Lite
		 */
		$options = array(
		    'cacheDir' => DIR_CACHE_MAIL,
		    'lifeTime' => CACHE_MAIL_LIFETIME
		);
		$Cache_Lite = new Cache_Lite($options);

		/**
		 * php Mailer
		 */
		$mail = new MyMailer();
		
		
		/**
		 * Compute mails
		 */				
		
		$o_config =& PmvConfig::getInstance();

		//$toMail = "xav@spotk.net";
		//$toMail = "matthieu@phpmyvisites.net";
		
		$toMail = SU_EMAIL;
		
		$toName = "phpMyVisites";
		$mail->AddAddress($toMail, $toName);
		$mail->IsHTML(true);
		
		$imgUrl = INCLUDE_PATH . "/themes/default/images/phpmv.png";
		
		foreach($allSiteArchive as $id => $infoSite) 
		{
			$uniqCacheId = md5(serialize($infoSite).date("Y-m-d")) . '.mail';
			
			// Test if thereis a valide cache for this id
			if (!$allData = $Cache_Lite->get($uniqCacheId)) 
			{
				$o_mod = new ViewVisitsRss($infoSite);
				$o_mod->init($this->request);
				
				$dateLiteral = $o_mod->data->archive->getLiteralDate();
						
				$body = $o_mod->showAll( true, true);
				$textBody = strip_tags($body);
				
				$subject = vsprintf($GLOBALS['lang']['rss_titre'], 
									array($infoSite->getName(), $dateLiteral));
					
				print("<br>Subject : $subject<hr>");
				print("<br>Content : $body<hr>");
				
				//$Cache_Lite->save($body);
			}
			
			$mail->Subject = $subject;
			$mail->Body    = $body;
			$mail->AltBody = $textBody;
	
			if($o_mod->data->getContent('nb_vis') != 0)
				$mail->AddEmbeddedImage($imgUrl, "my-attach", "Bande", "base64", "image/png");
					
			if(!$mail->Send())
			{
			   echo "There was an error sending the message";
			}
			else
			{
				echo "Message was sent successfully";
			}
			
			$mail->ClearAttachments();
		}
	}
}
?>