<?php
/*
 * This work is hereby released into the Public Domain.
 * To view a copy of the public domain dedication,
 * visit http://creativecommons.org/licenses/publicdomain/ or send a letter to
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 *
 */

require_once INCLUDE_PATH . "/libs/artichow/BarPlot.class.php";
require_once INCLUDE_PATH . "/core/include/graphs/PmvGraph.class.php";

class GraphVerticalBar extends PmvGraph
{
	function GraphVerticalBar( $width = 500, $height = 250)
	{
		parent::PmvGraph($width, $height);	
	}
	
	function setData( $a_data )
	{
//		var_dump($a_data);exit;
//		require "./artichow/g2a.php";
//		$a_data = $data;	
		$this->y = $a_data['data'];
		$this->title = $a_data['title'];
		$this->x = $a_data['axis'];
	}
	
	function process()
	{
		parent::process();
		
		$this->plot = new BarPlot($this->y);
		
		$this->plot->grid->setType( LINE_DASHED );
		
		//$this->plot->setSpace(4, 4, 10, 0);
		$this->plot->setPadding(25, 15, 30, 25);
		$this->plot->title->set($this->title);
		$this->plot->title->setFont(new Tuffy(16));
		$this->plot->title->setColor(new Color(0, 0, 165, 10));
		//$this->plot->title->move(-20, 25);
		
		/*
		$this->plot->yAxis->title->set("Axe des Y");
		$this->plot->yAxis->title->setFont(new TuffyBold(10));
		$this->plot->yAxis->title->move(-4, 0);
		$this->plot->yAxis->setTitleAlignment(LABEL_TOP);
		
		//$this->plot->xAxis->title->set("Axe des X");
		$this->plot->xAxis->title->setFont(new TuffyBold(10));
		$this->plot->xAxis->setTitleAlignment(LABEL_RIGHT);
		*/
		
		$this->plot->setBackgroundGradient(
			new LinearGradient(
				new Color(241, 241, 241),
				new Color(255, 255, 255),
				0
			)
		);
		
		$this->plot->barBorder->setColor(new Color(0, 0, 0));
		
		$this->plot->barShadow->setSize(2);
		$this->plot->barShadow->setPosition(SHADOW_RIGHT_TOP);
		$this->plot->barShadow->setColor(new Color(180, 180, 180, 10));
		$this->plot->barShadow->smooth(TRUE);
		
		$this->plot->label->set($this->y);
		$this->plot->label->move(0, -5);
		$this->plot->label->setFont(new Tuffy(10));
		$this->plot->label->setColor(new Color( 0, 0, 139));
		$this->plot->label->setAngle(0);
		//$this->plot->label->setColor();
		//$this->plot->label->setInterval(2);
		$this->plot->label->setAlign(NULL, LABEL_TOP);
		$this->plot->label->setPadding(3, 1, 0, 6);
			
		$this->plot->setBarColor( new Color(255, 165, 0) );
		$this->plot->setBarSize( 0.5 );
		
		/*
		$this->plot->setBarGradient(
			new LinearGradient(
				new Color(150, 150, 210, 0),
				new Color(230, 230, 255, 30),
				0
			)
		);*/
		
		$this->plot->xAxis->setColor( new Color(  50, 97, 243) );
		$this->plot->yAxis->setColor( new Color(  50, 97, 243) );
		
		$this->plot->xAxis->setLabelText($this->x);
		$this->plot->xAxis->label->setFont(new Tuffy(8));
		

	}
	
	function display()
	{
		$this->graph->add($this->plot);
		$this->graph->draw();
	}
}
?>