<?php
/*
 * This work is hereby released into the Public Domain.
 * To view a copy of the public domain dedication,
 * visit http://creativecommons.org/licenses/publicdomain/ or send a letter to
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 *
 */

require_once INCLUDE_PATH . "/libs/artichow/BarPlot.class.php";
require_once INCLUDE_PATH . "/libs/artichow/LinePlot.class.php";
require_once INCLUDE_PATH . "/core/include/graphs/PmvGraph.class.php";

class GraphBarAndCurb extends PmvGraph
{
	function GraphBarAndCurb( $width = 580, $height = 250)
	{
		parent::PmvGraph($width, $height);
	}

	function setData( $a_data )
	{
		//var_dump($a_data);exit;
		//require "./artichow/g1a.php";
		//$a_data = $data;
		$this->y1 = $a_data['data1']['data'];
		$this->y2 = $a_data['data2']['data'];
		$this->y1Legend = $a_data['data1']['legend'];
		$this->y2Legend = $a_data['data2']['legend'];
		$this->title = $a_data['title'];
		$this->x = $a_data['axis'];
	}

	function process()
	{
		parent::process();

		/**
		 * group (bar + line)
		 */
		$group = new PlotGroup();
		$group->setSize(0.8, 1);
		$group->setCenter(0.41, 0.5);
		$group->setPadding(35, 26, 40, 27);
		$group->setSpace(2, 2);

		$group->grid->setColor(new Color(0xC4, 0xC4, 0xC4));
		$group->grid->setType(LINE_DASHED);
		$group->grid->hideVertical(TRUE);
		$group->grid->setBackgroundColor(new White);

		$group->axis->left->setColor(new DarkGreen);
		$group->axis->left->label->setFont(new Font2);

		$group->axis->right->setColor(new DarkBlue);
		$group->axis->right->label->setFont(new Font2);

		$group->axis->bottom->label->setFont(new Font2);

		$group->legend->setPosition(1.18, 0.2);
		$group->legend->setTextFont(new Tuffy(8));
		$group->legend->setSpace(10);


		/**
		 * line
		 */
		$plot = new LinePlot($this->y2, LINEPLOT_MIDDLE);

		$plot->setColor(new Red);
		$plot->setThickness(1);
		$plot->setYAxis(PLOT_RIGHT);

		$group->legend->add($plot, $this->y2Legend, LEGEND_MARK);
		$group->add($plot);


		/**
		 * vertical bar
		 */
		$plot = new BarPlot($this->y1);

		$plot->grid->setType( LINE_DASHED );

		//$plot->setSpace(4, 4, 10, 0);
		$plot->setPadding(25, 15, 30, 25);
		$plot->title->set($this->title);
		$plot->title->setFont(new Tuffy(16));
		$plot->title->setColor(new Color(0, 0, 165, 10));
		//$plot->title->move(-20, 25);

		$plot->setBackgroundGradient(
			new LinearGradient(
				new Color(241, 241, 241),
				new Color(255, 255, 255),
				0
			)
		);

		$plot->barBorder->setColor(new Color(0, 0, 0));

		$plot->barShadow->setSize(2);
		$plot->barShadow->setPosition(SHADOW_RIGHT_TOP);
		$plot->barShadow->setColor(new Color(180, 180, 180, 10));
		$plot->barShadow->smooth(TRUE);

		$plot->label->set($this->y1);
		$plot->label->move(0, -5);
		$plot->label->setFont(new Tuffy(10));
		$plot->label->setColor(new Color( 0, 0, 139));
		$plot->label->setAngle(0);
		//$plot->label->setColor();
		//$plot->label->setInterval(2);
		$plot->label->setAlign(NULL, LABEL_TOP);
		$plot->label->setPadding(3, 1, 0, 6);

		$plot->setBarColor( new Color(255, 165, 0) );
		$plot->setBarSize( 0.5 );

		$plot->xAxis->setColor( new Color(  50, 97, 243) );
		$plot->yAxis->setColor( new Color(  50, 97, 243) );

		//$plot->xAxis->setLabelText($this->x);
		$group->axis->bottom->setLabelText($this->x);
		$plot->xAxis->label->setFont(new Tuffy(8));

		$group->legend->add($plot, $this->y1Legend, LEGEND_BACKGROUND);
		$group->add($plot);

		/**
		 * add group to graph
		 */
		$this->graph->add($group);
		$this->graph->setBackgroundGradient(
			new LinearGradient(
				new Color(241, 241, 241),
				new Color(255, 255, 255),
				0
			)
		);
	}

	function display()
	{
		$this->graph->draw();
	}
}
?>