<?php
/* 
 * phpMyVisites : website statistics and audience measurements
 * Copyright (C) 2002 - 2006
 * http://www.phpmyvisites.net/ 
 * phpMyVisites is free software (license GNU/GPL)
 * Authors : phpMyVisites team
*/

// $Id: DataModel.class.php,v 1.60 2005/10/28 21:27:47 matthieu_ Exp $


$GLOBALS['sorting_index'] = 'sum';
$GLOBALS['sorting_order'] = 'desc';

require_once INCLUDE_PATH."/core/include/Archive.class.php";
require_once INCLUDE_PATH."/core/include/ArchiveEmpty.class.php";
require_once INCLUDE_PATH."/core/include/ArchiveDay.class.php";
require_once INCLUDE_PATH."/core/include/ArchivePeriod.class.php";
require_once INCLUDE_PATH."/core/include/ArchiveWeek.class.php";
require_once INCLUDE_PATH."/core/include/ArchiveMonth.class.php";
require_once INCLUDE_PATH."/core/include/ArchiveYear.class.php";
require_once INCLUDE_PATH . "/core/include/ArchiveTable.class.php";

class DataModel
{
	//object ArchiveX
	var $archive;
	
	var $langFile;
	
	var $content;
	
	var $objects;
	
	var $infoSerialized;
	
	var $idDetailsSaved; // store ID for compute nb of subelements for a data like search engines, keywords...
	var $sizeDetailsSaved;
	
	function DataModel( & $o_archive, & $o_request)
	{
		$this->archive = $o_archive;

		$this->infoSerialized = $this->archive->getArchived();
		
		$this->request = $o_request;
		
		$this->arraySumInfo = array(
				'int'           => $this->getContent('nb_vis'),
				'pag'           => $this->getContent('nb_pag'),
				'exit'          => $this->getContent('nb_vis'),
				'entry'         => $this->getContent('nb_vis'), 
				'sumtime'       => $this->getContent('nb_pag'),
				'singlepage'    => $this->getContent('nb_vis'),
				'keyword'       => $this->getReferersNbSearchEngines(),
				'searchengine'  => $this->getReferersNbSearchEngines(),
				'site'          => $this->getReferersNbSites(),
				'partner'       => $this->getReferersNbPartners(),
				'newsletter'    => $this->getReferersNbNewsletters()
				);
		
		$this->deleteOldRecords();		
	}
	
	function deleteOldRecords()
	{
		// delete failed archives
		// delete temp archives older than today
		
		$r = query("DELETE FROM ".T_ARCHIVES."
					WHERE done = ".DB_ARCHIVES_FAIL."
						OR (done = ".DB_ARCHIVES_TEMP." 
							AND date1 <> '".date("Y-m-d")."'
							AND date2 <> '".date("Y-m-d")."'
							)
					");
					
	}
	
	function getContent($name, $offset = 0, $nbElementsToDisplay = -1)
	{
		$indexName = $name."-".$offset."-".$nbElementsToDisplay;
		
		if(!isset($this->content[$indexName]))
		{
			//printDebug($this->infoSerialized);
		//print("content : ".$this->infoSerialized[$name]);
			if(!is_numeric($this->infoSerialized[$name]) && $name!='date1' && $name != 'date2')
			{
				//printTime('before unserialize', true);
				if(substr($name, 0, 4) === 'int_')
				{
					$array = $this->getArrayInterestNamed(unserialize($this->infoSerialized[$name]));
				}
				else
				{
					$array = unserialize($this->infoSerialized[$name]);
				}
//print("<br>");				print($name);
//			printDebug($array);
			
				// case subdetail, record number of subdetails for an element
				if($name == 'vis_search_engine'
				|| $name == 'vis_keyword'
				|| $name == 'vis_site'
				|| $name == 'vis_partner')
				{
					if(is_array($array))
					{
						foreach($array as $key => $infoA)
						{
					//		print("$key vs ".$this->idDetailsSaved[$name]."<br>");
							if($key == $this->idDetailsSaved[$name])
							{	
								$this->sizeDetailsSaved[$name] = sizeof($infoA)-1;
							}		
						}
					}
				}
				//printTime('before offset', true);
				$this->content[$indexName] = getArrayOffsetLimit(
														$array, 
														$offset, 
														$nbElementsToDisplay,
														$name,
														null,
														$this->arraySumInfo
														);
				//printTime('after offset', true);
				//printDebug($this->content[$indexName]);
			}
			else
			{
				$this->content[$indexName] = $this->infoSerialized[$name];
			}
		}
		return $this->content[$indexName];
	}
	
	
	function getVisitsFrequencyNewReturningGraph()
	{
		$all =  $this->getContent('vis_period');
		
		//printDebug($all);
		
		switch($this->archive->periodType)
		{
				
			case DB_ARCHIVES_PERIOD_WEEK:
				$typeDateDisplay = 2;
				$typeDateDisplayGraph = 8;
				
			break;
				
			case DB_ARCHIVES_PERIOD_MONTH:
				$typeDateDisplay = 2;
				$typeDateDisplayGraph = 8;
				
			break;
				
			case DB_ARCHIVES_PERIOD_YEAR:
				$typeDateDisplay = 5;
				$typeDateDisplayGraph = 10;
			break;
		}
				
			
		foreach($all as $date => $info)
		{
			$new[]       = $info[ARRAY_INDEX_NEW_COUNT];
			$returning[] = $info[ARRAY_INDEX_RETURNING_COUNT];
			$axis[]      = ($this->archive->periodType === DB_ARCHIVES_PERIOD_DAY)
						  ? sprintf( $GLOBALS['lang']['generique_tempsheure'], $date)
						  : getDateDisplay($typeDateDisplayGraph, new Date($date));
		}
		
		return array(
				'data1' => array(
					'data'     => $new,
					'legend'   => $GLOBALS['lang']['frequence_nouvellesvisites']
					),
				'data2' => array(
					'data'     => $returning,
					'legend'   => $GLOBALS['lang']['frequence_visitesconnues']
					),
				'axis'  => $axis,						
				'title' => $GLOBALS['lang']['frequence_nouveauxconnus']
				);
	}
	
	function getVisitsFrequencyStatistics()
	{
	    $ret = array();
	    
		if($this->getContent('nb_vis') != 0)
		{
			$nbVisitNew = $this->getContent('nb_vis') - $this->getContent('nb_vis_returning');
			$nbPagNew = $this->getContent('nb_pag') - $this->getContent('nb_pag_returning');
			$totalTimeNew = $this->getContent('sum_vis_lth') - $this->getContent('sum_vis_lth_returning');
			$nbOnePagVis = $this->getContent('nb_vis_1pag') - $this->getContent('nb_vis_1pag_returning');
			
			$nb_vis                  = $this->getContent('nb_vis');
			$nb_uniq_vis             = $this->getContent('nb_uniq_vis');
			$nb_pag                  = $this->getContent('nb_pag');
			$nb_vis_returning        = $this->getContent('nb_vis_returning');
			$nb_pag_returning        = $this->getContent('nb_pag_returning');
			$sum_vis_lth_returning   = $this->getContent('sum_vis_lth_returning');
			$nb_vis_1pag_returning   = $this->getContent('nb_vis_1pag_returning');
			
			
			$ret = array();
			$ret['returning_rate']           = 100 * $this->_secureDiv($nb_vis_returning , $nb_vis);
			$ret['nb_vis_returning_percent'] = 100 * $this->_secureDiv($nb_vis_returning , $nb_vis);
			$ret['nb_vis_new_percent']       = 100 * $this->_secureDiv($nbVisitNew ,$nb_vis );
			
			$ret['nb_vis_per_uniq_vis']      = $this->_secureDiv($nb_vis,$nb_uniq_vis);
			$ret['nb_vis_returning']         = $nb_vis_returning;
			$ret['nb_vis_new']               = $nbVisitNew;
			$ret['nb_pag_returning']         = $nb_pag_returning;
			$ret['nb_pag_new']               = $nbPagNew;
			
			$ret['nb_pag_returning_percent'] = 100 * $this->_secureDiv($nb_pag_returning ,$nb_pag );
			$ret['nb_pag_new_percent']       = 100 * $this->_secureDiv($nbPagNew ,$nb_pag);
			
			$ret['nb_pag_per_vis_returning'] = $this->_secureDiv($nb_pag_returning, $nb_vis_returning );
			$ret['time_per_vis_returning']   = $this->_secureDiv($sum_vis_lth_returning, $nb_vis_returning);
            $ret['time_per_pag_returning']   = $this->_secureDiv($sum_vis_lth_returning, $nb_vis_returning);
            $ret['one_page_rate_returning']  = 100 * $this->_secureDiv($nb_vis_1pag_returning,$nb_vis_returning);
            
			$ret['nb_pag_per_vis_new']       = $this->_secureDiv($nbPagNew, $nbVisitNew);
			$ret['one_page_rate_new']        = 100 * $this->_secureDiv($nbOnePagVis,$nbVisitNew);
			$ret['time_per_vis_new']         = $this->_secureDiv($totalTimeNew, $nbVisitNew);
			
			$ret['time_per_pag_new']         = $this->_secureDiv($totalTimeNew, $nbPagNew);
			
		}
		return $ret;
	}
			
	
	/**
	 * Visits
	 */

	function getVisitsStatistics()
	{
	    $ret = array();
	    
		if($this->getContent('nb_vis') != 0
			&& $this->getContent('nb_pag') != 0 )
		{
		    $nb_vis                  = $this->getContent('nb_vis');
			$nb_uniq_vis             = $this->getContent('nb_uniq_vis');
			$nb_pag                  = $this->getContent('nb_pag');
			$nb_vis_1pag             = $this->getContent('nb_vis_1pag');
			$sum_vis_lth             = $this->getContent('sum_vis_lth');
			
			$nbPagPerVisSig          = $this->_secureDiv($nb_pag, ($nb_vis - $nb_vis_1pag));

			$ret['nb_vis']               = $nb_vis;
			$ret['nb_uniq_vis']          = $nb_uniq_vis;
			$ret['nb_pag']               = $nb_pag;
			$ret['nb_pag_per_vis_sig']   = $nbPagPerVisSig;
			$ret['nb_pag_per_vis']      = $this->_secureDiv($nb_pag, $nb_uniq_vis);
			$ret['time_per_vis']         = $this->_secureDiv($sum_vis_lth, $nb_vis);
			$ret['time_per_pag']         = $this->_secureDiv($sum_vis_lth, $nb_pag);
			$ret['one_page_rate']        = 100 * $this->_secureDiv($nb_vis_1pag, $nb_vis);
		}
		return $ret;
	}
	

	function getSites()
	{
		if(!isset($this->siteInfo))
		{
			$site = new Site(1);
			$siteInfo = $site->getAllowedSites( 'view' );
			
			//array();
			//require INCLUDE_PATH."/config/site_info.php";
			
			foreach($siteInfo as $id => $info)
			{
				$return[] = new Site( $id );// $info['idsite'] );
			}
			//printDebug($return);
			$this->siteInfo = $return;
		}
		else
		{
			$return = $this->siteInfo;
		}
		return $return;
	}
		
	function getSitesArchives()
	{
		$siteInfo = $this->getSites();
		foreach($siteInfo as $id => $o_site)
		{
			$id = $o_site->getId();
			$p = $this->getArchive($o_site, $this->archive->date->get(), $this->request->getPeriod() );
			$allArchive[] = new DataModel( $p , $this->request);
		}	
		return $allArchive;
	}
	
	function getSitesSummaryStatisticsGraph()
	{
		$allSiteArchive =  $this->getSites();
		
		$i = 0;
		foreach($allSiteArchive as $id => $infoSite)
		{
			$allArchive = $this->getLastArchives( 15, 0, true, $infoSite);
			
			$data = array();
			$axis = array();
			
			$allArchive = array_reverse($allArchive, true);
			foreach($allArchive as $date => $o_archive)
			{
				$o_data = new DataModel($o_archive, $this->request);
				$data[] = $o_data->getContent('nb_vis');
				$axis[] = $date;
			} 
			
			$return['data'.$i++] = array(
				'data' => $data,
				'legend' => $infoSite->getName()
				);
			
		}
		
		$return['axis'] = $axis;
		$return['title'] = $GLOBALS['lang']['visites_grapghrecap'];
		return $return;

	}
	
	function getSitesSummaryStatistics()
	{
		$allSiteArchive =  $this->getSitesArchives();

		foreach($allSiteArchive as $value)
		{
			$siteInfo =  $value->archive->site->a_info;
			
			$toSum['nb_vis'][] = $value->getContent('nb_vis');
			$toSum['nb_pag'][] = $value->getContent('nb_pag');
			$toSum['nb_uniq_vis'][] = $value->getContent('nb_uniq_vis');
			$toSum['sum_vis_lth'][] = $value->getContent('sum_vis_lth');
			$toSum['nb_vis_1pag'][] = $value->getContent('nb_vis_1pag');
			
			@$nbPagPerVisSig = $value->getContent('nb_pag') 
								/ ($value->getContent('nb_vis') - $value->getContent('nb_vis_1pag'));
			$return[] = array(
				'id'                => $value->archive->site->getId(),
				'site_name'         => $siteInfo['name'],
				'nb_vis'            => $value->getContent('nb_vis'),
				'nb_uniq_vis'       => $value->getContent('nb_uniq_vis'),
				'nb_pag'            => $value->getContent('nb_pag'),
				'nb_pag_per_vis_sig'=> $nbPagPerVisSig,
				'nb_pag_per_vis'    => $this->_secureDiv($value->getContent('nb_pag') ,$value->getContent('nb_uniq_vis')),
				'time_per_vis'      => $this->_secureDiv($value->getContent('sum_vis_lth') ,$value->getContent('nb_vis')),
				'time_per_pag'      => $this->_secureDiv($value->getContent('sum_vis_lth') , $value->getContent('nb_pag')),
				'one_page_rate'     => 100 * $this->_secureDiv($value->getContent('nb_vis_1pag'), $this->getContent('nb_vis'))
				);
		}
		
		foreach($toSum as $id => $value)
		{
			$totalSum[$id] = array_sum($value);
		}
		
		$returnTotal = array(
			'nb_vis'         => $totalSum['nb_vis'],
			'nb_pag'         => $totalSum['nb_pag'],
			'nb_pag_per_vis' => $this->_secureDiv($totalSum['nb_pag'] , $totalSum['nb_vis']) ,
			'time_per_vis'   => $this->_secureDiv($totalSum['sum_vis_lth'] ,$totalSum['nb_vis']) ,
			'one_page_rate'  => 100 * $this->_secureDiv($totalSum['nb_vis_1pag'] ,$totalSum['nb_vis'] )
			);
		
		$GLOBALS['sorting_index'] = 'nb_vis';
		uasort($return, "sortingDataInfo");
		//printdebug($return);

		return array(
			'sites_info' => $return,
			'total' => $returnTotal
			);
	}
	
	function getVisitsPeriodSummaries($nbPeriodToDisplay = 8, $forGraph = false)
	{
		$archives = $this->getLastArchives($nbPeriodToDisplay, 0, $forGraph);		
		
		$visitsToday = $this->getContent('nb_vis');
		$pagesToday = $this->getContent('nb_pag');

		foreach($archives as $dateToDisplay => $archive)
		{
			$info = $archive->getArchived();
			
			$visitsPercent = $this->getDiffPercent($visitsToday, $info['nb_vis']);
			$pagesPercent = $this->getDiffPercent($pagesToday, $info['nb_pag']);
			
			$return[] = array(
				'date'          => $dateToDisplay,
				'visits'        => $info['nb_vis'],
				'visits_percent'=> $visitsPercent,
				'pages'         => $info['nb_pag'],
				'pages_percent' => $pagesPercent
				);	
		}
		return array_reverse($return);
	}
	
	function getVisitsPeriodSummariesGraph($nbPeriodToDisplay = 8)
	{
		$info = $this->getVisitsPeriodSummaries($nbPeriodToDisplay, true);
		
		foreach($info as $info)
		{
			$visits[] = $info['visits'];
			$pages[] = $info['pages'];
			$axis[] = $info['date'];
		}
		return array(
				'data1' => array(
					'data'     => $visits,
					'legend'   => $GLOBALS['lang']['visites_visites']
					),
				'data2' => array(
					'data'     => $pages,
					'legend'   => $GLOBALS['lang']['visites_pagesvues']
					),
				'axis'  => $axis,						
				'title' => $GLOBALS['lang']['visites_recap']
				);
	}
	
	function getVisitsServerTimeGraph()
	{
		$data = $this->getContent('vis_st');
		for($i = 0; $i < 24; $i++)
		{
			if(!isset($data[$i]))
			{
				$data[$i] = 0;
			}
		}
		ksort($data);
		return array(
				'data'  => $data,
				'axis'  => array_keys($data),
				'title' => $GLOBALS['lang']['visites_graphheureserveurimg']
				);
	}
	
	function getVisitsTimeVisitsGraph()
	{
		$GLOBALS['timeGap'][0][1] = "30";
		$GLOBALS['timeGap'][1][0] = "30";
		$GLOBALS['timeGap'][1][1] = "60";
		$data = $this->getContent('vis_lth');
		foreach($data as $id => $value)
		{
			$axis[] = sprintf( ($id == 0 || $id == 1)
								? $GLOBALS['lang']['visites_sec']
								: $GLOBALS['lang']['visites_min'] , 
									$GLOBALS['timeGap'][$id][0]."-".$GLOBALS['timeGap'][$id][1]. " " );
		}
		
		return array(
				'data' => $data,
				'axis' => $axis,
				'title' => $GLOBALS['lang']['visites_graphtempsvisitesimg']
				);
	}
	
	function getSourceContinentCountriesDistinct( )
	{
		return $this->sizeDetailsSaved['continentcountries'];
	}
	/**
	 * returns continent hits if no continent specified, or details of country per continent 
	 */
	
	// -1 is default because of the need of all info for map of the world computing 
	function getSourceContinentCountries($cont='', $offset = 0, $nbElementsToDisplay = -1)
	{
		$sum = array(
			$GLOBALS['lang']['eur'] => 0, 
			$GLOBALS['lang']['asi'] => 0,
			$GLOBALS['lang']['ams'] => 0, 
			$GLOBALS['lang']['amn'] => 0,
			$GLOBALS['lang']['afr'] => 0,
			$GLOBALS['lang']['oce'] => 0,
			$GLOBALS['lang']['domaines']['xx'] => 0
		);
		
		// case continent global summary, we need all countries
		
		$a = $this->getSourceCountries(0,-1);
		
		$t = sizeof($a);
		reset($a);
		
		for($i = 0; $i < $t; $i++)
		{
			//print("i $i ");			

			$key = key($a);
			
			//print("k : $key ");
			
			$value =& $a[$key];
			$continent = $GLOBALS['countryList'][substr($value['img'], 0, strpos($value['img'], '.'))][0];

			$value['continent'] = $continent;	
			
			if($continent == 'unk')
			{
				$continentLang = $GLOBALS['lang']['domaines']['xx'];
			}
			else
			{
				$continentLang = $GLOBALS['lang'][$continent];
			} 
				
			if(!empty($cont))
			{
				if($continent != $cont)
				{
				//print("conteinnt : $continent != $cont");
					unset($a[$key]);
				}
				else
				{
					next($a);
				}	
			}
			else
			{
				$sum[$continentLang] += $value['sum'];		
				next($a);
			}
		}
		
		if(!empty($cont))
		{
			$this->sizeDetailsSaved['continentcountries'] = sizeof($a);
			$toReturn = getArrayOffsetLimit($a, $offset, $nbElementsToDisplay);
			

			return $toReturn;
		}
		
		$this->sizeDetailsSaved['continentcountries'] = sizeof($sum);
		arsort($sum);
		$toReturn = $this->getContinentId(
						$this->getArraySum($sum)
						);
						
//		printDebug($toReturn);
		return $toReturn;
	}
	
	function getContinentId($a)
	{
		$return = array();
		$continentReversed = @array_flip($GLOBALS['lang']);
		
		foreach($a as $key => $value)
		{
			$value['continent'] = $continentReversed[$value['data']];
			$return[] = $value;
		}
		return $return;
	}
	
	function getFollowUpZoom($category='')
	{
		return $this->getPagesDetailsZoomAll($category, array('entry', 'exit', 'singlepage'));
	}
	
	function getPagesZoom($category='')
	{
		return $this->getPagesDetailsZoomAll($category, array('sum', 'sumtime'));
	}
	
	function getPagesDetailsZoomSorted($category, $idToUseForPagesInfoToCompute)
	{
		return $this->getPagesDetailsZoomAll($category, array($idToUseForPagesInfoToCompute));
	}
	
	function getPageGroupIdToName($return)
	{
		$type = array(
			'page',
			'category',
			'file'
			);
		foreach($return as $data)
		{
			$toLoad[$data['type']][] = $data['data'];
		}

		foreach($type as $name)
		{
			if(isset($toLoad[$name]))
			{
				 $this->objects[$name]->loadName($toLoad[$name]);
			}
		}
		
		$s = sizeof($return);
		reset($return);
		for($i = 0; $i < $s ; $i ++)
		{
			
			$data =& $return[key($return)];
			
			if($data['type'] == 'page' || $data['type'] == 'category' || $data['type'] == 'file')  
			$data['data'] = $this->objects[$data['type']]->getName($data['data']);
			
			//print($data['data']." ");
			next($return);
		}
		
		return $return;
	}
	
	function getPagesDetailsZoomAll($category, $a_infoAsked = array())
	{
		printTime('begin zoom all');
		$info = $this->getPagesDetailsZoom($category);
		
		if($info)
		{
			printTime('end of pages details2');
			
			if(in_array('sumtime', $a_infoAsked))
			{
				$sortedEntry = $this->getPageGroupIdToName(
						getArrayOffsetLimit($info[1], 0, -1, 'a_sumtime_sort', 'sum', $this->arraySumInfo)
						);
						
				$return['sumtime'] = array(
												$info[0],
												$sortedEntry,
												$info[2]
												);
			}
			printTime('after sumtime compute');
			if(in_array('singlepage', $a_infoAsked))
			{
				$toto = getArrayOffsetLimit($info[1], 0, -1, 'a_singlepage_sort', 'singlepage', $this->arraySumInfo);
	
				$sortedEntry = $this->getPageGroupIdToName($toto
						
						);
						
				$return['singlepage'] = array(
												$info[0],
												$sortedEntry,
												$info[2]
												);
												
	//											printdebug($info[1]);
			}
			printTime('after singlepage compute');
			if(in_array('entry', $a_infoAsked))
			{
				$sortedEntry = $this->getPageGroupIdToName(
						getArrayOffsetLimit($info[1], 0, -1, 'a_entry_sort', 'entry', $this->arraySumInfo)
						);
						
				$return['entry'] = array(
												$info[0],
												$sortedEntry,
												$info[2]
												);
			}
			printTime('after entry compute');
			if(in_array('exit', $a_infoAsked))
			{
				//printDebug($sortedEntry);exit;
				$sortedExit = $this->getPageGroupIdToName(
						getArrayOffsetLimit($info[1], 0, -1, 'a_exit_sort', 'exit', $this->arraySumInfo)
						);
				$return['exit'] = array(
												$info[0],
												$sortedExit,
												$info[2]
												);
			}
			printTime('after exit compute');
			if(in_array('sum', $a_infoAsked))
			{
				$toto = getArrayOffsetLimit($info[1], 0, -1, 'a_pag_sort', 'sum', $this->arraySumInfo);
				$sortedHits = $this->getPageGroupIdToName( $toto);
				$return['sum'] = array(
												$info[0],
												$sortedHits,
												$info[2]
												);
			}
			
			printTime('end zoom all');
			return $return;
		}
	}
	
	function getPagesDetailsZoom($categoryAsked = '')
	{		
	
		$this->objects['category'] = new ArchiveTable('category');
		$this->objects['page'] = new ArchiveTable('page');
		
//		printDebug($all); exit;
		
		if($this->archive->periodType === DB_ARCHIVES_PERIOD_DAY)
		{
			$nbLast = 15;
		}
		else
		{
			$nbLast = 3;
		}
		$archives = $this->getLastArchives($nbLast, 1, 0);		
	
		printTime('beg 1 of pages details');
		$i=0;
		foreach($archives as $dateToDisplay => $archive)
		{
			printTime('foreach'.++$i.' of pages details');
			$o_data = new DataModel( $archive , $this->request);
			$displayInfo[] = $dateToDisplay;
			
			printTime('before uz'.$i.' of pages details');
			
			if( STORE_PAG_ARRAY_IN_FILE )
			{
				$file = INCLUDE_PATH . "/datas/archives/". $o_data->infoSerialized['idarchives'].".dat";
				if( !is_readable($file))
				{
					saveConfigFile($file, unserialize($o_data->infoSerialized['vis_pag_grp']) , 'visPagGrp');
				}
				
				if(is_readable($file))
				{
					require_once $file;
					$array = $visPagGrp;
				}
			}
			else
			{
				$visPagGrp = unserialize($o_data->infoSerialized['vis_pag_grp']);
			} 
			
			$a_all[] = $visPagGrp; 
			
			printTime('after uz'.$i.' of pages details');
			$headerInfo[] = array(
			'nb_pag' => $o_data->getContent('nb_pag'),
			'nb_uniq_pag' => $o_data->getContent('nb_uniq_pag'),
			'nb_max_pag' => $o_data->getContent('nb_max_pag')
			);
			//printDebug($headerInfo);
		}

		printTime('beg 2 of pages details');
		foreach($a_all as $j => $all)
		{
			if(empty($categoryAsked))
			{
				$a_infosDay[$j] = $all;
				$level = 0;
			}
			else
			{
				$categoryAsked = (string)$categoryAsked;
				//print("Zoom cate '$categoryAsked' <br>");
				//print($categoryAsked[2]);
				$detailsCategory = explode(">", $categoryAsked);
				//printDebug($detailsCategory);
				$level = sizeof($detailsCategory);
				
				//print("level : $level <br>");
				$array = $all;
				
				for($i = 0; $i < $level ; $i++)
				{
					$arrayZoomed = array();
					// find category to detail
					if(is_array($array))
					{
						foreach($array as $id => $info)
						{
							if($id == $detailsCategory[$i])
							{
								$arrayZoomed = $info;
								break;
							}
						}
						$array = $arrayZoomed;
					}
				}
				
				//print("id $j");
				$a_infosDay[$j] = $array;
			}
		}
		printTime('mid of pages details');
		//printDebug($category);
		// list asked category
		if($level != 0) $categoryAsked .= '>';
		
		$return = array();
		if(is_array($a_infosDay[0]))
		{
			foreach($a_infosDay[0] as $currentId => $info)
			{
				if($currentId != 'p_pmv_sum' 
				&& $currentId != 'f_pmv_sum'
				)
				{
					$id = '';
					$parentId = '';
					$data ='';
					$sum = 0;
					$sumN1 = 0;
					$sumN2 = 0;
					$percentN1 = 0;
					$percentN2 = 0;
					$type = '';
					$entry = 0;
					$sumtime = 0;
					$exit = 0;
					$singlepage = 0;
					
					if(substr($currentId, 0, 1) === 'c')
					{
						$type = 'category';
						
						$entry = $info['p_pmv_sum'][ARRAY_INDEX_ENTRYPAGE];
						$exit = $info['p_pmv_sum'][ARRAY_INDEX_EXITPAGE];
						$sum = $info['p_pmv_sum'][ARRAY_INDEX_COUNT];
						$sumtime = $info['p_pmv_sum'][ARRAY_INDEX_TIME_TOTAL];
						$singlepage = $info['p_pmv_sum'][ARRAY_INDEX_PAGES_VISIT_ONEPAGE];
						
						if(isset($a_infosDay[1][$currentId]['p_pmv_sum'][ARRAY_INDEX_COUNT]))
						{
						
						//print(" data !");
						$sumN1 = $a_infosDay[1][$currentId]['p_pmv_sum'][ARRAY_INDEX_COUNT];
						
						}
						
						$percentN1 = $this->getDiffPercent($sum, $sumN1);
						
						if(isset($a_infosDay[2][$currentId]['p_pmv_sum'][ARRAY_INDEX_COUNT]))
						$sumN2 = $a_infosDay[2][$currentId]['p_pmv_sum'][ARRAY_INDEX_COUNT];
						
						$percentN2 = $this->getDiffPercent($sum, $sumN2);
						
						$id = $categoryAsked . $currentId;
						if($level != 0) $parentId = substr(
									$categoryAsked,
									 0,
									  strlen($categoryAsked) -1 
									  );
						else $parentId = "root";
						$data = $info[ARRAY_INDEX_IDCATEGORY];
						
						if($data != -1)
							$toLoad['category'][] = $data;
	
					}
					else if(substr($currentId, 0, 1) === 'p')
					{
						$type = 'page';
						//printDebug($info);
						if(!isset($info[ARRAY_INDEX_COUNT]))
						{
							// TODO: voir ce bug de merde d'ou vient il ???
							$info[ARRAY_INDEX_COUNT] = 0;
						}
						$sum = @$info[ARRAY_INDEX_COUNT];
						$entry = @$info[ARRAY_INDEX_ENTRYPAGE];
						$exit = @$info[ARRAY_INDEX_EXITPAGE];
						$sumtime = @$info[ARRAY_INDEX_TIME_TOTAL];
						$singlepage = @$info[ARRAY_INDEX_PAGES_VISIT_ONEPAGE];
						
						if(isset($a_infosDay[1][$currentId][ARRAY_INDEX_COUNT]))
						$sumN1 = $a_infosDay[1][$currentId][ARRAY_INDEX_COUNT];
						
						$percentN1 = $this->getDiffPercent($sum, $sumN1);
						
						if(isset($a_infosDay[2][$currentId][ARRAY_INDEX_COUNT]))
						$sumN2 = $a_infosDay[2][$currentId][ARRAY_INDEX_COUNT];
						
						$percentN2 = $this->getDiffPercent($sum, $sumN2);
						
						$data = $info[ARRAY_INDEX_IDPAGE];
						
						$toLoad['page'][] = $data;
		
						//print("toto");
						//printDebug($info);
						
					}
					else
					{
						// file
					}
					
					
					if(!empty($data)
					&& !empty($type)
					&& $sum > 0
					)
					{
						$return[] = array(
							'type' => $type,
							'sum' => $sum,
							'sumn1' => $sumN1,
							'sumn2' => $sumN2,
							'percentn1' => $percentN1,
							'percentn2' => $percentN2,
							'data' => $data,
							'id' => $id,
							'parentid' => $parentId,
							'entry' => $entry,
							'exit' => $exit,
							'sumtime' => $sumtime,
							'avgtime' => round($sumtime / $sum),
							'exitrate' => 100 *  $exit / $sum,
							'singlepage' => $singlepage,
							);
					}
				}
			}
			printTime('end of pages details');
			$GLOBALS['sorting_index'] = 'sum';
	
			uasort($return, "sortingDataInfo");
			
			return array(
				$displayInfo,
				$return,
				$headerInfo
				);
		}
		
		return false;
		
	}
	
	function getSourceContinentInterest()
	{
		return $this->getContent('int_continent');			
	}

	function getSourceCountriesDistinct()
	{
		return $this->getDistinct('country');
	}
	
	function getSourceProvidersDistinct()
	{
		return $this->getDistinct('provider');
	}
	
	function getSourceCountries($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getCountriesImg(
					$this->getArraySum(
						$this->getContent('vis_country', $offset, $nbElementsToDisplay)
			)
		);		
	}
	function getCountriesImg($a)
	{
		$return = array();
		
		if(is_array($a))
		{
			foreach($a as $id => $value)
			{
				$value['img'] = $value['data'] . ".png";
				
				// flags not in the package !
				if(!file_exists(DIR_IMG_COUNTRIES_FLAGS . "/". $value['img']))
					$value['img'] = 'xx.png';
				
					$value['data'] = $GLOBALS['lang']['domaines'][$value['data']];
				$return[$id] = $value;
			}
		}
		return $return;
	}
	
	function getSourceCountriesInterest($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getCountriesImg(
					$this->getContent('int_country', $offset, $nbElementsToDisplay)
					);
	}
	
	function getSourceProviders($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getProvidersNameAndUrl(
					$this->getArraySum(
						$this->getArrayIdToName(
							$this->getContent('vis_provider', $offset, $nbElementsToDisplay), 
							'provider'
							)
						)
				);
	}
	
	
	/**
	 * Settings
	 */
	
	function getSettingsConfig($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		$return = $this->getArraySum(
					$this->getArrayIdToName($this->getContent('vis_config', $offset, $nbElementsToDisplay), 'config')
					);		
		foreach($return as $key => $value)
		{
			$value['data'] = $this->getConfigName($value['data']);
			$return[$key] = $value;
		}
		return $return;
	}
	
	/*
	function getSettingsConfigInterest($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		$a = $this->getArrayIdToName($this->getContent('int_config', $offset, $nbElementsToDisplay), 'config');
		foreach($a as $key => $value)
		{
			$return[$this->getConfigName($key)] = $value;
		}
		return $this->getArrayInterestNamed($return);
	}
	*/
	function getSettingsOsDistinct()
	{
		return $this->getDistinct('os');
	}
	
	function getSettingsOs($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getOsNameAndImage(
					$this->getArraySum($this->getContent('vis_os', $offset, $nbElementsToDisplay)
					)
				);
	}
	
	
	function getSettingsOsInterest($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getOsNameAndImage(
					$this->getContent('int_os', $offset, $nbElementsToDisplay)
				);
	}
	
	function getSettingsBrowsersDistinct()
	{
		return $this->getDistinct('browser');
	}
	
	function getSettingsBrowsers($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getBrowsersNameAndImage(
					$this->getArraySum($this->getContent('vis_browser', $offset, $nbElementsToDisplay)
					)
				);
	}
	
	function getSettingsBrowsersGraph()
	{
		$all = $this->getSettingsBrowsers(0, -1);
		
		foreach($all as $id => $info)
		{
			if($id < 5)
			{
				$data[] = (int)$info['sum'];
				$axis[] = ucfirst($GLOBALS['browsers_graph'][substr($info['img'], 0, strpos($info['img'], '.'))])
										. substr($info['data'], -strlen($info['data']) + strrpos($info['data'], ' '));
			
			}
			else
			{
				@$data[5] += $info['sum'];
				$axis[5] = $GLOBALS['lang']['generique_divers'];
			}
		}
			
		
		return array(
				'data' => $data,
				'axis' => $axis,
				'title' => $GLOBALS['lang']['configurations_navigateurs']
				);
	}
	
	function getSettingsBrowsersInterest($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getBrowsersNameAndImage(
					$this->getContent('int_browser', $offset, $nbElementsToDisplay)
				);
	}
	
	function getSettingsConfigDistinct()
	{
		return $this->getDistinct( 'config' );
	}
	
	function getSettingsBrowsersType()
	{
		$return = $this->getArraySum($this->getContent('vis_browser_type'));
		

		foreach($return as $key => $value)
		{
			$value['data'] = $GLOBALS['browsers_type_display'][$value['data']];
			$return[$key] = $value;
		}
		return $return;
	}
	
	//TODO -1 = all
	function getSettingsResolutions($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getArraySum(
					$this->getArrayIdToName(
						$this->getContent('vis_resolution', $offset, $nbElementsToDisplay), 'resolution')
						);
	}
	
	function getSettingsResolutionsDistinct()
	{
		return $this->getDistinct( 'resolution' );
	}
	
	function getSettingsResolutionsInterest($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getArrayIdToName(
						$this->getContent('int_resolution', $offset, $nbElementsToDisplay)
						,'resolution'
		);
	}
	
	function getSettingsNormalWidescreen()
	{
		$return = array();
		$normal = $wide = $dual = 0;
		$a = $this->getSettingsResolutions(0, -1);
		foreach($a as $value)
		{
			$str = $value['data'];
			$operande = intval(substr($str, 0, strpos($str, 'x')));
			$terme    = intval(substr($str, strpos($str, 'x') + 1));
			$ratio = $this->_secureDiv($operande, $terme);
			
			if($ratio < 1.4)
			{
				$normal += $value['sum'];
			}
			else if($ratio < 2)
			{
				$wide += $value['sum'];
			}
			else
			{
				$dual += $value['sum'];
			}
		}
		
		if($dual!=0) $return['dual'] = $dual;
		if($wide!=0) $return['wide'] = $wide;
		if($normal!=0) $return['normal'] = $normal;

		arsort($return);
		return $this->getScreensNameAndImage(
					$this->getArraySum($return)
				);
	}
	
	function getSettingsNormalWidescreenDistinct()
	{
		return 3;
	}
	
	function getSettingsColorDepthDistinct()
	{
		return $this->getDistinct( 'depth' );
	}
	
	
	function getSettingsColorDepth()
	{
		$return = $this->getArraySum($this->getContent('vis_depth'));
		foreach($return as $key => $value)
		{
			$value['data'] = $this->getColorDepthName($value['data']);
			$return[$key] = $value;
		}
		return $return;
	}
	
	
	function getSettingsColorDepthInterest()
	{
		$a = $this->getContent('int_depth');
		
		$return = array();
		foreach($a as $key => $value)
		{
			$value['data'] = $this->getColorDepthName($key);
			$return[$key] = $value;
		}
		return $return;
	}
	
	function getSettingsPlugins()
	{
		return $this->getPluginsNameAndImg(
					$this->getArraySum(
						$this->getContent('vis_plugin')
					)
				);		
	}
	
	
	function getSettingsPluginsDistinct()
	{
		return $this->getDistinct( 'plugin' );
	}
	
	/**
	 * Referers
	 */
	/*
	function getReferersGraphSummary()
	{
	}*/
	
	function getDistinct($name, $name2 = null)
	{
		if(isset($name2))
		{
			switch($name)
			{
				case 'continent':
					$t = sizeof($this->getSourceContinentCountries( $name2, 0, -1));
				break;
			}			
			
		}
		else
		{
			$t = sizeof($this->getContent('vis_'.$name));
		}
		return $t;
	}
	
	
	/*
	 * numbers
	 */
	function getReferersSearchEnginesDetailsDistinct(  )
	{
		return $this->sizeDetailsSaved['vis_search_engine'];
	}
	
	function getReferersPartnersDetailsDistinct(  )
	{
		return $this->sizeDetailsSaved['vis_partner'];
	}
	function getReferersKeywordsDetailsDistinct(  )
	{
		return $this->sizeDetailsSaved['vis_keyword'];
	}
	function getReferersSitesDetailsDistinct(  )
	{
		return $this->sizeDetailsSaved['vis_site'];
	}
	function getReferersKeywordsDistinct( )
	{
		return $this->getDistinct( 'keyword');
	}
	function getReferersNewslettersDistinct()
	{
		return $this->getDistinct( 'newsletter');
	}
	function getSettingsBrowsersTypeDistinct()
	{
		return 4;
	}
	function getReferersSearchEnginesDistinct( )
	{
		return $this->getDistinct( 'search_engine');
	}
	function getReferersPartnersDistinct()
	{
		return $this->getDistinct( 'partner');
	}
	function getReferersSitesDistinct( )
	{
		return $this->getDistinct( 'site');
	}
	
	function getReferersNbSearchEngines()
	{
		return $this->getContent('nb_search_engine');
	}
	function getReferersNbSites()
	{
		return $this->getContent('nb_site');
	}
	function getReferersNbDirect()
	{
		return $this->getContent('nb_direct');
	}
	function getReferersNbPartners()
	{
		return $this->getContent('nb_partner');
	}

	function getReferersNbNewsletters()
	{
		return $this->getContent('nb_newsletter');
	}
	
	function getReferersSummaryGraph()
	{
		
		return array(
				'data' => array(
							$this->getReferersNbSearchEngines(),
							$this->getReferersNbSites(),
							$this->getReferersNbNewsletters(),
							$this->getReferersNbPartners(),
							$this->getReferersNbDirect(),
						),
				'axis' => array(
								$GLOBALS['lang']['affluents_moteursimg'],
								$GLOBALS['lang']['affluents_sitesimg'],
								$GLOBALS['lang']['affluents_newslettersimg'],
								$GLOBALS['lang']['affluents_partenairesimg'],
								$GLOBALS['lang']['affluents_directimg'],
								),
				'title' => $GLOBALS['lang']['affluents_referrersimg']
				);
	}
	/*
	 * arrays
	 */
	function getReferersSearchEngines($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getSearchEnginesUrlAndImg(
					$this->getArrayPmvSum(
						$this->getArrayIdToName(
							$this->getContent('vis_search_engine', $offset, $nbElementsToDisplay)
							, 'search_engine'),
						$this->getReferersNbSearchEngines()
						)
				//	)
					)
				;		
	}
	
	function getReferersSearchEnginesInterest($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getSearchEnginesUrlAndImg(
						$this->getArrayIdToName(
							$this->getContent('int_search_engine', 
											$offset, 
											$nbElementsToDisplay), 
										'search_engine')
			);
	}
	
	
	function getReferersSearchEnginesDetails($id, $offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		$this->idDetailsSaved['vis_search_engine'] = $id;
		//printTime('before', true);
		$test =	$this->getContent('vis_search_engine');
		//printTime('after1', true);
		$return = 	$this->getArrayDetail( $test,				$id, 
						'keyword',
						$offset,
						$nbElementsToDisplay
					);	
	//	printTime('after2', true);
		return $return;
	}
	
	function getReferersKeywords($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getKeywordDecode(
					$this->getArrayPmvSum(
						$this->getArrayIdToName(
							$this->getContent('vis_keyword', $offset, $nbElementsToDisplay), 
							'keyword'),
						$this->getReferersNbSearchEngines()
						)
					);
	}
	
	function getReferersKeywordsInterest($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getKeywordDecode(
						$this->getArrayIdToName(
							$this->getContent('int_keyword', $offset, $nbElementsToDisplay), 'keyword')
				);
	}
	
	function getReferersKeywordsDetails($id, $offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		
		$this->idDetailsSaved['vis_keyword'] = $id;
		return $this->getSearchEnginesUrlAndImg(
					$this->getArrayDetail(
						$this->getContent('vis_keyword'), 
						$id, 
						'search_engine',
						$offset,
						$nbElementsToDisplay
					)
				);
	}
	
	function getReferersSites($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getArrayPmvSum(
					$this->getArrayIdToName(
						$this->getContent('vis_site', $offset, $nbElementsToDisplay), 
						'site'),
					$this->getReferersNbSites()
				);
	}

	function getReferersSitesInterest($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return	$this->getArrayIdToName(
						$this->getContent('int_site', $offset, $nbElementsToDisplay), 'site');
	}
	
	function getReferersSitesDetails($id, $offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		$this->idDetailsSaved['vis_site'] = $id;
		return $this->getSitesDetailsUrl(
					$this->getArrayDetail(
						$this->getContent('vis_site'), 
						$id, 
						'site',
						$offset,
						$nbElementsToDisplay
						)	
				);
	}
	function getSitesDetailsUrl( &$a )
	{
		foreach($a as $key => $value)
		{
			$value['url'] = $value['data'];
			$a[$key] = $value;
		}
		return $a;
	}
	
	
	function getReferersPartners($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getArrayPmvSum(
					$this->getArrayIdToName($this->getContent('vis_partner', $offset, $nbElementsToDisplay), 
					'partner_name'),
					$this->getReferersNbPartners()
				);		
	}
	function getReferersPartnersInterest($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return 	$this->getArrayIdToName(
					$this->getContent('int_partner', $offset, $nbElementsToDisplay), 
					'partner_name');
	}	
	function getReferersPartnersDetails($id, $offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		
		$this->idDetailsSaved['vis_partner'] = $id;
		return $this->getSitesDetailsUrl(
					$this->getArrayDetail(
						$this->getContent('vis_partner'), 
						$id, 
						'partner_url',
						$offset,
						$nbElementsToDisplay
					)
				);
	}
	
	
	// TODO voir si newsletter arrayPmv ou array
	
	function getReferersNewsletters($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return $this->getArraySum(
					$this->getArrayIdToName(
						$this->getContent('vis_newsletter', $offset, $nbElementsToDisplay),
										  'newsletter'),
						$this->getReferersNbNewsletters()
		);		
	}
	
	
	function getReferersNewslettersInterest($offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		return 	$this->getArrayIdToName(
							$this->getContent('int_newsletter', $offset, $nbElementsToDisplay), 'newsletter');
	}	
	
	function getReferersTypeInterest()
	{
		$a = $this->getContent('int_referer_type');
		$convert = array(
				REF_TYPE_SEARCH_ENGINE => 'search_engine',
				REF_TYPE_SITE =>'site',
				REF_TYPE_PARTNER =>'partner',
				REF_TYPE_NEWSLETTER =>'newsletter',
				REF_TYPE_DIRECT_ENTRY =>'direct_entry'
		);
		foreach($a as $key => $value)
		{
			if(sizeof($value) != 0)
			{
				$return2[$convert[$key]] = $value; 
			}
		}
		
		return $return2;
	}

	function addPercent( $nb, $total)
	{
	    $calc = 100 * $this->_secureDiv($nb, $total);
		return "<strong> $nb </strong> <small>(". round($calc) . "%)</small>";
	}
	
	function getReferersNumbers()
	{
	    $ret = array();
	    
		if($this->getContent('nb_vis') != 0)
		{
			$a = array(
					'visits'           => $this->getContent('nb_vis'),
					'searchengines'    => $this->getReferersNbSearchEngines(),
					'keywords'         => $this->getReferersKeywordsDistinct(),
					'sites'            => $this->getReferersNbSites(),
					'distinctsites'    => $this->getReferersSitesDistinct(),
					'partners'         => $this->getReferersNbPartners(),
					'newsletters'      => $this->getReferersNbNewsletters(),
					'direct'           => $this->getReferersNbDirect(),

					);
					
			foreach($a as $key => $value)
			{
				if($key != 'distinctsites' && $key != 'keywords')
				{
					$a2[$key] = $this->addPercent( $value, $this->getContent('nb_vis'));
				}
			}
			
			$ret =  array_merge($a, $a2);
		}
		return $ret;
	}
	/*
	 * Process functions
	 */
	function getArrayDetail(&$a, $id, $table, $offset = 0, $nbElementsToDisplay = NB_ELEMENTS_TO_DISPLAY)
	{
		$return = array();
		foreach($a as $key => $value)
		{
			if($key == $id)
			{
//				printTime('1', true);
				$sum = $value['pmv_sum'];
				unset($value['pmv_sum']);
				$a2 = $this->getArrayIdToName(
							getArrayOffsetLimit($value, $offset, $nbElementsToDisplay), 
					$table
					);
			//	printDebug($a2);
	
	//			printTime('2', true);
				foreach($a2 as $name => $hits)
				{
					if($table === 'keyword')
					{
						$name = urldecode($name);
					}
					$return[] = array(
						'data' => $name,
						'sum' => $hits,
						'percent' => 100 * $this->_secureDiv($hits, $sum)
						);
				}
		//		printTime('3', true);
				break;
			}
		}
//		printTime('4', true);
		//printDebug($return);
		usort($return, "sortingDataInfo");
//		printTime('5', true);
		return $return;
	}
	function getArrayIdToName($a, $table)
	{
		$return = array();
		if(sizeof($a) != 0)
		{
			if(!isset($this->objects[$table]))
			{
				$this->objects[$table] = new ArchiveTable($table);
			}
			$this->objects[$table]->loadName(array_keys($a));
			
			foreach($a as $id => $value)
			{
				// case when all table with details for each key
				if(is_array($value))
				{
					$value['id'] = $id;
				}
				// else we only have hits number, don't do anything
				$name = $this->objects[$table]->getName($id);
				
				//printDebug("id ".$id);
				//printDebug("name ".$name);
				//printDebug("value ".$value);
				
				// héhé... :-D
				if(is_array($value))
				{
					$value['data'] = $name;
				}
				$return[$name] = $value;
			}
		}
		return $return;
	}
	
	function getArraySum($a, $max = 0)
	{
		if($max === 0) 
		{
			$max = $this->getContent('nb_vis');
		}
		
		$return = array();
		
		if($max == 0) return $return;
		
		foreach($a as $key => $value)
		{
			if($value != 0)
			{
				$return[] = array(
				'sum' =>$value,
				'percent' => 100 * $this->_secureDiv($value, $max),
				'data' => $key
				);
			}
		}
		
		return $return;
	}
	
	function getArrayPmvSum($a, $max = 0)
	{
		if($max === 0) 
		{
			$max = $this->getContent('nb_vis');
		}
		$return = array();
		foreach($a as $key => $value)
		{
			$return[] = array(
			'sum' =>$value['pmv_sum'],
			'percent' => 100 * $this->_secureDiv($value['pmv_sum'] , $max),
			'data' => $key,
			'id' => $value['id']
			);
		}
//		print("sort here<br>");
				
		$GLOBALS['sorting_index'] = 'sum';
		$GLOBALS['sorting_order'] = 'desc';
		usort($return, "sortingDataInfo");
		
		return $return;
	}
	
	
	function getInterestValues($s, $sumpage, $onepage, $sumtime, $data)
	{
		// pages per visit
		$pv = $this->_secureDiv($sumpage ,$s); 
		
		// pages per significativ visit 
		if($s != $onepage)
		{
			$psv = $this->_secureDiv(($sumpage - $onepage) , ($s - $onepage));
		}
		else
		{
			$psv = 0;
		}
		// 1 page visit rate
		$opr =  $this->_secureDiv($onepage ,$s);
		// time spent per visit
		$vl = round( $this->_secureDiv($sumtime , $s ));
		/*
		printDebug("<br>hits $s<br>");
		printDebug("pages per visit $pv<br>" );
		printDebug("pages per significativ visit $psv<br>" );
		printDebug("1 page visit rate $opr<br>" );
		printDebug("time spent per visit $vl<br>" );	
		*/
		return array( 
						'sum' => $s,
						'page_per_visit' => $pv, 
						'page_per_visit_significant' => $psv, 
						'one_page_rate' => $opr * 100, 
						'time_per_visit' => strftime("%H:%M:%S", $vl+82800),
						'data' => $data
		);	
	}
	
	function getArrayInterestNamed($a)
	{
//		printDebug($a);exit;
		$return = array();
		
		if(is_array($a))
		{
			foreach($a as $key => $value)
			{
				$return[$key] = $this->getInterestValues(
										$value[0],
										$value[1], 
										$value[2], 
										$value[3],
										$key
								);
			}
		}		
		return $return;
	}
	
	function getKeywordDecode($return)
	{
		$return2 = array();
		foreach($return as $value)
		{
			$value['data'] = urldecode($value['data']);
			$return2[] = $value;
		}
		return $return2;
	}	
	
	function getBrowserName($str)
	{
		return ucfirst(
						$GLOBALS['browsers_reverse'][
												substr($str, 0, strpos($str, ';'))
													]); 
	}
	
	function getBrowserVersion($str)
	{
		return substr($str, strpos($str, ';') + 1);
	}
	
	function getConfigName($str)
	{
		$os = substr($str, 0, strpos($str, ';'));
		
		$browser = substr(substr($str, strlen($os)+1), 0, 
		strrpos(substr($str, strlen($os)+1), ';'));
		
		$resolution = substr($str, strrpos($str, ';') + 1);
		$str = $GLOBALS['osIdToName'][$os];
		$str .= " / ";
		$str .= ucfirst($GLOBALS['browsers_reverse'][$browser]);
		$str .= " / "; 
		$str .= $resolution;
		return $str;
	}
	
	function getColorDepthName($str)
	{
		return $str . " bits";
	}
	
	function getProvidersNameAndUrl($return)
	{	
		foreach($return as $key => $value)
		{
			if($value['data'] === 'Ip')
			{
				$value['url'] = "http://www.phpmyvisites.net/";
				$value['data'] = "Ip";
			}
			else
			{
				$value['url'] = "http://www.".$value['data']."/";
				$value['data'] = ucfirst(substr($value['data'], 0, strpos($value['data'], '.')));
			}
			$return[$key] = $value;
		}
		return $return;
	}
	

	function getPluginsNameAndImg($return)
	{
		foreach($return as $key => $value)
		{
			$value['img'] = substr($value['data'], 0, 3) . ".png";
			$value['data'] = ucfirst($value['data']);
			$return[$key] = $value;
		}
		return $return;
	}
	function getOsNameAndImage($return)
	{	
		foreach($return as $key => $value)
		{
			$value['img'] = $value['data'] . ".png";
			$value['data'] = $GLOBALS['osIdToName'][$value['data']];
			$return[$key] = $value;
		}
		return $return;
	}

	function getSearchEnginesUrlAndImg($return)
	{
		foreach($GLOBALS['searchEngines'] as $url => $value)
		{
			$searchEnginesReversed[$value[0]] = $url;
		}
		
		$return2 = array();
		foreach($return as $value)
		{
			$value['url'] = $searchEnginesReversed[$value['data']];
			
			$img = $value['url'];
			$imgUrlP = DIR_IMG_SEARCH_ENGINES . "/" .  $img  . ".png";
			
			$value['img'] = is_file( $imgUrlP ) 
							? $img . ".png"
							: 'xx.gif';

			$value['url'] = 'http://' . $value['url'];				
							
			$return2[] = $value;
		}
		return $return2;
	}

	function getBrowsersNameAndImage($return)
	{		
		foreach($return as $key => $value)
		{
			$prefix = substr($value['data'], 0, strpos($value['data'], ';'));
			if($prefix != 'unk')
			{
				$value['img'] = $prefix. ".png";
			}
			else
			{
				$value['img'] = 'unk.gif';
			}
			$value['data'] = $this->getBrowserName($value['data']) ." ".$this->getBrowserVersion($value['data']);
			$return[$key] = $value;
		}
		return $return;
	}
	
	function getScreensNameAndImage($return)
	{		
		foreach($return as $key => $value)
		{
			$value['img'] = $value['data'] . ".png";
			switch($value['data'])
			{
				case 'dual':
					$txt = $GLOBALS['lang']['configurations_double'];
				break;
				case 'wide':
					$txt = $GLOBALS['lang']['configurations_large'];
				break;
				case 'normal':
					$txt = $GLOBALS['lang']['configurations_normal'];
				break;
			}
			$value['data'] = $txt;
			$return[$key] = $value;
		}
		return $return;
	}
	// nb1 = base
	// nb2 / nb1 ?
	function getDiffPercent($nb1, $nb2)
	{
		if($nb2 == 0)
		{
			return "+ 1000%";
		}
		if($nb2 <= $nb1)
		{
			$percent = ($nb1/$nb2) * 100 - 100;
			$percent>PERCENT_MAX?$percent=PERCENT_MAX:'';
			
			$str = "+";
		}
		else
		{
			$percent = (( $nb2 - $nb1) / $nb2) * 100;
			$percent>PERCENT_MAX?$percent=PERCENT_MAX:'';
			
			$str = "-";
		}
		return $str . " " .round($percent)."%";
	}

	function getLastArchives($n, $boolOnlyGetPeriodNMinus=0, $forGraph = false, $o_site = false)
	{
		$date = $this->archive->date;
		
		if($o_site)
		{
			$o_siteToUse = $o_site;
		}
		else
		{
			$o_siteToUse = $this->archive->site;
		}
		
		$toArchive = array();
		switch($this->archive->periodType)
		{
			case DB_ARCHIVES_PERIOD_DAY:
				$ts = $date->getTimestamp() + 86400;
				while(sizeof($toArchive) < $n)
				{
					$toArchive[] = getDateFromTimestamp( $ts -= 86400);
				}
				$typeDateDisplay = 2;
				$typeDateDisplayGraph = 8;
				
				// only take N - x, only for page views comparisons
				if($boolOnlyGetPeriodNMinus===1)
				{
					$date0 = $toArchive[0];
					$date1 = $toArchive[7];
					$date2 = $toArchive[14];
					unset($toArchive);
					$toArchive[] = $date0;
					$toArchive[] = $date1;
					$toArchive[] = $date2;
					$typeDateDisplay = 7;
					//print("date1 $date1 date2 $date2 ");
				}
			break;
				
			case DB_ARCHIVES_PERIOD_WEEK:
				$ts = $date->getTimestamp();
				$ts += 86400*7;
				while(sizeof($toArchive) < $n)
				{
					$toArchive[] = getDateFromTimestamp( $ts-=86400*7);
				}
				$typeDateDisplay = 6;
				$typeDateDisplayGraph = 6;

			break;
				
			case DB_ARCHIVES_PERIOD_MONTH:
				$s_date1 = getDateFromTimestamp(
				mktime(23, 59, 59, 
				$date->getMonth() - $n % 12, 
				15, 
				$date->getYear() - floor($n/12))
				);
				$s_date2 = $date->get();
				
				$toArchive = array_reverse(getDayOfMonthBetween($s_date1, $s_date2));
				$typeDateDisplay = 5;
				$typeDateDisplayGraph = 10;
				
			break;
				
			case DB_ARCHIVES_PERIOD_YEAR:
				for($i = 0; $i < $n; $i++)
				{
					$a = $date->getYear()-$i;
					$toArchive[] = $a."-01-01";
				}
				
				$typeDateDisplay = 11;
				$typeDateDisplayGraph = 12;
			break;
		}
		
		
		$return = array();
		foreach($toArchive as $dateToArchive)
		{
			// if day, and IF current date asked is today, then take current archive
			if(
				   $dateToArchive == $this->archive->date->get() 
				&& $this->archive->periodType === DB_ARCHIVES_PERIOD_DAY
				&& $o_siteToUse->getId() === $this->archive->site->getId()
			)
			{
				$a =& $this->archive;
			}
			else
			{
				$a = $this->getArchive(	$o_siteToUse,
										$dateToArchive, 
										$this->archive->periodType
										);
			}
			
			if($forGraph)
			{
				$dateToDisplay = getDateDisplay($typeDateDisplayGraph, new Date($dateToArchive));
				$dateComputed  = getDateDisplay($typeDateDisplayGraph, $a->date);
			}
			else
			{
				$dateToDisplay = getDateDisplay($typeDateDisplay, new Date($dateToArchive));
				$dateComputed  = getDateDisplay($typeDateDisplay, $a->date);
			}
			
			if($this->archive->periodType === DB_ARCHIVES_PERIOD_WEEK)
			{
				$dateToDisplay = getDateDisplay($typeDateDisplay, new Date(getFirstDayOfWeek(new Date($dateToArchive))));
			}
			
			if($dateComputed == $dateToDisplay 
			//|| $dateComputed ==  getDateDisplay($typeDateDisplay, new Date($this->archive->site->getMinDay('string')))
			)
			{
				//print("$dateToDisplay is correctly computed ($dateComputed)<br>");
				$return[$dateComputed] = $a;
			}
			else
			{
				$return[$dateToDisplay] = 
					$this->getEmptyArchive(	$o_siteToUse,
											$dateToArchive, 
											$this->archive->periodType
											);
			}
		}
		return $return;
	}
	
	function getVisitsSummaryRss()
	{
		
		
		return array(
			'site' => '');
	}
	
	function getArchive($site, $s_date, $type)
	{
		switch($type)
		{
			case DB_ARCHIVES_PERIOD_DAY:
			$p = new ArchiveDay($site, $s_date);
			break;
			
			case DB_ARCHIVES_PERIOD_MONTH:
			$p = new ArchiveMonth($site, $s_date); 
			break;
			
			case DB_ARCHIVES_PERIOD_WEEK:
			$p = new ArchiveWeek($site, $s_date);
			break;
			
			case DB_ARCHIVES_PERIOD_YEAR:
			$p = new ArchiveYear($site, $s_date);
			break;
		}
		return $p;
	}
	
	function getEmptyArchive($site, $s_date, $type)
	{
		return new ArchiveEmpty($site, $s_date, $type);
	}
	
	function _secureDiv($operande, $terme)
	{
	    if ( is_numeric($operande) && is_numeric($terme) && intval($terme) != 0)
		{ 
			return $operande / $terme;
		}   
		return 0;
	}
}
