<?php
/* 
 * phpMyVisites : website statistics and audience measurements
 * Copyright (C) 2002 - 2006
 * http://www.phpmyvisites.net/ 
 * phpMyVisites is free software (license GNU/GPL)
 * Authors : phpMyVisites team
*/

// $Id: Cookie.class.php,v 1.5 2005/10/27 22:12:44 matthieu_ Exp $


/**
 * Class that sets a cookie, read values, saves arrays in cookie, etc.
 */
class Cookie {

	/**
	 * @var string 
	 */
	var $name;
	
	/**
	 * @var array cookie content
	 */
	var $a_content = array();
	
	var $expire;
	
	/**
	 * Constructor
	 * 
	 * @param string $nameCookie
	 */
	function Cookie($nameCookie='pmv_cookie_default')
	{
		$this->expire = 86400*365*10;
		
		$this->name=$nameCookie;
		if($this->isDefined())
		{
			$this->a_content = $this->get();
		}
	}
	
 	function setExpire( $ts )
	{
		$this->expire = $ts;
	}
	/**
	 * returns array contained in the cookie 
	 * 
	 * @return array
	 */
 	function getContent()
 	{
 		return $this->a_content;
 	}
	
	/**
	 * returns true if the cookie already exist, false else
	 * 
	 * @return bool
	 */
 	function isDefined()
 	{
 		return isset($_COOKIE[$this->name]);
 	}
	
	/**
	 * returns the size of the cookie content, in bytes
	 */
	function getSize()
	{
		return strlen($_COOKIE[$this->name]);
	}

	/**
	 * returns the cookie's content array unserialized 
	 * 
	 * @return array 
	 */
	function get()
	{
		return unserialize(base64_decode($_COOKIE[$this->name]));
	}
	
	/**
	 * returns the $varName value from the array in the cookie
	 * 
	 * @param string $varName
	 * 
	 * @return string|false
	 */
	function getVar($varName)
	{
		if(is_array($this->a_content) && isset($this->a_content[$varName]))
		{
			return secureVar($this->a_content[$varName]);
		}
		else
		{
			return false;
		}
	}
	
	/**
	 * assigns a value to a variable in the cookie array
	 * 
	 * @param string $varName variable name
	 * @param all $varValue
	 */
	function setVar($varName, $varValue)
	{
		$this->a_content[$varName] = $varValue;
	}
	
	/**
	 * saves the cookie on visitor computer, called once at the end of the whole process
	 * 
	 * @return bool
	 */
	function save()
	{
		header("P3P: CP='OTI DSP COR NID STP UNI OTPa OUR'");
		setcookie($this->name, base64_encode(serialize($this->a_content)), time()+ $this->expire);
		return true;
	}
	
	function delete()
	{
		header("P3P: CP='OTI DSP COR NID STP UNI OTPa OUR'");
		setcookie($this->name, false);
		return true;
	
	}
	
	/**
	 * Init the phpmv cookie used in logging. Called when no previous phpmv cookie detected.
	 * 
	 * @param string $uniqId Old uniqId if exists
	 * 
	 * @return string uniqId assigned
	 */
	function put($uniqId='')
	{
		printDebug("<br>=>Cookie is init on visitor (idcookie and last_visit_time)<br>");
		if($uniqId=='')
		{
			$uniqId = md5(uniqid(rand()));
		}
		$this->setVar('idcookie', $uniqId);
		$this->setVar('last_visit_time', todayTime());
		return $uniqId;
	}
}
?>