<?php
/* 
 * phpMyVisites : website statistics and audience measurements
 * Copyright (C) 2002 - 2006
 * http://www.phpmyvisites.net/ 
 * phpMyVisites is free software (license GNU/GPL)
 * Authors : phpMyVisites team
*/

// $Id: ArchivePeriod.class.php,v 1.2 2005/10/26 21:35:29 matthieu_ Exp $


/**
 * Used for misc periods, weeks, months, and years
 * Can archive a period using the DAYS of the period, or the MONTHS,
 * depending on the var periodType value
 */
class ArchivePeriod extends Archive
{
	
	var $subPeriodValues = array();
	var $archiveDay;
	
	function ArchivePeriod($site, $s_date, $s_date2, $typePeriod)
	{
		parent::Archive($site);
		$this->setPeriodType($typePeriod);
		$this->date = $this->offsetDate(new Date($s_date));
		$this->date2 = $this->offsetDate(new Date($s_date2));
	}
	
	function setDate($s_date)
	{
		$this->reset();
		$this->getPeriodDatesLimit($s_date);
		
		if($this->date->isPeriodFinished($this->periodType))
		{
			$this->state = DB_ARCHIVES_DONE;
		}
		else
		{
			$this->state = DB_ARCHIVES_TEMP;
		}
		
		
		$this->setLiteralDate();
	}
	
	function reset()
	{
		
		$this->date = null;
		$this->toRecord = null;
		$this->idArchives = null; 
		$this->state = null;
		
		$this->date2 = null;
		$this->subPeriodValues = null;
	}
	
	/**
	 * If period isn't archived, then it assign var state, var archiveSubPeriod,
	 * and each subperiod values in subPeriodValues array 
	 * If period is already archived, true
	 * 
	 * @return bool 
	 */
	function isArchived()
	{
		
		$r = query("SELECT idarchives " .
		" FROM ".T_ARCHIVES.
		" WHERE idsite = ".$this->site->getId().
		" AND date1 = '".$this->date->get()."'".
		" AND date2 = '".$this->date2->get()."'".
		" AND period = ".$this->periodType.
		" AND done <> ".DB_ARCHIVES_FAIL
		);
		
		// not archived
		if(mysql_num_rows($r) == 0)
		{
			// if YEAR, we use Months for processing
			if( $this->periodType ===  DB_ARCHIVES_PERIOD_YEAR)
			{
				$this->archiveSubPeriod = new ArchiveMonth($this->site);
				$a_subPeriod = getDayOfMonthBetween($this->date->get(), $this->date2->get());
			}
			// in the other cases, we use Days for processing
			else
			{
				$this->archiveSubPeriod = new ArchiveDay($this->site);
				$a_subPeriod = getDaysBetween($this->date->get(), $this->date2->get());
				//printDebug($a_subPeriod);
			}
			
			
			foreach($a_subPeriod as $subPeriod)
			{
				// printDebug("<br>avant set date : ".$this->archiveSubPeriod->date->get());
				$this->archiveSubPeriod->setDate($subPeriod);
				//printDebug("<br>apres set date : devrait etre $subPeriod et est ".$this->archiveSubPeriod->date->get());
								
				// if any of the days in period is temp, then the whole period is set to temp
				if($this->archiveSubPeriod->state === DB_ARCHIVES_TEMP)
				{
					$this->state = DB_ARCHIVES_TEMP;
				}
				
				// store in ->subPeriodValues[] days to compute and select * for each day
				$l = $this->archiveSubPeriod->getArchived();
				
				// if subperiod is the day, stocke KEY = DATE
				// else if period, stock KEY = IDARCHIVES
				// needed for computing nb_uniq_vis
				if($this->periodType ===  DB_ARCHIVES_PERIOD_YEAR)
				{
					$key = $l['idarchives'];
				}
				else
				{
					$key = $subPeriod;
				}
				
				$this->subPeriodValues[$key] = $l; 
			}
			//printDebug("OK we have all datas<br>");
			
			//printDebug($this->subPeriodValues);
			return false;
		}
		// if the period date, date2 is known, means ever archived, it's ok
		// because the period is only computed ONCE for each couple (date, date2)
		else
		{
			//printDebug("<u>Period known ! Don't archive</u><br>");
			$l = mysql_fetch_assoc($r);
			
			$this->idArchives = $l['idarchives'];
			return true;
		}
	}
	
	/**
	 * returns 'select *' for current period
	 * 
	 * @return array SELECT * FROM archives [...]
	 */
	function getArchived()
	{
		if(!$this->isArchived())
		{
			$this->compute();
		}
		
		$r = query("SELECT * " .
		" FROM ".T_ARCHIVES.
		" WHERE idarchives = ".$this->idArchives .
		" ORDER BY idarchives DESC" .
		" LIMIT 1"
		);
		return mysql_fetch_assoc($r);
	}

	/**
	 * Computes datas for all subPeriodValues values 
	 * and saves it in a new row in the database table archives
	 * 
	 * @return void
	 */
	function compute()
	{			
		// date in the IN(...) SQL field for unique visitors
		$inIdArchives = '';
		$this->toRecord['vis_pag_grp'] = array();
		
		// init 
		$toInitInt = $this->intValuesToSum;
		$toInitArray = array_merge($this->arrayOneDimToSum, $this->arrayPmvSumToSum, $this->arrayIntToSum);
		foreach($toInitInt as $value)
		{
			$this->toRecord[$value] = 0;
		}
		foreach($toInitArray as $value)
		{
			$this->toRecord[$value] = array();
		}
		
		
		// for each subPeriod, sum all values
		foreach($this->subPeriodValues as $idArchives => $subPeriodValues)
		{			
			//printDebug("Sum1 : <br>");
			foreach($this->intValuesToSum as $name)
			{
				$this->toRecord[$name] += $subPeriodValues[$name];
			}
			
			//printDebug("Sum2 : <br>");
			foreach ($this->arrayOneDimToSum as $name) 
			{
				$this->toRecord[$name] = 
					getArrayOneDimVeryVeryVerySpecialSum($this->toRecord[$name], 
								unserialize($subPeriodValues[$name]), "sum");
			}
			
			//printDebug("Sum3 : <br>");
			foreach($this->arrayPmvSumToSum as $name)
			{
				$this->toRecord[$name] = 
					getArrayOneDimVeryVeryVerySpecialSum($this->toRecord[$name], 
								unserialize($subPeriodValues[$name]), "sumArray");
			}
			
			//printDebug("Sum4 : <br>");
			foreach($this->arrayIntToSum as $name)
			{
				$this->toRecord[$name] = 
					getArrayOneDimVeryVeryVerySpecialSum($this->toRecord[$name], 
								unserialize($subPeriodValues[$name]), "sumArray");
			}
			
			//printDebug("<h1>Sum5  $idArchives: </h1><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>");
			//printDebug("table to add");
			//printDebug(unserialize($subPeriodValues['vis_pag_grp']));
			$this->toRecord['vis_pag_grp'] = getPagGrpArrayMultiDimSum($this->toRecord['vis_pag_grp'],
												unserialize($subPeriodValues['vis_pag_grp']));
			//printDebug("<h1>after add</h1>");
			//printDebug($this->toRecord['vis_pag_grp']);
			// constructs id list ('id1', 'id2', ...)  maybe date list ('date1', 'date2'...
			$inIdArchives .= "'".$idArchives."', ";
		}
		
		//printDebug($this->toRecord['vis_pag_grp']); 
		//exit;
		/*
		 * Sorting arrays
		 */
		
		$this->sortAndLimitToRecord();
		
		$inIdArchives = substr($inIdArchives, 0, strlen($inIdArchives) - 2);
				
		// if year, look for info averaging month archives
		if($this->periodType === DB_ARCHIVES_PERIOD_YEAR)
		{
			$r = query("SELECT sum(nb_uniq_vis) as nb_uniq_vis, max(nb_max_pag) as nb_max_pag
					FROM ".T_ARCHIVES."
					WHERE idarchives IN (".$inIdArchives.")"
					);
					
			
			// returning visitors
			$returning = query("SELECT nb_vis_returning as s, idarchives as pseudodate, nb_pag_returning as sp
						FROM ".T_ARCHIVES."
						WHERE idsite = ".$this->site->getId()."
						AND idarchives IN (".$inIdArchives.")
						GROUP BY pseudodate
						");
			
		}
		// but for other periods, look directly into logs tables
		// CAREFUL : WONT WORK FOR PERIOD OLDER THAN 1 MONTH !!
		else
		{
			$r = query("SELECT count(distinct idcookie) as nb_uniq_vis, max(total_pages) as nb_max_pag
				FROM ".T_VISIT."
				WHERE idsite = ".$this->site->getId()."
				AND server_date IN (".$inIdArchives.")"
				);

			// returning visitors
			$returning = query("SELECT count(*) as s, server_date as pseudodate, sum(total_pages) as sp
						FROM ".T_VISIT."
						WHERE idsite = ".$this->site->getId()."
						AND server_date IN (".$inIdArchives.")
						AND returning = 1
						GROUP BY pseudodate"); 
			
			// for each returning visit, how many time did they return?			
			$f1 = query("SELECT count(*) as s
						FROM ".T_VISIT."
						WHERE idsite = ".$this->site->getId()."
						AND server_date IN (".$inIdArchives.")
						GROUP BY idcookie");	
			$res = array();					
			while($fx = mysql_fetch_assoc($f1))
			{
				@$res[(int)$fx['s']]++;
			}
			ksort($res);		
			$this->toRecord['vis_nb_vis'] = $res;
			
		}
		$l = mysql_fetch_assoc($r);
		$this->toRecord['nb_uniq_vis'] = $l['nb_uniq_vis'];
		$this->toRecord['nb_max_pag']  = $l['nb_max_pag'];
		
		// visits per period, new vs returning, and pages hits
		$returningTotal = 0;
		$returningPag = 0;
		while($l2 = mysql_fetch_assoc($returning))
		{
			$visitsTotal = $this->subPeriodValues[$l2['pseudodate']]['nb_vis'];
			$pagesTotal =  $this->subPeriodValues[$l2['pseudodate']]['nb_pag'];
			$returningVisits = $l2['s'];
			
			$returningPag += $l2['sp'];
			
			$returningTotal += $returningVisits;
			
			$this->toRecord['vis_period'][$l2['pseudodate']] = array(
						ARRAY_INDEX_RETURNING_COUNT => (int)$returningVisits,
						ARRAY_INDEX_NEW_COUNT => $visitsTotal - $returningVisits,
						ARRAY_INDEX_PAGES_COUNT => (int)$pagesTotal
						);
		}
		
		// number of returning visits
		$this->toRecord['nb_vis_returning'] = $returningTotal;
		$this->toRecord['nb_pag_returning'] = $returningPag;
		
		/*
		printDebug("<br>");
		printDebug($this->toRecord['nb_uniq_vis']." (uniq visites)");
		printDebug($this->toRecord['nb_vis_returning']." (returning visites)");
		printDebug($this->toRecord['vis_nb_vis']);
		printDebug($this->toRecord['vis_period']);
		printDebug("<br>returning visitor ". $this->toRecord['nb_vis_returning']);		
		printDebug("<br>pag  returning ". $this->toRecord['nb_pag_returning']);		
		printDebug("<br>vis a 1 page returning ". $this->toRecord['nb_vis_1pag_returning']);		
		printDebug("<br>sum vis returnoing ". $this->toRecord['sum_vis_lth_returning']);
		//exit;
		*/
		
		//TODO nb_uniq_pag est ACG normalement !
			
		//printDebug("TO RECORD<br>");
		//printDebug($this->toRecord);
				
		/*
		 * init
		 */
		 
		$this->initDb();
		
		/*
		 * final save, close your eyes and prey 
		 */
		 $this->saveDb();
	}
	// TODO protéger le champ pmv_sum des mots clés	
	
}

?>