<?php
/* 
 * phpMyVisites : website statistics and audience measurements
 * Copyright (C) 2002 - 2006
 * http://www.phpmyvisites.net/ 
 * phpMyVisites is free software (license GNU/GPL)
 * Authors : phpMyVisites team
*/

// $Id: Archive.class.php,v 1.60 2005/10/08 02:57:52 matthieu_ Exp $


$GLOBALS['test'] = ", sum(case total_pages when 1 then 1 else 0 end) as onepage," .
				" sum(total_pages) as sumpage, count(*) as s, sum(total_time) as sumtime";

require_once INCLUDE_PATH."/core/include/Date.class.php";
require_once INCLUDE_PATH."/core/include/Str.class.php";
require_once INCLUDE_PATH."/core/include/Archive.functions.php";
require_once INCLUDE_PATH."/core/include/functions.php";

/**
 * Base class used by other ArchiveClass to assign some standard attributes
 * 
 */
class Archive
{
 	/**
 	 * @var object Site
 	 */	
	var $site;
	
	/**
	 * @var array fieldName => fieldValue to save in database
	 */
	var $toRecord; // array 'field_name' => value to record
	
	/**
	 * @var int Current idarchives of the archive process
	 */
	var $idArchives; 
	
	/**
	 * @var int State of the current archive process (Must be DB_ARCHIVES_*)
	 */
	var $state; // DB_x
	
	/**
	 * @var object Date
	 */
	var $date;
	var $date2;
	
	/**
	 * @var int Type of the current archive period (Must be DB_ARCHIVES_PERIOD_*)
	 */
	var $periodType;
	
	
	// int value
	/**
	 * @var array integer arrays to sum conserving keys array( 3, 4, 6 ); 
	 */
	var $intValuesToSum;
	
	// key => int value
	var $arrayOneDimToSum;
	
	// key => array('pmv_sum' => X, 'iddetail1' => Y, 'iddetail2' => Z);
	var $arrayPmvSumToSum;
	
	var $arrayIntToSum;
	var $archiveOk; // flag to known if finished, used when using current archive twice
	
	/**
	 * @var string literal date corresponding to $this->date
	 */
	var $literalDate;
	
	/**
	 * @param object $site
	 */
	function Archive($site)
	{
		$this->site = $site;
		$this->state = DB_ARCHIVES_DONE;
		$this->toRecord = array();
		
		$this->archiveOk = false;
		
		$this->intValuesToSum = array(
		'nb_vis', 'nb_pag', 'nb_uniq_pag', 'nb_vis_1pag', 'sum_vis_lth',
		'nb_direct', 'nb_search_engine', 'nb_site', 'nb_newsletter', 'nb_partner',
		'nb_vis_returning', 'nb_pag_returning', 'nb_vis_1pag_returning', 'sum_vis_lth_returning'
		);
		
		// key => int value
		$this->arrayOneDimToSum = array(
		'vis_st', 'vis_lt', 'pag_st', 'pag_lt', 'vis_lth', 'vis_nb_pag', 
		'vis_country', 'vis_continent', 'vis_provider', 'vis_config', 'vis_os', 'vis_browser', 'vis_browser_type',
		'vis_resolution', 'vis_plugin', 'vis_depth', 
		'vis_newsletter',
		'vis_nb_vis'
		);
		
		// key => array('pmv_sum' => X, 'iddetail1' => Y, 'iddetail2' => Z);
		$this->arrayPmvSumToSum = array(
		'vis_search_engine', 'vis_keyword', 'vis_site', 'vis_partner'
		);
		
		$this->arrayIntToSum = array(
		'int_lt', 'int_st', 'int_referer_type', 'int_search_engine', 'int_keyword', 'int_site', 'int_partner',
		'int_newsletter', 'int_country', 'int_continent', 'int_os', 'int_browser', 'int_resolution', 
		//'int_config', 
		'int_depth'
		);
	}	
	
	/**
	 * Update database, set var state 
	 */
	function updateDbState()
	{
		updateLine(
			T_ARCHIVES, 
			array( 'done' => $this->state, 'idarchives' => $this->idArchives), 
			'idarchives');
		
	}
	
	/**
	 * saves var toRecord values in the database, serializing arrays
	 */
	function saveDb()
	{
		foreach($this->toRecord as $fieldName => $a_value)
		{
			if(is_array($a_value))
			{
				$a_value = serialize($a_value);
			}
			
			updateLine(
				T_ARCHIVES, 
				array( $fieldName => $a_value, 'idarchives' => $this->idArchives), 
				'idarchives');
		}
		
		/*
		if($this->state === DB_ARCHIVES_TEMP)
		{
			printDebug("Update archive, set new date2...<br>");
			updateDb(array( 
							'done' => $this->state, 
							'date2' => $this->date2->get(), 
							'idarchives' => $this->idArchives
							), 
					'archives', 
					'idarchives');
		}*/
		$this->updateDbState();
	}
	
	/**
	 * set periodType
	 * 
	 * @param int $type
	 */
	function setPeriodType($type)
	{
		$this->periodType = $type;
		
	}
	
	function getLiteralDate()
	{
		return $this->literalDate;
	}
	function setLiteralDate()
	{
		switch($this->periodType)
		{
			
			case DB_ARCHIVES_PERIOD_DAY:
				$typeDateDisplay = 1;
			break;
			
			case DB_ARCHIVES_PERIOD_WEEK:
				$typeDateDisplay = 6;				
			break;
				
			case DB_ARCHIVES_PERIOD_MONTH:
				$typeDateDisplay = 4;
				
			break;
				
			case DB_ARCHIVES_PERIOD_YEAR:
				$typeDateDisplay = 11;
			break;
		}
		
		$this->literalDate = getDateDisplay($typeDateDisplay, $this->date);
	}
	/**
	 * init the database, inserting a new row for the current archive process
	 * assigns var idArchives
	 * 
	 * @return true
	 */
	function initDb()
	{
		$r = query("INSERT INTO ".T_ARCHIVES." (idsite, done, period, date1, date2)" .
				" VALUES (".$this->site->getId().", " .
						" ". DB_ARCHIVES_FAIL."," .
						 $this->periodType .", ".
						" '".$this->date->get()."'," .
						" '".$this->date2->get()."')"
				);
		$this->idArchives = mysql_insert_id();
		return true;
	}
	
	/**
	 * offset the date, considering the date of the first log record for the current site
	 * and considering today date. It gives a date which is between these 2 dates.
	 * 
	 * @param object $o_date
	 */
	function offsetDate($o_date, $minDay = null)
	{	
		if(is_null($minDay)) $minDay = $this->site->getMinDay();
		
		// Manage with future
		if($o_date->getTimestamp() > time())
		{
			$o_date = new Date(getDateFromTimestamp(time()));
		}
		
				
		// manage with past
		if($o_date->getTimestamp() <  $minDay->getTimestamp())
		{
			$o_date = $minDay;
		}
		return $o_date;
	}
	
	/**
	 * Returns limit of the period periodType containing $s_date
	 * Works with weeks, month, years, and misc periods (in this case, minDate is the first day where there are logs)
	 * 
	 * @param string $s_date 
	 */
	function getPeriodDatesLimit($s_date)
	{
		// objects
		$date = new Date($s_date);
		$minDate = $this->site->getMinDay();
		
		$date = $this->offsetDate($date);
		
		//printDebug("MinDate is ".$minDate->get()."<br>Date asked is $s_date<br>Date after Offset is ".$date->get()."<br>");
		
		switch ($this->periodType) {
		case DB_ARCHIVES_PERIOD_MONTH:
			// detect min day for the month
			// if the minimum date month is different, we surely take the whole month 
			if($minDate->getMonth() == $date->getMonth() && $minDate->getYear() == $date->getYear())
			{
				$minDateForSure = $minDate->get();
			}
			else
			{
				$minDateForSure = $date->getYear()."-".$date->getMonth()."-01";
			}
			
			// detect max date for the month
			// if month asked is the current month then max day is today, else its the last day of the month
			if($date->getMonth() == date("m") && $date->getYear() == date("Y")) // >= because if month in future, take today
			{
				$maxDateForSure = getDateFromTimestamp(time()-86400);
			}
			else
			{
				$maxDateForSure = $date->getYear()."-".$date->getMonth()."-".date("t", $date->getTimestamp());
			}
			//print("min $minDateForSure max $maxDateForSure");
			break;
		case DB_ARCHIVES_PERIOD_WEEK:
			
			$time = $date->getTimestamp();
			
			// detect beginning of the week
			while(date("W", $time-86400) == $date->getWeek()
			&& $time-86400 >= $minDate->getTimestamp()
			)
			{
				$time -= 86400;
			}
			
			$minDateForSure = getDateFromTimestamp($time);
			
			// end of week
			while(date("W", $time+86400) == $date->getWeek()
			&& $time+86400 <= time()
			)
			{
				$time += 86400;
			}
			$maxDateForSure = getDateFromTimestamp($time);
			
			break;
		case DB_ARCHIVES_PERIOD_MISC_PERIOD:
			$minDateForSure = $minDate->get();
			$maxDateForSure = $date->get();
			break;
			
		case DB_ARCHIVES_PERIOD_YEAR:
		
			// min is minDate if year common 
			if($date->getYear() == date("Y", $minDate->getYear()))
			{
				$minDateForSure = $minDate->get();
			}
			else
			{
				$minDateForSure = $date->getYear()."-01-01";
			}
			
			// max date is today if year is current year
			if($date->getYear() == date("Y"))
			{
				$maxDateForSure = getDateFromTimestamp(time());
			}
			else
			{
				$maxDateForSure = $date->getYear()."-12-31";
			}
			break;
			
			default:
			break;
		}
		
		$this->date = new Date($minDateForSure);
		$this->date2 = new Date($maxDateForSure);
		
		$this->date = $this->offsetDate($this->date);
		$this->date2 = $this->offsetDate($this->date2);
		//printDebug(	$this->date->get()."=>".  $this->date2->get());
	}	
	
	
	function sortAndLimitToRecord()
	{
		$doNotSort = array('vis_st', 'vis_lt', 'pag_st', 'pag_lt', 'vis_lth', 'vis_nb_pag', 'vis_nb_vis');

		foreach ($this->arrayOneDimToSum as $name) 
		{

			if( !in_array($name, $doNotSort))
			{
				arsort($this->toRecord[$name]);
			}
			$this->toRecord[$name] = getArrayOffsetLimit($this->toRecord[$name], 0, MAX_DISTINCT_ELEMENTS);
		}
		
		foreach($this->arrayPmvSumToSum as $name)
		{
			uasort($this->toRecord[$name], "sortingPmv"); 
			$this->toRecord[$name] = getArrayOffsetLimit($this->toRecord[$name], 0, MAX_DISTINCT_ELEMENTS);
		}
		
		foreach($this->arrayIntToSum as $name)
		{
			uasort($this->toRecord[$name], "sortingInterest");
			$this->toRecord[$name] = getArrayOffsetLimit($this->toRecord[$name], 0, MAX_DISTINCT_INTEREST_ELEMENTS);
		}
		
	}
}




// TODO1 vérifiéer que total_time ok, semble avoir décalage de 20s
/*
SELECT sum( TIME_TO_SEC( last_visit_time ) - TIME_TO_SEC( server_time ) ) / count( * ) AS s, (
sum( total_time ) - count( * ) *20
) / count( * ) AS t2
FROM visit
WHERE server_date = current_date
GROUP BY server_date
LIMIT 0 , 30
*/
?>