<?php
/*
 * Classe Tempo
 * Raccoglie una libreria di funzioni legate alla lettura e scrittura di data e ora
 */

class Tempo {

	var $TEMPO;
	var $SESSION_END = 10000;
	var $GIORNO = 86400;

	function Tempo($data = "") {
		if($data == "") {
			$this->tempo = time();
		} else {
			$this->tempo = time();
		}
	}

	function get() {
		return $this->tempo;
	}

	function now(){
		return date("Y-m-d H:i:s", $this->tempo);
	}
	
	function conta($TEMPO = 0){
		return date("YmdHis", $this->tempo);
	}

	function today($TEMPO = 0){
		return date("Y-m-d", $this->tempo);
	}

	function oggi($TEMPO = 0){
		return $this->today($TEMPO);
	}
	
	function tomorrow($nDay = 1){
		if($nday > 50) {
			$newTempo = $this->tempo;
			for($i = 0; $i < $nDay; $i++) {
				$newTempo += $this->GIORNO;
			}
			return date("Y-m-d", $newTempo);
		}
		return date("Y-m-d", $this->tempo + $nDay * $this->GIORNO);
	}

	function domani($nDay = 1){
		return $this->yesterday($nDay);
	}

	function yesterday($nDay = 1){
		return date("Y-m-d", $this->tempo - $nDay * $this->GIORNO);
	}

	function ieri($nDay = 1){
		return $this->yesterday($nDay);
	}

	function day() {
		return date("d", $this->tempo);
	}

	function month() {
		return date("m", $this->tempo);
	}

	function year() {
		return date("Y", $this->tempo);
	}
	
	function end_session(){
		return date("Y-m-d H:i:s", $this->tempo - $this->SESSION_END);
	}

	function converti($ymd, $separatore='/') {
		return substr($ymd, 8, 2).$separatore.substr($ymd, 5, 2).$separatore.substr($ymd, 0, 4);
	}
	
	function extractDay($ymd) {
		return substr($ymd, 8, 2);
	}

	function extractMonth($ymd) {
		return substr($ymd, 5, 2);
	}

	function extractYear($ymd) {
		return substr($ymd, 0, 4);
	}

	function extractDate($ymd) {
		return substr($ymd, 0, 10);
	}


}
?>