<?php
/*
 * Classe Paginazione
 * Calcola e gestisce il numero di pagine in risposta a una query
 */

class Paginazione {

	var $pTot;		//Pagine Totali
	var $pCor;		//Pagina Corrente
	var $ppp;		//Record per pagina
	var $intorno;	//Numero di pagina cliccabili attorno alla pagina corrente
	var $nElem;		//Numero di record totali
	var $vrb;		//Nome variabile di controllo

	//inizializzazione
	function Paginazione($nElem, $pCor = 1, $ppp = 25, $intorno = 5, $vrb="pCor") {
		$this->nElem = $nElem;
		$this->pCor = $pCor;
		$this->ppp = $ppp == 0 ? 9999999 : $ppp;
		$this->intorno = $intorno == 0 ? 999999 : $intorno;
		$this->vrb = $vrb;
		$this->pTot = $this->calcola();
	}

	//modifica la pagina corrente
	function set_pCor($pCor){
		$this->pCor = $pCor;
	}

	//calcola il numero di pagine necessarie per contenere i record
	function calcola() {
		return floor(($this->nElem - 0.1) / $this->ppp ) + 1;
	}

	//crea il codice SQL per il LIMIT alla query
	function limit() {
		return " LIMIT ".(($this->pCor - 1) * $this->ppp)." , ".$this->ppp;
	}
	
	//stampa una tabella con numerazione e link necessari alla navigazione
	function stampaLink($link, $param = "") {
		$prev = $this->pCor - $this->intorno > 1 ? true : false;
		$post = $this->pCor + $this->intorno < $this->pTot ? true : false;
		echo '<TABLE WIDTH="100%">' .
			 '	<TR>' .
			 '		<TD ALIGN="LEFT" CLASS="pag">Pagina ' . $this->pCor . ' di ' . $this->pTot . '</TD>' .
			 '		<TD ALIGN="RIGHT" CLASS="pag">';
		if ($this->pCor > 1)
			echo '<A HREF="'.$link.'?'.($param != "" ? $param . '&'.$this->vrb.'=' : $this->vrb.'=').($this->pCor - 1).'">&lt;&lt; Prec</A> ';
		if ($prev)
			echo ' ... ';
		for ($i = 1; $i <= $this->pTot; $i++) {
			if ($i < $this->pCor - $this->intorno || $i > $this->pCor + $this->intorno)
				continue;
			if ($i == $this->pCor)
				echo ' <B>'.$i.'</B> ';
			else
				echo ' <A HREF="'.$link.'?'.($param != "" ? $param . '&'.$this->vrb.'=' : $this->vrb.'=').$i.'">'.$i.'</A> ';
		}
		if ($post)
			echo ' ... ';
		if ($this->pCor < $this->pTot)
			echo '<A HREF="'.$link.'?'.($param != "" ? $param . '&'.$this->vrb.'=' : $this->vrb.'=').($this->pCor + 1).'">Succ &gt;&gt;</A> ';
		echo '		</TD>' .
			 '	</TR>' .
			 '</TABLE>';
	}

	//stampa una tabella link necessari alla navigazione
	function stampaPag($link, $param = "") {
		$prev = $this->pCor - $this->intorno > 1 ? true : false;
		$post = $this->pCor + $this->intorno < $this->pTot ? true : false;
		echo '<TABLE WIDTH="100%">' .
			 '	<TR>' .
			 '		<TD ALIGN="RIGHT" CLASS="pag">';
		if ($this->pCor > 1)
			echo '<A HREF="'.$link.'?'.($param != "" ? $param . '&'.$this->vrb.'=' : $this->vrb.'=').($this->pCor - 1).'">&lt;&lt; Prec</A> ';
		if ($prev)
			echo ' ... ';
		for ($i = 1; $i <= $this->pTot; $i++) {
			if ($i < $this->pCor - $this->intorno || $i > $this->pCor + $this->intorno)
				continue;
			if ($i == $this->pCor)
				echo ' <B>'.$i.'</B> ';
			else
				echo ' <A HREF="'.$link.'?'.($param != "" ? $param . '&'.$this->vrb.'=' : $this->vrb.'=').$i.'">'.$i.'</A> ';
		}
		if ($post)
			echo ' ... ';
		if ($this->pCor < $this->pTot)
			echo '<A HREF="'.$link.'?'.($param != "" ? $param . '&'.$this->vrb.'=' : $this->vrb.'=').($this->pCor + 1).'">Succ &gt;&gt;</A> ';
		echo '		</TD>' .
			 '	</TR>' .
			 '</TABLE>';
	}
	
}
?>