<?php
// *************************************************************************************
//                                                                      
//  Contatore PNG  - Versione 2.00 - Dicembre 2005 - FREEWARE!
//     
//  by gian luca ruggero (rgl_it@yahoo.it)
//      
//  Ultima modifica: 01 dicembre 2005 20:05
//      
//  Codice: Script in php 4.4.0
//          Necessita di GD2 (libreria grafica di php, chiedete al web Hoster)
//
// Funzione: E' un contatore in php che una volta linkato restituisce un PNG (immagine) 
//           che mostra un contatore (tipo 0002520). Permette quindi di capire quante 
//           persone visitano il tuo sito.
//
// Funzionalit:
//    Lo script  configurabile via url. In pratica se vuoi puoi vedere l'immagine
//    del contatore in tuti i colori che preferisci, con il font che vuoi  e della
//    dimensione che vorresti. Questo per potersi integrare il contatore nello stile 
//    della tua pagina web.
//
// Come funziona in due frasi:
//    Lo linki come immagine e ogni volta che il visitatore vede la pagina
//    in numeretto mostrato aumenta di uno [o di quello che vuoi ;-)]
//
//  LEGGI il readme associato per capire come funziona!!!
//
// ********************************************************************************************
  
  // Controlla le variabili url ($_GET) e le setta se non presenti
  // Prende sia un parametro MAIUSCOLO sia MINUSCOLO
  $fg     = 'ffffff';                     //colore del font, nullo diventa bianco
  $border = false;                        //presenza o assenza del border
  $bcol   = $fg;                          //colore border, se nullo come quello del font
  $bg     = '000000';                     //colore sfondo, nullo diventa nero
  $fnt    = 'verdana';                    //font, nullo diventa verdana
  $car    = 5;                            //numeri di cifre, nullo diventa cinque
  $counter_name = "totale";               //Contatore usato, se nullo usa ./counter/counter.txt
  $step   = 1;                            //di quando si incremente il contatore. nullo = 1
  
  if (isset($_GET['cl']))  $fg   = strtolower(urldecode($_GET['cl']));
  if (isset($_GET['CL']))  $fg   = strtolower(urldecode($_GET['CL']));
  if (isset($_GET['br'])) {
     $bcol = strtolower(urldecode($_GET['br']));  
     $border = true;
  }   
  if (isset($_GET['BR'])) {
     $bcol   = strtolower(urldecode($_GET['BR']));  
     $border = true;
  }   
  if (isset($_GET['b']))   $bg   = strtolower(urldecode($_GET['b']));
  if (isset($_GET['B']))   $bg   = strtolower(urldecode($_GET['B']));
  if (isset($_GET['f']))   $fnt  = strtolower(urldecode($_GET['f']));
  if (isset($_GET['F']))   $fnt  = strtolower(urldecode($_GET['F']));
  if (isset($_GET['cf']))  $car  = min(max(3, (integer) $_GET['cf']),  10);
  if (isset($_GET['CF']))  $car  = min(max(3, (integer) $_GET['CF']),  10);
  if (isset($_GET['s']))   $step = min(max(1, (integer) $_GET['s']), 10);
  if (isset($_GET['S']))   $step = min(max(1, (integer) $_GET['S']), 10);
  if (isset($_GET['c']))   $counter_name = strtolower(substr(urldecode($_GET['c']), 0, 10));
  if (isset($_GET['C']))   $counter_name = strtolower(substr(urldecode($_GET['C']), 0, 10));
  
  // Funzione che trasforma da fffff nei vari colori hex per usarlo in php.
  // Copiata da qualche parte ma non ricordo da dove!
  function ConvertColor($hexVal){
    $ColorVal = array(0, 0, 0);
    for($i = 0; $i < 3; $i++)
      $ColorVal[$i] = HexDec(substr($hexVal, $i * 2, 2));
    return $ColorVal;
  }
  
  // Contatore in uso
  // percorso relativo a contatore_gif.php
  $file="./counter/counter_{$counter_name}.txt";
  
  //Apre il contatore, legge la variabile $counter come intero e chiude il file
  // Se non presente $counter diventa uguale a zero.
  $counter = 0;
  $handle  = @fopen($file, "r");
  @fscanf ($handle, "%010u", $counter);
  @fclose($handle);

  //Incrementa il contatore. Se STEP esiste pone il contatore come rnd(STEP)
  if ($step == 1) $counter++;
             else $counter += rand(1, $step);
  
  //Aggiorna il contatore come file (e se non esiste lo crea)
  $handle  = @fopen($file, "w");
  @fwrite($handle, sprintf("%010u", $counter));
  @fclose($handle);

  // Questa stringa  il numero da mostrare (lunga CAR caratteri)
  $nm = substr(sprintf("%010u", $counter), -$car);

  //Comincia la parte interessante
  //Prende la gif del font. di defualt: ./counter/verdana_10.gif
  // e fa anche un controllo di esistenza! Controlla che esista il $font_gif, altrimenti usa verdana_10
  $font_gif = "./counter/{$fnt}.gif";
  if (!file_exists($font_gif)) 
     $font_gif = "./counter/arial_10.gif";
 
  //controlla che ci siano le estensioni GD2
  //altrimenti manda una gif di pseudo errore (con il !01203)
  if (!defined('IMG_GIF')) {
    $error = file_get_contents("./counter/error.gif");
    Header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
    Header("Pragma: no-cache"); // HTTP/1.0
    Header("Content-type: image/gif");
    echo $error;
  }
 
  //Carica l'immagine del font e determina larghezza di ogni carattere e altezza
  // Altezza  semplice:  l'altezza della immagine font
  // Larghezza  la larghezza dell'immagine font diviso dieci caratteri (0123456789 logicamente)
  $imgFNT = @ImageCreateFromGif($font_gif);
  $w = (int) ImageSx($imgFNT)/10;
  $h = (int) ImageSy($imgFNT);

  //Imposta il margine (sotto e sopra, destra e sinistra)
  $margin = 4;
  
  // Imposta larghezza e altezza dell'immagine contatore
  $width  = $margin * 2 + strlen($nm) * $w;
  $height = $margin + $h;
  
  //Crea immagine contatore  
  $imgFRAME = ImageCreate($width, $height);

  //Setta il colore di sfondo
  list($red, $green, $blue) = ConvertColor($bg);
  $bgCOLOR = ImageColorAllocate($imgFRAME, $red, $green, $blue);

  //disegna lo sfondo
  ImageRectangle($imgFRAME, 0, 0, $width-1, $height-1, $bgCOLOR);

  //idem colore del font.
  list($red, $green, $blue) = ConvertColor($fg);
  $fgCOLOR = ImageColorAllocate($imgFRAME, $red, $green, $blue);
  
  //Furbata: cambia il primo colore dell'immagine font con questo colore.
  // Se le vostra immagini hanno solo i colori nero/trasparente dovrebbe funzionare per cambiare il colore
  // del font senza troppa fatica
  ImageColorSet($imgFNT, 0, $red, $green, $blue);

  //se bordo  impostato allora lo mostra
  if ($border) {
   list($red, $green, $blue) = ConvertColor($bcol);
   $bCOLOR = ImageColorAllocate($imgFRAME, $red, $green, $blue);
   ImageLine($imgFRAME, 0, 0, $width-1, 0, $bCOLOR);
   ImageLine($imgFRAME, 0, 0, 0, $height-1, $bCOLOR);
   ImageLine($imgFRAME, $width-1, 0,  $width-1, $height-1, $bCOLOR);
   ImageLine($imgFRAME, 0, $height-1, $width-1, $height-1, $bCOLOR);
  } 
  
  // Comincia il ciclo che scrive ogni singola cifra.
  // prende i-esimo carattere della stringa numero ($nm) e copia una porzione di grafica
  // dalla immagine font a quella contatore
  for ($i=0; $i<strlen($nm); $i++) {
    $j = $nm{$i};
    imagecopy($imgFRAME, $imgFNT, $margin+$i*$w, $margin/2, $j*$w, 0, $w, $h);
  }
   
  // manda un header gif. dice al browser: "t!, una gif, ricordati di non metterla in cache tanto non cambia."
  Header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
  Header("Pragma: no-cache"); // HTTP/1.0
  Header("Content-type: image/gif");
  
  // Manda l'immagine al browser
  ImageGif($imgFRAME);
  
  //Toglie dalla memoria tutto il rimanente (pulizia)
  ImageDestroy($imgFRAME);
  ImageDestroy($imgFNT);
  unset ($nm, $bgCOLOR, $fgCOLOR, $bcol, $width, $height, $w, $h, $margin, $i, $j, $counter);
?>