<?php

  /* ******************************************
     GIF COUNTER V1.01
     
      by gian luca ruggero (rgl_it@yahoo.it)
      
      Ultima modifica: marted 13 settembre 2005 20:05
      
      E' un contatore php che restituisce una GIF quando linkato o richiamato via url.
      Permette di usare font che trovate in /counter/*.gif
      Notate che sono gif trasparenti con i numeri da 0 a 9, quindi potete cambiarle e aggiungerne altre.
      Lo script supporta vari contatori diversi, quindi per contare su pagine diverse basta cambiare la variabile counter via url.
      
      Liberamente distribuibile (una email di messa in rete non dispiace).
      Se qualcuno riesce a migliorarlo, per favore mandate una email e condividete la gloria.
      
      Testato su Windows 2K, php 4.3.9, Firefox 1.04
      
    *******************************************
    
    PARAMETRI NELL'URL DEL CONTATORE
    
    SET     imposta (e salva il valore) il contatore al numero indicato.                           (Default: no)
    BG      imposta il colore di sfondo in esadecimale (000000, FFFFFF, etc)                       (Default: bianco #ffffff)
    F       sceglie il font come ./counter/FONT_SIZE.gif                                           (Default: Verdana)
    CAR     stabilisce il numero di caratteri (5 per 00000, 3 per 000, etc)                        (Default: 5 => 12345)
    COL     imposta il colore del font.                                                            (Default: nero #000000)
    SZ      imposta la dimensione del font                                                         (Default: 10 pixel)
    B       se 1 mostra il border, altrimenti nessun border.                                       (Default: nessun bordo)
    BCOL    imposta il colore del border.                                                          (Default: colore testo)
    COUNTER sceglie il contatore come file. permette di avere diversi contatori per ogni pagina.   (Default: vuoto)
   
    TUTTI I PARAMETRI SONO OPZIONALI!!!
   
    Esempio:
     Nella vostra pagina html dovete inserire il codice:
      <img src='http://server_php/directory_di_installazione/gif_counter.php?car=6&font=verdana&bg=ffccff&border=1&bcol=00ffff&counter=1&col=00aa00' alt='counter'>
    
     L'esempio st passando i parametri:
      car     => 6 caratteri (es 123456)
      f       => verdana, 
      sz      => 10 (predefinito),      quindi da queste due il contatatore user l'immagine ./counter/verdana_10.gif
      bg      => #ffccff imposta lo sfondo su una specie di rosa-viola
      b       => attiva il border
      bcol    => Il colore del border sar #00ffff che dovrebbe essere un ciano
      counter => 1 quindi usa il contatore ./counter/counter1.txt
      col     => imposta il colore del font come #00aa00, un verde.
    
    ***************************************************    
  */
  
  // Controlla le varibili urgl ($_get) e le setta se non presenti
  if (isset($_GET['col'])) $fg = $_GET['col'];
                      else $fg = '000000';                     //colore del font, nullo diventa nero
  if (isset($_GET['bcol'])) $bcol = $_GET['bcol'];  
                       else $bcol = $fg;                         //colore border, se nullo come quello del font
  if (isset($_GET['bg'])) $bg = $_GET['bg'];
                     else $bg = 'ffffff';                        //colore sfondo, nullo diventa bianco
  if (isset($_GET['f'])) $fnt = $_GET['f'];
                    else $fnt = 'verdana';                   //font, nullo diventa verdana
  if (isset($_GET['car'])) $car = (int) $_GET['car'];
                      else $car = 5;                            //caratteri numero, nullo diventa cinque
            if ($car > 10) $car = 10;
  if (isset($_GET['sz'])) $sz = (int) $_GET['sz'];
                     else $sz = 10;                            //altezza caratteri, se nullo diventa dieci
  if (isset($_GET['counter'])) $counter = (int) $_GET['counter'];
                          else $counter = "";                   //Contatore usato, se nullo usa ./counter/counter.txt
  if (isset($_GET['b'])) $border = (int) $_GET['b'];
                    else $border = 0;                      //Border, se nullo non lo mostra.
  
  // Funzione che trasforma da fffff nei vari colori per usarlo in php.
  // Copiata da qualche parte ma non ricordo da dove!
  function ConvertColor($hexVal){
    $ColorVal = array(3);
    for($i = 0; $i < 3; $i++)
      $ColorVal[$i] = HexDec(substr($hexVal, $i * 2, 2));
    return $ColorVal;
  }
  
  // Contatore in uso
  $file="./counter/counter{$_GET['counter']}.txt";
  
  //Apre il contatore, legge la variabile $counter e chiude il file
  $handle  = @fopen($file, "r");
  @fscanf ($handle, "%010u", $counter);
  @fclose($handle);

  //Incrementa il contatore. Se SET esiste pone il contatore come Set
  $counter++;
  if (isset($_GET['set'])) $counter = (int) $_GET['set'];
  
  //Aggiorna il contatore come file (se non esiste lo crea)
  $handle  = @fopen($file, "w");
  @fwrite($handle, sprintf("%010u", $counter));
  @fclose($handle);

  // Questa stringa  il numero da mostrare (lunga CAR caratteri)
  $nm = substr(sprintf( "%010u", $counter), -$car);

  //Comincia la parte interessante
  //Prende la gif del font. di defualt: ./counter/verdana_10.gif
  $font_gif = "./counter/{$fnt}_{$sz}.gif";
  
  //Controlla che esista il $font_gif, altrimenti usa verdana_10
  if (!file_exists($font_gif)) $font_gif = "./counter/verdana_10.gif";
 
  //Carica l'immagine del font e determina larghezza di ogni carattere e altezza
  // Altezza  semplice:  l'altezza della immagine font
  // Larghezza  la larghezza dell'immagine font diviso dieci caratteri (0123456789 logicamente)
  $imgFNT = @ImageCreateFromGif($font_gif);
  $w = (int) ImageSx($imgFNT)/10;
  $h = (int) ImageSy($imgFNT);

  //Imposta il margine (sotto e sopra, destra e sinistra)
  $margin = 4;
  
  // Imposta larghezza e altezza dell'immagine contatore
  $width  = $margin * 2 + strlen($nm) * $w;
  $height = $margin + $h;
  
  //Crea immagine contatore  
  $imgFRAME = ImageCreate($width, $height);

  //Setta il colore di sfondo
  list($red, $green, $blue) = ConvertColor($bg);
  $bgCOLOR = ImageColorAllocate($imgFRAME, $red, $green, $blue);

  //idem colore del font. 
  list($red, $green, $blue) = ConvertColor($fg);
  $fgCOLOR = ImageColorAllocate($imgFRAME, $red, $green, $blue);
  
  //Furbata: cambia il primo colore dell'immagine font con questo colore.
  // Se le vostr immagini hanno solo i colori nero/trasparente dovrebbe funzionare per cambiare il colore
  // del font senza troppa fatica
  ImageColorSet($imgFNT, 0, $red, $green, $blue);

  //colore del bordo
  list($red, $green, $blue) = ConvertColor($bcol);
  $bCOLOR = ImageColorAllocate($imgFRAME, $red, $green, $blue);

  //se bordo esiste allora mostralo
  if ($border) ImageRectangle($imgFRAME, 0, 0, $width-1, $height-1, $bCOLOR);
  
  //disegna lo sfondo
  ImageRectangle($imgFRAME, 1, 1, $width-2, $height-2, $bgCOLOR);
  
  // Comincia il ciclo che scrive ogni singola cifra.
  // prende i-esimo carattere della stringa numero ($nm) e copia una porzione di grafica
  // dalla immagine font a quella contatore
  for ($i=0; $i<strlen($nm); $i++) {
    $j = $nm{$i};
    ImageCopy($imgFRAME, $imgFNT, $margin+$i*$w, $margin/2, $j*$w, 0, $w, $h);
  }
   
  // manda un header gif. dice al browser: "t!, una gif"
  header("Content-type: image/gif");
  
  // Manda l'immagine al browser
  ImageGIF($imgFRAME);
  
  //Toglie dalla memoria tutto il rimanente (pulizia)
  ImageDestroy($imgFRAME);
  ImageDestroy($imgFNT);
  unset ($nm, $bgCOLOR, $fgCOLOR, $bCOLOR, $width, $height, $w, $h, $margin, $i, $j, $counter);
  
  /* ********************
  
     Ultima nota: le immagini font dovrebbero essere in nero (font) e trasparente, gif, con le cifre  messe come
                  012345789, altrimenti avrete seri problemi a far funzionare lo script.
                  
    Grazie per aver scaricato e provato questo file.
                  
    Suggerimenti, bugs e commenti sono bene accetti [anche soldi, se ne avete ;-) ]
    
     ******************** */
?>