<?php
 
 /***********************************************
  
    -=- Generatore di grafici statistici -=-
    
              Creato da SiberianSTAR
              
        -=> Copyright 2004, SiberianSTAR <=-
  
  -=--=--=--=--=--=--=--=--=--=--=--=--=--=--=--
   Utilizzo:
   
    1) includere il file "grafico.php" nel proprio
       progetto.
       
    2) Istanziare la classe grafico in questo modo:
       $var = new Grafico;
       
    3) Aggiungere le colonne al grafico, sintassi:
       $var->aggiungi_colonna(valore, titolo, colore);
    
    4) Creare il grafico, sintassi:
       $var->crea_grafico(altezza, bgcolor, fgcolor);
 
    Verr creata una immagine in formato png
  -=--=--=--=--=--=--=--=--=--=--=--=--=--=--=--
 
  ***********************************************/


class Grafico
{
 
 var $nomi_colonne, $valori_colonne, $colori_colonne, $colonne_totali;
 
 function Grafico()
 {
  $this->colonne_totali = 0; // Inizializzo la classe
 }
 
 function aggiungi_colonna($value, $name, $color)
 {
  $this->nomi_colonne[$this->colonne_totali] = $name;
  $this->colori_colonne[$this->colonne_totali] = $color;
  $this->valori_colonne[$this->colonne_totali] = $value;
  $this->colonne_totali++;
 }
 
 function hex2dec($color)
 {
    $color = str_replace('#', '', $color);
    
     $rgb = array(
         'r' => hexdec(substr($color, 0, 2)),
         'g' => hexdec(substr($color, 2, 2)),
         'b' => hexdec(substr($color, 4, 2))
     );
   return $rgb;
 }
 
 function crea_grafico($height, $bgcolor, $fgcolor)
 {
   
   $max_value = 0;
   
   
   for ($a = 0; $a < $this->colonne_totali; $a++)
    if ($this->valori_colonne[$a] > $max_value) $max_value = $this->valori_colonne[$a];
   
   if ($max_value == 0)
    $conv_value = 30;
   else
    $conv_value = $height/$max_value;
    
   
   
   /* Creo le colonne colorate e determino il valore massimo */
   for ($a = 0; $a < $this->colonne_totali; $a++)
   {
    
    
    $im_column[$a] = imagecreate(30, $conv_value * $this->valori_colonne[$a]+1);
    
    $rgb = $this->hex2dec($this->colori_colonne[$a]);
 
    $im_bg[$a] = imagecolorallocate($im_column[$a], $rgb['r'], $rgb['g'], $rgb['b']);
    
    $rgb = $this->hex2dec($fgcolor);
    $im_fg[$a] = imagecolorallocate($im_column[$a], $rgb['r'], $rgb['g'], $rgb['b']);
    
    $i = $this->valori_colonne[$a];
    
    
    imagestring($im_column[$a], 2, (imagesx($im_column[$a])-6*strlen($i))/2, 2,  $i, $im_fg[$a]);
    
    

   }

   $im = imagecreate(70 * $this->colonne_totali, $height+30);

   $rgb = $this->hex2dec($bgcolor);
 
   $im_bg_a = imagecolorallocate($im, $rgb['r'], $rgb['g'], $rgb['b']);   
  
   $rgb = $this->hex2dec($fgcolor);
 
   $im_fg_a = imagecolorallocate($im, $rgb['r'], $rgb['g'], $rgb['b']);        
   
   for ($a = 0; $a < $this->colonne_totali; $a++)
   {
     @imagecopy($im, $im_column[$a], $a*70, $height-imagesy($im_column[$a])+30, 0, 0, imagesx($im_column[$a]), imagesy($im_column[$a]));
   }
   
   for ($a = 0; $a < $this->colonne_totali; $a++)
    imagestring($im, 2, $a*70+2, 2, $this->nomi_colonne[$a], $im_fg_a);
   
   imageline($im, 0, 0, 0, imagesy($im), $im_fg_a);
   imageline($im, imagesx($im)-1, 0,imagesx($im)-1, imagesy($im), $im_fg_a);
   imageline($im, 0, imagesy($im)-1, imagesx($im), imagesy($im)-1, $im_fg_a);
   imageline($im, 0, 0, imagesx($im), 0, $im_fg_a);
   
   header("Content-type: image/png");
   imagepng($im);
   
 }
 
}


?>