<?php
/************************************************************************/
// gmt-utc.php
// converts a GMT date into a UTC timestamp and vice versa
// Version 3.0
// Developed by Black Widow
// Copyright (c) 2008 by Black Widow
// Support: www.forum.quirm.net
// Commercial Site: www.blackwidows.co.uk
/************************************************************************/
$date=$utc=$day=$month=$year='';
if(isset($_POST['gmt_submit']) || isset($_POST['utc_submit'])) {
	while (list($key, $value) = each($_POST)) $$key = $value;
	$date = $day.'/'.$month.'/'.$year;
}
Head();
// gmt-utc conversion
if(isset($_POST['gmt_submit'])) {
	if($year !='' && ctype_digit($year) && strlen($year) == 4) {
		$time = $hour.':'.$minutes.':'.$seconds;
		if(checkdate($month,$day,$year)) {
			$utc = gmmktime($hour,$minutes,$seconds,$month,$day,$year);
			$gmt_output = '<ul class="result">'."\n";
			$gmt_output .= '<li>GMT input: '.gmdate('l, d F Y', $utc).' at '.gmdate('H:i:s', $utc).'</li>'."\n";
			$gmt_output .= '<li>Unix timestamp: <strong>'.$utc.'</strong></li>'."\n</ul>\n";
		}
		else $gmt_output .= '<p><strong class="error">ERROR! '.$date.' is not a valid date!</strong></p>';
	}
	else $gmt_output .= '<p><strong class="error">ERROR! Please enter a 4 digit year!</strong></p>';
}

// utc-gmt conversion
if(isset($_POST['utc_submit'])) {
	if($utc_date !='') {
		$utc_output = '<ul class="result">'."\n";
		$utc_output .= '<li>Unix timestamp entered: '.$utc_date.'</li>'."\n";
		$utc_output .= '<li>GMT Output: <strong>'.gmdate('l, d F Y',$utc_date).' at '.gmdate('H:i:s',$utc_date).'</strong></li>'."\n</ul>\n";
	}
	else $utc_output .= '<p><strong> class="error">ERROR! Please enter a Unix timestamp</strong></p>';
}

if(isset($gmt_output) || isset($utc_output)) {
	echo '<h2>Conversion Results</h2>';
	if(isset($gmt_output) && $gmt_output != '') echo $gmt_output;
	if(isset($utc_output) && $utc_output != '') echo $utc_output;
}
PrintForm();

Foot();
exit;

function Head() {
	?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta name="url" content="" />
<meta name="description" content=""  />
<meta name="keywords" content="" />
<meta name="robots" content="noindex,nofollow" />
<meta name="distribution" content="Global" />
<meta name="copyright" content="Mel Pedley" />
<meta name="author" content="Mel Pedley" />
<meta name="Author URL" content="http://www.quirm.net/" />
<meta name="language" content="English" />
<style type="text/css">
body {background:#fff;color:#404040;font-size:100%;}
#wrapper {background:#E7EEF5;color:#000;margin:20px auto;width:80%;padding:10px 20px;border:1px solid #ccc;font-size:90%;}
h1 {font-size:150%;}
h2 {font-size:120%;}
.result li {margin-bottom:10px;}
a,a:link,a:visited {background:#fff;color:#426892;text-decoration:underline;}
a:hover,a:active,a:focus {text-decoration:none;background:#FFEBCF;color:#000;}
legend {background:#fff;color:#404040;border:1px solid #999;padding:3px;font-weight:bold;}
fieldset {margin-bottom:20px;border:1px solid #ADBECD;padding:10px;}
input {background:#f8f8f8;color:#000}
input.submit {background:#FFEBCF;color:#000;}
input:focus {background:#fff;color:#404040;}
#copyright {text-align:right;font-size:70%;}
.error {font-weight:bold;color:#A20F00;}
</style>
<title>Quirm.net Scriptlet: GMT Date Convertor</title>
</head>
<body>
<div id="wrapper">
<h1><abbr title="Greenwich Mean Time">GMT</abbr> to <abbr title="Universal Time Coordinated">UTC</abbr> Date Convertor</h1>
<p>Convert between GMT dates &amp; times and Unix timestamps (the number of seconds elapsed since January 1<sup>st</sup> 1970 at 00:00:00 GMT).</p>
	<?php
}

function Foot() {
	Copyright();
	?>
</body>
</html>
	<?php
}

function Copyright() {
	?>
</div>
<p id="copyright">Scriptlet developed by <a href="http://www.quirm.net">Quirm.net</a></p>
	<?php
}

function PrintForm() {
	?>
<form action="<?php echo $_SERVER['SCRIPT_NAME'];?>" method="post">
<fieldset><legend>GMT to Unix:</legend>

<fieldset>
<legend>Date:</legend>
<p><label for="day">Day</label>:  <select name="day" id="day">
<?php for($d=1;$d<=31;$d++) echo '<option value="'.$d.'">'.$d.'</option>';?>
</select>

<label for="month">Month</label>: <select name="month" id="month">
<?php for($m=1;$m<=12;$m++) echo '<option value="'.$m.'">'.$m.'</option>';?>
</select>

<label for="year">Year</label>: <input type="text" id="year" name="year" size="4" value="" /></p>
</fieldset>

<fieldset style="margin-top:20px;">
<legend>Time:</legend>
<label for="hour">Hour</label>: <select name="hour" id="hour">
<?php for($h=0;$h<=23;$h++) {
	echo '<option value="'.$h.'"';
	if($h==12) echo ' selected="selected"';
	echo '>'.$h.'</option>';
	}?>
</select>

<label for="minutes">Minutes</label>: <select name="minutes" id="minutes">
<?php for($mn=0;$mn<=59;$mn++) echo '<option value="'.$mn.'">'.$mn.'</option>';?>
</select>

<label for="minutes">Seconds</label>: <select name="seconds" id="seconds">
<?php for($s=0;$s<=59;$s++) echo '<option value="'.$s.'">'.$s.'</option>';?>
</select>
</fieldset>

<p><input name="gmt_submit" class="submit" type="submit" value="Get Unix Timestamp" /></p>
</fieldset>

<fieldset style="margin-top:20px;"><legend>Unix to GMT:</legend>
<p><label for="utc_date">Unix Timestamp</label>: <input type="text" id="utc_date" name="utc_date" size="10" value="" /></p>

<p><input name="utc_submit" class="submit" type="submit" value="Get GMT Date" /></p>
</fieldset>

</form>
	<?php
}

?>