<?php
/***************************************************************************
timeBG.php
originally (c) Aaron Robbins
www.aaronrobbins.com
aaron@aaronrobbins.com

This script is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
****************************************************************************

******************************   WHAT IT DOES   ****************************
Like the time changing themes on iGooogle this function dynamically inserts
css into the head of any web page to change the background and/or background
image of an html tag, class or id based on the time of the day.

There are currently 6 times phases supported:
midnight, dawn, morning, afternoon, dusk and evening

Include the timeBG.php file into the head of any php enabled doc
<?php include("timeBG.php"); ?>
-or-
copy the function and variables into your own functions.php or config.php
and include that.

See the included index.php for usage example
-or- see demo for a working example http://www.aaronrobbins.com/demos/timeBG
****************************************************************************/
////////////////
// Configure //
//////////////
//STEP 1.
//You need to create images named:
//midnight.jpg, dawn.jpg, morning.jpg, afternoon.jpg, dusk.jpg and evening.jpg
//or you can create less images and assign images to more then one phase.

//The default css definition is background:#FFFFFF url(dawn.jpg) no-repeat center;
//This assumes the background images are in the same directory as the file calling the function
//Feel free to chage the definition parameters. background:hexcolor url(path/to/image.jpg) repeat_flag alignment_flag;

//STEP 2.
//$hourOffset Example:
//Enter 0 if you are in the same time zone as the hosting server.
//Enter -8 if the hosting server is 8 hour ahead of your time.
//Enter 6 if the hosting server is 6 hours behind your time.
$hourOffset = -3;

//STEP 3.
//$cssName Example:
//$cssName = "body"  (this would add the background to the "body" tag)
//$cssName = "#page"  (this would add the background to an id named "page")
//$cssName = ".box"  (this would add the background to a class named "box")
$cssName = ".wrapper"; //the name of the css class you wish to add the background too

//Define Function
function timeBG($hourOffset,$cssName){
    $hourOffset = ($hourOffset * 3600);
    $currentHour = date("G",time() + $hourOffset);
    if($currentHour < 4){
        $phase="midnight";
    }
    else if($currentHour < 7){
        $phase="dawn";
    }
    else if($currentHour < 11){
        $phase="morning";
    }
    else if($currentHour < 16){
        $phase="afternoon";
    }
    else if($currentHour < 19){
        $phase="dusk";
    }
    else if($currentHour < 22){
        $phase="evening";
    }
    else{
        $phase="midnight";
    }
    switch ($phase){
    	case "dawn":
    		echo "
            <style type=\"text/css\" media=\"screen\">
            $cssName {
                background:#FFFFFF url(dawn.jpg) no-repeat center;
            }
            </style>
            ";
    		break;
    	case "morning":
    		echo "
            <style type=\"text/css\" media=\"screen\">
            $cssName {
                background:#FFFFFF url(morning.jpg) no-repeat center;
            }
            </style>
            ";
    		break;
    	case "afternoon":
    		echo "
            <style type=\"text/css\" media=\"screen\">
            $cssName {
                background:#FFFFFF url(afternoon.jpg) no-repeat center;
            }
            </style>
            ";
    		break;
    	case "dusk":
    		echo "
            <style type=\"text/css\" media=\"screen\">
            $cssName {
                background:#FFFFFF url(dusk.jpg) no-repeat center;
            }
            </style>
            ";
    		break;
        case "evening":
    		echo "
            <style type=\"text/css\" media=\"screen\">
            $cssName {
                background:#FFFFFF url(evening.jpg) no-repeat center;
            }
            </style>
            ";
    		break;
        case "midnight":
    		echo "
            <style type=\"text/css\" media=\"screen\">
            $cssName {
                background:#FFFFFF url(midnight.jpg) no-repeat center;
            }
            </style>
            ";
    		break;
    	default:
    		echo "
            <style type=\"text/css\" media=\"screen\">
            $cssName {
                background-color:#000099;
            }
            </style>
            ";
    		break;
    }
}
?>