<!--#include file="./config.asp" -->
<!--#include file="./lang/common.asp" -->
<!--#include file="./lang/emot.asp" -->
<%
'******************************************************************************
'* $Id: detail.asp,v 1.14 2005/05/28 07:37:00 nold_dbv Exp $
'*
'* This program displays a post's detailed info, it also displays a list 
'* of all posts of the topic this post in and a reply form if necessary.
'******************************************************************************
'* Copyright (C) 2005 hanru
'*
'* This program is free software; you can redistribute it and/or modify
'* it under the terms of the GNU General Public License as published by
'* the Free Software Foundation; either version 2 of the License, or
'* (at your option) any later version.
'*
'* This program is distributed in the hope that it will be useful,
'* but WITHOUT ANY WARRANTY; without even the implied warranty of
'* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'* GNU General Public License for more details.
'*
'* You should have received a copy of the GNU General Public License
'* along with this program; if not, write to the Free Software
'* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
'*
'* Website: http://jgbbs.sourceforge.net/
'* Email:   hanru@users.sourceforge.net
'******************************************************************************
%>
<%
Call DBOpen()

Dim rsPost, rsBoard, sql, bname, bid, pid, rid
pid = Request.QueryString("pid")

' Check whether the BBS is closed
If Not CheckBBS() Then
    Call DoErrorMsg("")
End if

' Check whether the post is valid
If Not CheckPost(pid) Then
    Call DoErrorMsg("./default.asp")
End If

sql = "SELECT * FROM posts WHERE post_id=" & pid
sql = ParseSql(sql)
Set rsPost = dbConn.Execute(sql)

bid = rsPost("board_id").Value
rid = rsPost("post_rootid").Value

' Check if the board the post in is vaild
If Not CheckBoard(bid, "read") Then
    rsPost.Close
    Set rsPost = Nothing
    Call DoErrorMsg("./default.asp")
End If

sql = "SELECT board_name FROM boards WHERE board_id=" & bid
sql = ParseSql(sql)
Set rsBoard = dbConn.Execute(sql)
bname = rsBoard("board_name").Value
rsBoard.Close
Set rsBoard = Nothing

Call UpdatePost(pid)
Call UpdateOnline(GetUserName(), bid)
Call UpdateBoard(bid)
Call UpdateUser(GetUserName(), "active")

Call PageHeader(bname, "")
Call ShowNavNew(langReadPost)
%>
<ul>
  <li><span class="prefix"><%=langBoard%>&nbsp;:&nbsp;</span><a href="list.asp?bid=<%=bid%>"><%=bname%></a></li>
  <li><span class="prefix"><%=langId%>&nbsp;:&nbsp;</span><%=pid%></li>
  <li><span class="prefix"><%=langTitle%>&nbsp;:&nbsp;</span><%=HtmlEncode(rsPost("post_title").Value)%></li>
  <li><span class="prefix"><%=langAuthor%>&nbsp;:&nbsp;</span><%=HtmlEncode(rsPost("user_name").Value)%></li>
  <li><span class="prefix"><%=langPostedOn%>&nbsp;:&nbsp;</span><%Response.Write(ParseDateTime(rsPost("post_datetime").Value, "full"))%></li>
  <li><span class="prefix"><%=langEditedOn%>&nbsp;:&nbsp;</span><% If Not IsNull(rsPost("post_lastupdate").Value) Then Response.Write(ParseDateTime(rsPost("post_lastupdate").Value, "full")) End If %></li>
  <li><span class="prefix"><%=langRead%>&nbsp;:&nbsp;</span><%=rsPost("post_counter").Value%></li>
  <li><span class="prefix"><%=langManage%>&nbsp;:</span><% If UCase(GetUserName()) = UCase(rsPost("user_name")) Then %>
    <a href="post_edit.asp?pid=<%=pid%>" title="<%=langMsgEditPost%>"><%=langEdit%></a>&nbsp;<% End If %><% If CheckModerator(bid) = True Then %>
    <a href="post_delete.asp?pid=<%=pid%>" title="<%=langMsgDeletePost%>"><%=langDelete%></a>&nbsp;
    <a href="post_prime.asp?pid=<%=pid%>" title="<% If rsPost("post_isprime") = True Then Response.Write(langMsgPrimePost2) Else Response.Write(langMsgPrimePost1) End If %>"><%=langPrime%></a>&nbsp;<% If rsPost("post_parentid") = 0 Then %>
    <a href="post_pin.asp?pid=<%=pid%>" title="<% If rsPost("post_istop") = True Then Response.Write(langMsgPinTopic2) Else Response.Write(langMsgPinTopic1) End If %>"><%=langPin%></a>&nbsp;
    <a href="post_move.asp?pid=<%=pid%>" title="<%=langMsgMoveTopic%>"><%=langMove%></a><% End If %><% End If %>
  </li>
</ul>
<ul>
<%=UbbCode(rsPost("post_body"))%>
</ul>
<hr size="1">
<%
sql = "SELECT * FROM posts WHERE post_rootid=" & rid & " ORDER BY post_order ASC"
sql = ParseSql(sql)
rsPost.Close
rsPost.Open sql, dbConn, adOpenForwardOnly, adLockReadOnly, adCmdText

Call InShowAllPost(rsPost) 

rsPost.Close
Set rsPost = Nothing
%>
<hr size="1">
<ul>
  <span class="prefix"><%=langReply%></span>
</ul>
<%
If GetUserName = "" Then
    Response.Write("<ul>" & langErrNotLogin & "</ul>")
Else
    Call InShowReplyForm()
End If

Call PageFooter()
Call DBClose()
'**************************
'* End of program main body
'**************************

Function InShowAllPost(rsPost)
    Dim indent, out, length
    indent = 1
    Response.Write("<ul>" & Chr(10))
    Do While Not rsPost.EOF
        Do While indent <> rsPost("post_indent")
            If rsPost("post_indent") > indent Then
                Response.Write("<ul>" & Chr(10))
                indent = indent + 1
            Else 
                Response.Write("</ul>" & Chr(10))
                indent = indent - 1  
            End If  
        Loop
        If CInt(rsPost("post_id")) <> CInt(pid) Then
            ShowPost(rsPost)
        Else
            InShowCurrentPost(rsPost)
        End If
        rsPost.MoveNext
    Loop
    If indent <> 0 Then
        For i = 1 To indent
            Response.Write("</ul>")
        Next
    End If
End Function

Function InShowCurrentPost(rsPost)
    Dim length, out
    If CInt(rsPost("post_length")) = 0 Then
        length = " (" & langEmpty & ") "
    Else
        length = " (" & CStr(rsPost("post_length")) & "&nbsp;" & langChar & ") "
    End If
    out = "<li>"
    out = out & "<img src=""./images/current.gif"" alt=""current"">"
    If rsPost("post_isprime") = True Then
        out = out & "<img src=""./images/prime.gif"" alt=""prime"">&nbsp;"
    End If
    If IsNumeric(rsPost("post_emot")) Then
        out = out & "<img src=""./images/" & rsPost("post_emot") & ".gif"" alt=""" & rsPost("post_emot") & """>"
    End If
    out = out & HtmlEncode(rsPost("post_title")) & length
    If DateDiff("d", rsPost("post_datetime"), GetGMTDateTime()) < 2 Then
        out = out & "<img src=""./images/new.gif"" alt=""new"">"
    End If
    out = out & " (<a href=""./profile.asp?name=" & Server.URLEncode(rsPost("user_name")) & """>"
    out = out & "<strong>" & HtmlEncode(rsPost("user_name")) & "</strong></a> "
    If IsDate(rsPost("post_lastupdate")) Then
        out = out & "<del>" & ParseDateTime(rsPost("post_datetime"), "simple") & "</del> "
        out = out & "<ins>" & ParseDateTime(rsPost("post_lastupdate"), "simple") & "</ins>"
    Else
        out = out & ParseDateTime(rsPost("post_datetime"), "simple")
    End If
    out = out & " " & langRead & ":" & rsPost("post_counter") & ")"
    out = out & "</li>" & Chr(10)
    Response.Write(out)
End Function

Function InShowReplyForm()
%>
<table width="600" border="0" align="center" cellpadding="5" cellspacing="1" class="color_dark">
  <tr>
    <td class="color_medium"><div align="center"><strong><%=langReplyPost%></strong></div></td>
  </tr>
  <tr>
    <td class="color_light">
      <table width="100%" border="0">
        <form action="./reply.asp" method="post" name="postFrm" id="postFrm" onSubmit="OnFormPostSubmit();">
        <tr>
          <td align="right"><%=langUserName%>&nbsp;</td>
          <td>&nbsp;<% Response.Write(GetUserName()) %></td>
        </tr>
        <tr>
          <td align="right"><%=langTitle%>&nbsp;</td>
          <td><input name="title" type="text" id="title" size="60" maxlength="255"></td>
        </tr>
        <tr>
          <td align="right" valign="top"><%=langEmotion%>&nbsp;</td>
          <td>
<% ShowEmot(0) %>
          </td>
        </tr>
        <tr>
          <td align="right" valign="top"><%=langBody%>&nbsp;<br>(<%Response.Write(langMaximin & CStr(GetCfgItem("POST_MAXBYTE")/1024) & "KB")%>)</td>
          <td><textarea name="body" cols="60" rows="15" id="body"></textarea></td>
        </tr>
        <tr>
          <td align="right" valign="top">&nbsp;</td>
          <td>
            <input name="fid" type="hidden" value="<%=pid%>">
            <input name="post" type="hidden" value="yes">
            <input type="submit" name="Submit" value="<%=langSubmit%>">
            <input type="reset" name="Reset" value="<%=langReset%>">
          </td>
        </tr>
        </form>
      </table>
    </td>
  </tr>
</table>
<%
End Function
%>
