<!--#include file="../config.asp" -->
<!--#include file="../lang/common.asp" -->
<%
'******************************************************************************
'* $Id: user_admin.asp,v 1.2 2005/07/08 12:07:54 hanru Exp $
'*
'* This program allows administrators to view users' profile and admin all users.
'******************************************************************************
'* Copyright (C) 2005 hanru
'*
'* This program is free software; you can redistribute it and/or modify
'* it under the terms of the GNU General Public License as published by
'* the Free Software Foundation; either version 2 of the License, or
'* (at your option) any later version.
'*
'* This program is distributed in the hope that it will be useful,
'* but WITHOUT ANY WARRANTY; without even the implied warranty of
'* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'* GNU General Public License for more details.
'*
'* You should have received a copy of the GNU General Public License
'* along with this program; if not, write to the Free Software
'* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
'*
'* Website: http://jgbbs.sourceforge.net/
'* Email:   hanru@users.sourceforge.net
'******************************************************************************
%>
<%
Call DBOpen()

Call CheckAdmin()

Dim rsUser, rsGroup, sql, action, uid, groupId(255), groupName(255), i, j, result, userPerPage
uid = Request.QueryString("uid")
If Not IsNumeric(uid) Then
    uid = 0
End If
action = Request.QueryString("action")
result = False
userPerPage = 20

Select Case action
    Case "valid"    Call InUserValid(uid)
    Case "invalid"  Call InUserInvalid(uid)
    Case "group"    Call InUserGroup(uid)
End Select

sql = InSelectUserSql()
sql = ParseSql(sql)
Set rsUser = dbConn.Execute(sql)

sql = "SELECT group_alias, group_id FROM groups"
sql = ParseSql(sql)
Set rsGroup = dbConn.Execute(sql)

i = 0
While Not rsGroup.EOF
    i = i + 1
    groupId(i) = rsGroup("group_id")
    groupName(i) = rsGroup("group_alias")
    rsGroup.MoveNext
Wend
rsGroup.Close
Set rsGroup = Nothing

Call PageHeaderAdmin(langUserAdmin)
%>
<h2><%=langUserAdmin%></h2>
<h3><%=langIntroduction%></h3>
<p>&nbsp;<!-- introduction here --></p>
<form name="selUser" method="get" action="./user_admin.asp">
  <input type="text" name="name" size="20" maxlength="20">
  <select name="status">
    <option value=""><%=langStatus%></option>
    <option value="valid"><%=langValid%></option>
    <option value="invalid"><%=langInvalid%></option>
  </select>
  <select name="group">
    <option value=""><%=langGroup%></option><%
    For j = 1 To i %>
    <option value="<%=groupId(j)%>"><%=groupName(j)%></option><%
    Next %>  
  </select>
  <input type="submit" value="<%=langSearch%>">
</form>
<table width="100%"  border="0" cellspacing="1" cellpadding="5" class="color_dark">
  <tr class="color_medium">
    <td><%=langId%></td>
    <td><%=langUserName%></td>
    <td><%=langDateRegister%></td>
    <td><%=langStatus%></td>
    <td><%=langGroup%></td>
  </tr>
<%
While Not rsUser.EOF
%>
  <tr class="color_light">
    <td><%=rsUser("user_id")%></td>
    <td><%=rsUser("user_name")%></td>
    <td><%=FormatDateTime(rsUser("user_regtime"), 2)%></td>
    <td>
      <select name="status" onChange="javascript: window.location = options[selectedIndex].value">
        <option value="user_admin.asp?uid=<%=rsUser("user_id")%>&amp;action=valid&amp;name=<%=Request.QueryString("name")%>&amp;status=<%=Request.QueryString("status")%>&amp;group=<%=Request.QueryString("group")%>"<% If rsUser("user_valid") = True Then Response.Write(" selected") %>><%=langValid%></option>
        <option value="user_admin.asp?uid=<%=rsUser("user_id")%>&amp;action=invalid&amp;name=<%=Request.QueryString("name")%>&amp;status=<%=Request.QueryString("status")%>&amp;group=<%=Request.QueryString("group")%>"<% If rsUser("user_valid") = False Then Response.Write(" selected") %>><%=langInValid%></option>
      </select>
    </td>
    <form name="selGroup" method="post" action="./user_admin.asp?uid=<%=rsUser("user_id")%>&amp;action=group&amp;name=<%=Request.QueryString("name")%>&amp;status=<%=Request.QueryString("status")%>&amp;group=<%=Request.QueryString("group")%>">
    <td>
      <select name="gid"><%
    For j = 1 To i %>
        <option value="<%=groupId(j)%>"<% If CInt(rsUser("group_id")) = CInt(groupId(j)) Then Response.Write(" selected") %>><%=groupName(j)%></option><%
    Next %>
      </select>
      <input type="submit" value="<%=langModify%>">
    </td>
    </form>
  </tr>
<%
    rsUser.MoveNext
Wend
rsUser.Close
Set rsUser = Nothing
%>
</table>
<% If result Then Response.Write("<p class=""highlight""><strong>" & langMsgManipulateSuccess & "</strong></p>") %><%
Call PageFooterAdmin()

Call DBClose()
'**************************
'* End of program main body
'**************************

Function InSelectUserSql()
    Dim tmp, name, group, status
    name = UCase(Trim(Request.QueryString("name")))
    group = Request.QueryString("group")
    status = Request.QueryString("status")
    
    tmp = "SELECT * FROM users"
    If name <> "" Then
        tmp = tmp & " WHERE UCase(user_name) like '%" & name & "%'"
    End If
    If group <> "" Then
        If InStr(tmp, "WHERE") = 0 Then
            tmp = tmp & " WHERE group_id=" & group
        Else
            tmp = tmp & " AND group_id=" & group
        End If
    End If
    If status <> "" Then
        If status = "valid" Then
            status = True
        Else
            status = False
        End If
        If InStr(tmp, "WHERE") = 0 Then
            tmp = tmp & " WHERE user_valid=" & status
        Else
            tmp = tmp & " AND user_valid=" & status
        End If
    End If
    InSelectUserSql = tmp
End Function

Function InUserValid(uid)
    sql = "UPDATE users SET user_valid=True WHERE user_id=" & uid
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    result = True
End Function

Function InUserInvalid(uid)
    sql = "UPDATE users SET user_valid=False WHERE user_id=" & uid
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    result = True
End Function

Function InUserGroup(uid)
    Dim gid, rsTemp
    gid = Request.Form("gid")
    If Not IsNumeric(gid) Then
        gid = 0
    End If
    sql = "SELECT * FROM groups WHERE group_id=" & gid
    sql = ParseSql(sql)
    Set rsTemp = dbConn.Execute(sql)
    If rsTemp.EOF Then
        rsTemp.Close
        Set rsTemp = Nothing
        Exit Function
    End If
    sql = "UPDATE users SET group_id=" & gid & " WHERE user_id=" & uid
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    result = True
End Function
%>
