<!--#include file="../config.asp" -->
<!--#include file="../lang/common.asp" -->
<%
'******************************************************************************
'* $Id: tool_sql.asp,v 1.3 2005/05/01 10:18:43 hanru Exp $
'*
'* This program allows user to enter SQL statement and execute it, 
'* results are returned in a table if necessary.
'******************************************************************************
'* Copyright (C) 2005 hanru
'*
'* This program is free software; you can redistribute it and/or modify
'* it under the terms of the GNU General Public License as published by
'* the Free Software Foundation; either version 2 of the License, or
'* (at your option) any later version.
'*
'* This program is distributed in the hope that it will be useful,
'* but WITHOUT ANY WARRANTY; without even the implied warranty of
'* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'* GNU General Public License for more details.
'*
'* You should have received a copy of the GNU General Public License
'* along with this program; if not, write to the Free Software
'* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
'*
'* Website: http://jgbbs.sourceforge.net/
'* Email:   hanru@users.sourceforge.net
'******************************************************************************
%>
<%
Call DBOpen()

Call CheckAdmin()
Call PageHeaderAdmin(langSqlQuery)
%>
<h2><%=langSqlQuery%></h2>
<h3><%=langIntroduction%></h3>
<p>&nbsp;<!-- introduction here --></p>
<form name="sqlQuery" method="post" action="./tool_sql.asp">
  <p>
    <textarea name="sql" cols="60" rows="5"><%=Request.Form("sql")%></textarea>
  </p>
  <p>
    <input name="reConfig" type="checkbox" id="reConfig" value="yes">
    <label for="reConfig"><%=langRestoreConfig%></label>
  </p>
  <p>
    <input type="submit" name="sqlResult" value="<%=langExecuteSql%>">
    &nbsp;
    <input type="submit" name="sqlExecute" value="<%=langExecuteSqlNoResult%>">
    <input name="execute" type="hidden" value="yes">
  </p>
</form>
<%
If Request.Form("execute") = "yes" Then
%>
<h3><%=langExecuteResult%></h3>
<%
    If Request.Form("reConfig") = "yes" Then
        Application.Lock()
        Application(unique & "CONFIGED") = "NO"
        Application.UnLock()
    End If
    
    If Request.Form("sqlResult") <> "" Then
        Call InSqlResult()
    ElseIf Request.Form("sqlExecute") <> "" Then
        Call InSqlExecute()
    End If
%>
<%
End If

Call PageFooterAdmin()

Call DBClose()
'**************************
'* End of program main body
'**************************

Function InSqlResult()
    Dim rs, sql
    sql = Request.Form("sql")
    sql = ParseSql(sql)
    Set rs = Server.CreateObject("ADODB.Recordset")
    On Error Resume Next
    rs.Open sql, dbConn, adOpenKeyset, adLockReadOnly
    If dbConn.Errors.Count <> 0 Then
        Response.Write("<p><span class=""highlight"">" & langFailed & "</span></p>" & Chr(10))
        For Each x In dbConn.Errors
            Response.Write("<p>" & langDescription & ": " & x.Description & "</p>" & Chr(10))
        Next
        dbConn.Errors.Clear
    Else
        Response.Write("<p><span class=""highlight"">" & langSuccess & "</span></p>")
        Call InShowSqlResult(rs)
    End If  
    rs.Close
    Set rs = Nothing
End Function

Function InSqlExecute()
    Dim sql
    sql = Request.Form("sql")
    sql = ParseSql(sql)
    On Error Resume Next
    dbConn.Execute(sql)
    ' Error(s) occured
    If dbConn.Errors.Count <> 0 Then
        Response.Write("<p><span class=""highlight"">" & langFailed & "</span></p>" & Chr(10))
        For Each x In dbConn.Errors
            Response.Write("<p>" & langDescription & ": " & x.Description & "</p>" & Chr(10))
        Next
        dbConn.Errors.Clear
    Else
        Response.Write("<p><span class=""highlight"">" & langSuccess & "</span></p>")
    End If
End Function

Function InShowSqlResult(rs)
%>
<table border="0" cellspacing="1" cellpadding="5" class="color_dark">
  <tr class="color_medium">
<%
For Each x In rs.Fields
    Response.Write("    <td>" & x.Name & "</td>" & Chr(10))
Next
%>
  </tr>
<%
While Not rs.EOF
    Response.Write("  <tr class=""color_light"">" & Chr(10))
    For Each x In rs.Fields
        Response.Write("    <td>" & x.Value & "</td>" & Chr(10))
    Next
    Response.Write("  </tr>" & Chr(10))
    rs.MoveNext
Wend
%>
</table>
<%
    Response.Write("<strong>" & rs.RecordCount & "</strong>&nbsp;" & langRecord)
End Function
%>
