<!--#include file="../config.asp" -->
<!--#include file="../lang/common.asp" -->
<%
'******************************************************************************
'* $Id: cfg_general.asp,v 1.1 2005/07/11 10:58:19 hanru Exp $
'*
'* This program allows administrators to modify BBS's general configurations.
'******************************************************************************
'* Copyright (C) 2005 hanru
'*
'* This program is free software; you can redistribute it and/or modify
'* it under the terms of the GNU General Public License as published by
'* the Free Software Foundation; either version 2 of the License, or
'* (at your option) any later version.
'*
'* This program is distributed in the hope that it will be useful,
'* but WITHOUT ANY WARRANTY; without even the implied warranty of
'* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'* GNU General Public License for more details.
'*
'* You should have received a copy of the GNU General Public License
'* along with this program; if not, write to the Free Software
'* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
'*
'* Website: http://jgbbs.sourceforge.net/
'* Email:   hanru@users.sourceforge.net
'******************************************************************************
%>
<%
Call DBOpen()

Call CheckAdmin()

Dim result, arrayTimezone, arrayLang, arrayTemplate, i
result = False
arrayTimezone = Array(-12, -11, -10, -9, -8, -7, -6, -5, -4, -3.5, -3, -2, -1, 0, 1, 2, 3, 3.5, 4, 4.5, 5, 5.5, 6, 6.5, 7, 8, 9, 9.5, 10, 11, 12, 13)

Call InGetLang()
Call InGetTemplate()

If Request.Form("is_update") = "yes" Then
    Call InBBSUpdate()
End If

Call PageHeaderAdmin(langConfigGeneral)
%>
<h2><%=langConfigGeneral%></h2>
<h3><%=langIntroduction%></h3>
<p>&nbsp;<!-- introduction here --></p>

<form name="cfgFrm" method="post" action="./cfg_general.asp">
<fieldset style="width: 95%;">
<legend><%=langProfile%></legend>
<table width="100%" border="0" cellspacing="1" cellpadding="5">
  <tr>
    <td width="150"><%=langBBSVersion%></td>
    <td><input value="<%=GetCfgItem("VERSION")%>" class="inputbox" disabled style="width: 300px;"></td>
  </tr>
  <tr>
    <td width="150"><%=langBBSName%></td>
    <td><input name="bbsname" value="<%=GetCfgItem("BBS_NAME")%>" class="inputbox" style="width: 300px;"></td>
  </tr>
  <tr>
    <td width="150"><%=langCopyrightInfo%></td>
    <td><input name="copyright" value="<%=GetCfgItem("COPYRIGHT")%>" class="inputbox" style="width: 300px;"></td>
  </tr>
</table>
</fieldset>

<fieldset style="width: 95%;">
<legend><%=langInterface%></legend>
<table width="100%" border="0" cellspacing="1" cellpadding="5">
  <tr>
    <td width="150"><%=langLanguage%></td>
    <td>
      <select name="lang"><%
For Each i In arrayLang %>
        <option value="<%=i%>"<% If GetCfgItem("LANGUAGE") = i Then Response.Write(" selected") %>><%=i%></option><%
Next %>
      </select>
    </td>
  </tr>
  <tr>
    <td><%=langTemplate%></td>
    <td>
      <select name="template"><%
For Each i In arrayTemplate %>
        <option value="<%=i%>"<% If GetCfgItem("TEMPLATE") = i Then Response.Write(" selected") %>><%=i%></option><%
Next %>
      </select>
    </td>
  </tr>
</table>
</fieldset>

<fieldset style="width: 95%;">
<legend><%=langTime%></legend>
<table width="100%" border="0" cellspacing="1" cellpadding="5">
  <tr>
    <td width="150"><%=langTimezone%></td>
    <td>
      <select name="timezone"><%
For Each i In arrayTimezone %>
        <option value="<%=i%>"<% If GetCfgItem("TIME_ZONE") = CStr(i) Then Response.Write(" selected") %>><%=langGMT%>&nbsp;<%
    If i > 0 Then
        Response.Write("+")
    End If
    If i <> 0 Then
        Response.Write(i & " " & langHour)
    End If %></option><%
Next %>
      </select>
  </tr>
  <tr>
    <td><%=langTimeScript%></td>
    <td><input name="script_timeout" value="<%=GetCfgItem("SCRIPT_TIMEOUT")%>" class="inputbox" style="width: 30px;">&nbsp;<%=langSecond%></td>
  </tr>
  <tr>
    <td><%=langTimeCookie%></td>
    <td><input name="cookie_timeout" value="<%=GetCfgItem("COOKIE_TIMEOUT")%>" class="inputbox" style="width: 30px;">&nbsp;<%=langDay%></td>
  </tr>
  <tr>
    <td><%=langTimeOnline%></td>
    <td><input name="online_timeout" value="<%=GetCfgItem("ONLINE_TIMEOUT")%>" class="inputbox" style="width: 30px;">&nbsp;<%=langMinute%></td>
  </tr>
  <tr>
    <td width="150"><%=langTimeJump%></td>
    <td><input name="jump_timer" value="<%=GetCfgItem("JUMP_TIMER")%>" class="inputbox" style="width: 30px;">&nbsp;<%=langSecond%></td>
  </tr>
</table>
</fieldset>
<p align="center">
  <input name="is_update" type="hidden" value="yes">
  <input name="Submit" type="submit" value="<%=langSubmit%>">
  <input name="Reset" type="reset" value="<%=langReset%>">
</p>
</form>

<% If result Then Response.Write("<p class=""highlight""><strong>" & langMsgManipulateSuccess & "</strong></p>") %><%
Call PageFooterAdmin()

Call DBClose()
'**************************
'* End of program main body
'**************************

Function InGetLang()
    Dim path, fso, f, sf, fl, names
    path = Server.MapPath("../lang/")
    names = ""
    
    Set fso = Server.CreateObject("Scripting.FileSystemObject")
    Set f = fso.GetFolder(path)
    Set sf = f.SubFolders
    For Each fl In sf
        If names = "" Then
            names = fl.Name
        Else
            names = names & "," & fl.Name
        End If
    Next
    
    arrayLang = Split(names, ",")
End Function

Function InGetTemplate()
    Dim path, fso, f, sf, fl, names
    path = Server.MapPath("../template/")
    names = ""
    
    Set fso = Server.CreateObject("Scripting.FileSystemObject")
    Set f = fso.GetFolder(path)
    Set sf = f.SubFolders
    For Each fl In sf
        If names = "" Then
            names = fl.Name
        Else
            names = names & "," & fl.Name
        End If
    Next
    
    arrayTemplate = Split(names, ",")
End Function

'************************************************
'* Parameters pass from Request.Form
'*   | bbsname BBS_NAME
'*   | copyright COPYRIGHT
'*   | lang LANGUAGE
'*   | template TEMPLATE
'*   | timezone TIME_ZONE
'*   | script_timeout SCRIPT_TIMEOUT
'*   | cookie_timeout COOKIE_TIMEOUT
'*   | online_timeout ONLINE_TIMEOUT
'*   | jump_timer JUMP_TIMER
'************************************************
Function InBBSUpdate()
    Dim bbsname, copyright, lang, template, timezone, script_to, cookie_to, online_to, jump
    bbsname = Request.Form("bbsname")
    copyright = Request.Form("copyright")
    lang = Request.Form("lang")
    template = Request.Form("template")
    timezone = Request.Form("timezone")
    script_to = Request.Form("script_timeout")
    cookie_to = Request.Form("cookie_timeout")
    online_to = Request.Form("online_timeout")
    jump = Request.Form("jump_timer")
    ' TODO: check the validity of parameters
    
    Call UpdateCfgItem("BBS_NAME", bbsname)
    Call UpdateCfgItem("COPYRIGHT", copyright)
    Call UpdateCfgItem("LANGUAGE", lang)
    Call UpdateCfgItem("TEMPLATE", template)
    Call UpdateCfgItem("SCRIPT_TIMEOUT", script_to)
    Call UpdateCfgItem("COOKIE_TIMEOUT", cookie_to)
    Call UpdateCfgItem("ONLINE_TIMEOUT", online_to)
    Call UpdateCfgItem("JUMP_TIMER", jump)
    Call UpdateCfgItem("TIME_ZONE", timezone)
    
    result = True
End Function
%>
