<!--#include file="../config.asp" -->
<!--#include file="../lang/common.asp" -->
<%
'******************************************************************************
'* $Id: board_moderator.asp,v 1.1 2005/07/02 12:11:16 hanru Exp $
'*
'* This program allows administrators to add, remove, assign moderators for a
'* specific board.
'* Select a board first if no parameter found.
'******************************************************************************
'* Copyright (C) 2005 hanru
'*
'* This program is free software; you can redistribute it and/or modify
'* it under the terms of the GNU General Public License as published by
'* the Free Software Foundation; either version 2 of the License, or
'* (at your option) any later version.
'*
'* This program is distributed in the hope that it will be useful,
'* but WITHOUT ANY WARRANTY; without even the implied warranty of
'* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'* GNU General Public License for more details.
'*
'* You should have received a copy of the GNU General Public License
'* along with this program; if not, write to the Free Software
'* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
'*
'* Website: http://jgbbs.sourceforge.net/
'* Email:   hanru@users.sourceforge.net
'******************************************************************************
%>
<%
Call DBOpen()

Call CheckAdmin()

Dim bid, result

result = False
bid = Request.QueryString("bid")
If Not IsNumeric(bid) Then
    bid = 0
End If

Call PageHeaderAdmin(langModeratorAdmin)
%>
<h2><%=langModeratorAdmin%></h2>
<h3><%=langIntroduction%></h3>
<p>&nbsp;<!-- introduction here --></p>
<script language="javascript" src="../inc/selectbox.js"></script>
<%
If IsEmpty(bid) Then
    Call InSelectBoard()
ElseIf Request.Form("is_submit") = "yes" Then
    Call InUpdateModerator(bid)
Else
    Call InSelectModerator(bid)
End If

Call PageFooterAdmin()

Call DBClose()
'**************************
'* End of program main body
'**************************

Function InSelectBoard()
    Dim rsBoard, sql
    sql = "SELECT board_id, board_name FROM boards ORDER BY board_order ASC"
    sql = ParseSql(sql)
    Set rsBoard = dbConn.Execute(sql)
%>
<form name="selboard" method="get" action="./board_moderator.asp">
  <select name="bid"><%
    While Not rsBoard.EOF %>
    <option value="<%=rsBoard("board_id")%>"><%=rsBoard("board_name")%></option><%
        rsBoard.MoveNext
    Wend
    rsBoard.Close
    Set rsBoard = Nothing %>
  </select>
  <input type="submit" value="<%=langContinue%>">
</form>
<%
End Function

Function InSelectModerator(bid)
    Dim rsBoard, rsModSel, rsModAvail, sql, bname
    sql = "SELECT board_name FROM boards WHERE board_id=" & bid
    sql = ParseSql(sql)
    Set rsBoard = dbConn.Execute(sql)
    If rsBoard.EOF Then
        rsBoard.Close
        Set rsBoard = Nothing
        Call InSelectBoard()
    Else
        bname = rsBoard(0)
        rsBoard.Close
        Set rsBoard = Nothing
    End If
    sql = "SELECT user_name FROM moderators WHERE board_id=" & bid
    sql = ParseSql(sql)
    Set rsModSel = dbConn.Execute(sql)
    sql = "SELECT user_name FROM users WHERE group_id>=3 AND user_name NOT IN (SELECT user_name FROM moderators WHERE board_id=" & bid & ")"
    sql = ParseSql(sql)
    Set rsModAvail = dbConn.Execute(sql)    
%>
<table>
<form name="selFrm" method="post" action="./board_moderator.asp?bid=<%=bid%>">
  <tr>
    <td><%=langModeratorCandidate%></td>
    <td width="100"></td>
    <td><%=(langModeratorCurrent & " (" & bname & ")")%></td>
  </tr>
  <tr>
    <td>
      <select name="available" size="10" multiple><%
        While Not rsModAvail.EOF %>
        <option value="<%=rsModAvail(0)%>"><%=rsModAvail(0)%></option><%
            rsModAvail.MoveNext
        Wend %>
      </select>
    </td>
    <td align="center">
      <input type="button" class="button" style="width:50px; " value=">>" onClick="javascript:moveAllOptions(document.selFrm.available, document.selFrm.selected, true)"><br /><br />
      <input type="button" class="button" style="width:50px; " value=">" onClick="javascript:moveSelectedOptions(document.selFrm.available, document.selFrm.selected, true)"><br /><br />
      <input type="button" class="button" style="width:50px; " value="<<" onClick="javascript:moveAllOptions(document.selFrm.selected, document.selFrm.available, true)"><br /><br />
      <input type="button" class="button" style="width:50px; " value="<" onClick="javascript:moveSelectedOptions(document.selFrm.selected, document.selFrm.available, true)"><br /><br />
    </td>
    <td>
      <select name="selected" size="10" multiple><%
        While Not rsModSel.EOF %>
        <option value="<%=rsModSel(0)%>"><%=rsModSel(0)%></option><%
            rsModSel.MoveNext
        Wend %>
      </select>
    </td>
  </tr>
  <tr>
    <td><input type="submit" value="<%=langSubmit%>" style="margin-top:5px; " onClick="javascript:selectAllOptions(document.selFrm.selected)"></td>
    <td></td>
    <td></td>    
  </tr>
  <input type="hidden" name="is_submit" value="yes">
</form>
</table>
<% If result Then Response.Write("<p class=""highlight""><strong>" & langMsgManipulateSuccess & "</strong></p>") %>
<%
End Function

Function InUpdateModerator(bid)
    ' New moderator names are stored in Form("selected") object, splitted by commas
    Dim rsUpdate, sql, allnames, names, x
    allnames = Request.Form("selected")
    If allnames = "" Then
        ' no moderator is set, then delete all current moderators
        sql = "DELETE FROM moderators WHERE board_id=" & bid
        sql = ParseSql(sql)
        dbConn.Execute(sql)
        result = True
        Call InSelectModerator(bid)
        Exit Function
    End If
    names = Split(allnames, ",")
    allnames = ""
    For Each x In names
        x = Trim(x)
        If allnames = "" Then
            allnames = "'" & x & "'"
        Else
            allnames = allnames & "," & "'" & x & "'"
        End If
    Next
    ' Delete those that are no longer moderators
    sql = "DELETE FROM moderators WHERE user_name NOT IN (" & allnames & ") AND board_id=" & bid
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    ' Add new moderators
    For Each x In names
        x = Trim(x)
        sql = "SELECT * FROM moderators WHERE user_name='" & x & "' AND board_id=" & bid
        sql = ParseSql(sql)
        Set rsUpdate = dbConn.Execute(sql)
        If rsUpdate.EOF Then
            ' This user name is not included in current moderators
            sql = "INSERT INTO moderators (user_name,board_id) VALUES ('" & x & "'," & bid & ")"
            sql = ParseSql(sql)
            dbConn.Execute(sql)
        End If
        rsUpdate.Close
        Set rsUpdate = Nothing
    Next
    result = True
    Call InSelectModerator(bid)
End Function
%>
