<!--#include file="../config.asp" -->
<!--#include file="../lang/common.asp" -->
<%
'******************************************************************************
'* $Id: board_admin.asp,v 1.3 2005/07/05 10:50:06 hanru Exp $
'*
'* This program allows administrators to admin all existing boards
'* and add a new board if necessary.
'******************************************************************************
'* Copyright (C) 2005 hanru
'*
'* This program is free software; you can redistribute it and/or modify
'* it under the terms of the GNU General Public License as published by
'* the Free Software Foundation; either version 2 of the License, or
'* (at your option) any later version.
'*
'* This program is distributed in the hope that it will be useful,
'* but WITHOUT ANY WARRANTY; without even the implied warranty of
'* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'* GNU General Public License for more details.
'*
'* You should have received a copy of the GNU General Public License
'* along with this program; if not, write to the Free Software
'* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
'*
'* Website: http://jgbbs.sourceforge.net/
'* Email:   hanru@users.sourceforge.net
'******************************************************************************
%>
<%
Call DBOpen()

Call CheckAdmin()

Dim rsBoard, rsModerator, rsGroup, sql, action, bid, result, groupId(255), groupName(255), i, j

bid = Request.QueryString("bid")
action = Request.QueryString("action")
result = False

Select Case action
    Case "up"          Call InBoardMoveUp(bid)
    Case "down"        Call InBoardMoveDown(bid)
    Case "valid"       Call InBoardValid(bid)
    Case "invalid"     Call InBoardInvalid(bid)
    Case "add"         Call InBoardAdd()
    Case "permission"  Call InBoardPermission(bid)
End Select

sql = "SELECT * FROM boards ORDER BY board_order ASC"
sql = ParseSql(sql)
Set rsBoard = dbConn.Execute(sql)

sql = "SELECT group_alias, group_id FROM groups"
sql = ParseSql(sql)
Set rsGroup = dbConn.Execute(sql)

i = 0
While Not rsGroup.EOF
    i = i + 1
    groupId(i) = rsGroup("group_id")
    groupName(i) = rsGroup("group_alias")
    rsGroup.MoveNext
Wend
rsGroup.Close
Set rsGroup = Nothing

Call PageHeaderAdmin(langBoardAdmin)
%>
<h2><%=langBoardAdmin%></h2>
<h3><%=langIntroduction%></h3>
<p>&nbsp;<!-- introduction here --></p>
<table border="0" cellspacing="1" cellpadding="5" class="color_dark">
  <tr class="color_medium">
    <td><%=langId%></td>
    <td><%=langBoard%></td>
    <td><%=langStatus%></td>
    <td><%=langModerator%></td>
    <td><%=langPermission%> ( <%=langRead%>&nbsp;|&nbsp;<%=langPosting%>&nbsp;|&nbsp;<%=langSpecial%> ) </td>
    <td><%=langPosition%></td>
  </tr>
<%
While Not rsBoard.EOF
%>
  <tr class="color_light">
    <td nowrap><%=rsBoard("board_id")%></td>
    <td nowrap><%=rsBoard("board_name")%></td>
    <td nowrap>
      <select name="status" onChange="javascript: window.location = options[selectedIndex].value">
        <option value="board_admin.asp?bid=<%=rsBoard("board_id")%>&amp;action=valid"<% If rsBoard("board_valid") = True Then Response.Write(" selected") %>><%=langValid%></option>
        <option value="board_admin.asp?bid=<%=rsBoard("board_id")%>&amp;action=invalid"<% If rsBoard("board_valid") = False Then Response.Write(" selected") %>><%=langInValid%></option>
      </select>
    </td>
    <td nowrap>
      <select name="moderator"><%
    sql = "SELECT user_name FROM moderators WHERE board_id=" & rsBoard("board_id")
    sql = ParseSql(sql)
    Set rsModerator = dbConn.Execute(sql)
    While Not rsModerator.EOF %>
        <option value=""><%=rsModerator(0)%></option><%
        rsModerator.MoveNext
    Wend
    rsModerator.Close %>
      </select>
      <a href="./board_moderator.asp?bid=<%=rsBoard("board_id")%>"><%=langManage%></a>
    </td>
    <form name="modFrm" method="post" action="./board_admin.asp?action=permission&amp;bid=<%=rsBoard("board_id")%>">
    <td nowrap>
      <select name="read"><%
    For j = 1 To i %>
        <option value="<%=groupId(j)%>"<% If CInt(rsBoard("board_allow_read")) = CInt(groupId(j)) Then Response.Write(" selected") %>><%=groupName(j)%></option><%
    Next %>
      </select>
      <select name="write"><%
    For j = 1 To i %>
        <option value="<%=groupId(j)%>"<% If CInt(rsBoard("board_allow_write")) = CInt(groupId(j)) Then Response.Write(" selected") %>><%=groupName(j)%></option><%
    Next %>
      </select>
      <select name="execute"><%
    For j = 1 To i %>
        <option value="<%=groupId(j)%>"<% If CInt(rsBoard("board_allow_execute")) = CInt(groupId(j)) Then Response.Write(" selected") %>><%=groupName(j)%></option><%
    Next %>
      </select>
      <input type="submit" value="<%=langModify%>">
    </td>
    </form>
    <td nowrap><a href="./board_admin.asp?bid=<%=rsBoard("board_id")%>&amp;action=up"><%=langMoveUp%></a>&nbsp;&nbsp;<a href="./board_admin.asp?bid=<%=rsBoard("board_id")%>&amp;action=down"><%=langMoveDown%></a></td>
  </tr>
<%
    rsBoard.MoveNext
Wend
rsBoard.Close
Set rsBoard = Nothing
Set rsModerator = Nothing
%>
</table>
<p>
<form name="boardAdd" method="post" action="./board_admin.asp?action=add">
  <input name="bname" type="text" id="bname" size="50" maxlength="50">
  <input type="submit" value="<%=langBoardAdd%>">
</form>
</p>
<% If result Then Response.Write("<p class=""highlight""><strong>" & langMsgManipulateSuccess & "</strong></p>") %>
<%
Call PageFooterAdmin()

Call DBClose()
'**************************
'* End of program main body
'**************************

Function InBoardMoveUp(bid)
    If Not IsNumeric(bid) Then
        Exit Function
    End if
    Dim rsTemp, sql, orderOld, orderNew, bidNew
    sql = "SELECT board_order FROM boards WHERE board_id=" & bid
    sql = ParseSql(sql)
    Set rsTemp = dbConn.Execute(sql)
    If rsTemp.EOF Then
        rsTemp.Close
        Set rsTemp = Nothing
        Exit Function
    End If
    orderOld = rsTemp(0)
    rsTemp.Close
    ' get the new board order of required board
    sql = "SELECT TOP 1 board_order, board_id FROM boards WHERE board_order<" & orderOld & " ORDER BY board_order DESC"
    sql = ParseSql(sql)
    Set rsTemp = dbConn.Execute(sql)
    If rsTemp.EOF Then
        rsTemp.Close
        Set rsTemp = Nothing
        Exit Function
    End If
    orderNew = rsTemp("board_order")
    bidNew = rsTemp("board_id")
    rsTemp.Close
    Set rsTemp = Nothing
    ' update the board order of required board
    sql = "UPDATE boards SET board_order=" & orderNew & " WHERE board_id=" & bid
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    ' update the board order of the affected board
    sql = "UPDATE boards SET board_order=" & orderOld & " WHERE board_id=" & bidNew
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    result = True
End Function

Function InBoardMoveDown(bid)
    If Not IsNumeric(bid) Then
        Exit Function
    End if
    Dim rsTemp, sql, orderOld, orderNew, bidNew
    sql = "SELECT board_order FROM boards WHERE board_id=" & bid
    sql = ParseSql(sql)
    Set rsTemp = dbConn.Execute(sql)
    If rsTemp.EOF Then
        rsTemp.Close
        Set rsTemp = Nothing
        Exit Function
    End If
    orderOld = rsTemp(0)
    rsTemp.Close
    ' get the new board order of required board
    sql = "SELECT TOP 1 board_order, board_id FROM boards WHERE board_order>" & orderOld & " ORDER BY board_order ASC"
    sql = ParseSql(sql)
    Set rsTemp = dbConn.Execute(sql)
    If rsTemp.EOF Then
        rsTemp.Close
        Set rsTemp = Nothing
        Exit Function
    End If
    orderNew = rsTemp("board_order")
    bidNew = rsTemp("board_id")
    rsTemp.Close
    Set rsTemp = Nothing
    ' update the board order of required board
    sql = "UPDATE boards SET board_order=" & orderNew & " WHERE board_id=" & bid
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    ' update the board order of the affected board
    sql = "UPDATE boards SET board_order=" & orderOld & " WHERE board_id=" & bidNew
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    result = True
End Function

Function InBoardValid(bid)
    If Not IsNumeric(bid) Then
        Exit Function
    End If
    Dim rsTemp, sql
    sql = "SELECT board_valid FROM boards WHERE board_id=" & bid
    sql = ParseSql(sql)
    Set rsTemp = dbConn.Execute(sql)
    If rsTemp.EOF Then
        rsTemp.Close
        Set rsTemp = Nothing
        Exit Function
    End If
    rsTemp.Close
    Set rsTemp = Nothing
    sql = "UPDATE boards SET board_valid=True WHERE board_id=" & bid
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    result = True
End Function

Function InBoardInvalid(bid)
    If Not IsNumeric(bid) Then
        Exit Function
    End If
    Dim rsTemp, sql
    sql = "SELECT board_valid FROM boards WHERE board_id=" & bid
    sql = ParseSql(sql)
    Set rsTemp = dbConn.Execute(sql)
    If rsTemp.EOF Then
        rsTemp.Close
        Set rsTemp = Nothing
        Exit Function
    End If
    rsTemp.Close
    Set rsTemp = Nothing
    sql = "UPDATE boards SET board_valid=False WHERE board_id=" & bid
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    result = True
End Function

Function InBoardAdd()
    Dim rsTemp, sql, bname, border
    bname = Request.Form("bname")
    If bname = "" Then
        Exit Function
    End If
    ' get the maximum order integer of existing board(s)
    ' then calculate the new board order
    sql = "SELECT TOP 1 board_order FROM boards ORDER BY board_order DESC"
    sql = ParseSql(sql)
    Set rsTemp = dbConn.Execute(sql)
    If rsTemp.EOF Then
        border = 1
    Else
        border = rsTemp(0) + 1
    End If
    rsTemp.Close
    Set rsTemp = Nothing
    sql = "INSERT INTO boards (board_name, board_order) VALUES ('" & bname & "'," & border & ")"
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    result = True
End Function

Function InBoardPermission(bid)
    If Not IsNumeric(bid) Then
        Exit Function
    End If
    Dim perRead, perWrite, perExecute
    perRead = Request.Form("read")
    If Not IsNumeric(perRead) Then
        perRead = 0
    End If
    perWrite = Request.Form("write")
    If Not IsNumeric(perWrite) Then
        perWrite = 1
    End If
    perExecute = Request.Form("execute")
    If Not IsNumeric(perExecute) Then
        perExecute = 2
    End If
    ' TODO: check the validity of thest three integers, that is, if they are valid group id
    sql = "UPDATE boards SET board_allow_read=" & perRead & ", board_allow_write=" & perWrite & ", board_allow_execute=" & perExecute & " WHERE board_id=" & bid
    sql = ParseSql(sql)
    dbConn.Execute(sql)
    result = True
End Function
%>
