<%
' ---------------------------------------------------
'                    aspXML v1.0
' ---------------------------------------------------
'  Copyright(c) 2002 KattanWeb.com
'  This notice MUST not be removed.
' ---------------------------------------------------
' Author: Rami Kattan
' Web Site: http://www.kattanweb.com/webdev
' Email:  aspXML@kattanweb.8k.com
' Date:   July 3, 2002
'
' This class with make easy the construction of XML
' files using simple ASP, without any components.
'
' Features:
'  - Keep track of opened tags, and closing will close
'    last open one.
'  - Can open tags with attributes passed as string
'  - Automatic format for tag names with special characters.
'  - Automatic check if data inside the tag need CData or no.
'  - Can add Date using XSL date format.
' ---------------------------------------------------

class aspXML
	Private top				'Stack current element
	Private TagArray()		'Stack of tags
	Private XML				'XML code

    '>>>>>>>> Setup Initialize event, called automtially when creating an instant of this class using
	'	      Set MyXML = new aspXML
	Private Sub Class_Initialize
		Redim TagArray(10)
		top = -1
		XML = "<?xml version=""1.0"" encoding=""ISO-8859-1""?>" & vbCrLf
	End Sub

    '>>>>>>>> Setup Terminate event, called automtially when killing an instant of this class using
	'	      Set MyXML = nothing
	Private Sub Class_Terminate
		top = null
		XML = null
		Erase TagArray
	End Sub
	
    '>>>>>>>> Reset the class, as if it was just created, Use with care
	Public Function Reset
		call Class_Terminate
		call Class_Initialize
	End Function

    '>>>>>>>> Open a new element tag
	Public Function OpenTag(tagName)
		tagName = FormatXML(tagName)
		top = top + 1
		if top > ubound(TagArray) then
			ReDim Preserve TagArray(ubound(TagArray) + 10)
		end if
		TagArray(top) = tagName
		XML = XML & "<" & tagName & ">"
		if top = 0 then	XML = XML & vbCrLf 'Code format, root tag is on separate line
	end function

    '>>>>>>>> Opens a new tag, add the data, and close the tag
	Public Function QuickTag(tagName, Data)
		tagName = FormatXML(tagName)
		XML = XML & "<" & tagName & ">" & CheckString(Data) & "</" & tagName & ">" & vbCrLf
	end function

    '>>>>>>>> Put an empty tag, uses less code than opening and closing a normal tag (in case, if needed :)
	Public Function EmptyTag(tagName)
		tagName = FormatXML(tagName)
		XML = XML & "<" & tagName & " />" & vbCrLf
	end function
	
    '>>>>>>>> Add an attribute to the last open tag (can be used before or after adding data)
	Public Function AddAttribute(attribName, attribValue)
		lastTag = inStrRev(XML, ">")
		TextRemoved = Right(XML, len(XML) - lastTag)
		XML = Left(XML, lastTag - 1)
		XML = XML & " " & FormatXML(attribName) & "=""" & attribValue & """>"
		XML = XML & TextRemoved
	End function

    '>>>>>>>> Add data to current open tag (automatic check if need CDATA or no)
	Public Function AddData(Data)
		XML = XML & CheckString(Data)
	end function

    '>>>>>>>> Add data to current open tag, formated as XSL date
	Public Function AddDate(strDate)
		if isDate(strDate) then
			strDate = cDate(strDate)
			XML = XML & year(strDate) & "-" & LeadingZero(month(strDate), 2) & "-" & LeadingZero(day(strDate),2) & "T" & LeadingZero(Hour(strDate),2) & ":" & LeadingZero(Minute(strDate),2) & ":" & LeadingZero(Second(strDate),2)
		end if
	end function

    '>>>>>>>> Add Comment in the current location
	Public Function AddComment(Data)
		XML = XML & "<!--" & Data & "-->"
	end function

	'>>>>>>>> Close last open tag
	Public Function CloseTag()
		tagName = TagArray(top)
		XML = XML & "</" & tagName & ">" & vbCrLf
		top = top - 1
	end function

    '>>>>>>>> Close all open tags, including main root tag
	'after calling this function, it is not recomended opening new
	'tags as XML can only have 1 root element
	Public Function CloseAllTags()
		while (top >= 0)
			tagName = TagArray(top)
			XML = XML & "</" & tagName & ">" & vbCrLf
			top = top - 1
		wend
	end function

    '>>>>>>>> Returns the XML final code
	Public Function GetXML()
		GetXML = XML
	end function

'---------------------------------------------------------------
' Special internal functions
'---------------------------------------------------------------

    '>>>>>>>> Format the tag name if contains special characters
	Private function FormatXML(data)
		if isNumeric(left(data,1)) then
			data = FormatNumericXML(data)
		end if
		data = replace(data, "?", "_x003F_")
		data = replace(data, " ", "_x0020_")
		data = replace(data, "/", "_x002F_")
		data = replace(data, "=", "_x003D_")
		data = replace(data, "%", "_x0025_")
		data = replace(data, "\", "_x005C_")
		data = replace(data, "~", "_x007E_")
		data = replace(data, "@", "_x0040_")
		data = replace(data, "#", "_x0023_")
		data = replace(data, "$", "_x0024_")
		data = replace(data, "%", "_x0025_")
		data = replace(data, "^", "_x005E_")
		data = replace(data, "&", "_x0026_")
		data = replace(data, "*", "_x002A_")
		data = replace(data, "(", "_x0028_")
		data = replace(data, ")", "_x0029_")
		data = replace(data, "+", "_x002B_")
		data = replace(data, "{", "_x007B_")
		data = replace(data, "}", "_x007D_")
		data = replace(data, "|", "_x007C_")
		data = replace(data, "'", "_x0027_")
		data = replace(data, "<", "_x003C_")
		data = replace(data, ">", "_x003E_")
		data = replace(data, ",", "_x002C_")
		data = replace(data, ";", "_x003B_")
   		FormatXML = data
	end function

    '>>>>>>>> Format the tag name if starts with digit
	Private function FormatNumericXML(data)
		StrLeft = Left(data, 1)
		StrRight = Right(data, (len(data) - 1))
		ReturnValue = "_x003" & StrLeft & "_" & StrRight
		FormatNumericXML = ReturnValue
	end function

    '>>>>>>>> Format the data with or without CData
	Private function CheckString(data)
		need = false
		if instr(data, "<") then need = true
		if instr(data, "&") then need = true
		if need then
			CheckString = "<![CDATA[" & data & "]]>"
		else
			CheckString = data
		end if
	end function

    '>>>>>>>> Leading Zeros function, for AddDate function
	Private Function LeadingZero(data, numdigits)
		while len(data) < numdigits
			data = "0" & data
		wend
		LeadingZero = data
	End Function

end class
%>