<?xml version="1.0" encoding="utf-8" ?>

<!--   Paul Millar - GrabNews
*    Copyright (C) 2001 - 2005 Paul Millar
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
*   dazzle@edazzle.net
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" encoding="utf-8" omit-xml-declaration="yes" indent="yes"/>

<xsl:template match="*">
<table border="1" align="center">
<tr><td valign="top" align="center" class="title" width="200" bgcolor="silver" >
<a>
<xsl:attribute name="href">
<xsl:for-each select="*[local-name()='link'] | *[local-name()='channel']/*[local-name()='link']">
<xsl:choose>
<xsl:when test="@rel='alternate'">
<xsl:value-of disable-output-escaping="yes" select="./@href"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of disable-output-escaping="yes" select="."/>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:attribute>
<xsl:value-of disable-output-escaping="yes" select="*[local-name()='channel']/*[local-name()='title'] | *[local-name()='title']"/>
</a>
</td></tr><tr><td valign="top" bgcolor="ghostwhite" class="headlines" width="200">
<ul>
<xsl:for-each select="//*[local-name()='item'] | //*[local-name()='entry']">
<xsl:if test="position() &lt; 10">
<li>
<a target="_top">
<xsl:attribute name="href">
<xsl:for-each select="*[local-name()='link']">
<xsl:choose>
<xsl:when test="@rel='alternate'">
<xsl:value-of disable-output-escaping="yes" select="./@href"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="."/>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:attribute>
<xsl:value-of disable-output-escaping="yes" select="*[local-name()='title']"/>
</a>
<xsl:if test="*[local-name()='enclosure']">
<a title="podcast - {*[local-name()='enclosure']/@type}" href="{*[local-name()='enclosure']/@url}">
<img border="0" src="/images/icon_speaker.png" alt="podcast - {*[local-name()='enclosure']/@type}"/>
</a>
</xsl:if>
</li>
</xsl:if>
</xsl:for-each>
</ul>
<div align="right"><a href="http://www.edazzle.net/#grabnews" title="powered by grabnews">?</a></div>
</td></tr>
</table>
</xsl:template>

<xsl:template match="/">
<xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet>
