<% @Language="VBScript" %>
<%
'========================================================================
' MODULE:   demo.asp
' AUTHOR:   Terje Hauger
' HOME:        www.u229.no/stuff/Rss/
' CREATED:  February 2006   
' Version:    1.1
'========================================================================
' COMMENT:
' - Reference for RSS 2.0: http://blogs.law.harvard.edu/tech/rss
'========================================================================
' HOW TO USE:
' - If you use the Stylesheet property, make sure you edit the file path.
'========================================================================

Option Explicit
On Error Resume Next
%>
<!--#include file="cCreateRSSFeed.asp"-->

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>RSS 2.0 Demo</title>
</head>
<body>

<h3>RSS 2.0 Demo:</h3>

<%

Dim oConn
Dim oRs
Dim oRSS

'---------------------------- Create our recordset object
Set oConn = Server.CreateObject("ADODB.Connection")
Set oRs = Server.CreateObject("ADODB.Recordset")

With oConn
		.Provider = "Microsoft.Jet.OLEDB.4.0"
		.ConnectionString = "Data Source=" & Server.MapPath("rss2.0.mdb") & ";User Id=;Password="
		.Open
End With

With oRs
		.ActiveConnection = oConn
		' Select top 10 from tblArticles order by sortfield desc?
		.Source = "SELECT * FROM tblArticles"
		.Open
End With

'---------------------------- Create the RSS feed
Set oRSS = New cCreateRSSFeed

With oRSS
    '=============
    ' THE RSS HEADER:
    '=============

    '// These 2 are not part of the RSS specification
    '// Where to save the feed? If this file name or path changes, it must also be changed in rss.asp.
    .SavePath = Server.MapPath("rss.xml")
    '// This should be a complete URI: http://www.mydomain/mystylesheet.xsl
    .stylesheet = "mystylesheet.xsl"

    '// The following 3 RSS Properties are requried
    .Title = "My Brilliant RSS News Service"
    .Link = "http://www.mydomain.com/"
    .Description = "My excellent news service about something."

    '// The rest is optional
    .Language = "en-gb"
    .Copyright = "Copyright 2006, Oslo Your Company Name"
    .ManagingEditor = "manager@mydomain.com (Elvis Presley)"
    .WebMaster = "webmaster@mydomain.com (Priscilla Presley)"
    .PubDate = "Sat, 07 Sep 2006 00:00:01 GMT"
    .LastBuildDate = "Sat, 07 Sep 2006 09:42:31 GMT"
    .Category = "Newspapers"
    .Generator = "MightyInHouse Content System v2.3"
    ' A URL that points to the documentation for the format used in the RSS feed.
    .Docs = "http://blogs.law.harvard.edu/tech/rss"
    ' Allow clients to register with a cloud to be notified of updates to the RSS channel.
    .Cloud = "<cloud domain=""rpc.sys.com"" port=""80"" path=""/RPC2"" registerProcedure=""pingMe"" protocol=""soap""/>"
    .TimeToLive = "60"
    ' Image: GIF, JPEG or PNG.
    ' Parameters for image: Title, url, link, width (max 144: default 88), height (max 400: default 31), description.
    .Image = "My News, http://www.mydomain/image.gif, http://www.mydomain/, 120, 60, Text for the title attribute."
    ' The PICS label is meant to categorize your pages in terms of nudity, violence, sex and language. Values are between 0 to 4.
    .Rating = "http-equiv=""PICS-Label"" content='(PICS-1.1 ""http://www.icra.org/ratingsv02.html"" " & "l gen true for ""http://www.mydomain.com"" r (n 0 s 0 v 0 l 0)'"
    ' Parameters for the input box: Button caption, description, Html name of text box, Url
    .TextInput = "Submit Feedback, Submit your feedback to our news service, txtFeedback, http://www.mydomain.com/feedback.asp"
    ' Tell RSS readers there is no need to poll your news service between the six hours from 6AM GMT to 11AM GMT (until noon).
    .SkipHours = "6, 7, 8, 9, 10, 11"
    ' Tell RSS readers there is no need to poll your news service on saturdays and sundays.
    .SkipDays = "Saturday, Sunday"

    '=============
    ' THE RSS BODY:
    '=============

    '// Pass the recordset object containing your data.
    Call .CreateRSSFeed(oRs)

    If Err Then
        Response.Write "<br />Err.Number = " & Err.Number & "<br />" & Err.Description
    End If

    Response.Write "<p>If no error occured you should now have created a RSS feed named rss.xml in this folder.</p>"
    Response.Write "<p>http://www.u229.no/stuff/rss/</p>"

End With

'---------------------------- Clean up

Set oRSS = Nothing: Set oRs = Nothing: Set oConn = Nothing

 %>

 </body>
 </html>