<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" />
<xsl:variable name="title" select="/rss/channel/title"/>
<xsl:variable name="copyright" select="/rss/channel/copyright"/>

<xsl:template match="/">
	<html>
	<head>
	<title><xsl:value-of select="$title"/> XML Feed</title>
	<style type="text/css">
		div {font-family: verdana; arial; font-size: 12px;}
		.footerbox {font-size: 11px; color: gray;}
	</style>
	</head>
	<xsl:apply-templates select="rss/channel"/>
	</html>
</xsl:template>

<xsl:template match="channel">
	<body>
	<div class="topbox"><h2><xsl:value-of select="$title"/> XML Feed:</h2></div>
	<div>Below is the latest content available from this feed.</div>
	<div class="mainbox"><xsl:apply-templates select="item"/></div>
	<div class="footerbox"><xsl:value-of select="$copyright"/></div>
	</body>
</xsl:template>

<xsl:template match="item">
	<div id="item">
		<ul>
			<li>
				<a href="{link}" class="item"><xsl:value-of select="title"/></a>
				<div><xsl:value-of select="description" /></div>
			</li>
		</ul>
	</div>
</xsl:template>
</xsl:stylesheet>