<%@ LANGUAGE = "VBScript" %>
<%Option Explicit%>

<%
'This function will get an Ad of the format specified by "format" (string, eg. "468x60", "120x100")
'  and based on the "randomize" integer. This function does not truely randomize, if the 
'  same parameters are passed in, the same Ad will display (unless a new Ad is inserted). The
'  calling page should use it's own random generating code to choose the Ad to display.
function ShowAd(format, randomize)
	Dim conn, rs, str_sql, str_conn, intRsCount

	Set conn = Server.CreateObject("ADODB.Connection")
	Set rs = Server.CreateObject("ADODB.Recordset")
	str_conn = "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA SOURCE=" & server.mappath("\AdRotate.mdb")
				
	conn.Open str_conn

	'Get the Ads
	str_sql = "SELECT Link FROM Ads WHERE Format LIKE '" & format & "' AND InRotation = true"
	rs.Open str_sql, conn, 1, 2
	
	'Get the number of Ads that meet the criteria
	intRsCount = rs.RecordCount

	'Move a "random" number of records without going over the size of the 
	'  recordset.
	rs.Move(randomize Mod intRsCount)	
	
	'There should always be a record here, but it's better to be safe
	If Not(rs.EOF) Then
		ShowAd = rs("Link")
	Else
		ShowAd = ""
	End If

	rs.Close
	conn.Close
	Set rs = Nothing
	Set conn = Nothing
end function
%>

<%

'Usage Examples

'I use the following equation to generate a fairly random number based on 
'  the time the page is loaded. This basically returns the number of 
'  seconds from the current time. If you have more than 60 ads, this 
'  will not be a good number generator.
Dim AdSeed
AdSeed = Mid(Now(), Len(Now()) - 4, 2)


'Display a single 468x60 Ad
Response.Write ShowAd("468x60", AdSeed) + "<BR>"

'Display a pair of Ads with a width of 120 and where height is unimportant
Response.Write ShowAd("120x%", AdSeed)
Response.Write ShowAd("120x%", AdSeed + 1) + "<BR>"

%>