<%@ Page Language="C#" ContentType="text/html" ResponseEncoding="iso-8859-1" %>
<script language="C#" runat="server">
void Page_Load(Object sender, EventArgs e)
{
	try{
		Response.Cache.VaryByParams["Image;Width;Height;ForceAspect"] = true;
		Response.ContentType = "image/jpeg";
		System.Collections.Hashtable imageOutputFormatsTable = new System.Collections.Hashtable();
		imageOutputFormatsTable.Add(System.Drawing.Imaging.ImageFormat.Gif.Guid, System.Drawing.Imaging.ImageFormat.Gif);
		imageOutputFormatsTable.Add(System.Drawing.Imaging.ImageFormat.Jpeg.Guid, System.Drawing.Imaging.ImageFormat.Jpeg);
		imageOutputFormatsTable.Add(System.Drawing.Imaging.ImageFormat.Bmp.Guid, System.Drawing.Imaging.ImageFormat.Gif);
		imageOutputFormatsTable.Add(System.Drawing.Imaging.ImageFormat.Tiff.Guid, System.Drawing.Imaging.ImageFormat.Jpeg);
		imageOutputFormatsTable.Add(System.Drawing.Imaging.ImageFormat.Png.Guid, System.Drawing.Imaging.ImageFormat.Jpeg);
	
		string imageLocation;
		bool forceaspect = true;
		int newHeight;
		int newWidth;
		int reqHeight = 100;
		int reqWidth = 100;
		int origHeight;
		int origWidth;
		
		imageLocation = Server.MapPath(Request.QueryString["Image"]);
		if (Request.QueryString["Height"] != null){
			reqHeight = Convert.ToInt32(Request.QueryString["Height"]);
		}
		if (Request.QueryString["ForceAspect"] != null){
			forceaspect = Convert.ToBoolean(Request.QueryString["ForceAspect"]);
		}
		if(Request.QueryString["Width"] != null){
			reqWidth = Convert.ToInt32(Request.QueryString["Width"]);
		}
		if (Request.QueryString["ForceAspect"] == "true"){
			forceaspect = true;
		}
		
		System.Drawing.Bitmap origBitmap = new System.Drawing.Bitmap(imageLocation);
		origHeight = origBitmap.Height;
		origWidth = origBitmap.Width;
		
		if (forceaspect){
			//Force Aspect Change
			newHeight = reqHeight;
			newWidth = reqWidth;
		}		
		else if (origBitmap.Height >= origBitmap.Width){
			//Portrait
			newHeight = reqHeight;
			newWidth = (int)(((double)origBitmap.Width / (double)origBitmap.Height) * reqHeight);
		}
		else{ 
			//Landscape
			newWidth = reqWidth;
			newHeight = (int)(((double)origBitmap.Height / (double)origBitmap.Width) * reqWidth);
		}		
		
		System.Drawing.Bitmap outputImage = new System.Drawing.Bitmap(origBitmap, newWidth, newHeight);
		//outputImage.SetResolution(24, 24); //use this line for lower resolution thumbnails
		outputImage.SetResolution(72, 72); 
					
		//outputImage.InterpolationMode = InterpolationMode.HighQualityBicubic;
		System.Drawing.Imaging.ImageFormat outputFormat = (System.Drawing.Imaging.ImageFormat)imageOutputFormatsTable[origBitmap.RawFormat.Guid];
		
		outputImage.Save(Response.OutputStream, outputFormat);
		outputImage.Dispose();
		origBitmap.Dispose();
	}
	catch (Exception ex){
		//log error so we may know the problem. you need to have write permits, of course on log path			
		System.IO.StreamWriter sw=null;
		try{
			sw=new System.IO.StreamWriter(Server.MapPath("error.txt"),true);
			sw.WriteLine("Error : " + ex.Message + " processing " + Request.QueryString["Image"]);
		}	 
		catch{}		
		finally{sw.Close();}
		//now display the error image
		Response.Redirect("thumberror.gif");
	}
}
</script>