<%@ Page Language="C#" ContentType="text/html" ResponseEncoding="iso-8859-1" %>
<script language="C#" runat="server">
void Page_Load(Object sender, EventArgs e)
{
	try{				
		string imageLocation = Server.MapPath("image1.jpg");
		if (!System.IO.File.Exists(imageLocation)){
			Response.Write ("The file to do the thumbnail generation testing, <em>" + imageLocation + "</em> was not found.");
			return;
		}
		System.Drawing.Bitmap origBitmap = new System.Drawing.Bitmap(imageLocation);
				
		System.Drawing.Bitmap outputImage = new System.Drawing.Bitmap(origBitmap, 50, 50);
		outputImage.SetResolution(72, 72); 					
		System.Drawing.Imaging.ImageFormat outputFormat = System.Drawing.Imaging.ImageFormat.Jpeg;
		
		outputImage.Save(Response.OutputStream, outputFormat);
		outputImage.Dispose();
		origBitmap.Dispose();
		Response.Clear ();
		Response.Write ("<strong>Success!</strong><br/>");
		Response.Write ("Thumbnail generation into OutputStream is working fine so if you experience any thumbnail generation errors, check that you are not defining a virtual path for the images folder that tries to move up above the root of the application as defined in IIS. <br/>Ex: try to use just <em>images</em> as your images virtual path, like it is default in the applicat,ion");
	}
	catch (Exception ex){
		Response.Clear ();
		Response.Write ("<strong>Error generation thumbnails!</strong><br/>");
		Response.Write ("Error: <em>" + ex.Message + "</em><br />");
		Response.Write ("Please, check this error with your system administrator");
	}
}
</script>