<!-- #include file="admin/DBconn.asp" -->
<!-- #include file="config/config.asp" -->

<%
	'Vi skal angive, at dette dokument skal vre en XML-fil.
	'Dette klares ved at stte Contenttypen til text/xml
	Response.ContentType = "text/xml"
	
	
	'Nedenstende udskriver toppen af XML-dokumentet.
	'Det er lagt i en seperat sub for overskuelighedens skyld.
	Call RenderXMLHeader()
	
	
	'Nu bliver det tricky. Vi skal hente de nyeste poster fra databasen,
	'Lave en lkke der lber igennem dem og udskriver dem.
	'Her skal du tilpasse sub'en, s den henter de rigtige felter
	'fra databasen og benytter den rigtige connection-string til din database.
	Call RenderXMLContent()
	
	
	'Til slut udskriver vi afslutningen p XML-dokumentet.
	Call RenderXMLFooter()
	
	
	'--- Herunder findes de function og subs der bruges til at rendere XML-filen ---
	
	'Udskriver toppen af XML-dokumentet. Brugt tidligere p siden
	Sub RenderXMLHeader()
		Response.Write("<?xml version=""1.0"" encoding=""ISO-8859-1""?>")
		Response.Write("<rss version=""2.0"">")
		Response.Write("<channel>")
		Response.Write("<title>" & RSStitle & "</title>")
		Response.Write("<link>" & RSSlink & "</link>")
		Response.Write("<description>" & RSSdescription & "</description>")
	End Sub
	
	
	'Henter de nyeste poster fra din database og udskriver dem.
	Sub RenderXMLContent()
		
		'Variable til opbevaring af data.
		Dim sHeader		'String
		Dim sContent	'String
		Dim iPostID		'Integer
		Dim sTime		'Date/time
		
		
		'Opret en ny forbindelse til databasen
		
		
		
		'Henter de ti nyeste poster fra databasen.
		'Her skal du tilpasse funktionen, s de rigtige felter bliver hentet.
		'Jeg kender jo ikke navngivningen i din database.
		Set objWeblogRecords = objConn.Execute("SELECT TOP 10 * FROM weblog ORDER BY date DESC")
	
	
		'Gennemlb resultaterne
		While Not objWeblogRecords.EOF
		
			'Lgger data i de lokale variable
			iPostID = objWeblogRecords(0)
			sHeader = objWeblogRecords(1)
			sTime = objWeblogRecords(2)
			sContent = objWeblogRecords(3)
			
			'Formaterer specialtegn i overskrift og post
			sHeader = PrepeareTextForXMLUse(sHeader)
			sContent = PrepeareTextForXMLUse(sContent)
			
			'Formaterer dato og tid i UTM-format.
			'sTime = FormatTimeForXMLUse(sTime)
			
			'Udskriver element i feedet.
			Response.Write("<item>")
			Response.Write("<title>" & sHeader & "</title>")
			Response.Write("<description>" & sContent & "</description>")
			Response.Write("<pubDate>" & sTime & "</pubDate>")
			Response.Write("<link>" & RSScomment & "" & iPostID & "</link>")
			Response.Write("</item>")
			
			'G til nste post
			objWeblogRecords.MoveNext
		
		Wend
		
		
		'Ryd op i forbindelsen
		objWeblogRecords.Close()
		Set objWeblogRecords = Nothing
		objConn.Close()
		Set objConn = Nothing
		
	End Sub
	
	
	'Udskriver ganske kort bunden af XML-dokumentet.
	'Det er lidt overkill at benytte en sub til det,
	'men pnt ser det jo ud.
	Sub RenderXMLFooter()
		Response.Write("</channel>")
		Response.Write("</rss>")
	End Sub
	
	
	'Funktion, der fjerner al HTML i den angivne tekst
	Function RemoveHTMLInText(strHTML, intWorkFlow)
	
		'Variable
		Dim objRegExp, strTagLess
		
		'Fjern linieskift i teksten
		strTagless = strHTML
		strTagless = Replace(strTagless, "<p>", " ")
		strTagless = Replace(strTagless, "<br />", " ")
		
		'Opret et RegExp, der fjerner HTML
		Set objRegExp = New RegExp 
		objRegExp.IgnoreCase = True
		objRegExp.Global = True
		
		'Fjern HTML
		If intWorkFlow <> 1 Then
			objRegExp.Pattern = "<[^>]*>"
			strTagLess = objRegExp.Replace(strTagLess, "")
		End If
		
		If intWorkFlow > 0 AND intWorkFlow < 3 Then
			objRegExp.Pattern = "[<]"
			strTagLess = objRegExp.Replace(strTagLess, "<")
			objRegExp.Pattern = "[>]"
			strTagLess = objRegExp.Replace(strTagLess, ">")
		End If
		
		'Ryd op
		Set objRegExp = Nothing
		
		'Returner tekst
		RemoveHTMLInText = Trim(strTagLess)
		
	End function
	
	
	'Funktion, der escaper specialtegn som <, > og &.
	Function EscapeSpecialChars(Text)
		
		'Variable
		Dim strText		'String
		strText = Text
		
		'Erstat 'forbudte' tegn.
		strText = Replace(strText, "&", "&amp;")
		strText = Replace(strText, "<", "&lt;")
		strText = Replace(strText, ">", "&gt;")
		strText = Replace(strText, "'", "&apos;")
		strText = Replace(strText, """", "&quot;")
		
		'Returner data
		EscapeSpecialChars = strText
		
	End Function
	
	
	'Function, der kombinerer de to foregende til en funktion
	Function PrepeareTextForXMLUse(Text)
		Text = RemoveHTMLInText(Text, 0)
		Text = EscapeSpecialChars(Text)
		PrepeareTextForXMLUse = Text
	End Function
	
	
	'Funktion, der formaterer datoen til GMT-format.
	Function FormatTimeForXMLUse(InputDate)
			
		'Afslut, hvis inputtet ikke er en dato.
		If NOT IsDate(InputDate) Then
			Exit Function
		End If
		
		'Array med mnedernes forkortelser
		Dim arrShortMonth(12)
		arrShortMonth(1) = "Jan"
		arrShortMonth(2) = "Feb"
		arrShortMonth(3) = "Mar"
		arrShortMonth(4) = "Apr"
		arrShortMonth(5) = "May"
		arrShortMonth(6) = "Jun"
		arrShortMonth(7) = "Jul"
		arrShortMonth(8) = "Aug"
		arrShortMonth(9) = "Sep"
		arrShortMonth(10) = "Oct"
		arrShortMonth(11) = "Nov"
		arrShortMonth(12) = "Dec"

		'Variable
		Dim intDay			'Integer
		Dim strMonth		'String
		Dim intYear			'Integer
		Dim datTimestamp	'Dato
		
		'Find relevante variable
		intDay = DatePart("d", Input, vbMonday, vbFirstJan1)
		strMonth = ArrShortMonth(DatePart("m", Input, vbMonday, vbFirstJan1))
		intYear = DatePart("yyyy", Input, vbMonday, vbFirstJan1)
		datTimestamp = FormatDateTime(Input, vbLongTime)
		
		'Returner data.
		FormatTimeForXMLUse = Trim(intDay & " " & strMonth & " " & intYear & " " & datTimeStamp & " +0100")
	
	End Function
%>