<%
'*************** FUNCTIONS


Function headdate(sDate)
	sDay = fncFmtDate(sDate, "%A")
	sY = DatePart("yyyy",sDate)
	sM = fncFmtDate(sDate, "%B")
	sMDay = DatePart("d",sDate)
	headdate = sDay & ", " & sM & " " & sMDay & ", " & sY
End function


'TIME DATE
' Template items (example)
' %m Month as a decimal (02)
' %B Full month name (February)
' %b Abbreviated month name (Feb )
' %d Day of the month (23)
' %O Ordinal of day of month (eg st or rd or nd)
' %j Day of the year (54)
' %Y Year with century (1998)
' %y Year without century (98)
' %w Weekday as integer (0 is Sunday)
' %a Abbreviated day name (Fri)
' %A Weekday Name (Friday)
' %H Hour in 24 hour format (24)
' %h Hour in 12 hour format (12)
' %N Minute as an integer (01)
' %n Minute as optional if minute <> 0
' %S Second as an integer (55)
' %P AM/PM Indicator (PM)
'
'Example fncFmtDate(sDate,"%h:%N %P") = 10:00 pm



Function ampm(sDate,sFormat)

	Select Case sFormat

	Case "ampm"

		ampm = fncFmtDate(sDate,"%h:%N %P")

	Case Else

		ampm = sDate

	End select

End function

Function ampmDate(sDate,sFormat)

	Select Case sFormat

	Case "ampm"

		ampmDate = fncFmtDate(sDate,"%m/%d/%y")

	Case Else

		ampmDate = sDate

	End select

End function

Function ampmFull(sDate,sFormat)

	Select Case sFormat

	Case "ampm"

		sY = Year(sDate)
		sM = Month(sDate)
		If Len(sM) < 2 then
		sM = "0" & sM
		End if
		sD = Day(sDate)
		If Len(sD) < 2 then
	 	sD = "0" & sD
		End if
		sDateFormat = sY & "-" & sM & "-" & sD

		ampmTime = fncFmtDate(sDate,"%h:%N %P")

		ampmFull = fncFmtDate(sDate,"%m/%d %Y") & " " & ampmTime

	Case Else

		sY = DatePart("yyyy",sDate)
		sM = DatePart("m",sDate)
		If Len(sM) < 2 then
		 sM = "0" & sM
		End if
		sD = DatePart("d",sDate)
		If Len(sD) < 2 then
		 sD = "0" & sD
		End if
		dDate = sY & "-" & sM & "-" & sD
		sS = DatePart("s",sDate)
		If Len(sS) < 2 then
		sS = "0" & sS
		End if
		dTime = Formatdatetime(sDate,4)
		fDate = dDate & " " & dTime

		ampmFull = fDate

	End select

End function


'------- FORMAT DATE

Function fncGetDayOrdinal( _
 byVal intDay _
 )
 ' Accepts a day of the month as an integer and returns the
 ' appropriate suffix

 Dim strOrd

 Select Case intDay
 Case 1, 21, 31
  strOrd = ":a"
 Case 2, 22
  strOrd = ":a"
 Case 3, 23
  strOrd = ":e"
 Case Else
  strOrd = ":e"
 End Select

 fncGetDayOrdinal = strOrd
End Function ' fncGetDayOrdinal



Function fncFmtDate( _
    byVal strDate, _
    byRef strFormat _
   )
 ' Accepts strDate as a valid date/time,
 ' strFormat as the output template.
 ' The function finds each item in the
 ' template and replaces it with the
 ' relevant information extracted from strDate

 ' Template items (example)
 ' %m Month as a decimal (02)
 ' %B Full month name (February)
 ' %b Abbreviated month name (Feb )
 ' %d Day of the month (23)
 ' %O Ordinal of day of month (eg st or rd or nd)
 ' %j Day of the year (54)
 ' %Y Year with century (1998)
 ' %y Year without century (98)
 ' %w Weekday as integer (0 is Sunday)
 ' %a Abbreviated day name (Fri)
 ' %A Weekday Name (Friday)
 ' %H Hour in 24 hour format (24)
 ' %h Hour in 12 hour format (12)
 ' %N Minute as an integer (01)
 ' %n Minute as optional if minute <> 0
 ' %S Second as an integer (55)
 ' %P AM/PM Indicator (PM)

 On Error Resume Next

 Dim intPosItem
 Dim int12HourPart
 Dim str24HourPart
 Dim strMinutePart
 Dim strSecondPart
 Dim strAMPM

 ' Insert Month Numbers
 strFormat = Replace(strFormat, "%m", _
          DatePart("m", strDate), 1, -1, vbBinaryCompare)


 ' Insert non-Abbreviated Month Names
 strFormat = Replace(strFormat, "%B", _
          MonthName(DatePart("m", strDate), _
          False), 1, -1, vbBinaryCompare)

 ' Insert Abbreviated Month Names
 strFormat = Replace(strFormat, "%b", _
          MonthName(DatePart("m", strDate), _
          True), 1, -1, vbBinaryCompare)

 ' Insert Day Of Month
 strFormat = Replace(strFormat, "%d", _
          DatePart("d",strDate), 1, _
          -1, vbBinaryCompare)

 ' Insert Day of Month Ordinal (eg st, th, or rd)
 strFormat = Replace(strFormat, "%O", _
          fncGetDayOrdinal(Day(strDate)), _
          1, -1, vbBinaryCompare)

 ' Insert Day of Year
 strFormat = Replace(strFormat, "%j", _
          DatePart("y",strDate), 1, _
          -1, vbBinaryCompare)

 ' Insert Long Year (4 digit)
 strFormat = Replace(strFormat, "%Y", _
          DatePart("yyyy",strDate), 1, _
          -1, vbBinaryCompare)

 ' Insert Short Year (2 digit)
 strFormat = Replace(strFormat, "%y", _
          Right(DatePart("yyyy",strDate),2), _
          1, -1, vbBinaryCompare)

 ' Insert Weekday as Integer (eg 0 = Sunday)
 strFormat = Replace(strFormat, "%w", _
          DatePart("w",strDate,1), 1, _
          -1, vbBinaryCompare)

 ' Insert Abbreviated Weekday Name (eg Sun)
 strFormat = Replace(strFormat, "%a", _
          WeekDayName(DatePart("w",strDate,1),True), 1, _
          -1, vbBinaryCompare)

 ' Insert non-Abbreviated Weekday Name
 strFormat = Replace(strFormat, "%A", _
          WeekDayName(DatePart("w",strDate,1),False), 1, _
          -1, vbBinaryCompare)

 ' Insert Hour in 24hr format
 str24HourPart = DatePart("h",strDate)
 If Len(str24HourPart) < 2 then str24HourPart = "0" & _
                                                 str24HourPart
 strFormat = Replace(strFormat, "%H", str24HourPart, 1, _
          -1, vbBinaryCompare)

 ' Insert Hour in 12hr format
 int12HourPart = DatePart("h",strDate) Mod 12
 If int12HourPart = 0 then int12HourPart = 12
  If Len(int12HourPart) < 2 then _
          int12HourPart = "0" & int12HourPart
 strFormat = Replace(strFormat, "%h", int12HourPart, 1, _
          -1, vbBinaryCompare)

 ' Insert Minutes
 strMinutePart = DatePart("n",strDate)
 If Len(strMinutePart) < 2 then _
          strMinutePart = "0" & strMinutePart
 strFormat = Replace(strFormat, "%N", strMinutePart, _
          1, -1, vbBinaryCompare)

 ' Insert Optional Minutes
 If CInt(strMinutePart) = 0 then
  strFormat = Replace(strFormat, "%n", "", 1, _
           -1, vbBinaryCompare)
 Else
  If CInt(strMinutePart) < 10 then _
           strMinutePart = "0" & strMinutePart
  strMinutePart = ":" & strMinutePart
  strFormat = Replace(strFormat, "%n", strMinutePart, _
           1, -1, vbBinaryCompare)
 End if

 ' Insert Seconds
 strSecondPart = DatePart("s",strDate)
 If Len(strSecondPart) < 2 then _
          strSecondPart = "0" & strSecondPart
 strFormat = Replace(strFormat, "%S", strSecondPart, 1, _
          -1, vbBinaryCompare)

 ' Insert AM/PM indicator
 If DatePart("h",strDate) >= 12 then
   strAMPM = "PM"
 Else
   strAMPM = "AM"
 End If

 strFormat = Replace(strFormat, "%P", strAMPM, 1, _
          -1, vbBinaryCompare)


' Day Eng to ?
strFormat = Replace(strFormat,"Monday",dictLanguage.Item(sLang&"_cal_1"))
strFormat = Replace(strFormat,"Tuesday",dictLanguage.Item(sLang&"_cal_2"))
strFormat = Replace(strFormat,"Wednesday",dictLanguage.Item(sLang&"_cal_3"))
strFormat = Replace(strFormat,"Thursday",dictLanguage.Item(sLang&"_cal_4"))
strFormat = Replace(strFormat,"Friday",dictLanguage.Item(sLang&"_cal_5"))
strFormat = Replace(strFormat,"Saturday",dictLanguage.Item(sLang&"_cal_6"))
strFormat = Replace(strFormat,"Sunday",dictLanguage.Item(sLang&"_cal_7"))

' Month Eng to ?
strFormat = Replace(strFormat,"January",dictLanguage.Item(sLang&"_cal_16"))
strFormat = Replace(strFormat,"February",dictLanguage.Item(sLang&"_cal_17"))
strFormat = Replace(strFormat,"March",dictLanguage.Item(sLang&"_cal_18"))
strFormat = Replace(strFormat,"April",dictLanguage.Item(sLang&"_cal_19"))
strFormat = Replace(strFormat,"May",dictLanguage.Item(sLang&"_cal_20"))
strFormat = Replace(strFormat,"June",dictLanguage.Item(sLang&"_cal_21"))
strFormat = Replace(strFormat,"July",dictLanguage.Item(sLang&"_cal_22"))
strFormat = Replace(strFormat,"August",dictLanguage.Item(sLang&"_cal_23"))
strFormat = Replace(strFormat,"September",dictLanguage.Item(sLang&"_cal_24"))
strFormat = Replace(strFormat,"October",dictLanguage.Item(sLang&"_cal_25"))
strFormat = Replace(strFormat,"November",dictLanguage.Item(sLang&"_cal_26"))
strFormat = Replace(strFormat,"December",dictLanguage.Item(sLang&"_cal_27"))

 fncFmtDate = strFormat


 'If there is an error output its value
 If err.Number <> 0 then
  Response.Clear
  Response.Write "ERROR " & err.Number & _
                 ": fmcFmtDate - " & err.Description
  Response.Flush
  Response.End
 End if
End Function ' fncFmtDate


'------- END DATE FUNCTION

Function RemoveHTML(sText)

Set objRegExp = New RegExp
objRegExp.Global = True
objRegExp.IgnoreCase = True
'strMatch1 = "<(.*?)>"
strMatch1 = "<(.|\n)+?>"
'Set the pattern to search for
objRegExp.Pattern = strMatch1

'Search the file for the phrase
Set objMatches = objRegExp.Execute(sText)

'Get the number of times the phrase is matched
intNumMatches = objMatches.Count


RemoveHTML = sText

For Each objMatch in objMatches

	RemoveHTML = objRegExp.Replace(RemoveHTML, "")

	'RemoveHTML = Replace(RemoveHTML,"/"," ")
	RemoveHTML = Replace(RemoveHTML,"<"," ")
	RemoveHTML = Replace(RemoveHTML,"/>"," ")
	RemoveHTML = Replace(RemoveHTML,">"," ")

Next

Set objRegExp = Nothing

End function

Function MakeURL(Data)
	UrlData = Data
		UrlData = edit_hrefs(UrlData, 1)
		UrlData = edit_hrefs(UrlData, 2)
		UrlData = edit_hrefs(UrlData, 3)
		'UrlData = edit_hrefs(UrlData, 4)
		UrlData = edit_hrefs(UrlData, 5)
		UrlData = edit_hrefs(UrlData, 6)
	MakeURL = UrlData
End function

%>
<script language="javascript1.2" runat=server>
function edit_hrefs(s_html, type){
    s_str = new String(s_html);
	if (type == 1) { // Start with http://
     	s_str = s_str.replace(/\b(http\:\/\/[\w+\.]+[\w+\.\:\/\_\?\=\&\-\'\#\%\~\;\,\$\!\+\*]+)/gi,
		  "<a href=\"$1\" title=\"$1\" target=\"_blank\">$1<\/a>");
	}
	if (type == 2) { // Start with https://
		s_str = s_str.replace(/\b(https\:\/\/[\w+\.]+[\w+\.\:\/\_\?\=\&\-\'\#\%\~\;\,\$\!\+\*]+)/gi,
		  "<a href=\"$1\" title=\"$1\" target=\"_blank\">$1<\/a>");
	}
	if (type == 3) { // Start with file://
		s_str = s_str.replace(/\b(file\:\/\/\/\w\:\\[\w+\/\w+\.\:\/\_\?\=\&\-\'\#\%\~\;\,\$\!\+\*]+)/gi,
		  "<a href=\"$1\" title=\"$1\" target=\"_blank\">$1<\/a>");
	}
	if (type == 4) { // Start with www.
		s_str = s_str.replace(/\b(www\.[\w+\.\:\/\_\?\=\&\-\'\#\%\~\;\,\$\!\+\*]+)/gi,
 		  "<a href=\"http://$1\" title=\"$1\" target=\"_blank\">$1</a>");
	}
	if (type == 5) { // email
		s_str = s_str.replace(/\b([\w+\-\'\#\%\.\_\,\$\!\+\*]+@[\w+\.?\-\'\#\%\~\_\.\;\,\$\!\+\*]*)/gi,
 		  "<a href=\"mailto\:$1\" title=\"$1\">$1</a>");
	}
	if (type == 6) { // Start with ftp://
     	s_str = s_str.replace(/\b(ftp\:\/\/[\w+\.]+[\w+\.\:\/\_\?\=\&\-\'\#\%\~\;\,\$\!\+\*]+)/gi,
		  "<a href=\"$1\" title=\"$1\" target=\"_blank\">$1<\/a>");
	}
    return s_str;
}
</script>