<%@ LANGUAGE = VBScript %>
<% '********************************************************************************************************************
   '* XcDiag - XCENT IIS Diagnostic Utility  *  Copyright 1997-2003 XCENT, Inc.  *  www.xcent.com                      *
   '********************************************************************************************************************
   '* If you see this text in your browser, and have tried to access this file from your web server,                   *
   '* then you do not have this installed on an ASP enabled web server. ASP stands for Active                          *
   '* Server Pages and is typically only found on Windows NT/2000 based web servers. For information                   *
   '* on requirements for XCENT ASP applications, see the XCENT online faq database at                                 *
   '* http://www.XCENT.com/FAQ/                                                                                        *
   '********************************************************************************************************************
    GC_Version = "3.1.1"
    gsRequired = "<i>X</i>"
    gsNotRequired = "&nbsp;"
    gsTypeRequired = "<i>*</i>"
    gsTypeRequiredInfo = "Note: a <i>*</i> in the Required column denotes that one of the supported components of this type is required."
    gsOptional = "<i>X</i>"
    gsNotOptional = "&nbsp;"
    gsInstalled = "<i>Yes</i>"
    gsNotInstalled = "<i>No</i>"
    sTemp = Trim("" & ScriptEngineMajorVersion() & "." & ScriptEngineMinorVersion())
    fScriptEngineVersion = FVal(sTemp)
    bEmailComponent = False
    bFileSystem = False
    bUploadComponent = False
    bImagingComponent = False
    bHTTPComponent = False
    bVendorSpecOnlineProcessing = False
    bMultipurposeOnlineProcessing = False
    sCMD = UCase(Trim(RequestValue("CMD")))

'*** Switch to HTML and display IIS Server Information Header ***
%>
<html><head>
<meta http-equiv="Content-Language" content="en-us">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
<title>XCENT Diagnostic for ASP</title>
<style>
<!--
table        { font-family: Arial; font-size: 8pt }
body         { font-size: 10pt; font-family: Arial }
-->
</style>
</head>
<body topmargin="3" leftmargin="3">
<p><b><font size="5">XcDiag.ASP</font></b><br>
<b>XCENT ASP Diagnostic Script Version <% Response.Write GC_Version %></b>
</p>
<div align="left">
  <table border="1" cellpadding="2" cellspacing="0" width="100%" bordercolorlight="#00FFFF" bordercolordark="#0000FF" bordercolor="#000000" height="64">
    <tr>
      <td bgcolor="#C0C0C0" colspan="2" height="16"><b>ASP Server Information</b></td>
    </tr>
    <tr>
      <td width="200" bgcolor="#C0C0C0" height="16">Item</td>
      <td bgcolor="#C0C0C0" height="16">Information</td>
    </tr>
<%
'*** Display Dynamic IIS Server Information ***
    ShowIISInfoLine "Server Name", Request.ServerVariables("SERVER_NAME")
    ShowIISInfoLine "Script Name", Request.ServerVariables("SCRIPT_NAME")
    ShowIISInfoLine "Server Protocol", Request.ServerVariables("SERVER_PROTOCOL")
    ShowIISInfoLine "Path Info", Request.ServerVariables("PATH_INFO")
    ShowIISInfoLine "Path Translated", Request.ServerVariables("PATH_TRANSLATED")
    ShowIISInfoLine "HTTP_REFERER", Request.ServerVariables("HTTP_REFERER")
    ShowIISInfoLine "Server DateTime", "" & Now
    ShowIISInfoLine "VBScript Engine Version", "" & fScriptEngineVersion
    ShowIISInfoLine "VBScript Engine Build", "" & ScriptEngineBuildVersion()

%>
  </table>
  &nbsp;
  <table border="1" cellspacing="0" width="100%" cellpadding="2" bordercolorlight="#00FFFF" bordercolordark="#0000FF" bordercolor="#000000">
    <tr>
      <td bgcolor="#C0C0C0" colspan="6"><b>Components on this Server</b></td>
    </tr>
    <tr>
      <td width="200" bgcolor="#C0C0C0">Component</td>
      <td width="100" bgcolor="#C0C0C0">Type</td>
      <td width="50" bgcolor="#C0C0C0">Installed</td>
      <td width="40" bgcolor="#C0C0C0">Req</td>
      <td width="40" bgcolor="#C0C0C0">Opt</td>
      <td bgcolor="#C0C0C0">Information</td>
    </tr>
<%
    '*** AlphaSierraPapa AspTear ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("SOFTWING.ASPtear")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bHTTPComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "AlphaSierraPapa AspTear", "HTTP", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***
    
    '*** AspHelp Simple Upload ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("ASPSimpleUpload.Upload")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bUploadComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "AspHelp Simple Upload", "Upload", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

IF FALSE THEN '*** DEPRECATED ***
    '*** AuthorizeNet SSLPost ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("AuthNetSSLConnect.SSLPost")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bVendorSpecOnlineProcessing = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "AuthorizeNet SSLPost", "VSOP", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***
END IF '*** END DEPRECATED COMPONENT SECTION ***

    '*** AspSmart aspSmartMail ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("aspSmartMail.SmartMail")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bEmailComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "AspSmart aspSmartMail", "Email", sInstalled, gsTypeRequired, gsNotOptional, sAdditionalInfo
    '*** End ***
    
    '*** AspSmart aspSmartUpload ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("aspSmartUpload.SmartUpload")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bUploadComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "AspSmart aspSmartUpload", "Upload", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** Bamboo.SMTP ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("Bamboo.SMTP")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bEmailComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "Bamboo.SMTP", "Email", sInstalled, gsTypeRequired, gsNotOptional, sAdditionalInfo
    '*** End ***

    '*** DevGuru dgCharge ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("dgCharge.Charge")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bMultipurposeOnlineProcessing = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "DevGuru dgCharge", "MPOP", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** Dimac JMail ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("JMail.SMTPMail")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bEmailComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "Dimac JMail", "Email", sInstalled, gsTypeRequired, gsNotOptional, sAdditionalInfo
    '*** End ***

    '****Dundas Upload ****
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("Dundas.Upload.2")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bUploadComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "Dundas Upload", "Upload", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** Microsoft AD Rotator ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("MSWC.AdRotator")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "Microsoft Ad Rotator", "Misc.", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** Microsoft ADODB ***
    fMicrosoftADODBVersion = 0
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("ADODB.Connection")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        fMicrosoftADODBVersion = FVal("" & obj.Version)
        sInstalled = "" & fMicrosoftADODBVersion
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "The current version of MDAC/ADO can be download from <a href=""http://www.microsoft.com/data/"" target=""_blank"">www.microsoft.com/data/</a>. "
    ShowComponentInfo "Microsoft ADODB", "Data Access", sInstalled, gsRequired, gsNotOptional, sAdditionalInfo
    '*** End ***
    
    '*** Microsoft CDONTS ***
    bCDONTS = False
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("CDONTS.Session")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = "" & obj.Version
        bEmailComponent = True
        bCDONTS = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "See <a href=""http://www.xcent.com/FAQ/XcIBViewItem.asp?id=26"" target=""_blank"">FAQ Article 26</a>"
    ShowComponentInfo "Microsoft CDONTS", "Email", sInstalled, gsTypeRequired, gsNotOptional, sAdditionalInfo
    '*** End ***

    '*** Microsoft CDOSYS ***
    bCDONTS = False
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("CDO.Message")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bEmailComponent = True
        bCDOSYS = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "Microsoft CDOSYS", "Email", sInstalled, gsTypeRequired, gsNotOptional, sAdditionalInfo
    '*** End ***
    
    '*** Microsoft Counters ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("MSWC.Counters")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "Microsoft Counters", "Misc.", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** Microsoft FileSystem ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("Scripting.FileSystemObject")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bFileSystem = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    If bFileSystem Then
        sFile = Server.MapPath(".") & "\XcDiag.tmp"
        If TestFileSystemRW( sFile ) Then
            sAdditionalInfo = "Application can work with files in the same folder as XcDiag is running from."
        Else
            sAdditionalInfo = "Applications <b>cannot</b> work with files in the same folder as XcDiag is running from. See <a href=""http://www.xcent.com/FAQ/XcIBViewItem.asp?id=329"" target=""_blank"">FAQ Article 329</a>"
        End If
    End If
    ShowComponentInfo "Microsoft FileSystem", "FSO", sInstalled, gsRequired, gsNotOptional, sAdditionalInfo
    '*** End ***

    '*** Microsoft ServerXMLHTTP ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("MSXML2.ServerXMLHTTP")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bHTTPComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "Microsoft ServerXMLHTTP", "HTTP", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***
    
    '*** Microsoft XMLHTTP ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("Microsoft.XMLHTTP")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bHTTPComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "Microsoft XMLHTTP", "HTTP", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***
    
    '*** Persits AspEmail ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("Persits.MailSender")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
        sAdditionalInfo = "&nbsp;"
    Else
        sInstalled = gsInstalled
        bEmailComponent = True
        sAdditionalInfo = "Expires " & obj.Expires
    End If
    Set obj = Nothing
    On Error Goto 0
    ShowComponentInfo "Persits AspEmail", "Email", sInstalled, gsTypeRequired, gsNotOptional, sAdditionalInfo
    '*** End ***
    
    '*** Persits AspJpeg ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("Persits.Jpeg")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
        sAdditionalInfo = "&nbsp;"
    Else
        sInstalled = "" & obj.Version
        bImagingComponent = True
        sAdditionalInfo = "Expires " & obj.Expires
    End If
    Set obj = Nothing
    On Error Goto 0
    ShowComponentInfo "Persits AspJpeg", "Imaging", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***
    
    '*** Persits Upload ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("Persits.Upload.1")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bUploadComponent = True
    End If
    Set obj = Nothing
    sAdditionalInfo = "&nbsp;"
    On Error Goto 0
    ShowComponentInfo "Persits AspUpload", "Upload", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** ServerObjects AspImage ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("AspImage.Image")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = "" & obj.Version
        bImagingComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "ServerObjects AspImage", "Imaging", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** ServerObjects AspHTTP ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("AspHTTP.Conn")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = "" & obj.Version
        bHTTPComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    ShowComponentInfo "ServerObjects AspHTTP", "HTTP", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** ServerObjects AspMail ***
    fAspMailVersion = 0
    bAspMailAsAspQmail = False
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("SMTPsvg.Mailer")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        fAspMailVersion = Fval("" & obj.Version)
        sInstalled = "" & fAspMailVersion
        bEmailComponent = True
        Err.Clear
        obj.QMessage = True
        If Err.Number = 0 Then
            bAspMailAsAspQmail = True
        End If
    End If
    Set obj = Nothing
    On Error Goto 0
    sAdditionalInfo = "&nbsp;"
    If bAspMailAsAspQmail Then
        sAdditionalInfo = "ASPMail component appears to actually be AspQmail."
    End If
    ShowComponentInfo "ServerObjects AspMail", "Email", sInstalled, gsTypeRequired, gsNotOptional, sAdditionalInfo
    '*** End ***

    '*** SoftArtisans SA-Fileup ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("SoftArtisans.FileUp")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
        sAdditionalInfo = "&nbsp;"
    Else
        sInstalled = "" & obj.Version
        bUploadComponent = True
        If Len(Trim("" & obj.ExpirationDate)) > 0 Then
            sAdditionalInfo = "Expires: " & obj.ExpirationDate
        Else
            sAdditionalInfo = "Expires: n/a"
        End If
    End If
    Set obj = Nothing
    On Error Goto 0
    ShowComponentInfo "SoftArtisans SA-FileUp", "Upload", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** SoftArtisans SmtpMail ***
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("SoftArtisans.SMTPMail")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
        sAdditionalInfo = "&nbsp;"
    Else
        sInstalled = gsInstalled
        bEmailComponent = True
        sAdditionalInfo = "" & obj.Version
        If Len(Trim("" & obj.ExpirationDate)) > 0 Then
            sAdditionalInfo = sAdditionalInfo & " Expires: " & obj.ExpirationDate
        Else
            sAdditionalInfo = sAdditionalInfo & " Expires: n/a"
        End If
    End If
    Set obj = Nothing
    On Error Goto 0
    ShowComponentInfo "SoftArtisans SmtpMail", "Email", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End *** 

    '*** Verisign PayFlow Pro ***
    sAdditionalInfo = "&nbsp;"
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("PFProCOMControl.PFProCOMControl.1")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bVendorSpecOnlineProcessing = True
    End If
    Set obj = Nothing
    On Error Goto 0
    ShowComponentInfo "Verisign PayFlowPro", "VSOP", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** Verisign PayFlow Pro ***
    sAdditionalInfo = "&nbsp;"
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("WorldPay.COMpurchase")
    If Err.Number <> 0 Then
        bFirst = False
        sInstalled = gsNotInstalled
        sAdditionalInfo = "COMpurchase missing, "
    Else
        bFirst = True
        sInstalled = gsInstalled
        bVendorSpecOnlineProcessing = True
        sAdditionalInfo = "COMpurchase installed, "
    End If
    Set obj = Nothing

    '*** WebSupergoo ABCUpload ***
    sAdditionalInfo = "&nbsp;"
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("ABCUpload4.XForm")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = gsInstalled
        bUploadComponent = True
    End If
    Set obj = Nothing
    On Error Goto 0
    ShowComponentInfo "WebSupergoo ABCUpload", "Upload", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    
    '*** World Pay Select Com
    sAdditionalInfo = "&nbsp;"
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("WorldPay.COMcallback")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
        If bFirst Then
            sAdditionalInfo = sAdditionalInfo & "COMcallback missing "
        Else
            sAdditionalInfo = "&nbsp;"
        End If
    Else
        sInstalled = gsInstalled
        bVendorSpecOnlineProcessing = True
        sAdditionalInfo = sAdditionalInfo & "COMcallback installed "
    End If
    Set obj = Nothing
    On Error Goto 0
    
    ShowComponentInfo "WorldPay Select COM", "VSOP", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***

    '*** XCENT XUDTools
    sAdditionalInfo = "&nbsp;"
    Err.Clear
    On Error Resume Next
    Set obj = Server.CreateObject("XUDTOOLS.WSAClusterHelper")
    If Err.Number <> 0 Then
        sInstalled = gsNotInstalled
    Else
        sInstalled = "" & obj.Version 'gsInstalled
    End If
    Set obj = Nothing
    On Error Goto 0
    
    ShowComponentInfo "XCENT XUDTools", "Misc.", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    '*** End ***



    If Instr(1, sCMD, "XCPRIV") > 0 Then
        Err.Clear
        On Error Resume Next
        Set obj = Server.CreateObject("BROADCASTSERVER.BroadCast")
        If Err.Number <> 0 Then
            sInstalled = gsNotInstalled
            sAdditionalInfo = "[<b>" & Hex(Err.Number) & "</b>] " & Err.Description
        Else
            sInstalled = gsInstalled
            sAdditionalInfo = "&nbsp;"
        End If
        Set obj = Nothing
        On Error Goto 0
        ShowComponentInfo "XCENT BroadcastServer", "Custom", sInstalled, gsNotRequired, gsOptional, sAdditionalInfo
    End If





    Response.Write "<tr><td colspan=""6"">" & gsTypeRequiredInfo & "</td></tr>"

%>
  </table>
  &nbsp;
  <div align="left">
    <table border="1" cellpadding="2" cellspacing="0" width="100%" bordercolor="#000000" bordercolorlight="#00FFFF" bordercolordark="#0000FF">
      <tr>
        <td colspan="2" bgcolor="#C0C0C0"><b>Summary Information and Recommendations</b></td>
      </tr>
      <tr>
        <td width="200" bgcolor="#C0C0C0">Item</td>
        <td bgcolor="#C0C0C0">Information</td>
      </tr>
<%

    'ShowSummaryInfo "1", "2"
    If fScriptEngineVersion <= 5.1 Then
        ShowSummaryInfo "Script Engine", "It is recommended to upgrade the scripting engine on the web server for increased reliability, performance, and functionality. Versions 5.1 and earlier may exhibit some limitations in these areas. See <a href=""http://www.xcent.com/FAQ/XcIBViewItem.asp?id=312"" target=""_blank"">FAQ Article 312</a>"
    End If

    If fMicrosoftADODBVersion < 2.5 Then
        ShowSummaryInfo "Microsoft ADODB", "It is recommended to upgrade the Microsoft ADODB libraries (MDAC) to version 2.5 or later. See <a href=""http://www.xcent.com/FAQ/XcIBViewItem.asp?id=313"" target=""_blank"">FAQ Article 313</a>"
    End If
    If fMicrosoftADODBVersion >= 2.5 Then
        ShowSummaryInfo "Microsoft ADODB/JET", "If there are JET databases being used on this server, it is recommended to make absolutely sure the very latest Microsoft JET libraries are installed. See <a href=""http://www.xcent.com/FAQ/XcIBViewItem.asp?id=336"" target=""_blank"">FAQ Article 336</a>"
    End If
    If bCDONTS Then
        ShowSummaryInfo "Microsoft CDONTS", "CDONTS is also known as the Microsoft SMTP service which is an optional component of IIS. It is possible that CDONTS can be installed, but not be configured for use. If your site is hosted with an ISP, you may need to ask your ISP to properly configure it before it will function. See <a href=""http://www.xcent.com/FAQ/XcIBViewItem.asp?id=17"" target=""_blank"">FAQ Article 17</a>"
    End If
    If Not bFileSystem Then
        ShowSummaryInfo "Microsoft FileSystem", "The FileSystem object is required for any ASP application to be able to read/write files. This is a <b>critical</b> component that must be installed for an application to function. "
    End If
    If fAspMailVersion < 3.52 Then
        ShowSummaryInfo "ServerObjects ASPMail", "The version of ASPMail that is installed on this server is known to have some problems and it should be upgraded to 3.52 or later."
    End If
    If bEmailComponent Then
        ShowSummaryInfo "Email Component", "This web server appears to have at least one supported email component installed."
    Else
        ShowSummaryInfo "Email Component", "All XCENT web server applications require a valid email component to be installed and functional. Your web server does not appear to have any such components. One of the supported email components will need to be installed on the web server."
    End If
    If bUploadComponent Then
        ShowSummaryInfo "Upload Component", "This web server appears to have at least one upload component installed. You may need to verify if the application you want to use supports the upload component that is installed."
    Else
        ShowSummaryInfo "Upload Component", "Most XCENT web server applications will require an upload component in order to enable certain options. If you want to be able to upload files through your web browser to the application(s), you will need to install a supported upload component on your web server."
    End If
    If bImagingComponent Then
        ShowSummaryInfo "Imaging Component", "This web server appears to have at least one imaging component installed. You may need to verify if the application you want to use supports the imaging component that is installed."
    Else
        ShowSummaryInfo "Imaging Component", "Some XCENT web server applications can use an imaging component to generate image thumbnails, resize images, or other advanced effects. If you want to be able to take advantage of such additional features, you will need to install a supported imaging component."
    End If
    If bHTTPComponent Then
        ShowSummaryInfo "HTTP Component", "This web server appears to have at least one HTTP component installed. You may need to verify if the application you want to use supports the HTTP component that is installed."
    Else
        ShowSummaryInfo "HTTP Component", "Some XCENT web server applications can use an HTTP component to communicate with other web servers or internet services to provide more advanced features. If you want to be able to take advantage of such additional features, you will need to install a supported HTTP component."
    End If
    If bVendorSpecOnlineProcessing Then
        ShowSummaryInfo "VSOP Component", "This server has at least one supported Vendor Specific Online Processing component installed. See <a href=""http://www.xcent.com/FAQ/XcIBViewItem.asp?id=338"" target=""_blank"">FAQ Article 338</a>."
    Else
        ShowSummaryInfo "VSOP Component", "This server does not have any supported Vendor Specific Online Processing components installed. See <a href=""http://www.xcent.com/FAQ/XcIBViewItem.asp?id=338"" target=""_blank"">FAQ Article 338</a>."
    End If
    If bMultipurposeOnlineProcessing Then
        ShowSummaryInfo "MPOP Component", "This server has at least one supported Multipurpose Online Processing component installed. See <a href=""http://www.xcent.com/FAQ/XcIBViewItem.asp?id=338"" target=""_blank"">FAQ Article 338</a>."
    Else
        ShowSummaryInfo "MPOP Component", "This server does not have any supported Multipurpose Online Processing components installed. See <a href=""http://www.xcent.com/FAQ/XcIBViewItem.asp?id=338"" target=""_blank"">FAQ Article 338</a>."
    End If    
    If bFileSystem And bEmailComponent And (fMicrosoftADODBVersion > 0) Then
        ShowSummaryInfo "Minimum Requirements", "This web server seems to meet the minimum requirements for most XCENT web server applications."
    Else
        ShowSummaryInfo "Minimum Requirements", "This web server does not seem to meet minimum requirements for most XCENT web server applications." 
    End If
    
    
%>
    </table>
  </div>
</div>
<%

Sub ShowIISInfoLine(psCol1, psCol2)
    Response.Write "<tr><td width=""200"" valign=""top"">" & psCol1 & "</td>"
    Response.Write "<td valign=""top"">" & psCol2 & "</td></tr>"
End Sub

Sub ShowComponentInfo(psCol1, psCol2, psCol3, psCol4, psCol5, psCol6)
    Response.Write "<tr>"
    Response.Write "<td width=""200"" valign=""top"">" & psCol1 & "</td>"
    Response.Write "<td width=""100"" valign=""top"">" & psCol2 & "</td>"
    Response.Write "<td width=""50"" valign=""top"">" & psCol3 & "</td>"
    Response.Write "<td width=""40"" valign=""top"">" & psCol4 & "</td>"
    Response.Write "<td width=""40"" valign=""top"">" & psCol5 & "</td>"
    Response.Write "<td valign=""top"">" & psCol6 & "</td>"
    Response.Write "</tr>"
End Sub

Sub ShowSummaryInfo(psCol1, psCol2)
    Response.Write "<tr><td width=""200"" valign=""top"">" & psCol1 & "</td>"
    Response.Write "<td valign=""top"">" & psCol2 & "</td></tr>"
End Sub

Function RequestValue( psValueName )
   Dim sTemp 
   sTemp = Request.Form("" & psValueName)
   If Len(Trim(sTemp)) = 0 Then
      sTemp = Request.QueryString("" & psValueName)
   End If
   RequestValue = sTemp
End Function

Function FVal(pvValue)
   Dim sTemp
   Select Case VarType(pvValue)
      Case 0, 1:
         FVal = 0
      Case 2, 3, 4, 5, 6:
         FVal = pvValue
      Case 7:
         FVal = CDbl(pvValue)
      Case 8: 'String
         sTemp = Trim(pvValue)
         On Error Resume Next
         FVal = CDbl(sTemp)
         If Err.Number <> 0 Then
            Err.Clear
            FVal = 0
         End If
      Case 11:
         FVal = Cint(pvValue)
      Case 14:
         FVal = Clng(pvValue)
      Case Else
         FVal = 0
   End Select
End Function

Function TestFileSystemRW(psFilePath)
    Dim objFSO
    Dim objTS
    Dim sFilePath

    sFilePath = "" & psFilePath
    lErrorCount = 0
    On Error Resume Next
    Set objFSO = CreateObject("Scripting.FileSystemObject")
    If Err.Number = 0 Then
        'File System Object Created
        Set objTS = objFSO.CreateTextFile(sFilePath, True)
        If Err.Number = 0 Then
            'File created
            objTS.WriteLine("Testing")
            If Err.Number = 0 Then
                'Data written
                objTS.Close
                If Err.Number = 0 Then
                    'File closed
                    Set objFile = objFSO.GetFile(sFilePath)
                    If Err.Number = 0 Then
                        'File Handle Retrieved
                        objFile.Delete True
                        If Err.Number = 0 Then
                            'File was removed, successful test for this file
                            TestFileSystemRW = True
                        Else
                            'File could not be removed
                            TestFileSystemRW = False
                        End If
                    End If 'Could not retrieve file handle
                End If 'Problem closing file
            End If 'Could NOT write data
            objTS.Close
        End If 'File could NOT be created
        Set objTS = Nothing
    End If 'Cannot create file system object
    Set objFile = Nothing
    Set objTS = Nothing
    Set objFSO = Nothing
    On Error Goto 0
End Function


%>
<p align="center"><font size="1"> Copyright 2003 - XCENT - <a href="http://www.xcent.com" target="_blank">www.xcent.com</a></font></p>
</body>
</html>
