<!-- #include file="QNConfig.asp" -->
<!-- #include file="QNLangUSEng.asp" -->

<%
'*******************************************************************************
'* QuickNews Copyright 2003 XCENT - www.xcent.com                              *
'* QuickNews is a trademark of XCENT                                           *
'* This notice may not be removed from this source code file                   *
'*******************************************************************************
  
Function SQLStr(pvValue)
   Dim sTemp
   Select Case VarType(pvValue)
      Case 0, 1:
         SQLStr = "NULL"
      Case 2, 3, 4, 5, 6:
         sTemp = "" & pvValue
         sTemp = Replace(sTemp, "'", "''")
         SQLStr = "'" & sTemp & "'"
      Case 7: 'DateTime
         sTemp = FormatDateTime(pvValue)
         sTemp = Replace(sTemp, "'", "''")
         SQLStr = "'" & sTemp & "'"
      Case 8: 'String
         sTemp = pvValue
         sTemp = Replace(sTemp, "'", "''")
         If Len(Trim(sTemp)) > 0 Then
            SQLStr = "'" & sTemp & "'"
         Else
            SQLStr = "NULL"
         End If
      Case Else
         SQLStr = "NULL"
   End Select
End Function

Function SQLBool(pvValue)
   Dim sTemp
   Select Case VarType(pvValue)
      Case 0, 1:
         SQLBool = "'N'"
      Case 2, 3, 4, 5, 6:
         If pvValue Then
            SQLBool = "'Y'"
         Else
            SQLBool = "'N'"
         End If
      Case 8: 'String
         sTemp = UCase(Left(Trim(pvValue), 1))
         Select Case sTemp
            Case "Y", "T", "1", "-":
               SQLBool = "'Y'"
            Case "N", "F", "0", "":
               SQLBool = "'N'"
            Case Else
               SQLBool = "'N'"
         End Select
      Case 11:
         If pvValue Then
            SQLBool = "'Y'"
         Else
            SQLBool = "'N'"
         End If
      Case Else
         SQLBool = "'N'"
   End Select
End Function

Function SQLVal(pvValue)
   Dim sTemp

   Select Case VarType(pvValue)
      Case 0, 1:
         sTemp = "NULL"
      Case 2, 3, 4, 5, 6:
         sTemp = "" & pvValue
      Case 8: 'String
         sTemp = Trim(pvValue)
         On Error Resume Next
         sTemp = "" & CDbl(sTemp)
         If Err.Number <> 0 Then
            Err.Clear
            sTemp = "NULL"
         End If
      Case 11:
         sTemp = "" & Cint(pvValue)         
      Case Else
         sTemp = "NULL"
   End Select
   sTemp = Replace(sTemp, ",", ".")
   SQLVal = sTemp
End Function

Function SQLDate(pvDate)
    Dim sSQLDate
    Dim vDate
    Dim iBuild
    Dim sYear, sMonth, sDay, sHour, sMinute, sSecond
    sSQLDate = "NULL"
    iBuild = False
    Select Case VarType(pvDate)
        Case 7: 'Date
        	iBuild = True
        	vDate = pvDate
        Case 8: 'String
            If IsDate(pvDate) Then
                vDate = CDate(pvDate)
                iBuild = True
            End If
    End Select
    
    If iBuild Then
        Select Case giSQLDateFormat
            Case 1: 'SC SQL Server
                sSQLDate = gsSQLDateDelimiter & NumToStrLeadDigits(Year(vDate),4) & NumToStrLeadDigits(Month(vDate),2) & NumToStrLeadDigits(Day(vDate),2) & " " & FormatDateTime(vDate,4) & gsSQLDateDelimiter
            Case 2: 'SC JET-MDY
                sSQLDate = gsSQLDateDelimiter & Month(vDate) & "/" & Day(vDate) & "/" & Year(vDate) & " " & FormatDateTime(vDate,4) & gsSQLDateDelimiter
            Case 3: 'SC JET-DMY
                sSQLDate = gsSQLDateDelimiter & Day(vDate) & "/" & Month(vDate) & "/" & Year(vDate) & " " & FormatDateTime(vDate,4) & gsSQLDateDelimiter
            Case Else 'As System
                'sSQLDate = gsSQLDateDelimiter & FormatDateTime(vDate,2) & " " & FormatDateTime(vDate,4) & gsSQLDateDelimiter
                sYear = "" & Year(vDate)
                Do While Len(sYear) < 4
                	sYear = "0" & sYear
                Loop
                sMonth = "" & Month(vDate)
                Do While Len(sMonth) < 2
                	sMonth = "0" & sMonth
                Loop
                sDay = "" & Day(vDate)
                Do While Len(sDay) < 2
                	sDay = "0" & sDay
                Loop
                sHour = "" & Hour(vDate)
                Do While Len(sHour) < 2
                	sHour = "0" & sHour
                Loop
                sMinute = "" & Minute(vDate)
                Do While Len(sMinute) < 2
                	sMinute = "0" & sMinute
                Loop
                sSecond = "" & Second(vDate)
                Do While Len(sSecond) < 2
                	sSecond = "0" & sSecond
                Loop
                If (Hour(vDate)=0) And (Minute(vDate)=0) And (Second(vDate)=0) Then
                	sSQLDate = "{d '" & sYear & "-" & sMonth & "-" & sDay & "'}"
                Else
                	sSQLDate = "{ts '" & sYear & "-" & sMonth & "-" & sDay & " " & sHour & ":" & sMinute & ":" & sSecond & "' }"
                End If
        End Select
    End If
    
    sSQLDate = Replace(sSQLDate, ".", "/")
    SQLDate = sSQLDate
End Function

Sub NavBar
    If gbShowNavBar Then
        Response.Write "<BR><TABLE WIDTH=""" & gsTableWidth & """ ALIGN=""CENTER"" CELLSPACING=""0"" CELLPADDING=""0"" BORDER=""0"">"
        Response.Write "<TR bgcolor=""" & gsLineColor & """><TD COLSPAN=""2""></TD></TR>"
    	Response.Write "<TR bgcolor=""" & gsCellColor & """><TD COLSPAN=""2"">"
    	Response.Write gsNavOpen & "<CENTER><DIV CLASS=""QNNavBar"">"
    	Response.Write "<A HREF=""QuickNews.asp"">" & GLS_NavHome & "</A>" 
    	Response.Write "&nbsp;&nbsp;|&nbsp;&nbsp;"
    	Response.Write "<A HREF=""QuickNews.asp?TYPE=EXPIRED"">" & GLS_NavExpired & "</A>" 
    	Response.Write "</DIV></CENTER>"
    	Response.Write gsNavClose
    	Response.Write "</TD></TR>"
    	Response.Write "<TR bgcolor=""" & gsLineColor & """><TD COLSPAN=""2""></TD></TR>"
    	Response.Write "</TABLE></CENTER>"
	End If
End Sub

Sub DoPageFooter
   If Len(Trim(gsPageFooter)) > 0 Then
      Response.Write(gsPageFooter)
   End If
End Sub

Sub DoPageHeader
   Dim sPrePageFooter
   Dim lEmbeddedAt
   gsPageFooter = "<P><P align=""center""><FONT SIZE=""1""><EM>" & Chr(68) & Chr(114) & Chr(105) & Chr(118) & Chr(101) & _
                  Chr(110) & " " & Chr(98) & Chr(121) & " " & Chr(60) & Chr(65) & " H" & Chr(82) & "E" & Chr(70) & _
                  Chr(61) & Chr(34) & Chr(104) & Chr(116) & Chr(116) & Chr(112) & Chr(58) & Chr(47) & _
                  Chr(47) & Chr(119) & Chr(119) & Chr(119) & Chr(46) & Chr(120) & Chr(99) & _
                  Chr(101) & Chr(110) & Chr(116) & Chr(46) & Chr(99) & Chr(111) & Chr(109) & Chr(34) & " " & _
                  Chr(116) & "arg" & "et=" & Chr(34) & "res" & Chr(111) & "ur" & Chr(99) & "e" & Chr(32) & "window"">" & _
                  Chr(88) & Chr(99) & Chr(101) & Chr(110) & Chr(116) & "</" & Chr(65) & "></EM></FONT>"
   sPrePageFooter = gsPageFooter 
   sTemp = ""
   If Len(Trim(gsPageHeader)) > 0 Then
      On Error Resume Next
      Set fs = CreateObject("Scripting.FileSystemObject")
      Set ts = fs.OpenTextFile(gsPageHeader)
      sTemp = ts.ReadAll
      ts.Close
      Set ts = Nothing
      Set fs = Nothing
      On Error Goto 0
   End If
   If Len(Trim(sTemp)) = 0 Then
      sTemp = "<TITLE>QuickNews System</TITLE>"
   End If
   lEmbeddedAt = Instr(1, sTemp, gsEmbeddedCode, 1)
   If lEmbeddedAt > 0 Then
      gsPageFooter = sPrePageFooter & Right(sTemp, Len(sTemp) - lEmbeddedAt - Len(gsEmbeddedCode) + 1)
      sTemp = Left(sTemp, lEmbeddedAt - 1)
   End If
   Response.Write(sTemp)

End Sub

Sub OpenDBConn
   Set gobjConnect = Server.CreateObject("ADODB.Connection")
   gobjConnect.Open gsConnect
End Sub

Sub CloseDBConn
   gobjConnect.Close
   Set gobjConnect = Nothing
End Sub

Function RequestValue( psValueName )
   Dim sTemp 
   sTemp = Request.Form("" & psValueName)
   If Len(Trim(sTemp)) = 0 Then
      sTemp = Request.QueryString("" & psValueName)
   End If
   RequestValue = sTemp
End Function

Function FVal(pvValue)
   Dim sTemp
   Select Case VarType(pvValue)
      Case 0, 1:
         FVal = 0
      Case 2, 3, 4, 5, 6:
         FVal = pvValue
      Case 7:
         FVal = CDbl(pvValue)
      Case 8: 'String
         sTemp = Trim(pvValue)
         On Error Resume Next
         FVal = CDbl(sTemp)
         If Err.Number <> 0 Then
            Err.Clear
            FVal = 0
         End If
      Case 11:
         FVal = Cint(pvValue)
      Case 14:
         FVal = Clng(pvValue)
      Case Else
         FVal = 0
   End Select

End Function


Function FDate(pvDate)
   Select Case VarType(pvDate)
      Case 7: 'Date
         FDate = pvDate
      Case 8: 'String
         If IsDate(pvDate) Then
            FDate = CDate(pvDate)
         Else
            FDate = Null
         End If
      Case Else
         FDate = Null
   End Select
End Function

Function OutMatch(pvFirst, pvSecond, pvMatchOut, pvBadOut)
   Dim sFirst
   Dim sSecond
   sFirst = UCase(Trim("" & pvFirst))
   sSecond = UCase(Trim("" & pvSecond))
   If sFirst = sSecond Then
      OutMatch = pvMatchOut
   Else
      OutMatch = pvBadOut
   End If
End Function

Sub ShowHTMLFile(psFile)
   Dim sFile, fso, ts, sTemp 
   If Instr(psFile, "\") > 0 Then
      sFile = psFile
   Else
      sFile = Server.MapPath(".") & "\" & psFile
   End If

   On Error Resume Next
   Set fso = CreateObject("Scripting.FileSystemObject")
   Set ts = fso.OpenTextFile(sFile)
   sTemp = ts.ReadAll
   ts.Close
   Set ts = Nothing
   Set fso = Nothing
   
   If Len(Trim( "" & sTemp )) = 0 Then
      'Could not open file
      sTemp = "<B>Error</B><BR>File:" & sFile & " could not be read."
   End If

   Response.Write(sTemp)
End Sub

Function DispShortDate(pvValue)
    Dim vDate
    If IsDate(pvValue) Then
        vDate = DateAdd("h", giDeltaTime, CDate(pvValue))
        DispShortDate = FormatDateTime(vDate,2)
    Else
        DispShortDate = ""
    End If
End Function

Function DispLongTime(pvValue)
    Dim vDate
    If IsDate(pvValue) Then
        vDate = DateAdd("h", giDeltaTime, CDate(pvValue))
        DispLongTime = FormatDateTime(vDate,3)
    Else
        DispLongTime = ""
    End If
End Function

Function DispShortDateTime(pvValue)
    DispShortDateTime = "" & DispShortDate(pvValue) & " " & DispLongTime(pvValue)
End Function
%>