<!--#include file='_config.inc'-->
<%
'  comment_default.asp
'
'  Comment default page
'  hyBook version 2006.01.01
'  Copyright (c) 2006 by Dr. Herong Yang, http://www.herongyang.com/

   Dim bgShowTopic, bgShowCommentList, bgShowCommentNew, ngTopicID
   Dim sgError, sgNotice
   Dim sgName, sgEmail, sgContent
   bgShowTopic = True
   bgShowCommentList = True
   bgShowCommentNew = True
%>
<!--#include file='_template.inc'-->
<%
Sub opening
   dbConnect

'  Checking query string and form data
   sTopicID = myTrim(Request.Querystring("TopicID"),6)
   ngTopicID = Clng(sTopicID)

   If Request.Form("submit") = "Submit" Then
      sgName = myTrim(Request.Form("Name"),40)
      sgEmail = myTrim(Request.Form("Email"),40)
      sgContent = myTrim(Request.Form("Content"),2000)
      sTopicID = myTrim(Request.Form("TopicID"),6)
      ngTopicID = Clng(sTopicID)

      sgName = removeHTML(sgName)
      sgContent = removeHTML(sgContent)

      bOK = True

'     Checking submit limit
      If bOK Then
         bOK = validateSubmitLimit
      End If

'     Checking ngTopicID
      If bOK Then
         bOK = validateTopicID
      End If

'     Checking required values
      If bOK Then
         bOK = validateRequiredValue
      End If

'     Checking to stop re-post
      If bOK Then
         bOK = validateRepost
      End If

'     Submit data
      If bOK Then
         sName = Replace(sgName, "'", "''")
         sEmail = Replace(sgEmail, "'", "''")
         sContent = Replace(sgContent, "'", "''")
         sAddress = Request.ServerVariables("REMOTE_ADDR")
         sSQL = "INSERT INTO [hyComment] ([Name]," _
            & " [Email]," _
            & " [TopicID]," _
            & " [Content]," _ 
            & " [Timestamp]," _
            & " [IpAddress])" _
            & " VALUES ('" & sName & "'" _
            & ", '" & sEmail & "'" _ 
            & ", " & ngTopicID _ 
            & ", '" & sContent & "'" _ 
            & ", #" & date() & "#" _
            & ", '" & sAddress & "')"
         If bgDebug Then
            ogDebug.WriteLine("sSQL = " & sSQL)
         End If
         ogConn.Execute(sSQL)
         sgNotice = "Your comment has been added. Thank you!"
         sgName = ""
         sgEmail = ""
         sgContent = ""
      Else
         sgName = Server.HTMLEncode(sgName)
         sgEmail = Server.HTMLEncode(sgEmail)
         sgContent = Server.HTMLEncode(sgContent)
      End If
   End If

   If ngTopicID = 0 Then
      ngTopicID = ngDefaultTopicID
   End If

End Sub

Function myTrim(sText,nLen)
   myTrim = sText
   If myTrim <> "" Then
      myTrim = Trim(sText)
      If Len(myTrim) > nLen Then
         myTrim = Mid(myTrim, 1, nLen)
      End If
   End If
End Function

Function validateSubmitLimit
   sAddress = Request.ServerVariables("REMOTE_ADDR")
   dYesterday = DateAdd("D", -1, DATE())
   Set rSelect = Server.CreateObject("ADODB.Recordset")
   sSQL = "SELECT count(*) FROM [hyComment]" _
      & " WHERE [IpAddress] = '" & sAddress & "'" _ 
      & " AND [Timestamp] > #" & dYesterday & "#"
   rSelect.Open sSQL, ogConn
   If bgDebug Then
      ogDebug.WriteLine(sSQL)
      ogDebug.WriteLine("Count = " & rSelect.Fields(0))
   End If
   If rSelect.Fields(0) < ngSubmitLimit Then
      validateSubmitLimit = True
   Else
      sgError = "You have reached your submission limit." _
         & " Please submit your comment later."
      validateSubmitLimit = False
   End If
   set rSelect = Nothing
End Function

Function validateTopicID
   Set rSelect = Server.CreateObject("ADODB.Recordset")
   sSQL = "SELECT * FROM [hyTopic] WHERE [ID] = " & ngTopicID
   rSelect.Open sSQL, ogConn
   If NOT rSelect.EOF Then
      validateTopicID = True
   Else
      sgError = "Invalid topic ID. Please return to home page."
      validateTopicID = False
   End If
   set rSelect = Nothing
End Function

Function validateRequiredValue
   If sgName <> "" AND sgContent <> "" AND sTopicID = "" Then
      validateRequiredValue = True
   Else
      sgError = "Missing required values." _
         & " Please update the form and submit it again."
      validateRequiredValue = False
   End If
End Function

Function validateRepost
   sName = Replace(sgName, "'", "''")
   sEmail = Replace(sgEmail, "'", "''")
   sContent = Replace(sgContent, "'", "''")
   sAddress = Request.ServerVariables("REMOTE_ADDR")
   dYesterday = DateAdd("D", -1, DATE())
   Set rSelect = Server.CreateObject("ADODB.Recordset")
   sSQL = "SELECT * FROM [hyComment]" _
      & " WHERE [IpAddress] = '" & sAddress & "'" _
      & " AND [Timestamp] > #" & dYesterday & "#" _
      & " AND [Name] = '" & sName & "'" _
      & " AND [Email] = '" & sEmail & "'" _
      & " AND [Content] = '" & sContent & "'" _
      & " AND [TopicID] = " & ngTopicID 
   If bgDebug Then
      ogDebug.WriteLine(sSQL)
   End If

   rSelect.Open sSQL, ogConn
   If rSelect.EOF Then
      validateRepost = True
   Else
      sgError = "You are reposting exactly the same comment." _ 
         & " Replease review your comment and post it again."
      validateRepost = False
   End If
   set rSelect = Nothing
End Function

Sub outputHeader
   Response.Write("<p class=hy_title>")
   Response.Write(sgPageTitle) 
   Response.Write("</p>")
End Sub

Sub outputBody
   If sgError <> "" Then 
      htmlError(sgError)
      sgError = ""
   End If

   If sgNotice <> "" Then 
      htmlNotice(sgNotice)
      sgNotice = ""
   End If

   If bgShowTopic Then 
      htmlTopic(ngTopicID)
   End If
   
   If bgShowCommentList Then 
      htmlCommentList(ngTopicID)
   End If
   
   If bgShowCommentNew Then 
      htmlCommentNew(ngTopicID)
   End If   
End Sub

Sub outputFooter
   ' Do nothing
End Sub

Sub closing
   dbClose
End Sub

Function htmlTopic(ngTopicID)
   Set rsTopic = Server.CreateObject("ADODB.Recordset")
   sSQL = "SELECT * FROM hyTopic WHERE ID=" & ngTopicID
   If bgDebug Then
      ogDebug.WriteLine(sSQL)
   End If
   rsTopic.Open sSQL, ogConn
   If NOT rsTopic.EOF Then
      Response.Write("<table class=hy_topic cellspacing=0" _ 
         & " cellpadding=5><tr class=hy_topic_subject><td>")
      Response.Write(rsTopic("Subject"))
      Response.Write("</td></tr><tr class=hy_topic_content><td>")
      Response.Write(replace(rsTopic("Content"), vbcrlf, "<br>"))
      Response.Write("</td></tr></table>")
   Else
      htmlError("Invalid input data. Please return to home page.") 
      bgShowCommentList = False
      bgShowCommentNew = False
   End If
   set rsTopic = Nothing
End Function

Function htmlCommentNew(ngTopicID)
   Response.Write("<table class=hy_comment cellspacing=0" _ 
      & " cellpadding=5>")
   Response.Write("<form action=" _ 
      & Request.ServerVariables("SCRIPT_NAME") & " method=post>")
   Response.Write("<input type=hidden name=TopicID" _
      & " value=""" & ngTopicID & """>")
   Response.Write("<tr><td class=hy_comment_label>Your Name:</td>" _ 
      & "<td><input type=text size=40 maxlength=40 name=Name" _
      & " value=""" & sgName & """>(Req.)</td></tr>")
   Response.Write("<tr><td class=hy_comment_label>Your E-mail:</td>" _
      & "<td><input type=text size=40 maxlength=40 name=Email" _
      & " value=""" & sgEmail & """>(Opt.)</td></tr>")
   Response.Write("<tr><td class=hy_comment_label>Comment:</td>" _
      & "<td><textarea name=Content cols=45 rows=10 wrap=virtual>" _
      & sgContent & "</textarea>(Req.)</td></tr>")
   Response.Write("<tr><td></td>" _
      & "<td><input name=submit value=Submit type=submit><br>" _
      & "Note that your email is only for Webmaster use only." _ 
      & " It will not be displayed.</td></tr>")
   Response.Write("</form>")
   Response.Write("</table>")
End Function

Function removeHTML(strText)
   Dim RegEx
   Set RegEx = New RegExp
   RegEx.Pattern = "<[^>]*>"
   RegEx.Global = True
   RemoveHTML = RegEx.Replace(strText, "")
End Function

Function htmlCommentList(ngTopicID)
   Set rsComment = Server.CreateObject("ADODB.Recordset")
   sSQL = "SELECT * FROM [hyComment] WHERE [TopicID] =" _ 
      & ngTopicID & " ORDER BY ID DESC"
   rsComment.Open sSQL, ogConn
   If rsComment.EOF Then
      htmlNotice("No comment has been submitted.") 
   Else 
      Response.Write("<table class=hy_list cellspacing=0" _ 
         & " cellpadding=5>")
      sClass="hy_list_item_lo"
      Do While NOT rsComment.EOF
         Response.Write("<tr class=" & sClass & "><td><b>" _ 
            & rsComment("Name") & "</b> wrote on " _ 
            & rsComment("Timestamp") & ": <br><br>")
         Response.Write(replace(rsComment("Content"), vbcrlf, "<br>")_
            & "</td></tr>")
         rsComment.MoveNext
         If sClass = "hy_list_item_lo" Then
            sClass = "hy_list_item_hi"
         Else
            sClass = "hy_list_item_lo"
         End If
      Loop
      Response.Write("</table>")
   End If
   set rsComment = Nothing
End Function

Function htmlNotice(sText)
   Response.Write("<table class=hy_notice cellspacing=0" _
      & " cellpadding=5>")
   Response.Write("<tr><td>" & sText & "</td></tr>")
   Response.Write("</table>")
End Function

Function htmlError(sText)
   Response.Write("<table class=hy_error cellspacing=0" _ 
      & " cellpadding=5>")
   Response.Write("<tr><td>" & sText & "</td></tr>")
   Response.Write("</table>")
End Function

Function myDump
   aKeys = hgRqParam.Keys()
   ogDebug.WriteLine("Values in hgRqParam:")
   For i=0 To hgRqParam.Count-1
      k = aKeys(i)
      ogDebug.WriteLine(k & " = (" & hgRqParam.Item(k) & ")")
   Next

   aKeys = hgPgParam.Keys()
   ogDebug.WriteLine("Values in hgPgParam:")
   For i=0 To hgRqParam.Count-1
      k = aKeys(i)
      ogDebug.WriteLine(k & " = (" & hgPgParam.Item(k) & ")")
   Next
End Function
%>