<?php

/**
 *@package DortIslem
 *@author  Serkan Ceylani serkan@turk-php.com
 *@copyright 2005 turk-php.com
 */

class DortIslem {
    
    /**
     * Islemlerde kullanilan birinci grup sayi kumesi (X).
     * array(3,4,7,8); seklinde dizi olarak verildiginde,
     * dizinin toplami esas alinir...
     * 
     * @var array
     *
     *
     */
    
    public  $IsSayilarX = array();
   
    /**
     * Islemlerde kullanilan ikinci grup sayi kumesi (Y).
     * array(3,4,7,8); seklinde dizi olarak verildiginde,
     * dizinin toplami esas alinir...
     * 
     * @var array
     *
     *
     */
    
    public  $IsSayilarY = array();  
    
    /**
     * Verilen sayi kumesinin toplam sekline donusturulmus sekli.
     *
     * @var integer
     *
     *
     */

    public  $X;
    
    /**
     * Verilen sayi kumesinin toplam sekline donusturulmus sekli.
     *
     * @var integer
     *
     *
     */    
    
    public  $Y;

    /**
        * X ve Y sayilari ile DortIslem nesnesi olusturuluyor.(Constructor)
        *
        * @param $sayilarX  -- X sayi kumesi,
        * @param $sayilarY  -- Y sayi kumesi,
        *
        * @return void
    */
    
    /**
       * Dort islem nesnesi icin ornek kullanim:
       * <code>
       * $sayiX    = array (3,5,1,2);
       * $sayiY    = array (1,1,2,1);
       *
       * $math      = new DortIslem($sayiX,$sayiY);
       * 
       * print "X Sayisi  : {$math->X  }  \n<br />";
       * print "Y Sayisi  : {$math->Y  }  \n<br />";
       * print "\n<br />";
       * print "Toplam    : {$math->Toplama()}  \n<br />";
       * print "Fark      : {$math->Cikarma()}  \n<br />";
       * print "Carpim    : {$math->Carpma() }  \n<br />";
       * print "Bolum     : {$math->Bolme()  }  \n<br />";
       * print "Modul     : {$math->Modul()  }  \n<br />";
       * </code>
    */
    function __construct($sayilarX,$sayilarY){
        
        $this->IsSayilarX = $sayilarX;
        $this->IsSayilarY = $sayilarY;
    
        $this->X          = $this->SetX();
        $this->Y          = $this->SetY();
        
    }
    
    
    /**
        * X ve Y sayilari icin toplama islemi.
        *
        * @return $this->Toplam integer
        * 
    */
    function Toplama() {
        
        $this->Toplam = $this->X + $this->Y;
        return ($this->Toplam);
    }
    /**
        * X ve Y sayilari icin cikarma islemi.
        *
        * @return $this->Fark integer
        * 
    */
    function Cikarma() {
        
        $this->Fark = $this->X - $this->Y; 
        return ($this->Fark);
    }
    /**
        * X ve Y sayilari icin carpim islemi.
        *
        * @return $this->Carpim integer
        * 
    
    */    
    function Carpma() {
        
        $this->Carpim = $this->X * $this->Y;
        return ($this->Carpim);
        
    }
    /**
        * X ve Y sayilari icin bolum islemi.
        *
        * @return $this->Bolum integer
        * 
    */    
    function Bolme() {
        
        
        if ($this->Y == 0 || $this->Y === null ) {
            die("Bolunen sayi sifir olamaz");
        }
        
        $this->Bolum = $this->X/$this->Y;
        return ($this->Bolum);
        
    }
    /**
        * X ve Y sayilari icin modul islemi.
        *
        * @return $this->Modul integer
        * 
    */    
    function Modul() {
        
       
        $this->Modul = $this->X % $this->Y;
        return ($this->Modul);
        
    }
    
    function AsalMi ($sayi,$aralik=false) {
        
    }
    
    function SetX(){
        if (is_array($this->IsSayilarX)){ // dizi ise
            $X = array_sum($this->IsSayilarX);
        } else {
            $X = $this->IsSayilarX;
        }
        return (real)$X;
    }
    
    function SetY(){
        if (is_array($this->IsSayilarY)){ // dizi ise
            $Y = array_sum($this->IsSayilarY);
        } else {
            $Y = $this->IsSayilarY;
        }
        return (real)$Y;
    }
    
    function SetSayi (){
        if (is_array($this->Sayi)){ // dizi ise
            $tempT = array_sum($this->Sayi);
        } else {
            $tempT = $this->Sayi;
        }
        return (real)$tempT;
    }
    
}


class KareKok extends DortIslem {
    
    
    
    public $Sayi;
    /**
     * Karekok icin ornek kullanim :
     *  <code>
     *  $sayiX     = array (3,5,1,2);
     *  $karekok   = new KareKok($sayiX);
     *  print "SayiX icin ( {$karekok->SetSayi()} ) icin Karekok = {$karekok->Sonuc()} \n<br />";
     *  </code>
     */
    function __construct ($sayi) {
        $this->Sayi = $sayi;
    }
    
    
    
    function Sonuc () {
        return sqrt($this->SetSayi());
    }
    
}

class Faktoryel extends DortIslem {
    
    public $Sayi;
    /**
     * Faktoryel icin ornek kullanim :
     *  <code>
     *  $sayiX     = array (3,5,1,2);
     *  $faktoryel = new Faktoryel($sayiX);
     *  print "( {$faktoryel->SetSayi()}) sayisi icin
     *  Faktoryel = {$faktoryel->Sonuc($faktoryel->SetSayi())}
     *  \n<br />";
     *  </code>
     */
    function __construct ($sayi) {
        $this->Sayi = $sayi;
    }
    
    function Sonuc ($n) {   
        
        if ($n == 0 || $n == 1)
        { // $n == 0 veya $n == 1 ise donguden cik
        return 1;
        }
        else
        { // dongu satiri 10*9*8*7*6... gibi
        return ( $n * $this->Sonuc ($n-1));
        }
    }
    
}

class KesirliYazim extends DortIslem {
    
    public $Sayi;
    /**
     * Kesirli yazim icin icin ornek kullanim :
     *  <code>
     *  $kesirli = new KesirliYazim(1.5);
     *  print ("\n<br />".$kesirli->Sonuc());
     *  </code>
     */
    function __construct ($sayi) {
        $this->Sayi = $sayi;
    }
    
    function _Kesir($sayiA, $sayiB) {
        
        while ( $sayiB != 0){
            
            $kalan = $sayiA % $sayiB;
            $sayiA = $sayiB;
            $sayiB = $kalan;
        
        }
    return abs ($sayiA);
    }
    
    function Sonuc (){
        
        list($TamKesim,$OndalikKesim) = explode(".",$this->Sayi);
        $OnlukHaneleri                = 1 . str_repeat(0, strlen($OndalikKesim));
        
        $kesir                        = $this->_Kesir($OndalikKesim,$OnlukHaneleri);
        
        $OndalikKesim                 = $OndalikKesim  / $kesir;
        $OnlukHaneleri                = $OnlukHaneleri / $kesir;
        
        return sprintf ('%d <sup>%d</sup>/<sub>%d</sub>',$TamKesim,$OndalikKesim,$OnlukHaneleri);
    }
}


/**
 *@package Taban
 *@author  Serkan Ceylani serkan@turk-php.com
 *@copyright 2005 turk-php.com
 */


class Taban {
    
    public $Ifade;
    public $CevrilenTaban;
    public $CevrilecekTaban;
    /**
     *   Taban icin ornek kullanim:
     *   <code>
     *   $taban     = new Taban("FF00FF","16","2"); //Test degerleri
     *   print "FF00FF ifadesi 16 lik tabandan 2 lik Tabana cevrilirse : {$taban->Sonuc()}";
     *   </code>
     */
     
    function __construct($ifade,$cevrilen,$cevrilecek){
        
        $this->Ifade           = $ifade;
        $this->CevrilenTaban   = $cevrilen;
        $this->CevrilecekTaban = $cevrilecek;
    
    }
    
    function Sonuc () {
        return base_convert($this->Ifade,$this->CevrilenTaban,$this->CevrilecekTaban);
    }
}


/**
 *@package FonksiyonKokleriniBul
 *@author  Serkan Ceylani serkan@turk-php.com
 *@copyright 2005 turk-php.com
 */

class FonksiyonKokleriniBul {
    
    public $Fonksiyon;
    public $XAramaBaslangicNoktasi;
    public $XAramaBitisNoktasi;
    public $Tolerans;
    public $Adim;
    
    /**
     * Fonksiyon koklerini bulmak icin ornek kullanim:
     * Sablon:$fonksiyon,$xsolnokta,$xsagnokta,$tolerans,$adim
     * <code>
     * $kokler    = new FonksiyonKokleriniBul("(x*x-9)","-10","+10","0.01","0.1");
     * print_r ($kokler->Sonuc());
     * </code>
     */
    
    function __construct($fonksiyon,$xsolnokta,$xsagnokta,$tolerans,$adim) {
        
        $this->Fonksiyon              = $fonksiyon;
        $this->XAramaBaslangicNoktasi = $xsolnokta;
        $this->XAramaBitisNoktasi     = $xsagnokta;
        $this->Tolerans               = $tolerans;
        $this->Adim                   = $adim;
        $this->Kokler                 = array();
    }

    function Sonuc(){
		$index  = 0;
		$solnokta      =  $this->XAramaBaslangicNoktasi;
		do {
			$bulundumu = 0;
			
            $sagnokta  = $solnokta + $this->Adim; 
			
            while( abs ( $sagnokta - $solnokta ) > $this->Tolerans){
				
                eval('$solnoktaYdegeri='.str_replace('x','$sagnokta',$this->Fonksiyon).";"); 
				eval('$sagnoktaYdegeri='.str_replace('x','$solnokta',$this->Fonksiyon).";"); 
				
                if( $solnoktaYdegeri * $sagnoktaYdegeri < 0 ) {
					
                    $bulundumu = 1;
					
                    $karsilikXdegeri = (real)($solnokta + $sagnokta) / (real)2;
					
                    eval('$karsilikYdegeri='.str_replace('x','$karsilikXdegeri',$this->Fonksiyon).";");
					
                    if( $karsilikYdegeri * $solnoktaYdegeri < 0 ){
						$sagnokta = $karsilikXdegeri;
					} else {
						$solnokta = $karsilikXdegeri;
					}
					continue;
                } else {
                    break;
                }
			}
			if($bulundumu == 1){	
				$this->Kokler[$index++] = (real)($solnokta);
			}
			$solnokta = $sagnokta;
		} while( $sagnokta < $this->XAramaBitisNoktasi );
	return ($this->Kokler);
	}
}

/**
 *@package Daire
 *@author  Serkan Ceylani serkan@turk-php.com
 *@copyright 2005 turk-php.com
 */

class Daire {
    
    public $Yaricap;
    
    /**
     *  Daire icin ornek kullanim:
     *  <code>
     *   $daire = new Daire (3); // Yaricapi 3 birim olan daire nesnesi
     *   print ("<br>Daire Cevresi:" . $daire->Cevre ()." Birim ");
     *   print ("<br>Daire Alani  :" . $daire->Alan ()." Birim ");
     *   print ("<br>Daire Dilimi Alani (180 derece icin)" . $daire->DaireDilimiAlani (180)." Birim ");
     *   </code>
     */
    
    function __construct($yaricap) {
        
        $this->Yaricap = $yaricap;
    }
    
    function Cevre () {
        return ( 2 * M_PI * $this->Yaricap );
    }
    
    function Alan () {
        return  M_PI * pow($this->Yaricap,2);
    }
    
    function DaireDilimiAlani ($aci) {
        return ( M_PI * pow($this->Yaricap,2) * $aci / 360 );
    }
    
    function DaireYayiUzunlugu ($aci) {
        return ( 2 * M_PI * $this->Yaricap * $aci / 360 );
    }
}

/**
 *@package Ucgen
 *@author  Serkan Ceylani serkan@turk-php.com
 *@copyright 2005 turk-php.com
 */


class Ucgen {
    
    public $UcgenKenar1;
    public $UcgenKenar2;
    public $UcgenKenar3;
    
    public $UcgenAci1;
    public $UcgenAci2;
    public $UcgenAci3;
    
    public $Yukseklik;
    public $Taban;
    
    /**
     *
     * Ucgen nesnesi kenar uzunluklari verilerek olusturuluyor.
     *
     * Kenar uzunluklari bilinen bir ucgen icin Alan ve Aci degerleri
     * hesaplaniyor...
     *  <code> 
     *   $ucgen = new Ucgen;
     *
     *   $ucgen->Kenarlar(6,8,10);
     *
     *   echo $ucgen->AciA();
     *   print "\n <br />";
     *   echo $ucgen->AciB();
     *   print "\n <br />";
     *   echo $ucgen->AciC();
     *   print "\n <br />";
     *
     *   echo $ucgen->Alan();
     *   </code>
     */
    
    
    function __construct () {
    }
    
    function Kenarlar ($kenar1,$kenar2,$kenar3) {
        
        $this->UcgenKenar1 = (real)$kenar1;
        $this->UcgenKenar2 = (real)$kenar2;
        $this->UcgenKenar3 = (real)$kenar3;
        
        if (($this->UcgenKenar1 < 0) || ($this->UcgenKenar2 < 0) || ($this->UcgenKenar3 < 0)) {
            die ("Ucgen icin kenar uzunlugu negatif olamaz...");
        }
        
        $tS = (int)$this->getS();
        
        if ( $tS * ($tS - $this->UcgenKenar1) * ($tS - $this->UcgenKenar2) * ($tS - $this->UcgenKenar3) < 0 ) {
            die ("Verilen uzunluklar ile gercek bir ucgen yaratilamaz...");
        }
    }
    
    private function getS () {
        return (1 / 2 * ($this->UcgenKenar1 + $this->UcgenKenar2 + $this->UcgenKenar3));
    }
    
    function Acilar ($aci1=null,$aci2=null,$aci3=null) {
        
        $this->UcgenAci1 = (real)$aci1;
        $this->UcgenAci2 = (real)$aci2;
        $this->UcgenAci3 = (real)$aci3;
        
        if (($this->UcgenAci1 < 0) || ($this->UcgenAci2 < 0) || ($this->UcgenAci3 < 0)) {
            die ("Ucgen icin aci degeri negatif olamaz...");
        }
        
        if ( ($this->UcgenAci1 + $this->UcgenAci2 + $this->UcgenAci3) != 180 ) {
            die ("Verilen ic acilarin toplami 180 olmalidir...");
        }
    }
    
    function Alan () {
        if ($this->kenarDegerleri()){
        
        $tS = (real)$this->getS();
        
            return sqrt(
            ($tS * ($tS - $this->UcgenKenar1) *
            ($tS - $this->UcgenKenar2) * ($tS - $this->UcgenKenar3))
            );
        }
        if (isset($this->Yukseklik) && isset($this->Taban)){
            return ( 1 / 2 * $this->Yukseklik * $this->Taban );
        }
        
    die("Ucgenin alani icin kenar veya yukseklik degerlerini belirlemelisiniz...");
    return FALSE;
    }
    
    function kenarDegerleri () {
        return (isset($this->UcgenKenar1) && isset($this->UcgenKenar2) && isset($this->UcgenKenar3));
    }
    
    function setYukseklik ($yukseklik) {
        $this->Yukseklik = (real)$yukseklik;
    }
    
    function setTaban     ($taban) {
        $this->Taban     = (real)$taban;
    }
    
    function getYukseklik () {
        return $this->Yukseklik;
    }
    
    function getTaban () {
        return $this->Taban;
    }
    
    function AciA () {
        if ($this->kenarDegerleri()){
            
            $tempIfade1 =  pow($this->UcgenKenar2,2) + pow($this->UcgenKenar3,2) - pow($this->UcgenKenar1,2);
            $tempIfade2 =  2 *  $this->UcgenKenar2 * $this->UcgenKenar3;
            $tempIfade3 =  $tempIfade1 / $tempIfade2;
            
            $sonuc = round(rad2deg(acos($tempIfade3)));
            
            return ($sonuc);
            
        }
        return FALSE;
    }
    
    function AciB () {
        if ($this->kenarDegerleri()){
            
            $tempIfade1 = (int) pow($this->UcgenKenar1,2) + pow($this->UcgenKenar3,2) - pow($this->UcgenKenar2,2);
            $tempIfade2 = (int) 2 *  $this->UcgenKenar1 * $this->UcgenKenar3;
            $tempIfade3 = (int) $tempIfade1 / $tempIfade2;

            $sonuc = round(rad2deg(acos($tempIfade3)));
            
            return ($sonuc);
            
        }
        return FALSE;
    }
    
    function AciC () {
        if ($this->kenarDegerleri()){
            
            $tempIfade1 = (int) pow($this->UcgenKenar1,2) + pow($this->UcgenKenar2,2) - pow($this->UcgenKenar3,2);
            $tempIfade2 = (int) 2 *  $this->UcgenKenar1 * $this->UcgenKenar2;
            $tempIfade3 = (int) $tempIfade1 / $tempIfade2;
            
            
            $sonuc = round(rad2deg(acos($tempIfade3)));
            
            return ($sonuc);
            
        }
        return FALSE;
    }
}
?>