<%
'option explicit

'//===============================================================================================
'//
'// Date: 26 October 2005
'//
'// Author:  Robert "Nicodemas" Simpson
'//
'// This program:
'//      - creates a dynamic calendar using ASP with 'Next' and 'Previous' links to navigate
'//        throughout the Julian calendar, and
'//      - allows the user to set whether the script should query for data stored in a
'//        data source to related the dates in the calendar to the events
'//
'// Notes:
'//      - turn on/off option explicit as needed by your scripting (outside of this calendar script, such as if you include this file somewhere),
'//      - as mentioned, this only works for the Julian calendar system,
'//      - the data connection used by this system has to be changed based on the 
'//        needs of each system and data source,
'//      - this program is written entirely in ASP VBScript,
'//      - tested in IE 6.0 and Mozilla Firefox 1.0.7.
'//
'// Copyright:
'//      - Hey, I really do not care if you use this code.  I did not write it for profit.  Ergo,
'//        feel free to remove my name and any traces of me from this code.  But, if you like to
'//        give credit where credit is due then link to my site: nicodemas.com.  Or, just leave these
'//        comments as they are and get on with whatever you were doing before you spent 19.8 seconds
'//        reading this copyright statement.
'//
'// Disclaimer:
'//      - Use this code at your own risk.  If it has adverse effects on your web server(s) or database(s),
'//        then just remember: it works for me, I never said it would work for you explicitly. 
'//        Basically, I am not responsible.  
'//===============================================================================================

dim qsDate '// the date passed through the query string
dim thisDate '// the date to work with
dim thisMonth '// the 'current' month to work with
dim thisYear '// the 'current' year to work with
dim thisDay '// the 'current' day to work with
dim thisPage '// the filename of the page running this script
dim nextMonth '// the month number proceeding the [thisMonth] with acknowledgement of the Dec-Jan lapse
dim previousMonth '// the month preceeding [thisMonth]  with acknowledgement of the Jan-Dec lapse
dim startOfWeek '// the day number which starts the calendar week Sunday = 1, Saturday = 7
dim firstDayofThisMonth '// the first date appearing in the 'current' month
dim lastDayofPreviousMonth '// the last date in the month preceeding the 'current' month
dim lastWeekdayofPreviousMonth '// the last weekday (one thru seven; Sunday thru Saturday) in the preceeding month
dim firstWeekdayofThisMonth '// the first weekday (one thru seven; Sunday thru Saturday) in the 'current' month
dim firstDayofNextMonth '// the starting date of the month proceeding the 'current' working month
dim lastDayofThisMonth '// the last date of the 'current' working month
dim lastWeekdayofThisMonth '// the last weekday (one thru seven; Sunday thru Saturday) of the 'current' working month
dim startDayOfMonth '// the day number that every month starts with
dim maxDaysPerWeek '// the maximum number of days a week lasts
dim daysInThisMonth '// the number of days that occur in the 'current' working month
dim monthsInYear '// the number of months in a year
dim sEventDays '// an string to use for appending event days to; will be split and referenced for corresponding events while determining if a date should be highlighted in the calendar
dim iEventDays '// an array created from the split() of sEventDays
dim iDateDiff '// a range indicating integer variable
dim classEventTrue '// a CSS class name for hyperlinked days with corresponding events
dim eventHyperlink '// a string that holds a URL value
dim spanMultipleDays '// a boolean value indicating if multiple days should be highlighted in the calendar
dim sSQL '// an SQL statement
dim activeStatusNumber '// a constant value that defines what delineates 'active' records
dim QueryEventData '// a boolean value to determine whether the system should work with a data source, or just be a dynamic calendar
dim rsEventDays '// a recordset
dim aRecords '// an array that stores recordset data
dim aEventDays '// an array of days that have events
dim ibound '// an upper boundary integer variable

dim cnt '// a counter variable
dim nCnt '// a counter variable
dim currentDayinWeek '// a counter variable

dim iError '// an error number that raises an error flag to the program
dim iMsg   '// denotes an id for a system message to be printed to the screen later

'//==================================================
'// define the system error and message default
'// values.  Events are triggered (or not triggered)
'// based on these values.
'//==================================================

iError = 0
iMsg   = 0

'//==================================================
'// thisPage is the filename of the web page running
'// this calendar script, minus any querystring
'// data
'//==================================================
thisPage = thisPage = mid(request.servervariables("SCRIPT_NAME"), InstrRev(request.servervariables("SCRIPT_NAME"), "/") + 1)

'//==================================================
'// establish the current date figures to work with
'//==================================================

if request("searchDate") <> "" then
   if isdate(request("searchDate")) then
      thisDate = request("searchDate")
   else
      iError = 1
      iMsg   = 1
   end if
else
   thisDate = date
end if

if iError = 0 then

   thisMonth = month(thisDate)
   thisYear = year(thisDate)
   thisDay = day(thisDate)

   '//==================================================
   '// define the start of the week for this calendar
   '//==================================================

   startOfWeek = 1 '// vbSunday

   '//==================================================
   '// define the starting day of each month
   '//==================================================

   startDayOfMonth = 1

   '//==================================================
   '// define the number of months in a year
   '//==================================================

   monthsInYear = 12

   '//==================================================
   '// define max days per week
   '//==================================================

   maxDaysPerWeek = 7

   '//==================================================
   '// define the number that delineates "active"
   '// records in the data base, or comment this out
   '// if you do not track active or disabled status
   '//==================================================

   activeStatusNumber = 1

   '//==================================================
   '// define if the system should use a data source
   '// to highlight days with events
   '//==================================================

   QueryEventData = false

   '//==================================================
   '// define a CSS class name for events that 
   '// have a corresponding event,
   '//
   '// when QueryEventData = true only, this class will
   '// be applied to a hyperlink.
   '//==================================================

   classEventTrue = "eventTrue"

   '//==================================================
   '// define if the system should highlight multiple
   '// days in the calendar, if an event is multiple
   '// days in length.  Otherwise, it will only
   '// highlight the first day of the event.
   '//==================================================   
   spanMultipleDays = false

   '//==================================================
   '// deduce last weekday of previous month by
   '// getting the date of the last day in this month,
   '// subtracting one from it, then using the difference
   '// date and running it through the Weekday() function
   '// to resolve the last weekday of the previous month.
   '//==================================================

   firstDayofThisMonth = cdate(thisMonth & "/1/" & thisYear)
   lastDayofPreviousMonth = cdate((firstDayofThisMonth - 1))
   lastWeekdayofPreviousMonth = weekday(lastDayofPreviousMonth)

   '//==================================================
   '// get the starting weekday of thisMonth
   '//==================================================

   firstWeekdayofThisMonth = weekday(firstDayofThisMonth)

   '//==================================================
   '// if proceeding a month would cause a yearly lapse,
   '// add one (1) to the year of the date for next
   '// month
   '//==================================================

   if (thisMonth + 1) > monthsInYear then
      firstDayofNextMonth = cdate("1/" & startDayOfMonth & "/" & (thisYear + 1))
   else
      firstDayofNextMonth = cdate((thisMonth + 1) & "/" & startDayOfMonth & "/" & thisYear)
   end if

   '//==================================================
   '// derive the last day of thisMonth by subtracting 
   '// one (1) day from the next first day in the next
   '// month.  This makes up for the fact that we
   '// have not declared explicitly if each month has
   '// 28, 29, 30, or 31 days.  Pretty handy for leap
   '// year calculations.
   '//==================================================

   lastDayofThisMonth = cdate((firstDayofNextMonth - 1))
   lastWeekdayofThisMonth = weekday(lastDayofThisMonth)

   '//==================================================
   '// get the number of days in this month
   '//==================================================

   daysInThisMonth = datediff("d", lastDayofPreviousMonth, lastDayofThisMonth)

   if QueryEventData then
      '//==================================================
      '// Query the event data for all events with dates
      '// that are between the first and last day of this
      '// month.
      '//
      '// This query bases results on active/disabled
      '// values.  Omit the WHERE condition for evtStatus
      '// if you do not track such data.
      '//==================================================

      sSQL = "SELECT evtID, evtDate, evtDateEnd FROM PC_Events WHERE evtStatus = "& activeStatusNumber &" AND evtDate BETWEEN #"& firstDayofThisMonth &"# AND #"& lastDayofThisMonth &"#"

      set rsEventDays = dbconn.execute(sSQL)

      '//==================================================
      '// dump the recordset into a 2D array, then populate
      '// an array with days that correspond to an event
      '//==================================================

      if not rsEventDays.eof then
         aRecords = rsEventDays.getrows() '// get 2D array of records
         set rsEventDays = nothing

         ibound = ubound(aRecords, 2) '// get ubound of 2D array

         '//==================================================
         '// loop through the recordset, and
         '// insert the start day of an event into aEventDays.
         '//==================================================
         
         for nCnt = 0 to ibound

            if sEventDays = "" or isempty(sEventDays) then
               sEventDays = sEventDays & (day(cdate(aRecords(1,nCnt))))
            else
               sEventDays = sEventDays & ("," & day(cdate(aRecords(1,nCnt))))
            end if

            '//==================================================
            '// if the event has an end date, amass the days in
            '// between in sEventDays
            '//==================================================

            if isdate(aRecords(2,nCnt)) AND spanMultipleDays then

               iDateDiff = clng(datediff("d", cdate(aRecords(1,nCnt)), cdate(aRecords(2,nCnt))))

               '//==================================================
               '// if the event spans more than one day, get the
               '// extra days it lasts, and enter their dates in 
               '// sEventDays, too.
               '//==================================================
            
               if clng(iDateDiff) > 0 then
                  for cnt = 1 to iDateDiff
                     '//==================================================
                     '// make sure the date being appended does not fall
                     '// on a new month or year than the current date
                     '// because that would highlight the first day of the
                     '// 'current' working month, and that could be false
                     '// data.
                     '//
                     '// The program is only looking for days, here, to
                     '// be used later.  Nothing more like month numbers
                     '// or years.
                     '//==================================================
                     if datediff("m", thisMonth, month(cdate( (aRecords(1,nCnt) + cnt) ))) < 1 then
                        sEventDays = sEventDays & ("," & day( cdate( (aRecords(1,nCnt) + cnt) ) ) )
                     end if
                  next
               end if
            end if
         next
      end if

      '//==================================================
      '// split the string of days into a one-d array
      '//==================================================
      
      aEventDays = split(sEventDays, ",")

   end if 'QueryEventData
end if 'iError=0

'//==================================================
'// if a system message has been raised, display it
'//==================================================

if iMsg <> 0 then
   response.write "<p>"

   select case iMsg
      case 1 : response.write ""
   end select

   response.write "</p>"
end if
%>

<table cellpadding="0" cellspacing="0" class="calendarTable" summary="This table represents a calendar for <%= monthname(thisMonth) & " " & thisYear %>">
   <caption><span class="PreviousMonthLink"><a href="?searchDate=<%= lastDayofPreviousMonth - 3 %>" title="View the previous month">&lt;&lt;</a></span><%= monthname(thisMonth) & " " & thisYear %><span class="NextMonthLink"><a href="?searchDate=<%= firstDayofNextMonth + 1 %>" title="View next month">&gt;&gt;</a></caption>
      <tr>
         <th scope="col">Sun</th>
         <th scope="col">Mon</th>
         <th scope="col">Tue</th>
         <th scope="col">Wed</th>
         <th scope="col">Thu</th>
         <th scope="col">Fri</th>
         <th scope="col">Sat</th>
      </tr>

      <tr>
      <%
      '//==================================================
      '// write blank cells equal to the amount of weekdays
      '// passed through in the previous month up to first
      '// weekday of this month.
      '//
      '// Special:  if the last month ended on the last
      '//           day of the week, don't write the blank
      '//           cells.  Instead, just skip on to
      '//           writing the days of thisMonth.
      '//==================================================

      if not lastWeekdayofPreviousMonth = maxDaysPerWeek then
         for currentDayinWeek = 0 to (lastWeekdayofPreviousMonth - 1) '// subtract one because we're starting at zero in the loop
            response.write "<td>&nbsp;</td>"
         next
      else
         currentDayinWeek = 0
      end if

      '//==================================================
      '// start writing out the days of the month, when the
      '// currentDayinWeek = 7 then stop and restart the
      '// table row.  Preface this by setting 
      '// currentDayinWeek = nCnt (from the loop above)
      '//==================================================

      for nCnt = startDayofMonth to daysInThisMonth
         if currentDayinWeek => maxDaysPerWeek then
            response.write "</tr><tr>"
            currentDayinWeek = 0
         end if

         if QueryEventData then
            eventHyperLink = thisPage & "?searchDate="& thisMonth & "/" & nCnt & "/" & thisYear
            response.write "<td><a href="""& eventHyperlink &""" "& WriteCellClass(CheckEventDaysArray(nCnt, aEventDays)) &">" & nCnt & "</a></td>"
         else
            response.write "<td>" & nCnt & "</td>"
         end if

         currentDayinWeek = currentDayinWeek + 1
      next

      '//==================================================
      '// write blank cells equal to the remaining number 
      '// of cells needed to even out the table
      '//==================================================

      if cint(lastWeekdayofThisMonth) < cint(maxDaysPerWeek) then
         for nCnt = (lastWeekdayofThisMonth + 1) to maxDaysPerWeek
            response.write "<td>&nbsp;</td>"
         next
         response.write "</tr>"
      end if
      %>
</table>

<%
'//==================================================
'// determine the boolean value of b, return a value
'//==================================================

function WriteCellClass(b)
   if b = true then
      WriteCellClass = "class="""& classEventTrue &""""
   else
      WriteCellClass = ""
   end if
end function

'//==================================================
'// loop through array, comparing each value to a
'// given searchValue variable.  Return boolean True
'// if value is located in array, else return False.
'//==================================================

function CheckEventDaysArray(searchValue, arraySearched)
   dim i      '// a counter variable
   dim ibound '// upper boundary of arraySearched
   dim bFound '// boolean value; indicates if the searchValue has been located in the array or not

   ibound = ubound(arraySearched)
   bFound = false

   for i = 0 to (ibound)
      if clng(arraySearched(i)) = clng(searchValue) then
         bFound = true
         exit for
      end if
   next

   CheckEventDaysArray = bFound
end function
%>