<%
'*****************************************************
'*****************************************************
'**                                                 **
'**      CrazyBeavers Calendar Class v 1.0          **
'**                                                 **
'**  If you wish to use this piece of code in       **
'**  your own applications you have to let this     **
'**  statement remain in it's current state. If     **
'**  you plan to redistribute your application      **
'**  you will have to have inform the users         **
'**  that you are using CB Calendar Class and that  **
'**  they can find more information about it on     **
'**  CrazyBeaver Softwares homepage located at the  **
'**  URL below:                                     **
'**                                                 **
'**  http://www.crazybeavers.se/                    **
'**                                                 **
'**  / Karl-johan Sjgren                           **
'**  http://www.crazybeavers.se/                    **
'**   2005 CrazyBeaver Software                    **
'**                                                 **
'*****************************************************
'*****************************************************

  class cls_CBCalendar
    public ActiveWeek
    public ActiveMonth
    public ActiveYear
    public Text
    public HightlightWeek
    public HightlightDayspan
    public TargetPage
    public QueryString
    private aHightlight

    private sub Class_Initialize
      set Text = new cls_CBCalendar_Text
      if not(Request.QueryString("year") = empty) then
        ActiveYear = Request.QueryString("year")
      else
        ActiveYear = Year(Date)
      end if
      if not(Request.QueryString("month") = empty) then
        ActiveMonth = Request.QueryString("month")
      else
        ActiveMonth = Month(Date)
      end if
      if not(Request.QueryString("week") = empty) then
        ActiveWeek = Request.QueryString("week")
      else
        ActiveWeek = 0
      end if
      HightlightWeek = false
      HightlightDayspan = -1
      TargetPage = ""
      QueryString = ""
      ReDim aHightlight(1)
    end sub

    private sub Class_Terminate
      set Text = nothing
    end sub

    public sub AddHightlight(dDate)
      redim preserve aHightlight(uBound(aHightlight) +1)
      aHightlight(uBound(aHightlight)) = dDate
    end sub

    public sub DrawCalendar()
      dim sCurrentHeader
      dim iWeek, iMonth, iYear, iCurrentDay, iVBDay, iHightlightDayspan, i, j, MonthLengt
      dim bHightlightWeek, bHighlight, bWrittenContent, bPastFirstDay
      iCurrentDay = 1
      iWeek = ActiveWeek
      iMonth = ActiveMonth
      iYear = ActiveYear
      bHightlightWeek = HightlightWeek
      iHightlightDayspan = HightlightDayspan
      if(iYear  = "") then exit sub
      if(iMonth = "") then exit sub

      if(iMonth > 12) then
        iMonth = 1
        iYear = iYear + 1
      elseif(iMonth < 1) then
        iMonth = 12
        iYear = iYear - 1
      end if
      bPastFirstDay = false

      Response.Write("<table cellspacing=""0"" class=""calendar_table"" summary=""" & Replace(Replace(Replace(Text.Summary, "[YEAR]", iYear), "[MONTHNAME]", getMonthName(iMonth)), "[MONTH]", iMonth) & """>" & vbCrLf)

      Response.Write("  <caption>" & Replace(Replace(Replace(Text.Caption, "[YEAR]", iYear), "[MONTHNAME]", getMonthName(iMonth)), "[MONTH]", iMonth) & "</caption>" & vbCrLf)

      Response.Write("  <thead>" & vbCrLf)
      Response.Write("    <tr>" & vbCrLf)
      Response.Write("      <td colspan=""1"" class=""calendar_navigation"" align=""right""><a href=""?id=" & Request.QueryString("id") & "&amp;month=" & iMonth -1 & "&amp;year=" & iYear & "&amp;week=" & iWeek & "&amp;date=" & DateSerial(iYear, iMonth, iCurrentDay) & """ title=""" & Text.NextMonth & """>&laquo;</a></td>" & vbCrLf)
      Response.Write("      <td colspan=""5"" class=""calendar_navigation"" align=""center"">" & getMonthName(iMonth) & "</td>" & vbCrLf)
      Response.Write("      <td colspan=""1"" class=""calendar_navigation"" align=""left""><a href=""?id=" & Request.QueryString("id") & "&amp;month=" & iMonth +1 & "&amp;year=" & iYear & "&amp;week=" & iWeek & "&amp;date=" & DateSerial(iYear, iMonth, iCurrentDay) & """ title=""" & Text.NextMonth & """>&raquo;</a></td>" & vbCrLf)
      Response.Write("    </tr>" & vbCrLf)

      Response.Write("    <tr>" & vbCrLf)
      Response.Write("      <th class=""calendar_header"" scope=""colgroup"" abbr=""" & Text.Monday & """ id=""mo""><abbr title=""" & Text.Monday & """>" & Left(Text.Monday, 2) & "</abbr></th>" & vbCrLf)
      Response.Write("      <th class=""calendar_header"" scope=""colgroup"" abbr=""" & Text.Tuesday & """ id=""tu""><abbr title=""" & Text.Tuesday & """>" & Left(Text.Tuesday, 2) & "</abbr></th>" & vbCrLf)
      Response.Write("      <th class=""calendar_header"" scope=""colgroup"" abbr=""" & Text.Wednesday & """ id=""we""><abbr title=""" & Text.Wednesday & """>" & Left(Text.Wednesday, 2) & "</abbr></th>" & vbCrLf)
      Response.Write("      <th class=""calendar_header"" scope=""colgroup"" abbr=""" & Text.Thursday & """ id=""th""><abbr title=""" & Text.Thursday & """>" & Left(Text.Thursday, 2) & "</abbr></th>" & vbCrLf)
      Response.Write("      <th class=""calendar_header"" scope=""colgroup"" abbr=""" & Text.Friday & """ id=""fr""><abbr title=""" & Text.Friday & """>" & Left(Text.Friday, 2) & "</abbr></th>" & vbCrLf)
      Response.Write("      <th class=""calendar_header"" scope=""colgroup"" abbr=""" & Text.Saturday & """ id=""sa""><abbr title=""" & Text.Saturday & """>" & Left(Text.Saturday, 2) & "</abbr></th>" & vbCrLf)
      Response.Write("      <th class=""calendar_header"" scope=""colgroup"" abbr=""" & Text.Sunday & """ id=""su""><abbr title=""" & Text.Sunday & """>" & Left(Text.Sunday, 2) & "</abbr></th>" & vbCrLf)
      Response.Write("    </tr>" & vbCrLf)
      Response.Write("  </thead>" & vbCrLf)

      Response.Write("  <tbody>" & vbCrLf)
      MonthLengt = Day(DateSerial(iYear, iMonth + 1, 0))
      do while (iCurrentDay <= MonthLengt)
        Response.Flush
        bWrittenContent = false
        if(cLng("0" & getWeekNumber(DateSerial(iYear, iMonth, iCurrentDay))) = cLng("0" & iWeek) and bHightlightWeek) then
          Response.Write("    <tr class=""calendar_highlightweek"">" & vbCrLf)
        else
          Response.Write("    <tr>" & vbCrLf)
        end if
        for i = 1 to 7

          if bPastFirstDay and (iCurrentDay <= MonthLengt) then
            bWrittenContent = true
            bHighlight = false
            for j = LBound(aHightlight) to UBound(aHightlight)
              if(DateSerial(iYear, iMonth, iCurrentDay) = cDate(aHightlight(j))) then bHighlight = true
            next

            select case WeekDay(DateSerial(iYear, iMonth, iCurrentDay), VBMonday)
            case 1
               sCurrentHeader = "mo"
               iVBDay = VBMonday
            case 2
               sCurrentHeader = "tu"
               iVBDay = VBTuesday
            case 3
               sCurrentHeader = "we"
               iVBDay = VBWednesday
            case 4
               sCurrentHeader = "th"
               iVBDay = VBThursday
            case 5
               sCurrentHeader = "fr"
               iVBDay = VBFriday
            case 6
               sCurrentHeader = "sa"
               iVBDay = VBSaturday
            case 7
               sCurrentHeader = "su"
               iVBDay = VBSunday
            end select

            if(bHighlight) then
              if(iVBDay = iHightlightDayspan) then
                Response.Write("      <td class=""calendar_highlightday calendar_highlightdayspan"" headers=""" & sCurrentHeader & """><a href=""" & TargetPage & "?id=" & Request.QueryString("id") & "&amp;month=" & iMonth & "&amp;year=" & iYear & "&amp;week=" & getWeekNumber(DateSerial(iYear, iMonth, iCurrentDay)) & "&amp;date=" & DateSerial(iYear, iMonth, iCurrentDay) & QueryString & """>" & iCurrentDay & "</a></td>" & vbCrLf)
              else
                Response.Write("      <td class=""calendar_highlightday"" headers=""" & sCurrentHeader & """><a href=""" & TargetPage & "?id=" & Request.QueryString("id") & "&amp;month=" & iMonth & "&amp;year=" & iYear & "&amp;week=" & getWeekNumber(DateSerial(iYear, iMonth, iCurrentDay)) & "&amp;date=" & DateSerial(iYear, iMonth, iCurrentDay) & QueryString & """>" & iCurrentDay & "</a></td>" & vbCrLf)
              end if
            else
              if(iVBDay = iHightlightDayspan) then
                Response.Write("      <td class=""calendar_normal calendar_highlightdayspan"" headers=""" & sCurrentHeader & """><a href=""" & TargetPage & "?id=" & Request.QueryString("id") & "&amp;month=" & iMonth & "&amp;year=" & iYear & "&amp;week=" & getWeekNumber(DateSerial(iYear, iMonth, iCurrentDay)) & "&amp;date=" & DateSerial(iYear, iMonth, iCurrentDay) & QueryString & """>" & iCurrentDay & "</a></td>" & vbCrLf)
              else
                Response.Write("      <td class=""calendar_normal"" headers=""" & sCurrentHeader & """><a href=""" & TargetPage & "?id=" & Request.QueryString("id") & "&amp;month=" & iMonth & "&amp;year=" & iYear & "&amp;week=" & getWeekNumber(DateSerial(iYear, iMonth, iCurrentDay)) & "&amp;date=" & DateSerial(iYear, iMonth, iCurrentDay) & QueryString & """>" & iCurrentDay & "</a></td>" & vbCrLf)
              end if
            end if
          else
            Response.Write("      <td class=""calendar_normal"">&nbsp;</td>" & vbCrLf)
          end if

          if(bPastFirstDay = false) then
            if(iCurrentDay = WeekDay(DateSerial(iYear, iMonth, 1), VBTuesday)) then
              bPastFirstDay = true
              iCurrentDay = 0
            end if
          end if

          if(iCurrentDay <= MonthLengt) then
            iCurrentDay = iCurrentDay + 1
          end if
        next
        Response.Write("    </tr>" & vbCrLf)
        if not bWrittenContent then Response.Clear
      loop
      Response.Write("  </tbody>" & vbCrLf)
      Response.Write("</table>" & vbCrLf)
    end sub

    private function getWeekNumber(dDate)
      getWeekNumber = DatePart("WW", dDate, vbMonday, vbFirstFourDays)
      if getWeekNumber > 52 then
        If DatePart("WW", dDate + 7, vbMonday, vbFirstFourDays) = 2 then getWeekNumber = 1
      end if
    end function

    private function getMonthName(iMonth)
      select case iMonth
      case 1
         getMonthName = Text.January
      case 2
         getMonthName = Text.February
      case 3
         getMonthName = Text.March
      case 4
         getMonthName = Text.April
      case 5
         getMonthName = Text.May
      case 6
         getMonthName = Text.June
      case 7
         getMonthName = Text.July
      case 8
         getMonthName = Text.August
      case 9
         getMonthName = Text.September
      case 10
         getMonthName = Text.October
      case 11
         getMonthName = Text.November
      case 12
         getMonthName = Text.December
      end select
    end function
  end class

  class cls_CBCalendar_Text
    public Monday
    public Tuesday
    public Wednesday
    public Thursday
    public Friday
    public Saturday
    public Sunday

    public January
    public February
    public March
    public April
    public May
    public June
    public July
    public August
    public September
    public October
    public November
    public December

    public NextMonth
    public PreviousMonth
    public Summary
    public Caption

    sub Class_Initialize
      Monday = ucase(left(WeekdayName(vbMonday), 1)) & lcase(right(WeekdayName(vbMonday), len(WeekdayName(vbMonday)) -1))
      Tuesday = ucase(left(WeekdayName(vbTuesday), 1)) & lcase(right(WeekdayName(vbTuesday), len(WeekdayName(vbTuesday)) -1))
      Wednesday = ucase(left(WeekdayName(vbWednesday), 1)) & lcase(right(WeekdayName(vbWednesday), len(WeekdayName(vbWednesday)) -1))
      Thursday = ucase(left(WeekdayName(vbThursday), 1)) & lcase(right(WeekdayName(vbThursday), len(WeekdayName(vbThursday)) -1))
      Friday = ucase(left(WeekdayName(vbFriday), 1)) & lcase(right(WeekdayName(vbFriday), len(WeekdayName(vbFriday)) -1))
      Saturday = ucase(left(WeekdayName(vbSaturday), 1)) & lcase(right(WeekdayName(vbSaturday), len(WeekdayName(vbSaturday)) -1))
      Sunday = ucase(left(WeekdayName(vbSunday), 1)) & lcase(right(WeekdayName(vbSunday), len(WeekdayName(vbSunday)) -1))
    
      January = ucase(left(MonthName(1), 1)) & lcase(right(MonthName(1), len(MonthName(1)) -1))
      February = ucase(left(MonthName(2), 1)) & lcase(right(MonthName(2), len(MonthName(2)) -1))
      March = ucase(left(MonthName(3), 1)) & lcase(right(MonthName(3), len(MonthName(3)) -1))
      April = ucase(left(MonthName(4), 1)) & lcase(right(MonthName(4), len(MonthName(4)) -1))
      May = ucase(left(MonthName(5), 1)) & lcase(right(MonthName(5), len(MonthName(5)) -1))
      June = ucase(left(MonthName(6), 1)) & lcase(right(MonthName(6), len(MonthName(6)) -1))
      July = ucase(left(MonthName(7), 1)) & lcase(right(MonthName(7), len(MonthName(7)) -1))
      August = ucase(left(MonthName(8), 1)) & lcase(right(MonthName(8), len(MonthName(8)) -1))
      September = ucase(left(MonthName(9), 1)) & lcase(right(MonthName(9), len(MonthName(9)) -1))
      October = ucase(left(MonthName(10), 1)) & lcase(right(MonthName(10), len(MonthName(10)) -1))
      November = ucase(left(MonthName(11), 1)) & lcase(right(MonthName(11), len(MonthName(11)) -1))
      December = ucase(left(MonthName(12), 1)) & lcase(right(MonthName(12), len(MonthName(12)) -1))

      NextMonth = "Next month"
      PreviousMonth = "Previous month"
      Summary = "Calendar showing [MONTHNAME] ([MONTH]) [YEAR]"
      Caption = ""
    end sub
  end class
%>