<% @Language = "VBScript" %>
<%
'============================================================
' MODULE:    start.asp
' APP:           ASPCalendar
' AUTHOR:     www.u229.no
' CREATED:  June 2005
' MODIFIED: Nov 2005
'============================================================
' COMMENT: This file will set a cookie on your computer to enable direct editing of events via 
'                  the calendar it self.
'============================================================
' ROUTINES:
' - Sub SetCookie()
' - Sub PrintHTML()
'============================================================
%>
<!--#include file="aspcalendar_routines.asp"-->
<%

Call PrintHTML     '// Print the page html
Call SetCookie    '// Set a cookie on this computer


'------------------------------------------------------------------------------------------------------------
' Comment: Save cookie to users system.
'------------------------------------------------------------------------------------------------------------
Sub SetCookie()
		On Error Resume Next

		Response.Cookies("ASPCalendar").Expires = DateAdd("yyyy", 1, Date)
		Response.Cookies("ASPCalendar")("IsAdmin") = True

End Sub

'------------------------------------------------------------------------------------------------------------
' Comment:
'------------------------------------------------------------------------------------------------------------
Sub PrintHTML()
    On Error Resume Next
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <title>Classic Asp Calendar With  Events</title>
<meta name="copyright" content="www.u229.no &copy; 2002" />
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
<link rel="stylesheet" type="text/css" href="html/ASPCalendar.css" />
<style type="text/css">
body {
    margin-left: 30px;
	margin-right: 30px;
}
h3 {
    margin-top: 30px;
	clear: both;
}
.copy {
    font-size: 10px;
	font-weight: bold;
	color: #ccc;
	text-align: center;
	margin-top: 6em;
}
</style>
</head>
<body>

<h2>Welcome to ASPCalendar!</h2>

<p><b>Home Page:</b> http://www.u229.no/stuff/ASPCalendar/</p>

<h3>If everything works you should now see a live calendar on the left.</h3>

<p><%Response.Write ShowCalendar%></p>
<p><b>FEATURES:</b></p>
<p>- ASPCalendar is a complete out-of-the-box application that can be included on your own asp pages.</p> 
<p>- Dates with events are shown as links in bold text. When you click one of them a window shows information on events for that specific day. Events can be shown in a popup window or in a new browser window.</p>
<p>- Site owner can edit events from within the calendar itself using a cookie. No log-in is required.</p>
<p>- The calendar is pure html and can therefore be loaded very fast.</p>
<p>- ASPCalendar can create two calendars, one for the current month and one for next month.</p>
<p>- Displaying the calendar in your language and with your own regional date format is easy.</p>
<p>- Events older than 1 month are automatically deleted - no need to maintain the database.</p>

<h3>A quick tutorial of how to make this calendar work for you:</h3>

<p><img src="images/cal_w_folder.gif" width="176" height="217" alt="" style="float:left;padding:5px;margin-right:10px;" /><b>INSTALLATION:</b><br />
You should by now have uploaded the files to your web server and opened start.asp (this file :-) in your web browser. Requirements: Your web server must support ASP (Active Server Pages). Cookies must be enabled in your browser, at least for this domain. And you must have write permissions for the ASPCalendar folder.</p>

<p><b>TO DISPLAY A CALENDAR ON A PAGE:</b><br />
<b>Step 1:</b> Put this line near the top of your page: <span class="color_green">&lt;!--#include file="aspcalendar_routines.asp"--&gt;</span><br />Note that you have to adjust the file paths if the uploaded files are not located in the same folder as the page you want the calendar to be shown in.<br /> Then place this line where you want the calendar to appear: &lt;%<span class="color_blue">Response</span>.<span class="color_red">Write</span> ShowCalendar%&gt;

<p>When you opened this file (start.asp) in your web browser a cookie was set on your computer. This cookie allows for direct creating and editing of events from the calendar itself. A small folder image will appear near the calendar heading, and when you click this image you are taken to the admin page where you create your first event.</p>

<p>Now, if you see the folder image in the calendar at the top of this page, everything should be fine. All other users/viewers of the calendar will NOT see this image and will NOT be able to create/edit events. (See the two examples on the left.) Therefore, when the cookie is set you should RENAME START.ASP. This will prevent others from opening this file and grant access to the admin area. Unless the cookie on your computer is deleted, there will be no need to run this file again.</p>

<p><b>Step 2:</b> You need to set certain parameters, for instance the path to your database and your preferred date settings. This is done in the file aspcalendar_routines.asp. Open that file in your text editor and just follow the instructions there.</p>

<p style="border-bottom: 2px dotted #ccc;">&nbsp;</p>

<p>After you have created a new calendar or a new event, you will have to reload the calendar for the changes to take effect.</p>

<p>If you find bugs, please report them at http://www.u229.no/stuff/ASPCalendar/. In particular I would like to know what happens on January 1st :-)<br />
Also, if you make improvements to the code, or create better looking css, please share it with the rest of us.</p>

<p>Enjoy!</p>

<div class="copy">Therefore: For that or this for it.<br />&nbsp;www.u229.no</div>
<br />

</body>
</html>

<%
End Sub
%>